-- MySQL dump 10.13  Distrib 8.0.17, for Win64 (x86_64)
--
-- Host: mysql502.discountasp.net    Database: mysql5_184896_travel3rd
-- ------------------------------------------------------
-- Server version	5.6.34

DROP DATABASE IF EXISTS `travel`;
CREATE DATABASE IF NOT EXISTS `travel`;
USE `travel`;


--
-- Table structure for table `continents`
--

DROP TABLE IF EXISTS `continents`;

CREATE TABLE `continents` (
  `ContinentCode` varchar(2) NOT NULL,
  `ContinentName` varchar(255) DEFAULT NULL,
  `GeoNameId` int(11) DEFAULT NULL,
  PRIMARY KEY (`ContinentCode`),
  KEY `GeoNameId` (`GeoNameId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

LOCK TABLES `continents` WRITE;
INSERT INTO `continents` VALUES ('AF','Africa',6255146),('AN','Antarctica',6255152),('AS','Asia',6255147),('EU','Europe',6255148),('NA','North America',6255149),('OC','Oceania',6255151),('SA','South America',6255150);
UNLOCK TABLES;


--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;

CREATE TABLE `countries` (
  `ISO` varchar(255) NOT NULL,
  `ISONumeric` varchar(255) DEFAULT NULL,
  `CountryName` varchar(255) DEFAULT NULL,
  `Capital` varchar(255) DEFAULT NULL,
  `CityCode` int(11) DEFAULT NULL,
  `Area` varchar(255) DEFAULT NULL,
  `Population` int(11) DEFAULT NULL,
  `Continent` varchar(255) DEFAULT NULL,
  `TopLevelDomain` varchar(255) DEFAULT NULL,
  `CurrencyCode` varchar(255) DEFAULT NULL,
  `CurrencyName` varchar(255) DEFAULT NULL,
  `PhoneCountryCode` varchar(255) DEFAULT NULL,
  `Languages` varchar(255) DEFAULT NULL,
  `Neighbours` varchar(255) DEFAULT NULL,
  `CountryDescription` longtext,
  PRIMARY KEY (`ISO`),
  KEY `CurrencyCode` (`CurrencyCode`),
  KEY `CityCode` (`CityCode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

LOCK TABLES `countries` WRITE;
INSERT INTO `countries` VALUES ('AD','020','Andorra','Andorra la Vella',3041565,'468',84000,'EU','.ad','EUR','Euro','376','ca','ES,FR','Andorra is a landlocked microstate in Southwestern Europe, located in the eastern Pyrenees mountains and bordered by Spain and France. Its capital, Andorra la Vella, is the highest capital city in Europe, at an elevation of 1,023 metres (3,356 ft) above sea level. The official language is Catalan, although Spanish, Portuguese, and French are also commonly spoken.'),('AE','784','United Arab Emirates','Abu Dhabi',290557,'82880',4975593,'AS','.ae','AED','Dirham','971','ar-AE,fa,en,hi,ur','SA,OM','The United Arab Emirates is an Arab country in the southeast of the Arabian Peninsula on the Persian Gulf, bordering Oman to the east and Saudi Arabia to the south, as well as sharing sea borders with Qatar and Iran. The UAE is a federation of seven emirates (equivalent to principalities), each governed by a hereditary emir, with a single national president. The constituent emirates are Abu Dhabi, Ajman, Dubai, Fujairah, Ras al-Khaimah, Sharjah, and Umm al-Quwain. The capital is Abu Dhabi, which is also the state\'s center of political, industrial, and cultural activities.'),('AF','004','Afghanistan','Kabul',1149361,'647500',29121286,'AS','.af','AFN','Afghani','93','fa-AF,ps,uz-AF,tk','TM,CN,IR,TJ,PK,UZ','Afghanistan, officially the Islamic Republic of Afghanistan, is a landlocked country located in South-Central Asia. Afghanistan is bordered by Pakistan in the south and east; Iran in the west; Turkmenistan, Uzbekistan, and Tajikistan in the north; and in the far northeast, China. Much of its 652,000 square kilometers (252,000 sq mi) is covered by the Hindu Kush mountain range at the western end of the Himalayas, separating the Amu Darya and Indus valleys.[14] Kabul is the capital and largest city.'),('AG','028','Antigua and Barbuda','St. John\'s',3576396,'443',86754,'NA','.ag','XCD','Dollar','+1-268','en-AG',NULL,NULL),('AI','660','Anguilla','The Valley',3573511,'102',13254,'NA','.ai','XCD','Dollar','+1-264','en-AI',NULL,NULL),('AL','008','Albania','Tirana',783754,'28748',2986952,'EU','.al','ALL','Lek','355','sq,el','MK,GR,CS,ME,RS,XK',NULL),('AM','051','Armenia','Yerevan',174982,'29800',2968000,'AS','.am','AMD','Dram','374','hy','GE,IR,AZ,TR',NULL),('AN','530','Netherlands Antilles','Willemstad',NULL,'960',136197,'NA','.an','ANG','Guilder','599','nl-AN,en,es','GP',NULL),('AO','024','Angola','Luanda',3351879,'1246700',13068161,'AF','.ao','AOA','Kwanza','244','pt-AO','CD,NA,ZM,CG','Angola, officially the Republic of Angola, is a west-coast country of south-central Africa. It is the seventh-largest country in Africa, bordered by Namibia to the south, the Democratic Republic of the Congo to the north, Zambia to the east, and the Atlantic Ocean to the west. Angola has an exclave province, the province of Cabinda that borders the Republic of the Congo and the Democratic Republic of the Congo. The capital and largest city of Angola is Luanda.'),('AQ','010','Antarctica',NULL,6697173,'1.40E+007',0,'AN','.aq',NULL,NULL,NULL,NULL,NULL,NULL),('AR','032','Argentina','Buenos Aires',3865483,'2766890',41343201,'SA','.ar','ARS','Peso','54','es-AR,en,it,de,fr,gn','CL,BO,UY,PY,BR','Argentina is a country located mostly in the southern half of South America. Sharing the bulk of the Southern Cone with Chile to the west, the country is also bordered by Bolivia and Paraguay to the north, Brazil to the northeast, Uruguay and the South Atlantic Ocean to the east, and the Drake Passage to the south. With a mainland area of 2,780,400 km2 (1,073,500 sq mi), Argentina is the eighth-largest country in the world, the fourth largest in the Americas, and the largest Spanish-speaking nation. The sovereign state is subdivided into twenty-three provinces and one autonomous city, Buenos Aires, which is the federal capital of the nation as decided by Congress. The provinces and the capital have their own constitutions, but exist under a federal system. Argentina claims sovereignty over part of Antarctica, the Falkland Islands, and South Georgia and the South Sandwich Islands.'),('AS','016','American Samoa','Pago Pago',5880801,'199',57881,'OC','.as','USD','Dollar','+1-684','en-AS,sm,to',NULL,NULL),('AT','040','Austria','Vienna',2782113,'83858',8205000,'EU','.at','EUR','Euro','43','de-AT,hr,hu,sl','CH,DE,HU,SK,CZ,IT,SI,LI','Austria, officially the Republic of Austria, is a country in Central Europe comprising nine federated states. Its capital, largest city and one of nine states is Vienna. Austria has an area of 83,879 km2 (32,386 sq mi), a population of nearly nine million people and a nominal GDP of $477 billion. It is bordered by the Czech Republic and Germany to the north, Hungary and Slovakia to the east, Slovenia and Italy to the south, and Switzerland and Liechtenstein to the west. The terrain is landlocked and highly mountainous, lying within the Alps; only 32% of the country is below 500 m (1,640 ft), and its highest point is 3,798 m (12,461 ft). The majority of the population speaks local Bavarian dialects as their native language, and German in its standard form is the country\'s official language. Other regional languages are Hungarian, Burgenland Croatian, and Slovene.'),('AU','036','Australia','Canberra',2077456,'7686850',21515754,'OC','.au','AUD','Dollar','61','en-AU',NULL,'Australia, officially the Commonwealth of Australia, is a sovereign country comprising the mainland of the Australian continent, the island of Tasmania, and numerous smaller islands. It is the largest country in Oceania and the world\'s sixth-largest country by total area. The neighbouring countries are Papua New Guinea, Indonesia, and East Timor to the north; the Solomon Islands and Vanuatu to the north-east; and New Zealand to the south-east. The population of 26 million is highly urbanised and heavily concentrated on the eastern seaboard. Australia\'s capital is Canberra, and its largest city is Sydney. The country\'s other major metropolitan areas are Melbourne, Brisbane, Perth, and Adelaide.'),('AW','533','Aruba','Oranjestad',3577279,'193',71566,'NA','.aw','AWG','Guilder','297','nl-AW,es,en',NULL,NULL),('AX','248','Aland Islands','Mariehamn',661882,NULL,26711,'EU','.ax','EUR','Euro','+358-18','sv-AX',NULL,NULL),('AZ','031','Azerbaijan','Baku',587116,'86600',8303512,'AS','.az','AZN','Manat','994','az,ru,hy','GE,IR,AM,TR,RU','Azerbaijan, officially the Republic of Azerbaijan, is a country in the South Caucasus region of Eurasia at the crossroads of Eastern Europe and Western Asia. It is bounded by the Caspian Sea to the east, Russia to the north, Georgia to the northwest, Armenia to the west and Iran to the south. The exclave of Nakhchivan is bounded by Armenia to the north and east, Iran to the south and west, and has an 11 km (6.8 mi) long border with Turkey in the northwest.'),('BA','070','Bosnia and Herzegovina','Sarajevo',3277605,'51129',4590000,'EU','.ba','BAM','Marka','387','bs,hr-BA,sr-BA','CS,HR,ME,RS','Bosnia and Herzegovina, sometimes called Bosnia-Herzegovina and often known informally as Bosnia, is a country in Southeastern Europe, located within the Balkan Peninsula. Sarajevo is the capital and largest city.'),('BB','052','Barbados','Bridgetown',3374084,'431',285653,'NA','.bb','BBD','Dollar','+1-246','en-BB',NULL,NULL),('BD','050','Bangladesh','Dhaka',1210997,'144000',156118464,'AS','.bd','BDT','Taka','880','bn-BD,en','MM,IN','Bangladesh, officially the People\'s Republic of Bangladesh, is a country in South Asia. While it is the 92nd-largest country, spanning 147,570 square kilometres (56,980 sq mi), it is the world\'s 8th-most populous country with a population nearing 163 million[6], making it one of the most densely populated countries in the world. Bangladesh shares land borders with India to the west, north and the east and Myanmar to the east, whereas the Bay of Bengal lies to its south. Dhaka, its capital and largest city, is also the economic, political and the cultural hub of the country. Chittagong, the largest sea port, is the second largest city. The country\'s geography is dominated by the Ganges delta which empties into the Bay of Bengal the combined waters of several river systems, including those of the Brahmaputra and the Ganges. As a result, the country is criss-crossed by numerous rivers and inland water ways. Highlands with evergreen forests cover the landscape in the northeastern and southeastern regions of the country. The country also features the longest natural sea beach and most of the largest mangrove forest in the world. The country\'s biodiversity includes a vast array of plants and wildlife, including the endangered Bengal tiger, the national animal.'),('BE','056','Belgium','Brussels',2802361,'30510',10403000,'EU','.be','EUR','Euro','32','nl-BE,fr-BE,de-BE','DE,NL,LU,FR','Belgium, officially the Kingdom of Belgium, is a sovereign state in Western Europe. It is bordered by the Netherlands to the north, Germany to the east, Luxembourg to the southeast, France to the southwest, and the North Sea to the northwest. It covers an area of 30,688 km2 (11,849 sq mi) and has a population of more than 11.4 million. The capital and largest city is Brussels; other major cities are Antwerp, Ghent, Charleroi and Liege.'),('BF','854','Burkina Faso','Ouagadougou',2361809,'274200',16241811,'AF','.bf','XOF','Franc','226','fr-BF','NE,BJ,GH,CI,TG,ML',NULL),('BG','100','Bulgaria','Sofia',732800,'110910',7148785,'EU','.bg','BGN','Lev','359','bg,tr-BG','MK,GR,RO,CS,TR,RS','Bulgaria, officially the Republic of Bulgaria, is a country in Southeast Europe. It is bordered by Romania to the north, Serbia and North Macedonia to the west, Greece and Turkey to the south, and the Black Sea to the east. The capital and largest city is Sofia; other major cities are Plovdiv, Varna and Burgas. With a territory of 110,994 square kilometres (42,855 sq mi), Bulgaria is Europe\'s 16th-largest country.'),('BH','048','Bahrain','Manama',290291,'665',738004,'AS','.bh','BHD','Dinar','973','ar-BH,en,fa,ur',NULL,NULL),('BI','108','Burundi','Bujumbura',433561,'27830',9863117,'AF','.bi','BIF','Franc','257','fr-BI,rn','TZ,CD,RW',NULL),('BJ','204','Benin','Porto-Novo',2395170,'112620',9056010,'AF','.bj','XOF','Franc','229','fr-BJ','NE,TG,BF,NG',NULL),('BL','652','Saint Barthelemy','Gustavia',3578476,'21',8450,'NA','.gp','EUR','Euro','590','fr',NULL,NULL),('BM','060','Bermuda','Hamilton',3573345,'53',65365,'NA','.bm','BMD','Dollar','+1-441','en-BM,pt',NULL,'Bermuda is a British Overseas Territory in the North Atlantic Ocean. It is approximately 1,070 km (665 mi) east-southeast of Cape Hatteras, North Carolina; 1,236 km (768 mi) south of Cape Sable Island, Nova Scotia; and 1,759 km (1,093 mi) northeast of Cuba. The capital city is Hamilton. Bermuda is self-governing, with its own constitution and government and a Parliament which makes local laws. The United Kingdom retains responsibility for defence and foreign relations. As of July 2018, it has a population of 71,176, making it the most populous of the British overseas territories.'),('BN','096','Brunei','Bandar Seri Begawan',1820814,'5770',395027,'AS','.bn','BND','Dollar','673','ms-BN,en-BN','MY',NULL),('BO','068','Bolivia','Sucre',3923057,'1098580',9947418,'SA','.bo','BOB','Boliviano','591','es-BO,qu,ay','PE,CL,PY,BR,AR','Bolivia, officially the Plurinational State of Bolivia, is a landlocked country located in western-central South America. The capital is Sucre, while the seat of government and financial center is located in La Paz. The largest city and principal industrial center is Santa Cruz de la Sierra, located on the Llanos Orientales (tropical lowlands), a mostly flat region in the east of the country.'),('BQ','535','Bonaire, Saint Eustatius and Saba',NULL,7626844,NULL,18012,'NA','.bq','USD','Dollar','599','nl,pap,en',NULL,NULL),('BR','076','Brazil','Brasilia',3469034,'8511965',201103330,'SA','.br','BRL','Real','55','pt-BR,es,en,fr','SR,PE,BO,UY,GY,PY,GF,VE,CO,AR','Brazil, officially the Federative Republic of Brazil, is the largest country in both South America and Latin America. At 8.5 million square kilometers (3.2 million square miles) and with over 208 million people, Brazil is the world\'s fifth-largest country by area and the fifth most populous. Its capital is Brasília, and its most populated city is Sao Paulo. The federation is composed of the union of the 26 states, the Federal District, and the 5,570 municipalities. It is the largest country to have Portuguese as an official language and the only one in the Americas; it is also one of the most multicultural and ethnically diverse nations, due to over a century of mass immigration from around the world.'),('BS','044','Bahamas','Nassau',3572887,'13940',301790,'NA','.bs','BSD','Dollar','+1-242','en-BS',NULL,'The Bahamas, officially the Commonwealth of the Bahamas, is a country consisting of more than 3,000 islands, cays and islets in the Atlantic Ocean, north of Cuba and Hispaniola (the Dominican Republic and Haiti), northwest of the Turks and Caicos Islands and southeast of the US state of Florida. Its capital is Nassau on the island of New Providence. Geographically, the Bahamas lie in the same island chain as Cuba, Hispaniola and the Turks and Caicos Islands; the designation of \"Bahamas\" usually refers to the country and not the geographic chain. The country\'s population, numbering around 354,000, lives on a land area of 13,939 km2 (5,382 sq mi).'),('BT','064','Bhutan','Thimphu',1252634,'47000',699847,'AS','.bt','BTN','Ngultrum','975','dz','CN,IN',NULL),('BV','074','Bouvet Island',NULL,3371123,NULL,0,'AN','.bv','NOK','Krone',NULL,NULL,NULL,NULL),('BW','072','Botswana','Gaborone',933860,'600370',2029307,'AF','.bw','BWP','Pula','267','en-BW,tn-BW','ZW,ZA,NA','Botswana, officially the Republic of Botswana, is a landlocked country in Southern Africa. Formerly the British protectorate of Bechuanaland, Botswana adopted its new name after becoming independent within the Commonwealth on 30 September 1966. Since then, it has been a representative republic, with a consistent record of uninterrupted democratic elections and the best perceived corruption ranking in Africa since at least 1998. It is currently Africa\'s oldest continuous democracy.'),('BY','112','Belarus','Minsk',630336,'207600',9685000,'EU','.by','BYR','Ruble','375','be,ru','PL,LT,UA,RU,LV','Belarus, officially the Republic of Belarus, formerly known by its Russian name Byelorussia or Belorussia, is a landlocked country in Eastern Europe bordered by Russia to the northeast, Ukraine to the south, Poland to the west, and Lithuania and Latvia to the northwest. Its capital and most populous city is Minsk. Over 40% of its 207,600 square kilometres (80,200 sq mi) is forested. Its major economic sectors are service industries and manufacturing. Until the 20th century, different states at various times controlled the lands of modern-day Belarus, including the Principality of Polotsk (11th to 14th centuries), the Grand Duchy of Lithuania, the Polish-Lithuanian Commonwealth, and the Russian Empire.'),('BZ','084','Belize','Belmopan',3582678,'22966',314522,'NA','.bz','BZD','Dollar','501','en-BZ,es','GT,MX','Belize, formerly the British Honduras, is an independent and sovereign country located on the north eastern coast of Central America. Belize is bordered on the northwest by Mexico, on the east by the Caribbean Sea, and on the south and west by Guatemala. It has an area of 22,970 square kilometres (8,867 sq mi) and a population of 408,487 (2019). Its mainland is about 180 mi (290 km) long and 68 mi (110 km) wide. It has the lowest population and population density in Central America. The country\'s population growth rate of 1.87% per year (2018 estimate) is the second highest in the region and one of the highest in the Western Hemisphere.'),('CA','124','Canada','Ottawa',6251999,'9984670',33679000,'NA','.ca','CAD','Dollar','1','en-CA,fr-CA,iu','US','Canada is a North American country consisting of ten provinces and three territories. Located in the northern part of the continent, it extends from the Atlantic to the Pacific and northward into the Arctic Ocean. Canada is the world\'s second-largest country by total area, and its common border with the United States is the world\'s longest land border.'),('CC','166','Cocos Islands','West Island',1547376,'14',628,'AS','.cc','AUD','Dollar','61','ms-CC,en',NULL,NULL),('CD','180','Democratic Republic of the Congo','Kinshasa',203312,'2345410',70916439,'AF','.cd','CDF','Franc','243','fr-CD,ln,kg','TZ,CF,SS,RW,ZM,BI,UG,CG,AO','The Democratic Republic of the Congo, also known as DR Congo, the DRC, DROC, Congo-Kinshasa, or simply the Congo, is a country located in Central Africa. It is sometimes anachronistically referred to by its former name of Zaire, which was its official name between 1971 and 1997. It is, by area, the largest country in sub-Saharan Africa, the second-largest in all of Africa (after Algeria), and the 11th-largest in the world. With a population of over 78 million, the Democratic Republic of the Congo is the most populous officially Francophone country, the fourth-most-populous country in Africa, and the 16th-most-populous country in the world. Eastern DR Congo has been the scene of ongoing military conflict in Kivu, since 2015.'),('CF','140','Central African Republic','Bangui',239880,'622984',4844927,'AF','.cf','XAF','Franc','236','fr-CF,sg,ln,kg','TD,SD,CD,SS,CM,CG','The Central African Republic is a landlocked country in Central Africa. It is bordered by Chad to the north, Sudan to the northeast, South Sudan to the east, the Democratic Republic of the Congo to the south, the Republic of the Congo to the southwest and Cameroon to the west. The CAR covers a land area of about 620,000 square kilometres (240,000 sq mi) and had an estimated population of around 4.6 million as of 2016. As of 2019, the CAR is the scene of a civil war, ongoing since 2012.'),('CG','178','Republic of the Congo','Brazzaville',2260494,'342000',3039126,'AF','.cg','XAF','Franc','242','fr-CG,kg,ln-CG','CF,GA,CD,CM,AO',NULL),('CH','756','Switzerland','Berne',2658434,'41290',7581000,'EU','.ch','CHF','Franc','41','de-CH,fr-CH,it-CH,rm','DE,IT,LI,FR,AT','Switzerland, officially the Swiss Confederation, is a sovereign state situated in the confluence of western, central, and southern Europe. It is a federal republic composed of 26 cantons, with federal authorities seated in Bern. Switzerland is a landlocked country bordered by Italy to the south, France to the west, Germany to the north, and Austria and Liechtenstein to the east. It is geographically divided between the Alps, the Swiss Plateau and the Jura, spanning a total area of 41,285 km2 (15,940 sq mi), and land area of 39,997 km2 (15,443 sq mi). While the Alps occupy the greater part of the territory, the Swiss population of approximately 8.5 million is concentrated mostly on the plateau, where the largest cities are located, among them the two global cities and economic centres of Zurich and Geneva.'),('CI','384','Ivory Coast','Yamoussoukro',2287781,'322460',21058798,'AF','.ci','XOF','Franc','225','fr-CI','LR,GH,GN,BF,ML','Ivory Coast or Côte d\'Ivoire, officially the Republic of Côte d\'Ivoire, is a country located on the south coast of West Africa. Ivory Coast\'s political capital is Yamoussoukro in the centre of the country, while its economic capital and largest city is the port city of Abidjan. It borders Guinea and Liberia to the west, Burkina Faso and Mali to the north, Ghana to the east, and the Gulf of Guinea (Atlantic Ocean) to the south.'),('CK','184','Cook Islands','Avarua',1899402,'240',21388,'OC','.ck','NZD','Dollar','682','en-CK,mi',NULL,NULL),('CL','152','Chile','Santiago',3895114,'756950',16746491,'SA','.cl','CLP','Peso','56','es-CL','PE,BO,AR','Chile, officially the Republic of Chile, is a South American country occupying a long, narrow strip of land between the Andes to the east and the Pacific Ocean to the west. It borders Peru to the north, Bolivia to the northeast, Argentina to the east, and the Drake Passage in the far south. Chilean territory includes the Pacific islands of Juan Fernandez, Salas y Gomez, Desventuradas, and Easter Island in Oceania. Chile also claims about 1,250,000 square kilometres (480,000 sq mi) of Antarctica, although all claims are suspended under the Antarctic Treaty.'),('CM','120','Cameroon','Yaounde',2233387,'475440',19294149,'AF','.cm','XAF','Franc','237','en-CM,fr-CM','TD,CF,GA,GQ,CG,NG','Cameroon, officially the Republic of Cameroon, is a country in Central Africa. It is bordered by Nigeria to the west and north; Chad to the northeast; the Central African Republic to the east; and Equatorial Guinea, Gabon and the Republic of the Congo to the south. Cameroon\'s coastline lies on the Bight of Biafra, part of the Gulf of Guinea and the Atlantic Ocean. Although Cameroon is not an ECOWAS member state, it is geographically and historically in West Africa with the Southern Cameroons which now form her Northwest and Southwest Regions having a strong West African history. The country is sometimes identified as West African and other times as Central African due to its strategic position at the crossroads between West and Central Africa. Cameroon is home to over 250 native languages spoken by nearly 20 million people.'),('CN','156','China','Beijing',1814991,'9596960',1330044000,'AS','.cn','CNY','Yuan Renminbi','86','zh-CN,yue,wuu,dta,ug,za','LA,BT,TJ,KZ,MN,AF,NP,MM,KG,PK,KP,RU,VN,IN','China, officially the People\'s Republic of China (PRC or PR China), is a country in East Asia and the world\'s most populous country, with a population of around 1.404 billion in 2017. Covering approximately 9,600,000 square kilometers (3,700,000 sq mi), it is the third or fourth largest country by total area. Governed by the Communist Party of China, the state exercises jurisdiction over 22 provinces, five autonomous regions, four direct-controlled municipalities (Beijing, Tianjin, Shanghai, and Chongqing), and the special administrative regions of Hong Kong and Macau.'),('CO','170','Colombia','Bogota',3686110,'1138910',44205293,'SA','.co','COP','Peso','57','es-CO','EC,PE,PA,BR,VE','Colombia, officially the Republic of Colombia, is a country largely situated in the north of South America, with land, and territories in North America. Colombia is bounded on the north by the Caribbean Sea and the west by the Pacific. It comprises thirty-two departments, with the capital in Bogota.'),('CR','188','Costa Rica','San Jose',3624060,'51100',4516220,'NA','.cr','CRC','Colon','506','es-CR,en','PA,NI','Costa Rica, officially the Republic of Costa Rica, is a sovereign state in Central America, bordered by Nicaragua to the north, the Caribbean Sea to the northeast, Panama to the southeast, the Pacific Ocean to the southwest, and Ecuador to the south of Cocos Island. It has a population of around 5 million in a land area of 51,060 square kilometers (19,714 square miles). An estimated 333,980 people live in the capital and largest city, San Jose with around 2 million people in the surrounding metropolitan area.'),('CS','891','Serbia and Montenegro','Belgrade',NULL,'102350',10829175,'EU','.cs','RSD','Dinar','381','cu,hu,sq,sr','AL,HU,MK,RO,HR,BA,BG','Serbia and Montenegro, also known from 2003 to 2006 as the State Union of Serbia and Montenegro, and known as the Federal Republic of Yugoslavia from 1992 to 2003, was a country in Southeast Europe, created from the two remaining federal republics of Yugoslavia after its breakup in 1992. The republics of Serbia and Montenegro together established a federation in 1992 as the Federal Republic of Yugoslavia for short.'),('CU','192','Cuba','Havana',3562981,'110860',11423000,'NA','.cu','CUP','Peso','53','es-CU','US','Cuba, officially the Republic of Cuba, is a country comprising the island of Cuba as well as Isla de la Juventud and several minor archipelagos. Cuba is located in the northern Caribbean where the Caribbean Sea, Gulf of Mexico and Atlantic Ocean meet. It is east of the Yucatan Peninsula (Mexico), south of both the U.S. state of Florida and the Bahamas, west of Haiti and north of both Jamaica and the Cayman Islands. Havana is the largest city and capital; other major cities include Santiago de Cuba and Camaguey. The area of the Republic of Cuba is 110,860 square kilometers (42,800 sq mi) (109,884 square kilometers (42,426 sq mi) without the territorial waters). The island of Cuba is the largest island in Cuba and in the Caribbean, with an area of 105,006 square kilometers (40,543 sq mi), and the second-most populous after Hispaniola, with over 11 million inhabitants.'),('CV','132','Cape Verde','Praia',3374766,'4033',508659,'AF','.cv','CVE','Escudo','238','pt-CV',NULL,NULL),('CW','531','Curacao','Willemstad',7626836,NULL,141766,'NA','.cw','ANG','Guilder','599','nl,pap',NULL,NULL),('CX','162','Christmas Island','Flying Fish Cove',2078138,'135',1500,'AS','.cx','AUD','Dollar','61','en,zh,ms-CC',NULL,NULL),('CY','196','Cyprus','Nicosia',146669,'9250',1102677,'EU','.cy','EUR','Euro','357','el-CY,tr-CY,en',NULL,NULL),('CZ','203','Czech Republic','Prague',3077311,'78866',10476000,'EU','.cz','CZK','Koruna','420','cs,sk','PL,DE,SK,AT','The Czech Republic, also known by its short-form name, Czechia, is a country in Central Europe bordered by Germany to the west and northwest, Austria to the south, Slovakia to the east, and Poland to the northeast. The Czech Republic is a landlocked country with a hilly landscape that covers an area of 78,866 square kilometers (30,450 sq mi) with a mostly temperate continental climate and oceanic climate. It is a unitary parliamentary republic, with 10.6 million inhabitants. Its capital and largest city is Prague, with 1.3 million residents; other major cities are Brno, Ostrava, Olomouc and Pilsen.'),('DE','276','Germany','Berlin',2921044,'357021',81802257,'EU','.de','EUR','Euro','49','de','CH,PL,NL,DK,BE,CZ,LU,FR,AT','Germany is a federal parliamentary republic in west-central Europe. The country consists of 16 states, and its capital and largest city is Berlin. Germany covers an area of 357,021 square kilometres (137,847 sq mi) and has a largely temperate seasonal climate. With 81.8 million inhabitants, it is the most populous member state in the European Union. Germany is one of the major political and economic powers of the European continent and a historic leader in many theoretical and technical fields.'),('DJ','262','Djibouti','Djibouti',223816,'23000',740528,'AF','.dj','DJF','Franc','253','fr-DJ,ar,so-DJ,aa','ER,ET,SO',NULL),('DK','208','Denmark','Copenhagen',2623032,'43094',5484000,'EU','.dk','DKK','Krone','45','da-DK,en,fo,de-DK','DE','Denmark, officially the Kingdom of Denmark, is a Nordic country. Denmark proper, which is the southernmost of the Scandinavian countries, consists of a peninsula, Jutland, and an archipelago of 443 named islands, with the largest being Zealand, Funen and the North Jutlandic Island. The islands are characterised by flat, arable land and sandy coasts, low elevation and a temperate climate. The southernmost of the Scandinavian nations, Denmark lies southwest of Sweden and south of Norway, and is bordered to the south by Germany. The Kingdom of Denmark also includes two autonomous territories in the North Atlantic Ocean: the Faroe Islands and Greenland. Denmark has a total area of 42,924 km2 (16,573 sq mi), land area of 42,394 km2 (16,368 sq mi), and the total area including Greenland and the Faroe Islands is 2,210,579 km2 (853,509 sq mi), and a population of 5.8 million (as of 2019).'),('DM','212','Dominica','Roseau',3575830,'754',72813,'NA','.dm','XCD','Dollar','+1-767','en-DM',NULL,NULL),('DO','214','Dominican Republic','Santo Domingo',3508796,'48730',9823821,'NA','.do','DOP','Peso','+1-809 and 1-829','es-DO','HT',NULL),('DZ','012','Algeria','Algiers',2589581,'2381740',34586184,'AF','.dz','DZD','Dinar','213','ar-DZ','NE,EH,LY,MR,TN,MA,ML','Algeria, officially the People\'s Democratic Republic of Algeria, is a country in the Maghreb region of North Africa. The capital and most populous city is Algiers, located in the far north of the country on the Mediterranean coast. With an area of 2,381,741 square kilometres (919,595 sq mi), Algeria is the tenth-largest country in the world, the world\'s largest Arab country, and the largest in Africa. Algeria is bordered to the northeast by Tunisia, to the east by Libya, to the west by Morocco, to the southwest by the Western Saharan territory, Mauritania, and Mali, to the southeast by Niger, and to the north by the Mediterranean Sea. The country is a semi-presidential republic consisting of 48 provinces and 1,541 communes (counties). It has the highest human development index of all the non-island African countries.'),('EC','218','Ecuador','Quito',3658394,'283560',14790608,'SA','.ec','USD','Dollar','593','es-EC','PE,CO','Ecuador, officially the Republic of Ecuador, is a country in northwestern South America, bordered by Colombia on the north, Peru on the east and south, and the Pacific Ocean on the west. Ecuador also includes the Galapagos Islands in the Pacific, about 1,000 kilometres (620 mi) west of the mainland. The capital city is Quito, which is also the largest city since 2018.'),('EE','233','Estonia','Tallinn',453733,'45226',1291170,'EU','.ee','EUR','Euro','372','et,ru','RU,LV','Estonia, officially the Republic of Estonia , is a country on the eastern coast of the Baltic Sea in Northern Europe. It is bordered to the north by the Gulf of Finland with Finland on the other side, to the west by the Baltic Sea with Sweden on the other side, to the south by Latvia (343 km), and to the east by Lake Peipus and Russia (338.6 km). The territory of Estonia consists of a mainland and 2,222 islands in the Baltic Sea, covering a total area of 45,227 km2 (17,462 sq mi), water 2,839 km2 (1,096 sq mi), land area 42,388 km2 (16,366 sq mi), and is influenced by a humid continental climate. The official language of the country, Estonian, is the second-most-spoken Finnic language.'),('EG','818','Egypt','Cairo',357994,'1001450',80471869,'AF','.eg','EGP','Pound','20','ar-EG,en,fr','LY,SD,IL','Egypt, officially the Arab Republic of Egypt, is a country in the northeast corner of Africa, whose territory in the Sinai Peninsula extends beyond the continental boundary with Asia, as traditionally defined. Egypt is bordered by the Gaza Strip and Israel to the northeast, the Gulf of Aqaba and the Red Sea to the east, Sudan to the south, Libya to the west, and the Mediterranean Sea to the north. Across the Gulf of Aqaba lies Jordan, across the Red Sea lies Saudi Arabia, and across the Mediterranean lie Greece, Turkey and Cyprus, although none share a land border with Egypt.'),('EH','732','Western Sahara','El-Aaiun',2461445,'266000',273008,'AF','.eh','MAD','Dirham','212','ar,mey','DZ,MR,MA',NULL),('ER','232','Eritrea','Asmara',338010,'121320',5792984,'AF','.er','ERN','Nakfa','291','aa-ER,ar,tig,kun,ti-ER','ET,SD,DJ',NULL),('ES','724','Spain','Madrid',2510769,'504782',46505963,'EU','.es','EUR','Euro','34','es-ES,ca,gl,eu,oc','AD,PT,GI,FR,MA','Spain is a sovereign state and a member of the European Union located in southwestern Europe on the Iberian Peninsula. Its mainland is bordered to the south and east by the Mediterranean Sea except for a small land boundary with the British Overseas Territory of Gibraltar, to which Spain lays claim; to the north and north east by France, Andorra, and the Bay of Biscay; and to the northwest and west by the Atlantic Ocean and Portugal.'),('ET','231','Ethiopia','Addis Ababa',337996,'1127127',88013491,'AF','.et','ETB','Birr','251','am,en-ET,om-ET,ti-ET,so-ET,sid','ER,KE,SD,SS,SO,DJ','Ethiopia, officially the Federal Democratic Republic of Ethiopia, is a country in the northeastern part of Africa, known as the Horn of Africa. It shares borders with Eritrea to the north, Djibouti to the northeast, the de facto state of Somaliland and Somalia to the east, Kenya to the south, South Sudan to the west and Sudan to the northwest. With over 102 million inhabitants, Ethiopia is the most populous landlocked country in the world and the second-most populous nation on the African continent with a total area of 1,100,000 square kilometres (420,000 sq mi). Its capital and largest city is Addis Ababa, which lies a few miles west of the East African Rift that splits the country into the Nubian and Somali tectonic plates.'),('FI','246','Finland','Helsinki',660013,'337030',5244000,'EU','.fi','EUR','Euro','358','fi-FI,sv-FI,smn','NO,RU,SE','Finland, officially the Republic of Finland, is a Nordic country in Northern Europe bordering the Baltic Sea, Gulf of Bothnia, and Gulf of Finland, between Norway to the north, Sweden to the northwest, and Russia to the east. The capital and largest city is Helsinki. Other major cities are Espoo, Vantaa, Tampere, Oulu and Turku.'),('FJ','242','Fiji','Suva',2205218,'18270',875983,'OC','.fj','FJD','Dollar','679','en-FJ,fj',NULL,NULL),('FK','238','Falkland Islands','Stanley',3474414,'12173',2638,'SA','.fk','FKP','Pound','500','en-FK',NULL,NULL),('FM','583','Micronesia','Palikir',2081918,'702',107708,'OC','.fm','USD','Dollar','691','en-FM,chk,pon,yap,kos,uli,woe,nkr,kpg',NULL,NULL),('FO','234','Faroe Islands','Torshavn',2622320,'1399',48228,'EU','.fo','DKK','Krone','298','fo,da-FO',NULL,NULL),('FR','250','France','Paris',3017382,'547030',64768389,'EU','.fr','EUR','Euro','33','fr-FR,frp,br,co,ca,eu,oc','CH,DE,BE,LU,IT,AD,MC,ES','France is a unitary semi-presidential republic in Western Europe with several overseas territories and islands. Metropolitan France extends from the Mediterranean Sea to the English Channel and the North Sea, and from the Rhine to the Atlantic Ocean. It is often referred to as l\'Hexagone (\"The Hexagon\") because of the geometric shape of its territory.'),('GA','266','Gabon','Libreville',2400553,'267667',1545255,'AF','.ga','XAF','Franc','241','fr-GA','CM,GQ,CG',NULL),('GB','826','United Kingdom','London',2635167,'244820',62348447,'EU','.uk','GBP','Pound','44','en-GB,cy-GB,gd','IE','The United Kingdom of Great Britain and Northern Ireland, commonly known as the United Kingdom (UK) or Britain, is a sovereign state located off the north-western coast of continental Europe. The country includes the island of Great Britain, the north-eastern part of the island of Ireland, and many smaller islands. Northern Ireland is the only part of the UK that shares a land border with another sovereign state. Apart from this land border the UK is surrounded by the Atlantic Ocean, the North Sea, the English Channel and the Irish Sea.'),('GD','308','Grenada','St. George\'s',3580239,'344',107818,'NA','.gd','XCD','Dollar','+1-473','en-GD',NULL,NULL),('GE','268','Georgia','Tbilisi',614540,'69700',4630000,'AS','.ge','GEL','Lari','995','ka,ru,hy,az','AM,AZ,TR,RU',NULL),('GF','254','French Guiana','Cayenne',3381670,'91000',195506,'SA','.gf','EUR','Euro','594','fr-GF','SR,BR',NULL),('GG','831','Guernsey','St Peter Port',3042362,'78',65228,'EU','.gg','GBP','Pound','+44-1481','en,fr',NULL,NULL),('GH','288','Ghana','Accra',2300660,'239460',24339838,'AF','.gh','GHS','Cedi','233','en-GH,ak,ee,tw','CI,TG,BF','Ghana is a country in West Africa. It is bordered by Cote d\'Ivoire (Ivory Coast) to the west, Burkina Faso to the north, Togo to the east, and the Gulf of Guinea to the south. The word Ghana means \"Warrior King\" and is derived from the ancient Ghana Empire.'),('GI','292','Gibraltar','Gibraltar',2411586,'6.5',27884,'EU','.gi','GIP','Pound','350','en-GI,es,it,pt','ES',NULL),('GL','304','Greenland','Nuuk',3425505,'2166086',56375,'NA','.gl','DKK','Krone','299','kl,da-GL,en',NULL,NULL),('GM','270','Gambia','Banjul',2413451,'11300',1593256,'AF','.gm','GMD','Dalasi','220','en-GM,mnk,wof,wo,ff','SN',NULL),('GN','324','Guinea','Conakry',2420477,'245857',10324025,'AF','.gn','GNF','Franc','224','fr-GN','LR,SN,SL,CI,GW,ML',NULL),('GP','312','Guadeloupe','Basse-Terre',3579143,'1780',443000,'NA','.gp','EUR','Euro','590','fr-GP','AN',NULL),('GQ','226','Equatorial Guinea','Malabo',2309096,'28051',1014999,'AF','.gq','XAF','Franc','240','es-GQ,fr','GA,CM',NULL),('GR','300','Greece','Athens',390903,'131940',11000000,'EU','.gr','EUR','Euro','30','el-GR,en,fr','AL,MK,TR,BG','Greece, officially the Hellenic Republic, is a country located in Southeast Europe. Its population is approximately 10.7 million as of 2018; Athens is the nation\'s capital and largest city, followed by Thessaloniki.'),('GS','239','South Georgia and the South Sandwich Islands','Grytviken',3474415,'3903',30,'AN','.gs','GBP','Pound',NULL,'en',NULL,NULL),('GT','320','Guatemala','Guatemala City',3595528,'108890',13550440,'NA','.gt','GTQ','Quetzal','502','es-GT','MX,HN,BZ,SV','Guatemala, officially the Republic of Guatemala, is a country in Central America bordered by Mexico to the north and west, Belize and the Caribbean to the northeast, Honduras to the east, El Salvador to the southeast and the Pacific Ocean to the south. With an estimated population of around 16.6 million, it is the most populated country in Central America. Guatemala is a representative democracy; its capital and largest city is Nueva Guatemala de la Asuncion, also known as Guatemala City.'),('GU','316','Guam','Hagatna',4043988,'549',159358,'OC','.gu','USD','Dollar','+1-671','en-GU,ch-GU',NULL,NULL),('GW','624','Guinea-Bissau','Bissau',2372248,'36120',1565126,'AF','.gw','XOF','Franc','245','pt-GW,pov','SN,GN',NULL),('GY','328','Guyana','Georgetown',3378535,'214970',748486,'SA','.gy','GYD','Dollar','592','en-GY','SR,BR,VE',NULL),('HK','344','Hong Kong','Hong Kong',1819730,'1092',6898686,'AS','.hk','HKD','Dollar','852','zh-HK,yue,zh,en',NULL,NULL),('HM','334','Heard Island and McDonald Islands',NULL,1547314,'412',0,'AN','.hm','AUD','Dollar',NULL,NULL,NULL,NULL),('HN','340','Honduras','Tegucigalpa',3608932,'112090',7989415,'NA','.hn','HNL','Lempira','504','es-HN','GT,NI,SV',NULL),('HR','191','Croatia','Zagreb',3202326,'56542',4491000,'EU','.hr','HRK','Kuna','385','hr-HR,sr','HU,SI,CS,BA,ME,RS','Croatia, officially the Republic of Croatia, is a country at the crossroads of Central and Southeast Europe, on the Adriatic Sea. It borders Slovenia to the northwest, Hungary to the northeast, Serbia to the east, Bosnia and Herzegovina, and Montenegro to the southeast, sharing a maritime border with Italy. Its capital, Zagreb, forms one of the country\'s primary subdivisions, along with twenty counties. Croatia has an area of 56,594 square kilometres (21,851 square miles) and a population of 4.28 million, most of whom are Roman Catholics.'),('HT','332','Haiti','Port-au-Prince',3723988,'27750',9648924,'NA','.ht','HTG','Gourde','509','ht,fr-HT','DO',NULL),('HU','348','Hungary','Budapest',719819,'93030',9930000,'EU','.hu','HUF','Forint','36','hu-HU','SK,SI,RO,UA,CS,HR,AT,RS','Hungary is a country in Central Europe. Spanning 93,030 square kilometres (35,920 sq mi) in the Carpathian Basin, it borders Slovakia to the north, Ukraine to the northeast, Austria to the northwest, Romania to the east, Serbia to the south, Croatia to the southwest, and Slovenia to the west. With about 10 million inhabitants, Hungary is a medium-sized member state of the European Union. The official language is Hungarian, which is the most widely spoken Uralic language in the world, and among the few non-Indo-European languages to be widely spoken in Europe. Hungary\'s capital and largest city is Budapest; other major urban areas include Debrecen, Szeged, Miskolc, Pecs and Gyor.'),('ID','360','Indonesia','Jakarta',1643084,'1919440',242968342,'AS','.id','IDR','Rupiah','62','id,en,nl,jv','PG,TL,MY','Indonesia is a country in Southeast Asia, between the Indian and Pacific oceans. It is the world\'s largest island country, with more than seventeen thousand islands, and at 1,904,569 square kilometres (735,358 square miles), the 14th largest by land area and 7th in the combined sea and land area. With over 261 million people, it is the world\'s 4th most populous country as well as the most populous Muslim-majority country. Java, the world\'s most populous island, is home to more than half of the country\'s population.'),('IE','372','Ireland','Dublin',2963597,'70280',4622917,'EU','.ie','EUR','Euro','353','en-IE,ga-IE','GB','Ireland is an island in the North Atlantic. It is separated from Great Britain to its east by the North Channel, the Irish Sea, and St George\'s Channel. Ireland is the second-largest island of the British Isles, the third-largest in Europe, and the twentieth-largest on Earth.'),('IL','376','Israel','Jerusalem',294640,'20770',7353985,'AS','.il','ILS','Shekel','972','he,ar-IL,en-IL,','SY,JO,LB,EG,PS','Israel, also known as the State of Israel, is a country in Western Asia, located on the southeastern shore of the Mediterranean Sea and the northern shore of the Red Sea. It has land borders with Lebanon to the north, Syria to the northeast, Jordan on the east, the Palestinian territories of the West Bank and Gaza Strip to the east and west, respectively, and Egypt to the southwest. The country contains geographically diverse features within its relatively small area. Israel\'s economic and technological center is Tel Aviv, while its seat of government and proclaimed capital is Jerusalem, although the state\'s sovereignty over Jerusalem has only partial recognition.'),('IM','833','Isle of Man','Douglas, Isle of Man',3042225,'572',75049,'EU','.im','GBP','Pound','+44-1624','en,gv',NULL,NULL),('IN','356','India','New Delhi',1269750,'3287590',1173108018,'AS','.in','INR','Rupee','91','en-IN,hi,bn,te,mr,ta,ur,gu,kn,ml,or,pa,as,bh,sat,ks,ne,sd,kok,doi,mni,sit,sa,fr,lus,inc','CN,NP,MM,BT,PK,BD','India is a country in South Asia. It is the seventh-largest country by area, the second-most populous country, and the most populous democracy in the world. Bounded by the Indian Ocean on the south, the Arabian Sea on the southwest, and the Bay of Bengal on the southeast, it shares land borders with Pakistan to the west; China, Nepal, and Bhutan to the north; and Bangladesh and Myanmar to the east. In the Indian Ocean, India is in the vicinity of Sri Lanka and the Maldives; its Andaman and Nicobar Islands share a maritime border with Thailand and Indonesia.'),('IO','086','British Indian Ocean Territory','Diego Garcia',1282588,'60',4000,'AS','.io','USD','Dollar','246','en-IO',NULL,NULL),('IQ','368','Iraq','Baghdad',99237,'437072',29671605,'AS','.iq','IQD','Dinar','964','ar-IQ,ku,hy','SY,SA,IR,JO,TR,KW','Iraq, officially the Republic of Iraq, is a country in Western Asia, bordered by Turkey to the north, Iran to the east, Kuwait to the southeast, Saudi Arabia to the south, Jordan to the southwest and Syria to the west. The capital, and largest city, is Baghdad. Iraq is home to diverse ethnic groups including Arabs, Kurds, Chaldeans, Assyrians, Turkmen, Shabakis, Yazidis, Armenians, Mandeans, Circassians and Kawliya. Around 95% of the country\'s 37 million citizens are Muslims, with Christianity, Yarsan, Yezidism and Mandeanism also present. The official languages of Iraq are Arabic and Kurdish.'),('IR','364','Iran','Tehran',130758,'1648000',76923300,'AS','.ir','IRR','Rial','98','fa-IR,ku','TM,AF,IQ,AM,PK,AZ,TR','Iran, also called Persia, and officially the Islamic Republic of Iran, is a country in Western Asia. With 82 million inhabitants, Iran is the world\'s 18th most populous country. Its territory spans 1,648,195 km2 (636,372 sq mi), making it the second largest country in the Middle East and the 17th largest in the world. Iran is bordered to the northwest by Armenia and the Republic of Azerbaijan, to the north by the Caspian Sea, to the northeast by Turkmenistan, to the east by Afghanistan and Pakistan, to the south by the Persian Gulf and the Gulf of Oman, and to the west by Turkey and Iraq. Its central location in Eurasia and Western Asia, and its proximity to the Strait of Hormuz, give it geostrategic importance. Tehran is the political and economic center of Iran, and the largest and most populous city in Western Asia with more than 8.8 million residents in the city and 15 million in the larger metropolitan area.'),('IS','352','Iceland','Reykjavik',2629691,'103000',308910,'EU','.is','ISK','Krona','354','is,en,de,da,sv,no',NULL,'The Republic of Iceland is a Nordic island country in the North Atlantic Ocean. It has a population of 332,529 and an area of 103,000 km2 (40,000 sq mi), making it the most sparsely populated country in Europe. The capital and largest city is Reykjavik. Reykjavik and the surrounding areas in the southwest of the country are home to over two-thirds of the population. Iceland is volcanically and geologically active. The interior consists of a plateau characterised by sand and lava fields, mountains and glaciers, while many glacial rivers flow to the sea through the lowlands. Iceland is warmed by the Gulf Stream and has a temperate climate, despite a high latitude just outside the Arctic Circle. Its high latitude and marine influence still keeps summers chilly, with most of the archipelago having a tundra climate.'),('IT','380','Italy','Rome',3175395,'301230',60340328,'EU','.it','EUR','Euro','39','it-IT,de-IT,fr-IT,sc,ca,co,sl','CH,VA,SI,SM,FR,AT','Italy is a unitary parliamentary republic in Southern Europe. To the north, it borders France, Switzerland, Austria, and Slovenia along the Alps. To the south, it consists of the entirety of the Italian Peninsula, Sicily, Sardinia and many other smaller islands. The independent states of San Marino and the Vatican City are enclaves within Italy, while Campione d\'Italia is an Italian exclave in Switzerland. The territory of Italy covers some 301,338 km2 (116,347 sq mi) and is influenced by a temperate seasonal climate. With 60.8 million inhabitants, it is the fifth most populous country in Europe, and the 23rd most populous in the world.'),('JE','832','Jersey','Saint Helier',3042142,'116',90812,'EU','.je','GBP','Pound','+44-1534','en,pt',NULL,NULL),('JM','388','Jamaica','Kingston',3489940,'10991',2847232,'NA','.jm','JMD','Dollar','+1-876','en-JM',NULL,'Jamaica is an island country situated in the Caribbean Sea. Spanning 10,990 square kilometres (4,240 sq mi) in area, it is the third-largest island of the Greater Antilles and the Caribbean (after Cuba and Hispaniola).[9] Jamaica lies about 145 kilometres (90 mi) south of Cuba, and 191 kilometres (119 mi) west of Hispaniola (the island containing the countries of Haiti and the Dominican Republic); the British Overseas Territory of the Cayman Islands lies some 215 kilometres (134 mi) to the north-west.'),('JO','400','Jordan','Amman',248816,'92300',6407085,'AS','.jo','JOD','Dinar','962','ar-JO,en','SY,SA,IQ,IL,PS','Jordan, officially the Hashemite Kingdom of Jordan, north and Israel and Palestine (West Bank) to the west. The Dead Sea is located along its western borders and the country has a short 26-kilometre (16 mi) coastline on the Red Sea in its extreme south-west, but is otherwise landlocked. Jordan is strategically located at the crossroads of Asia, Africa and Europe. The capital, Amman, is Jordan\'s most populous city as well as the country\'s economic, political and cultural centre.'),('JP','392','Japan','Tokyo',1861060,'377835',127288000,'AS','.jp','JPY','Yen','81','ja',NULL,'Japan is an island country in East Asia. Located in the Pacific Ocean, it lies off the eastern coast of the Asian continent and stretches from the Sea of Okhotsk in the north to the East China Sea and the Philippine Sea in the south.'),('KE','404','Kenya','Nairobi',192950,'582650',40046566,'AF','.ke','KES','Shilling','254','en-KE,sw-KE','ET,TZ,SS,SO,UG','Kenya, officially the Republic of Kenya, is a country in Africa with 47 semiautonomous counties governed by elected governors. At 580,367 square kilometres (224,081 sq mi), Kenya is the world\'s 48th largest country by total area. With a population of more than 52.2 million people, Kenya is the 27th most populous country. Kenya\'s capital and largest city is Nairobi while its oldest city and first capital is the coastal city of Mombasa. Kisumu City is the third largest city and also an inland port on Lake Victoria. Other important urban centres include Nakuru and Eldoret.'),('KG','417','Kyrgyzstan','Bishkek',1527747,'198500',5508626,'AS','.kg','KGS','Som','996','ky,uz,ru','CN,TJ,UZ,KZ',NULL),('KH','116','Cambodia','Phnom Penh',1831722,'181040',14453680,'AS','.kh','KHR','Riels','855','km,fr,en','LA,TH,VN','Cambodia, officially the Kingdom of Cambodia, is a country located in the southern portion of the Indochina peninsula in Southeast Asia. It is 181,035 square kilometres (69,898 square miles) in area, bordered by Thailand to the northwest, Laos to the northeast, Vietnam to the east and the Gulf of Thailand to the southwest.'),('KI','296','Kiribati','Tarawa',4030945,'811',92533,'OC','.ki','AUD','Dollar','686','en-KI,gil',NULL,NULL),('KM','174','Comoros','Moroni',921929,'2170',773407,'AF','.km','KMF','Franc','269','ar,fr-KM',NULL,NULL),('KN','659','Saint Kitts and Nevis','Basseterre',3575174,'261',49898,'NA','.kn','XCD','Dollar','+1-869','en-KN',NULL,NULL),('KP','408','North Korea','Pyongyang',1873107,'120540',22912177,'AS','.kp','KPW','Won','850','ko-KP','CN,KR,RU',NULL),('KR','410','South Korea','Seoul',1835841,'98480',48422644,'AS','.kr','KRW','Won','82','ko-KR,en','KP','South Korea is a country in East Asia, constituting the southern part of the Korean Peninsula and sharing a land border with North Korea. The name Korea is derived from Goguryeo which was one of the great powers in East Asia during its time, ruling most of the Korean Peninsula, Manchuria, parts of the Russian Far East and Inner Mongolia under Gwanggaeto the Great. Its capital, Seoul, is a major global city and half of South Korea\'s over 51 million people live in the Seoul Capital Area, the fourth largest metropolitan economy in the world.'),('KW','414','Kuwait','Kuwait City',285570,'17820',2789132,'AS','.kw','KWD','Dinar','965','ar-KW,en','SA,IQ',NULL),('KY','136','Cayman Islands','George Town',3580718,'262',44270,'NA','.ky','KYD','Dollar','+1-345','en-KY',NULL,NULL),('KZ','398','Kazakhstan','Astana',1522867,'2717300',15340000,'AS','.kz','KZT','Tenge','7','kk,ru','TM,CN,KG,UZ,RU',NULL),('LA','418','Laos','Vientiane',1655842,'236800',6368162,'AS','.la','LAK','Kip','856','lo,fr,en','CN,MM,KH,TH,VN','Laos, officially the Lao People\'s Democratic Republic, or commonly referred to its colloquial name of Muang Lao is a landlocked country in the heart of the Indochinese peninsula of Mainland Southeast Asia, bordered by Myanmar (Burma) and China to the northwest, Vietnam to the east, Cambodia to the south, and Thailand to the west.'),('LB','422','Lebanon','Beirut',272103,'10400',4125247,'AS','.lb','LBP','Pound','961','ar-LB,fr-LB,en,hy','SY,IL',NULL),('LC','662','Saint Lucia','Castries',3576468,'616',160922,'NA','.lc','XCD','Dollar','+1-758','en-LC',NULL,NULL),('LI','438','Liechtenstein','Vaduz',3042058,'160',35000,'EU','.li','CHF','Franc','423','de-LI','CH,AT',NULL),('LK','144','Sri Lanka','Colombo',1227603,'65610',21513990,'AS','.lk','LKR','Rupee','94','si,ta,en',NULL,'Sri Lanka, officially the Democratic Socialist Republic of Sri Lanka, is an island country in South Asia, located in the Indian Ocean to the southwest of the Bay of Bengal and to the southeast of the Arabian Sea. The island is geographically separated from the Indian subcontinent by the Gulf of Mannar and the Palk Strait. The legislative capital, Sri Jayawardenepura Kotte, is a suburb of the commercial capital and largest city, Colombo.'),('LR','430','Liberia','Monrovia',2275384,'111370',3685076,'AF','.lr','LRD','Dollar','231','en-LR','SL,CI,GN',NULL),('LS','426','Lesotho','Maseru',932692,'30355',1919552,'AF','.ls','LSL','Loti','266','en-LS,st,zu,xh','ZA',NULL),('LT','440','Lithuania','Vilnius',597427,'65200',3565000,'EU','.lt','LTL','Litas','370','lt,ru,pl','PL,BY,RU,LV','Lithuania, officially the Republic of Lithuania, is a country in the Baltic region of Europe. Lithuania is considered to be one of the Baltic states. It is situated along the southeastern shore of the Baltic Sea, to the east of Sweden and Denmark. It is bordered by Latvia to the north, Belarus to the east and south, Poland to the south, and Kaliningrad Oblast (a Russian exclave) to the southwest. Lithuania has an estimated population of 2.8 million people as of 2019, and its capital and largest city is Vilnius. Other major cities are Kaunas and Klaipeda. Lithuanians are Baltic people. The official language, Lithuanian, is one of only two living languages in the Baltic branch of the Indo-European language family, the other being Latvian.'),('LU','442','Luxembourg','Luxembourg',2960313,'2586',497538,'EU','.lu','EUR','Euro','352','lb,de-LU,fr-LU','DE,BE,FR','Luxembourg, officially the Grand Duchy of Luxembourg, is a landlocked microstate in western Europe. It is bordered by Belgium to the west and north, Germany to the east, and France to the south. Its capital, Luxembourg City, is one of the four official capitals of the European Union (together with Brussels, Frankfurt, and Strasbourg) and the seat of the European Court of Justice, the highest judicial authority in the EU. Its culture, people, and languages are highly intertwined with its neighbours, making it essentially a mixture of French and German cultures, as evident by the nation\'s three official languages: French, German, and the national language of Luxembourgish. The repeated invasions by Germany, especially in World War II, resulted in the country\'s strong will for mediation between France and Germany and, among other things, led to the foundation of the European Union.'),('LV','428','Latvia','Riga',458258,'64589',2217969,'EU','.lv','LVL','Lat','371','lv,ru,lt','LT,EE,BY,RU','Latvia, officially the Latvian Republic, is a country in the Baltic region of Northern Europe. Since its independence, Latvia has been referred to as one of the Baltic states. It is bordered by Estonia to the north, Lithuania to the south, Russia to the east, and Belarus to the southeast, and shares a maritime border with Sweden to the west. Latvia has 1,957,200 inhabitants and a territory of 64,589 km2 (24,938 sq mi). The country has a temperate seasonal climate.'),('LY','434','Libya','Tripolis',2215636,'1759540',6461454,'AF','.ly','LYD','Dinar','218','ar-LY,it,en','TD,NE,DZ,SD,TN,EG','Libya, officially the State of Libya, is a country in the Maghreb region in North Africa, bordered by the Mediterranean Sea to the north, Egypt to the east, Sudan to the southeast, Chad to the south, Niger to the southwest, Algeria to the west, and Tunisia to the northwest. The sovereign state is made of three historical regions: Tripolitania, Fezzan and Cyrenaica. With an area of almost 1.8 million square kilometres (700,000 sq mi), Libya is the fourth largest country in Africa, and is the 16th largest country in the world. Libya has the 10th-largest proven oil reserves of any country in the world. The largest city and capital, Tripoli, is located in western Libya and contains over one million of Libya\'s six million people. The second-largest city is Benghazi, which is located in eastern Libya.'),('MA','504','Morocco','Rabat',2542007,'446550',31627428,'AF','.ma','MAD','Dirham','212','ar-MA,fr','DZ,EH,ES','Morocco, officially the Kingdom of Morocco, is a sovereign state located in the Maghreb region of North Africa. It overlooks the Mediterranean Sea to the north and the Atlantic Ocean to the west. Morocco claims the areas of Ceuta, Melilla and Peñón de Velez de la Gomera, all of them under Spanish jurisdiction. The capital is Rabat and the largest city Casablanca. Morocco spans an area of 710,850 km2 (274,460 sq mi) and has a population of over 35 million.'),('MC','492','Monaco','Monaco',2993457,'1.95',32965,'EU','.mc','EUR','Euro','377','fr-MC,en,it','FR',NULL),('MD','498','Moldova','Chisinau',617790,'33843',4324000,'EU','.md','MDL','Leu','373','ro,ru,gag,tr','RO,UA',NULL),('ME','499','Montenegro','Podgorica',3194884,'14026',666730,'EU','.me','EUR','Euro','382','sr,hu,bs,sq,hr,rom','AL,HR,BA,RS,XK',NULL),('MF','663','Saint Martin','Marigot',3578421,'53',35925,'NA','.gp','EUR','Euro','590','fr','SX',NULL),('MG','450','Madagascar','Antananarivo',1062947,'587040',21281844,'AF','.mg','MGA','Ariary','261','fr-MG,mg',NULL,'Madagascar, officially the Republic of Madagascar, and previously known as the Malagasy Republic, is an island country in the Indian Ocean, approximately 400 kilometres (250 miles) off the coast of East Africa. At 592,800 square kilometres (228,900 sq mi) Madagascar is the world\'s 2nd largest island country. The nation comprises the island of Madagascar (the fourth-largest island in the world) and numerous smaller peripheral islands. Following the prehistoric breakup of the supercontinent Gondwana, Madagascar split from the Indian subcontinent around 88 million years ago, allowing native plants and animals to evolve in relative isolation. Consequently, Madagascar is a biodiversity hotspot; over 90% of its wildlife is found nowhere else on Earth. The island\'s diverse ecosystems and unique wildlife are threatened by the encroachment of the rapidly growing human population and other environmental threats.'),('MH','584','Marshall Islands','Majuro',2080185,'181.3',65859,'OC','.mh','USD','Dollar','692','mh,en-MH',NULL,NULL),('MK','807','Macedonia','Skopje',718075,'25333',2061000,'EU','.mk','MKD','Denar','389','mk,sq,tr,rmm,sr','AL,GR,CS,BG,RS,XK',NULL),('ML','466','Mali','Bamako',2453866,'1240000',13796354,'AF','.ml','XOF','Franc','223','fr-ML,bm','SN,NE,DZ,CI,GN,MR,BF',NULL),('MM','104','Myanmar','Nay Pyi Taw',1327865,'678500',53414374,'AS','.mm','MMK','Kyat','95','my','CN,LA,TH,BD,IN','Myanmar, officially the Republic of the Union of Myanmar, and also known as Burma, is a country in Southeast Asia. Myanmar is bordered by India and Bangladesh to its west, Thailand and Laos to its east and China to its north and northeast. Myanmar is the largest of the mainland Southeast Asian states. To its south, about one third of Myanmar\'s total perimeter of 5,876 km (3,651 mi) forms an uninterrupted coastline of 1,930 km (1,200 mi) along the Bay of Bengal and the Andaman Sea. The country\'s 2014 census counted the population to be 51 million people. As of 2017, the population is about 54 million. Myanmar is 676,578 square kilometres (261,228 square miles) in size. Its capital city is Naypyidaw (Nay Pyi Taw), and its largest city is Yangon (Rangoon). Myanmar has been a member of the Association of Southeast Asian Nations (ASEAN) since 1997.'),('MN','496','Mongolia','Ulan Bator',2029969,'1565000',3086918,'AS','.mn','MNT','Tugrik','976','mn,ru','CN,RU','Mongolia is a landlocked country in East Asia. Its area is roughly equivalent with the historical territory of Outer Mongolia, and that term is sometimes used to refer to the current state. It is sandwiched between Russia to the north and China to the south, where it neighbours the Inner Mongolia Autonomous Region. Mongolia does not share a border with Kazakhstan, although only 37 kilometres (23 mi) separates them.'),('MO','446','Macao','Macao',1821275,'254',449198,'AS','.mo','MOP','Pataca','853','zh,zh-MO,pt',NULL,NULL),('MP','580','Northern Mariana Islands','Saipan',4041468,'477',53883,'OC','.mp','USD','Dollar','+1-670','fil,tl,zh,ch-MP,en-MP',NULL,NULL),('MQ','474','Martinique','Fort-de-France',3570311,'1100',432900,'NA','.mq','EUR','Euro','596','fr-MQ',NULL,NULL),('MR','478','Mauritania','Nouakchott',2378080,'1030700',3205060,'AF','.mr','MRO','Ouguiya','222','ar-MR,fuc,snk,fr,mey,wo','SN,DZ,EH,ML',NULL),('MS','500','Montserrat','Plymouth',3578097,'102',9341,'NA','.ms','XCD','Dollar','+1-664','en-MS',NULL,NULL),('MT','470','Malta','Valletta',2562770,'316',403000,'EU','.mt','EUR','Euro','356','mt,en-MT',NULL,'Malta, officially known as the Republic of Malta, is a Southern European island country consisting of an archipelago in the Mediterranean Sea. It lies 80 km (50 mi) south of Italy, 284 km (176 mi) east of Tunisia, and 333 km (207 mi) north of Libya. With a population of about 475,000 over an area of 316 km2 (122 sq mi), Malta is the world\'s tenth smallest and fifth most densely populated country. Its capital is Valletta, which is the smallest national capital in the European Union by area at 0.8 km2. The official languages are Maltese and English, with Maltese officially recognised as the national language and the only Semitic language in the European Union.'),('MU','480','Mauritius','Port Louis',934292,'2040',1294104,'AF','.mu','MUR','Rupee','230','en-MU,bho,fr',NULL,NULL),('MV','462','Maldives','Male',1282028,'300',395650,'AS','.mv','MVR','Rufiyaa','960','dv,en',NULL,NULL),('MW','454','Malawi','Lilongwe',927384,'118480',15447500,'AF','.mw','MWK','Kwacha','265','ny,yao,tum,swk','TZ,MZ,ZM',NULL),('MX','484','Mexico','Mexico City',3996063,'1972550',112468855,'NA','.mx','MXN','Peso','52','es-MX','GT,US,BZ','Mexico, officially the United Mexican States, is a country in the southern portion of North America. It is bordered to the north by the United States; to the south and west by the Pacific Ocean; to the southeast by Guatemala, Belize, and the Caribbean Sea; and to the east by the Gulf of Mexico. Covering almost 2,000,000 square kilometers (770,000 sq mi), the nation is the fourth largest country in the Americas by total area and the 13th largest independent state in the world. With an estimated population of over 129 million people, Mexico is the tenth most populous country and the most populous Spanish-speaking country in the world, while being the second most populous nation in Latin America after Brazil. Mexico is a federation comprising 31 states plus Mexico City (CDMX), which is the capital city and its most populous city. Other metropolises in the country include Guadalajara, Monterrey, Puebla, Toluca, Tijuana, and Leon.'),('MY','458','Malaysia','Kuala Lumpur',1733045,'329750',28274729,'AS','.my','MYR','Ringgit','60','ms-MY,en,zh,ta,te,ml,pa,th','BN,TH,ID','Malaysia is a country in Southeast Asia. The federal constitutional monarchy consists of 13 states and three federal territories, separated by the South China Sea into two similarly sized regions, Peninsular Malaysia and East Malaysia (Malaysian Borneo). Peninsular Malaysia shares a land and maritime border with Thailand and maritime borders with Singapore, Vietnam, and Indonesia. East Malaysia shares land and maritime borders with Brunei and Indonesia and a maritime border with the Philippines and Vietnam. Kuala Lumpur is the national capital and largest city while Putrajaya is the seat of the federal government. With a population of over 30 million, Malaysia is the world\'s 44th most populous country. The southernmost point of continental Eurasia, Tanjung Piai, is in Malaysia. In the tropics, Malaysia is one of 17 megadiverse countries, with large numbers of endemic species.'),('MZ','508','Mozambique','Maputo',1036973,'801590',22061451,'AF','.mz','MZN','Metical','258','pt-MZ,vmw','ZW,TZ,SZ,ZA,ZM,MW','Mozambique, officially the Republic of Mozambique, is a country located in Southeast Africa bordered by the Indian Ocean to the east, Tanzania to the north, Malawi and Zambia to the northwest, Zimbabwe to the west, and Eswatini (Swaziland) and South Africa to the southwest. The sovereign state is separated from the Comoros, Mayotte and Madagascar by the Mozambique Channel to the east. The capital and largest city of Mozambique is Maputo (formerly known as \"Lourenco Marques\" from 1876 to 1976).'),('NA','516','Namibia','Windhoek',3355338,'825418',2128471,'AF','.na','NAD','Dollar','264','en-NA,af,de,hz,naq','ZA,BW,ZM,AO','Namibia, officially the Republic of Namibia, is a country in southern Africa. Its western border is the Atlantic Ocean; it shares land borders with Zambia and Angola to the north, Botswana to the east and South Africa to the south and east. Although it does not border Zimbabwe, less than 200 metres of the Zambezi River separates the two countries. Namibia gained independence from South Africa on 21 March 1990, following the Namibian War of Independence. Its capital and largest city is Windhoek, and it is a member state of the United Nations (UN), the Southern African Development Community (SADC), the African Union (AU), and the Commonwealth of Nations.'),('NC','540','New Caledonia','Noumea',2139685,'19060',216494,'OC','.nc','XPF','Franc','687','fr-NC',NULL,NULL),('NE','562','Niger','Niamey',2440476,'1267000',15878271,'AF','.ne','XOF','Franc','227','fr-NE,ha,kr,dje','TD,BJ,DZ,LY,BF,NG,ML','Niger, officially the Republic of the Niger, is a landlocked country in West Africa named after the Niger River. Niger is bordered by Libya to the northeast, Chad to the east, Nigeria to the south, Benin to the southwest, Burkina Faso and Mali to the west, and Algeria to the northwest. Niger covers a land area of almost 1,270,000 km2 (490,000 sq mi), making it the largest country in West Africa. Over 80% of its land area lies in the Sahara Desert. The country\'s predominantly Islamic population of about 21 million live mostly in clusters in the far south and west of the country. The capital and largest city is Niamey, located in Niger\'s southwest corner.'),('NF','574','Norfolk Island','Kingston',2155115,'34.6',1828,'OC','.nf','AUD','Dollar','672','en-NF',NULL,NULL),('NG','566','Nigeria','Abuja',2328926,'923768',154000000,'AF','.ng','NGN','Naira','234','en-NG,ha,yo,ig,ff','TD,NE,BJ,CM','Nigeria, officially the Federal Republic of Nigeria, is a country in West Africa, bordering Niger in the north, Chad in the northeast, Cameroon in the east, and Benin in the west. Its coast in the south is located on the Gulf of Guinea in the Atlantic Ocean. The federation comprises 36 states and 1 Federal Capital Territory, where the capital, Abuja, is located. The constitution defines Nigeria as a democratic secular state.'),('NI','558','Nicaragua','Managua',3617476,'129494',5995928,'NA','.ni','NIO','Cordoba','505','es-NI,en','CR,HN',NULL),('NL','528','Netherlands','Amsterdam',2750405,'41526',16645000,'EU','.nl','EUR','Euro','31','nl-NL,fy-NL','DE,BE','The Netherlands is a small, densely populated country located in Western Europe with three island territories in the Caribbean. The European part of the Netherlands borders Germany to the east, Belgium to the south, and the North Sea to the northwest, sharing maritime borders with Belgium, the United Kingdom, and Germany. The largest cities in the Netherlands are Amsterdam, The Hague and Rotterdam. Amsterdam is the country\'s capital, while The Hague holds the Dutch seat of government and parliament. The port of Rotterdam is the largest port in Europe and was the world\'s largest port between 1962 and 2004. The name Holland is also frequently and incorrectly used to refer informally to the whole of the country of the Netherlands.'),('NO','578','Norway','Oslo',3144096,'324220',4985870,'EU','.no','NOK','Krone','47','no,nb,nn,se,fi','FI,RU,SE','Norway, officially the Kingdom of Norway, is a Nordic country in Northwestern Europe whose territory comprises of the western and northernmost portion of the Scandinavian Peninsula; the remote island of Jan Mayen and the archipelago of Svalbard are also part of the Kingdom of Norway. The Antarctic Peter I Island and the sub-Antarctic Bouvet Island are dependent territories and thus not considered part of the kingdom. Norway also lays claim to a section of Antarctica known as Queen Maud Land.'),('NP','524','Nepal','Kathmandu',1282988,'140800',28951852,'AS','.np','NPR','Rupee','977','ne,en','CN,IN','Nepal, officially the Federal Democratic Republic of Nepal,is a landlocked country in South Asia with a population of 26.4 million. It is a multiethnic nation with Nepali as the official language. Kathmandu is the nation\'s capital and largest city. Modern Nepal is a secular parliamentary republic.'),('NR','520','Nauru','Yaren',2110425,'21',10065,'OC','.nr','AUD','Dollar','674','na,en-NR',NULL,NULL),('NU','570','Niue','Alofi',4036232,'260',2166,'OC','.nu','NZD','Dollar','683','niu,en-NU',NULL,NULL),('NZ','554','New Zealand','Wellington',2186224,'268680',4252277,'OC','.nz','NZD','Dollar','64','en-NZ,mi',NULL,'New Zealand is a sovereign island country in the southwestern Pacific Ocean. The country geographically comprises two main landmasses—the North Island, and the South Island and around 600 smaller islands. It has a total land area of 268,000 square kilometres (103,500 sq mi). New Zealand is situated some 2,000 kilometres (1,200 mi) east of Australia across the Tasman Sea and roughly 1,000 kilometres (600 mi) south of the Pacific island areas of New Caledonia, Fiji, and Tonga. Because of its remoteness, it was one of the last lands to be settled by humans. During its long period of isolation, New Zealand developed a distinct biodiversity of animal, fungal, and plant life. The country\'s varied topography and its sharp mountain peaks, such as the Southern Alps, owe much to the tectonic uplift of land and volcanic eruptions. New Zealand\'s capital city is Wellington, while its most populous city is Auckland.'),('OM','512','Oman','Muscat',286963,'212460',2967717,'AS','.om','OMR','Rial','968','ar-OM,en,bal,ur','SA,YE,AE',NULL),('PA','591','Panama','Panama City',3703430,'78200',3410676,'NA','.pa','PAB','Balboa','507','es-PA,en','CR,CO','Panama, officially the Republic of Panama, is a country in Central America, bordered by Costa Rica to the west, Colombia to the southeast, the Caribbean Sea to the north, and the Pacific Ocean to the south. The capital and largest city is Panama City, whose metropolitan area is home to nearly half the country\'s 4 million people.'),('PE','604','Peru','Lima',3932488,'1285220',29907003,'SA','.pe','PEN','Sol','51','es-PE,qu,ay','EC,CL,BO,BR,CO','Peru, officially the Republic of Peru, is a country in western South America. It is bordered in the north by Ecuador and Colombia, in the east by Brazil, in the southeast by Bolivia, in the south by Chile, and in the west by the Pacific Ocean. Peru is an extremely biodiverse country with habitats ranging from the arid plains of the Pacific coastal region in the west to the peaks of the Andes mountains vertically extending from the north to the southeast of the country to the tropical Amazon Basin rainforest in the east with the Amazon river.'),('PF','258','French Polynesia','Papeete',4030656,'4167',270485,'OC','.pf','XPF','Franc','689','fr-PF,ty',NULL,NULL),('PG','598','Papua New Guinea','Port Moresby',2088628,'462840',6064515,'OC','.pg','PGK','Kina','675','en-PG,ho,meu,tpi','ID',NULL),('PH','608','Philippines','Manila',1694008,'300000',99900177,'AS','.ph','PHP','Peso','63','tl,en-PH,fil',NULL,'The Philippines, officially the Republic of the Philippines, is an archipelagic country in Southeast Asia. Situated in the western Pacific Ocean, it consists of about 7,641 islands that are categorized broadly under three main geographical divisions from north to south: Luzon, Visayas and Mindanao. The capital city of the Philippines is Manila and the most populous city is Quezon City, both part of Metro Manila. Bounded by the South China Sea on the west, the Philippine Sea on the east and the Celebes Sea on the southwest, the Philippines shares maritime borders with Taiwan to the north, Japan to the northeast, Vietnam to the west, Palau to the east, and Malaysia and Indonesia to the south.'),('PK','586','Pakistan','Islamabad',1168579,'803940',184404791,'AS','.pk','PKR','Rupee','92','ur-PK,en-PK,pa,sd,ps,brh','CN,AF,IR,IN','Pakistan, officially the Islamic Republic of Pakistan, is a country in South Asia. It is the world’s sixth-most populous country with a population exceeding 212,742,631 people. In area, it is the 33rd-largest country, spanning 881,913 square kilometres (340,509 square miles). Pakistan has a 1,046-kilometre (650-mile) coastline along the Arabian Sea and Gulf of Oman in the south and is bordered by India to the east, Afghanistan to the west, Iran to the southwest, and China in the northeast. It is separated narrowly from Tajikistan by Afghanistan\'s Wakhan Corridor in the northwest, and also shares a maritime border with Oman.'),('PL','616','Poland','Warsaw',798544,'312685',38500000,'EU','.pl','PLN','Zloty','48','pl','DE,LT,SK,CZ,BY,UA,RU','Poland, officially the Republic of Poland, is a country located in Central Europe. It is divided into 16 administrative subdivisions, covering an area of 312,696 square kilometres (120,733 sq mi), and has a largely temperate seasonal climate. With a population of approximately 38.5 million people, Poland is the sixth most populous member state of the European Union. Poland\'s capital and largest metropolis is Warsaw. Other major cities include Krakow, Lodz, Wroclaw, Poznan, Gdansk, and Szczecin.'),('PM','666','Saint Pierre and Miquelon','Saint-Pierre',3424932,'242',7012,'NA','.pm','EUR','Euro','508','fr-PM',NULL,NULL),('PN','612','Pitcairn','Adamstown',4030699,'47',46,'OC','.pn','NZD','Dollar','870','en-PN',NULL,NULL),('PR','630','Puerto Rico','San Juan',4566966,'9104',3916632,'NA','.pr','USD','Dollar','+1-787 and 1-939','en-PR,es-PR',NULL,NULL),('PS','275','Palestinian Territory','East Jerusalem',6254930,'5970',3800000,'AS','.ps','ILS','Shekel','970','ar-PS','JO,IL',NULL),('PT','620','Portugal','Lisbon',2264397,'92391',10676000,'EU','.pt','EUR','Euro','351','pt-PT,mwl','ES','Portugal, officially the Portuguese Republic, is a country located mostly on the Iberian Peninsula in southwestern Europe. It is the westernmost sovereign state of mainland Europe, being bordered to the west and south by the Atlantic Ocean and to the north and east by Spain. Its territory also includes the Atlantic archipelagos of the Azores and Madeira, both autonomous regions with their own regional governments.'),('PW','585','Palau','Melekeok',1559582,'458',19907,'OC','.pw','USD','Dollar','680','pau,sov,en-PW,tox,ja,fil,zh',NULL,NULL),('PY','600','Paraguay','Asuncion',3437598,'406750',6375830,'SA','.py','PYG','Guarani','595','es-PY,gn','BO,BR,AR',NULL),('QA','634','Qatar','Doha',289688,'11437',840926,'AS','.qa','QAR','Rial','974','ar-QA,es','SA',NULL),('RE','638','Reunion','Saint-Denis',935317,'2517',776948,'AF','.re','EUR','Euro','262','fr-RE',NULL,NULL),('RO','642','Romania','Bucharest',798549,'237500',21959278,'EU','.ro','RON','Leu','40','ro,hu,rom','MD,HU,UA,CS,BG,RS','Romania is a country located at the crossroads of Central, Eastern, and Southeastern Europe. It borders the Black Sea to the southeast, Bulgaria to the south, Ukraine to the north, Hungary to the west, Serbia to the southwest, and Moldova to the east. It has a predominantly temperate-continental climate. With a total area of 238,397 square kilometres (92,046 sq mi), Romania is the 12th largest country and also the 7th most populous member state of the European Union, having almost 20 million inhabitants. Its capital and largest city is Bucharest, and other major urban areas include Cluj-Napoca, Timisoara, Iași, Constanta, Craiova, and Brasov.'),('RS','688','Serbia','Belgrade',6290252,'88361',7344847,'EU','.rs','RSD','Dinar','381','sr,hu,bs,rom','AL,HU,MK,RO,HR,BA,BG,ME,XK','Serbia, officially the Republic of Serbia, is a country situated at the crossroads of Central and Southeast Europe in the southern Pannonian Plain and the central Balkans. It borders Hungary to the north, Romania to the northeast, Bulgaria to the southeast, North Macedonia to the south, Croatia and Bosnia and Herzegovina to the west, and Montenegro to the southwest. The country claims a border with Albania through the disputed territory of Kosovo. Serbia\'s population numbers approximately seven million. Its capital, Belgrade, ranks among the longest inhabited and largest citiеs in southeastern Europe.'),('RU','643','Russia','Moscow',2017370,'1.71E+007',140702000,'EU','.ru','RUB','Ruble','7','ru,tt,xal,cau,ady,kv,ce,tyv,cv,udm,tut,mns,bua,myv,mdf,chm,ba,inh,tut,kbd,krc,ava,sah,nog','GE,CN,BY,UA,KZ,LV,PL,EE,LT,FI,MN,NO,AZ,KP','Russia, or the Russian Federation, is a transcontinental country in Eastern Europe and North Asia. At 17,125,200 square kilometres (6,612,100 sq mi), Russia is, by a considerable margin, the largest country in the world by area, covering more than one-eighth of the Earth\'s inhabited land area, and the ninth most populous, with about 146.79 million people as of 2019, including Crimea. About 77% of the population live in the western, European part of the country. Russia\'s capital, Moscow, is one of the largest cities in the world and the second largest city in Europe; other major cities include Saint Petersburg, Novosibirsk, Yekaterinburg and Nizhny Novgorod. Extending across the entirety of Northern Asia and much of Eastern Europe, Russia spans eleven time zones and incorporates a wide range of environments and landforms. From northwest to southeast, Russia shares land borders with Norway, Finland, Estonia, Latvia, Lithuania and Poland (both with Kaliningrad Oblast), Belarus, Ukraine, Georgia, Azerbaijan, Kazakhstan, China, Mongolia and North Korea. It shares maritime borders with Japan by the Sea of Okhotsk and the U.S. state of Alaska across the Bering Strait. However, Russia recognises two more countries that border it, Abkhazia and South Ossetia, both of which are internationally recognized as parts of Georgia.'),('RW','646','Rwanda','Kigali',49518,'26338',11055976,'AF','.rw','RWF','Franc','250','rw,en-RW,fr-RW,sw','TZ,CD,BI,UG','Rwanda, officially the Republic of Rwanda, is a country in Central and East Africa and one of the smallest countries on the African mainland. Located a few degrees south of the Equator, Rwanda is bordered by Uganda, Tanzania, Burundi, and the Democratic Republic of the Congo. Rwanda is in the African Great Lakes region and is highly elevated; its geography is dominated by mountains in the west and savanna to the east, with numerous lakes throughout the country. The climate is temperate to subtropical, with two rainy seasons and two dry seasons each year.'),('SA','682','Saudi Arabia','Riyadh',102358,'1960582',25731776,'AS','.sa','SAR','Rial','966','ar-SA','QA,OM,IQ,YE,JO,AE,KW','Saudi Arabia, officially the Kingdom of Saudi Arabia, is a country in Western Asia constituting the bulk of the Arabian Peninsula. With a land area of approximately 2,150,000 km2 (830,000 sq mi), Saudi Arabia is geographically the largest sovereign state in the Middle East, the second-largest in the Arab world (after Algeria), the fifth-largest in Asia, and the 12th-largest in the world. Saudi Arabia is bordered by Jordan and Iraq to the north, Kuwait to the northeast, Qatar, Bahrain, and the United Arab Emirates to the east, Oman to the southeast and Yemen to the south; it is separated from Israel and Egypt by the Gulf of Aqaba. It is the only nation with both a Red Sea coast and a Persian Gulf coast, and most of its terrain consists of arid desert, lowland and mountains. As of October 2018, the Saudi economy was the largest in the Middle East and the 18th largest in the world. Saudi Arabia also has one of the world\'s youngest populations; 50 percent of its 33.4 million people are under 25 years old.'),('SB','090','Solomon Islands','Honiara',2103350,'28450',559198,'OC','.sb','SBD','Dollar','677','en-SB,tpi',NULL,NULL),('SC','690','Seychelles','Victoria',241170,'455',88340,'AF','.sc','SCR','Rupee','248','en-SC,fr-SC',NULL,NULL),('SD','729','Sudan','Khartoum',366755,'1861484',35000000,'AF','.sd','SDG','Pound','249','ar-SD,en,fia','SS,TD,EG,ET,ER,LY,CF','Sudan, officially the Republic of the Sudan, is a country in Northeast Africa. It is bordered by Egypt to the north, the Red Sea to the northeast, Eritrea to the east, Ethiopia to the southeast, South Sudan to the south, the Central African Republic to the southwest, Chad to the west, and Libya to the northwest. It has a population of 43 million people (2018 estimate) and occupies a total area of 1,886,068 square kilometres (728,215 square miles), making it the third-largest country in Africa. Sudan\'s predominant religion is Islam, and its official languages are Arabic and English. The capital is Khartoum, located at the confluence of the Blue and White Nile. Since 2011, Sudan is the scene of ongoing military conflict in its regions South Kordofan and the Blue Nile.'),('SE','752','Sweden','Stockholm',2661886,'449964',9045000,'EU','.se','SEK','Krona','46','sv-SE,se,sma,fi-SE','NO,FI','Sweden is a country in Northern Europe. It borders Norway to the west and north and Finland to the east, and is connected to Denmark in the southwest by a bridge-tunnel across the Oresund Strait. At 450,295 square kilometres (173,860 sq mi), Sweden is the largest country in Northern Europe, the third-largest country in the European Union and the fifth largest country in Europe by area. The capital city is Stockholm. Sweden has a total population of 10.3 million of which 2.5 million have a foreign background. It has a low population density of 22 inhabitants per square kilometre (57/sq mi) and the highest urban concentration is in the central and southern half of the country.'),('SG','702','Singapore','Singapur',1880251,'692.7',4701069,'AS','.sg','SGD','Dollar','65','cmn,en-SG,ms-SG,ta-SG,zh-SG',NULL,'Singapore, officially the Republic of Singapore, is a sovereign island city-state in Southeast Asia. The country is situated one degree (137 kilometres or 85 miles) north of the equator, at the southern tip of the Malay Peninsula, with Indonesia\'s Riau Islands to the south and Peninsular Malaysia to the north. Singapore\'s territory consists of one main island along with 62 other islets. Since independence, extensive land reclamation has increased its total size by 23% (130 square kilometres or 50 square miles).'),('SH','654','Saint Helena','Jamestown',3370751,'410',7460,'AF','.sh','SHP','Pound','290','en-SH',NULL,NULL),('SI','705','Slovenia','Ljubljana',3190538,'20273',2007000,'EU','.si','EUR','Euro','386','sl,sh','HU,IT,HR,AT','Slovenia, officially the Republic of Slovenia, is a nation state in southern Central Europe, located at the crossroads of main European cultural and trade routes. It is bordered by Italy to the west, Austria to the north, Hungary to the northeast, Croatia to the south and southeast, and the Adriatic Sea to the southwest. It covers 20,273 square kilometers (7,827 sq mi) and has a population of 2.06 million. It is a parliamentary republic and a member of the United Nations, European Union, and NATO. The capital and largest city is Ljubljana.'),('SJ','744','Svalbard and Jan Mayen','Longyearbyen',607072,'62049',2550,'EU','.sj','NOK','Krone','47','no,ru',NULL,NULL),('SK','703','Slovakia','Bratislava',3057568,'48845',5455000,'EU','.sk','EUR','Euro','421','sk,hu','PL,HU,CZ,UA,AT','Slovakia, officially the Slovak Republic, is a landlocked country in Central Europe. It is bordered by Poland to the north, Ukraine to the east, Hungary to the south, Austria to the west, and the Czech Republic to the northwest. Slovakia\'s territory spans about 49,000 square kilometres (19,000 sq mi) and is mostly mountainous. The population is over 5.4 million and consists mostly of Slovaks. The capital and largest city is Bratislava, and the second-largest city is Kosice. The official language is Slovak.'),('SL','694','Sierra Leone','Freetown',2403846,'71740',5245695,'AF','.sl','SLL','Leone','232','en-SL,men,tem','LR,GN',NULL),('SM','674','San Marino','San Marino',3168068,'61.2',31477,'EU','.sm','EUR','Euro','378','it-SM','IT',NULL),('SN','686','Senegal','Dakar',2245662,'196190',12323252,'AF','.sn','XOF','Franc','221','fr-SN,wo,fuc,mnk','GN,MR,GW,GM,ML',NULL),('SO','706','Somalia','Mogadishu',51537,'637657',10112453,'AF','.so','SOS','Shilling','252','so-SO,ar-SO,it,en-SO','ET,KE,DJ',NULL),('SR','740','Suriname','Paramaribo',3382998,'163270',492829,'SA','.sr','SRD','Dollar','597','nl-SR,en,srn,hns,jv','GY,BR,GF',NULL),('SS','728','South Sudan','Juba',7909807,'644329',8260490,'AF',NULL,'SSP','Pound','211','en','CD,CF,ET,KE,SD,UG,',NULL),('ST','678','Sao Tome and Principe','Sao Tome',2410758,'1001',175808,'AF','.st','STD','Dobra','239','pt-ST',NULL,NULL),('SV','222','El Salvador','San Salvador',3585968,'21040',6052064,'NA','.sv','USD','Dollar','503','es-SV','GT,HN','El Salvador, officially the Republic of El Salvador, is the smallest and the most densely populated country in Central America. It is bordered on the northeast by Honduras, on the northwest by Guatemala, and on the south by the Pacific Ocean. El Salvador\'s capital and largest city is San Salvador. As of 2016, the country had a population of approximately 6.34 million.'),('SX','534','Sint Maarten','Philipsburg',7609695,NULL,37429,'NA','.sx','ANG','Guilder','599','nl,en','MF',NULL),('SY','760','Syria','Damascus',163843,'185180',22198110,'AS','.sy','SYP','Pound','963','ar-SY,ku,hy,arc,fr,en','IQ,JO,IL,TR,LB',NULL),('SZ','748','Swaziland','Mbabane',934841,'17363',1354051,'AF','.sz','SZL','Lilangeni','268','en-SZ,ss-SZ','ZA,MZ',NULL),('TC','796','Turks and Caicos Islands','Cockburn Town',3576916,'430',20556,'NA','.tc','USD','Dollar','+1-649','en-TC',NULL,NULL),('TD','148','Chad','N\'Djamena',2434508,'1284000',10543464,'AF','.td','XAF','Franc','235','fr-TD,ar-TD,sre','NE,LY,CF,SD,CM,NG',NULL),('TF','260','French Southern Territories','Port-aux-Francais',1546748,'7829',140,'AN','.tf','EUR','Euro',NULL,'fr',NULL,NULL),('TG','768','Togo','Lome',2363686,'56785',6587239,'AF','.tg','XOF','Franc','228','fr-TG,ee,hna,kbp,dag,ha','BJ,GH,BF',NULL),('TH','764','Thailand','Bangkok',1605651,'514000',67089500,'AS','.th','THB','Baht','66','th,en','LA,MM,KH,MY','Thailand, officially the Kingdom of Thailand, formerly known as Siam, is a country at the centre of the Indochinese peninsula in Southeast Asia. With a total area of approximately 513,000 km2 (198,000 sq mi), Thailand is the world\'s 51st-largest country. It is the 20th-most-populous country in the world, with around 66 million people. The capital and largest city is Bangkok.'),('TJ','762','Tajikistan','Dushanbe',1220409,'143100',7487489,'AS','.tj','TJS','Somoni','992','tg,ru','CN,AF,KG,UZ',NULL),('TK','772','Tokelau',NULL,4031074,'10',1466,'OC','.tk','NZD','Dollar','690','tkl,en-TK',NULL,NULL),('TL','626','East Timor','Dili',1966436,'15007',1154625,'OC','.tl','USD','Dollar','670','tet,pt-TL,id,en','ID',NULL),('TM','795','Turkmenistan','Ashgabat',1218197,'488100',4940916,'AS','.tm','TMT','Manat','993','tk,ru,uz','AF,IR,UZ,KZ',NULL),('TN','788','Tunisia','Tunis',2464461,'163610',10589025,'AF','.tn','TND','Dinar','216','ar-TN,fr','DZ,LY','Tunisia, officially the Republic of Tunisia, is a country in the Maghreb region of North Africa, covering 163,610 square kilometres (63,170 square miles). Its northernmost point, Cape Angela, is the northernmost point on the African continent. It is bordered by Algeria to the west and southwest, Libya to the southeast, and the Mediterranean Sea to the north and east. Tunisia\'s population was 11.435 million in 2017. Tunisia\'s name is derived from its capital city, Tunis, which is located on its northeast coast.'),('TO','776','Tonga','Nuku\'alofa',4032283,'748',122580,'OC','.to','TOP','Pa\'anga','676','to,en-TO',NULL,NULL),('TR','792','Turkey','Ankara',298795,'780580',77804122,'AS','.tr','TRY','Lira','90','tr-TR,ku,diq,az,av','SY,GE,IQ,IR,GR,AM,AZ,BG','Turkey, officially the Republic of Turkey, is a transcontinental country located mainly on the Anatolian peninsula in Western Asia, with a small portion on the Balkan peninsula in Southeast Europe. East Thrace, the part of Turkey in Europe, is separated from Anatolia by the Sea of Marmara, the Bosphorous and the Dardanelles (collectively called the Turkish Straits). Turkey is bordered by Greece and Bulgaria to its northwest; Georgia to its northeast; Armenia, the Azerbaijani exclave of Nakhchivan and Iran to the east; and Iraq and Syria to the south. Istanbul is the largest city while Ankara is the capital. Approximately 70 to 80 per cent of the country\'s citizens identify as Turkish. Kurds are the largest minority; the size of the Kurdish population is a subject of dispute with estimates placing the figure at anywhere from 12 to 25 percent of the population.'),('TT','780','Trinidad and Tobago','Port of Spain',3573591,'5128',1228691,'NA','.tt','TTD','Dollar','+1-868','en-TT,hns,fr,es,zh',NULL,NULL),('TV','798','Tuvalu','Funafuti',2110297,'26',10472,'OC','.tv','AUD','Dollar','688','tvl,en,sm,gil',NULL,NULL),('TW','158','Taiwan','Taipei',1668284,'35980',22894384,'AS','.tw','TWD','Dollar','886','zh-TW,zh,nan,hak',NULL,'Taiwan, officially the Republic of China (ROC), is a state in East Asia. Neighbouring states include the People\'s Republic of China (PRC) to the west, Japan to the north-east, and the Philippines to the south. The island of Taiwan has an area of 35,808 square kilometres (13,826 sq mi), with mountain ranges dominating the eastern two thirds and plains in the western third, where its highly urbanised population is concentrated. Taipei is the capital and largest metropolitan area. Other major cities include Kaohsiung, Taichung, Tainan and Taoyuan. With 23.7 million inhabitants, Taiwan is among the most densely populated states, and is the most populous state and largest economy that is not a member of the United Nations (UN).'),('TZ','834','Tanzania','Dodoma',149590,'945087',41892895,'AF','.tz','TZS','Shilling','255','sw-TZ,en,ar','MZ,KE,CD,RW,ZM,BI,UG,MW','Tanzania, officially the United Republic of Tanzania, is a country in East Africa within the African Great Lakes region. It borders Uganda to the north; Kenya to the northeast; Comoro Islands at the Indian Ocean to the east; Mozambique and Malawi to the south; Zambia to the southwest; and Rwanda, Burundi, and the Democratic Republic of the Congo to the west. Mount Kilimanjaro, Africa\'s highest mountain, is in north-eastern Tanzania.'),('UA','804','Ukraine','Kiev',690791,'603700',45415596,'EU','.ua','UAH','Hryvnia','380','uk,ru-UA,rom,pl,hu','PL,MD,HU,SK,BY,RO,RU','Ukraine is a country in Eastern Europe. Excluding Crimea, Ukraine has a population of about 42 million, making it the 32nd most populous country in the world. Its capital and largest city is Kiev. Ukrainian is the official language and its alphabet is Cyrillic. The dominant religion in the country is Eastern Orthodoxy. Ukraine is currently in a territorial dispute with Russia over the Crimean Peninsula, which Russia annexed in 2014. Including Crimea, Ukraine has an area of 603,628 km2 (233,062 sq mi), making it the largest country entirely within Europe and the 46th largest country in the world.'),('UG','800','Uganda','Kampala',226074,'236040',33398682,'AF','.ug','UGX','Shilling','256','en-UG,lg,sw,ar','TZ,KE,SS,CD,RW','Uganda, officially the Republic of Uganda, is a country in East-Central Africa. It is bordered to the east by Kenya, to the north by South Sudan, to the west by the Democratic Republic of the Congo, to the south-west by Rwanda, and to the south by Tanzania. The southern part of the country includes a substantial portion of Lake Victoria, shared with Kenya and Tanzania. Uganda is in the African Great Lakes region. Uganda also lies within the Nile basin, and has a varied but generally a modified equatorial climate.'),('UM','581','United States Minor Outlying Islands',NULL,5854968,'0',0,'OC','.um','USD','Dollar','1','en-UM',NULL,NULL),('US','840','United States','Washington',6252001,'9629091',310232863,'NA','.us','USD','Dollar','1','en-US,es-US,haw,fr','CA,MX,CU','The United States of America (commonly called the United States, the U.S., the USA, America, and the States) is a federal constitutional republic consisting of fifty states and a federal district. The country is situated mostly in central North America, where its forty-eight contiguous states and Washington, D.C., the capital district, lie between the Pacific and Atlantic Oceans, bordered by Canada to the north and Mexico to the south. The state of Alaska is in the northwest of the continent, with Canada to the east and Russia to the west across the Bering Strait. The state of Hawaii is an archipelago in the mid-Pacific. The country also possesses several territories in the Pacific and Caribbean. At 3.79 million square miles (9.83 million km2) and with over 314 million people, the United States is the third- or fourth-largest country by total area, and the third-largest by both land area and population. It is one of the world\'s most ethnically diverse and multicultural nations, the product of large-scale immigration from many countries.'),('UY','858','Uruguay','Montevideo',3439705,'176220',3477000,'SA','.uy','UYU','Peso','598','es-UY','BR,AR','Uruguay is a country in the southeastern part of South America. It is home to 3.3 million people, of whom 1.8 million live in the capital Montevideo and its metropolitan area. An estimated 88% of the population is of European descent. With an area of approximately 176,000 square kilometres (68,000 sq mi), Uruguay is the second-smallest nation in South America by area, after Suriname.'),('UZ','860','Uzbekistan','Tashkent',1512440,'447400',27865738,'AS','.uz','UZS','Som','998','uz,ru,tg','TM,AF,KG,TJ,KZ','Uzbekistan, officially the Republic of Uzbekistan, is a doubly landlocked country in Central Asia and also a former Soviet Republic. The sovereign state is a secular, unitary constitutional republic, comprising 12 provinces, one autonomous republic, and a capital city. Uzbekistan is bordered by five landlocked countries: Kazakhstan to the north; Kyrgyzstan to the northeast; Tajikistan to the southeast; Afghanistan to the south; and Turkmenistan to the southwest. Along with Liechtenstein, it is one of the world\'s only two doubly landlocked countries.'),('VA','336','Vatican','Vatican City',3164670,'0.44',921,'EU','.va','EUR','Euro','379','la,it,fr','IT',NULL),('VC','670','Saint Vincent and the Grenadines','Kingstown',3577815,'389',104217,'NA','.vc','XCD','Dollar','+1-784','en-VC,fr',NULL,NULL),('VE','862','Venezuela','Caracas',3625428,'912050',27223228,'SA','.ve','VEF','Bolivar','58','es-VE','GY,BR,CO','Venezuela, officially the Bolivarian Republic of Venezuela, is a country on the northern coast of South America, consisting of a continental landmass and many small islands and islets in the Caribbean Sea. It has a territorial extension of 916,445 km2 (353,841 sq mi). The continental territory is bordered on the north by the Caribbean Sea and the Atlantic Ocean, on the west by Colombia, Brazil on the south, Trinidad and Tobago to the north-east and on the east by Guyana. The Venezuelan government maintains a claim against Guyana to Guayana Esequiba, an area of 159,542 km2 (61,600 sq mi). For its maritime areas, Venezuela exercises sovereignty over 71,295 km2 (27,527 sq mi) of territorial waters, 22,224 km2 (8,581 sq mi) in its contiguous zone, 471,507 km2 (182,050 sq mi) of the Caribbean Sea and the Atlantic Ocean under the concept of exclusive economic zone, and 99,889 km2 (38,567 sq mi) of continental shelf. This marine area borders those of 13 states. The capital and largest urban agglomeration is the city of Caracas. The country has extremely high biodiversity and is ranked seventh in the world\'s list of nations with the most number of species. There are habitats ranging from the Andes Mountains in the west to the Amazon basin rain-forest in the south via extensive llanos plains, the Caribbean coast and the Orinoco River Delta in the east.'),('VG','092','British Virgin Islands','Road Town',3577718,'153',21730,'NA','.vg','USD','Dollar','+1-284','en-VG',NULL,NULL),('VI','850','U.S. Virgin Islands','Charlotte Amalie',4796775,'352',108708,'NA','.vi','USD','Dollar','+1-340','en-VI',NULL,NULL),('VN','704','Vietnam','Hanoi',1562822,'329560',89571130,'AS','.vn','VND','Dong','84','vi,en,fr,zh,km','CN,LA,KH','Vietnam, officially the Socialist Republic of Vietnam, is the easternmost country on the Indochina Peninsula. With an estimated 94.6 million inhabitants as of 2016, it is the 15th most populous country in the world. Vietnam shares its land borders with China to the north, and Laos and Cambodia to the west. It shares its maritime borders with Thailand through the Gulf of Thailand, and the Philippines, Indonesia and Malaysia through the South China Sea. Its capital city is Hanoi, while its most populous city is Ho Chi Minh City.'),('VU','548','Vanuatu','Port Vila',2134431,'12200',221552,'OC','.vu','VUV','Vatu','678','bi,en-VU,fr-VU',NULL,NULL),('WF','876','Wallis and Futuna','Mata Utu',4034749,'274',16025,'OC','.wf','XPF','Franc','681','wls,fud,fr-WF',NULL,NULL),('WS','882','Samoa','Apia',4034894,'2944',192001,'OC','.ws','WST','Tala','685','sm,en-WS',NULL,NULL),('XK','0','Kosovo','Pristina',831053,NULL,1800000,'EU',NULL,'EUR','Euro',NULL,'sq,sr','RS,AL,MK,ME',NULL),('YE','887','Yemen','Sanaa',69543,'527970',23495361,'AS','.ye','YER','Rial','967','ar-YE','SA,OM',NULL),('YT','175','Mayotte','Mamoudzou',1024031,'374',159042,'AF','.yt','EUR','Euro','262','fr-YT',NULL,NULL),('ZA','710','South Africa','Pretoria',953987,'1219912',49000000,'AF','.za','ZAR','Rand','27','zu,xh,af,nso,en-ZA,tn,st,ts,ss,ve,nr','ZW,SZ,MZ,BW,NA,LS','South Africa, officially the Republic of South Africa (RSA), is the southernmost country in Africa. It is bounded to the south by 2,798 kilometres (1,739 mi) of coastline of Southern Africa stretching along the South Atlantic and Indian Oceans; to the north by the neighbouring countries of Namibia, Botswana, and Zimbabwe; and to the east and northeast by Mozambique and Eswatini (Swaziland); and it surrounds the enclaved country of Lesotho. South Africa is the largest country in Southern Africa and the 25th-largest country in the world by land area and, with over 57 million people, is the world\'s 24th-most populous nation. It is the southernmost country on the mainland of the Old World or the Eastern Hemisphere. About 80 percent of South Africans are of Bantu ancestry, divided among a variety of ethnic groups speaking different African languages, nine of which have official status. The remaining population consists of Africa\'s largest communities of European, Asian (Indian), and multiracial (Coloured) ancestry.'),('ZM','894','Zambia','Lusaka',895949,'752614',13460305,'AF','.zm','ZMK','Kwacha','260','en-ZM,bem,loz,lun,lue,ny,toi','ZW,TZ,MZ,CD,NA,MW,AO',NULL),('ZW','716','Zimbabwe','Harare',878675,'390580',11651858,'AF','.zw','ZWL','Dollar','263','en-ZW,sn,nr,nd','ZA,MZ,BW,ZM','Zimbabwe, officially the Republic of Zimbabwe, is a landlocked country located in southern Africa, between the Zambezi and Limpopo Rivers, bordered by South Africa, Botswana, Zambia and Mozambique. The capital and largest city is Harare and the second largest being Bulawayo. A country of roughly 16 million people, Zimbabwe has 16 official languages, with English, Shona, and Ndebele the most commonly used.');
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;

CREATE TABLE `cities` (
  `CityCode` int(11) NOT NULL,
  `AsciiName` varchar(255) DEFAULT NULL,
  `CountryCodeISO` varchar(2) DEFAULT NULL,
  `Latitude` double DEFAULT NULL,
  `Longitude` double DEFAULT NULL,
  `Population` int(11) DEFAULT NULL,
  `Elevation` int(11) DEFAULT NULL,
  `TimeZone` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`CityCode`),
  KEY `CountryCodeISO` (`CountryCodeISO`),
  KEY `CityCode` (`CityCode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

LOCK TABLES `cities` WRITE;
INSERT INTO `cities` VALUES (251833,'Volos','GR',39.36667,22.94583,84425,10,'Europe/Athens'),(251948,'Vyronas','GR',37.96667,23.75,61888,124,'Europe/Athens'),(252920,'Fira','GR',36.42107,25.43087,2376,244,'Europe/Athens'),(255274,'Piraeus','GR',37.94745,23.63708,172429,12,'Europe/Athens'),(255524,'Peristeri','GR',38.01667,23.7,137659,61,'Europe/Athens'),(255683,'Patra','GR',38.24444,21.73444,163360,20,'Europe/Athens'),(256075,'Palaio Faliro','GR',37.92066,23.70916,66292,28,'Europe/Athens'),(256131,'Palaiochora','GR',35.23333,23.68333,2372,5,'Europe/Athens'),(256429,'Nikaia','GR',37.96667,23.65,94608,30,'Europe/Athens'),(256575,'Nea Smyrni','GR',37.95,23.71667,75421,60,'Europe/Athens'),(256601,'Ilion','GR',38.03333,23.7,81647,90,'Europe/Athens'),(256614,'Nea Ionia','GR',38.03333,23.75,67835,135,'Europe/Athens'),(258576,'Larisa','GR',39.63722,22.42028,128758,85,'Europe/Athens'),(260172,'Khalandrion','GR',38.03058,23.79793,74211,192,'Europe/Athens'),(260204,'Keratsini','GR',37.9625,23.61972,77222,40,'Europe/Athens'),(261414,'Kallithea','GR',37.95,23.7,107767,28,'Europe/Athens'),(261745,'Irakleion','GR',35.32787,25.14341,137154,60,'Europe/Athens'),(261779,'Ioannina','GR',39.6675,20.85083,64012,491,'Europe/Athens'),(263219,'Delphi','GR',38.47995,22.49336,2373,500,'Europe/Athens'),(264194,'Agia Paraskevi','GR',38.01667,23.83333,60662,216,'Europe/Athens'),(264371,'Athens','GR',37.97945,23.71622,729137,42,'Europe/Athens'),(265243,'Marousi','GR',38.05,23.8,72310,220,'Europe/Athens'),(265488,'Acharnes','GR',38.08333,23.73333,82376,171,'Europe/Athens'),(265533,'Aigaleo','GR',37.98333,23.68333,72320,24,'Europe/Athens'),(346030,'Zifta','EG',30.7142,31.24425,92667,16,'Africa/Cairo'),(351434,'Naj Hammadi','EG',26.04949,32.24142,41184,78,'Africa/Cairo'),(352344,'Minyat an Nasr','EG',31.12294,31.6399,56951,7,'Africa/Cairo'),(352354,'Minuf','EG',30.46579,30.93164,83651,20,'Africa/Cairo'),(352628,'Matay','EG',28.41899,30.77924,45215,40,'Africa/Cairo'),(352679,'Mashtul as Suq','EG',30.36056,31.3776,45798,15,'Africa/Cairo'),(352733,'Marsa Matruh','EG',31.35254,27.24528,62042,9,'Africa/Cairo'),(354365,'Kafr az Zayyat','EG',30.8248,30.81805,73725,18,'Africa/Cairo'),(354502,'Kafr ash Shaykh','EG',31.1143,30.94012,143970,14,'Africa/Cairo'),(354775,'Kafr ad Dawwar','EG',31.13385,30.12843,267370,0,'Africa/Cairo'),(354981,'Juhaynah','EG',26.67319,31.4976,47821,64,'Africa/Cairo'),(355026,'Jirja','EG',26.33826,31.89161,128250,70,'Africa/Cairo'),(355392,'Izbat al Burj','EG',31.5084,31.84106,37953,8,'Africa/Cairo'),(355420,'Itsa','EG',29.2376,30.78944,45269,20,'Africa/Cairo'),(355449,'Isna','EG',25.29336,32.55402,69335,86,'Africa/Cairo'),(355628,'Idku','EG',31.30782,30.29901,105599,7,'Africa/Cairo'),(358619,'Port Said','EG',31.25654,32.28412,538378,6,'Africa/Cairo'),(358620,'Bur Safajah','EG',26.72918,33.93651,32944,23,'Africa/Cairo'),(358821,'Bilqas Qism Awwal','EG',31.21452,31.35798,103596,13,'Africa/Cairo'),(358840,'Bilbays','EG',30.42039,31.56223,129211,17,'Africa/Cairo'),(358970,'Basyun','EG',30.93976,30.81338,55523,12,'Africa/Cairo'),(359173,'Bani Suwayf','EG',29.07441,31.09785,189624,33,'Africa/Cairo'),(359212,'Bani Mazar','EG',28.5036,30.8004,58153,43,'Africa/Cairo'),(359280,'Banha','EG',30.45906,31.17858,167029,17,'Africa/Cairo'),(359493,'Az Zaqaziq','EG',30.58768,31.502,285097,16,'Africa/Cairo'),(359576,'Awsim','EG',30.12303,31.13571,63862,25,'Africa/Cairo'),(359678,'Tor','EG',28.23638,33.6254,14972,14,'Africa/Cairo'),(359710,'At Tall al Kabir','EG',30.54448,31.78525,51569,11,'Africa/Cairo'),(359783,'Asyut','EG',27.18096,31.18368,420585,56,'Africa/Cairo'),(359792,'Aswan','EG',24.09343,32.90704,241261,102,'Africa/Cairo'),(359796,'Suez','EG',29.97371,32.52627,488125,11,'Africa/Cairo'),(360542,'Al Qurayn','EG',30.61618,31.73514,61730,12,'Africa/Cairo'),(360612,'Al Qanayat','EG',30.6188,31.46099,42912,14,'Africa/Cairo'),(360630,'Cairo','EG',30.06263,31.24967,7734614,23,'Africa/Cairo'),(361055,'Ismailia','EG',30.60427,32.27225,284813,14,'Africa/Cairo'),(361058,'Alexandria','EG',31.21564,29.95527,3811516,255,'Africa/Cairo'),(361103,'Al Ibrahimiyah','EG',30.71877,31.56299,34638,14,'Africa/Cairo'),(361179,'Al Hawamidiyah','EG',29.9,31.25,106841,23,'Africa/Cairo'),(362485,'Abu Kabir','EG',30.72508,31.67148,100684,17,'Africa/Cairo'),(715429,'Szeged','HU',46.253,20.14824,164883,84,'Europe/Budapest'),(716935,'Nyiregyhaza','HU',47.95539,21.71671,116298,111,'Europe/Budapest'),(717582,'Miskolc','HU',48.1,20.78333,172637,131,'Europe/Budapest'),(721472,'Debrecen','HU',47.53333,21.63333,204124,123,'Europe/Budapest'),(734077,'Thessaloniki','GR',40.64028,22.94389,354290,34,'Europe/Athens'),(736083,'Kalamaria','GR',40.5825,22.95028,91617,39,'Europe/Athens'),(1154689,'Ko Samui','TH',9.53567,99.93567,50000,8,'Asia/Bangkok'),(1252797,'Yamunanagar','IN',30.12913,77.28049,208931,265,'Asia/Kolkata'),(1253102,'Vishakhapatnam','IN',17.69004,83.20925,1063178,38,'Asia/Kolkata'),(1253184,'Vijayawada','IN',16.51667,80.61667,874587,27,'Asia/Kolkata'),(1253573,'Vadodara','IN',22.3,73.2,1409476,39,'Asia/Kolkata'),(1254320,'Tiruvottiyur','IN',13.15778,80.30417,248059,8,'Asia/Kolkata'),(1254388,'Tiruchchirappalli','IN',10.805,78.68556,775484,81,'Asia/Kolkata'),(1254745,'Teni','IN',10,77.48333,1034724,297,'Asia/Kolkata'),(1255134,'Talegaon Dabhade','IN',18.71667,73.68333,47653,611,'Asia/Kolkata'),(1255744,'Sonipat','IN',28.99587,77.01165,250521,222,'Asia/Kolkata'),(1256039,'Sirsilla','IN',18.38333,78.83333,71499,326,'Asia/Kolkata'),(1256237,'Shimla','IN',31.10442,77.16662,173503,2032,'Asia/Kolkata'),(1256436,'Solapur','IN',17.68333,75.91667,997281,470,'Asia/Kolkata'),(1256515,'Shimoga','IN',13.93157,75.56791,319550,578,'Asia/Kolkata'),(1256523,'Shillong','IN',25.56892,91.88313,132842,1507,'Asia/Kolkata'),(1256525,'Shiliguri','IN',26.71004,88.42851,515574,125,'Asia/Kolkata'),(1256728,'Shahjahanpur','IN',27.88142,79.9109,320434,153,'Asia/Kolkata'),(1257416,'Sangli','IN',16.85438,74.56417,601214,553,'Asia/Kolkata'),(1257540,'Sambhal','IN',28.58323,78.56689,196109,195,'Asia/Kolkata'),(1257542,'Sambalpur','IN',21.45,83.96667,162887,142,'Asia/Kolkata'),(1257806,'Saharanpur','IN',29.9679,77.54522,484873,270,'Asia/Kolkata'),(1258076,'Rohtak','IN',28.88838,76.5754,317245,214,'Asia/Kolkata'),(1258342,'Ratlam','IN',23.33033,75.04032,236843,492,'Asia/Kolkata'),(1259229,'Pune','IN',18.51957,73.85535,2935744,554,'Asia/Kolkata'),(1259652,'Pimpri','IN',18.61667,73.8,1284606,566,'Asia/Kolkata'),(1260086,'Patna','IN',25.60222,85.11936,1599920,50,'Asia/Kolkata'),(1260476,'Panipat','IN',29.39005,76.96949,292808,219,'Asia/Kolkata'),(1260482,'Panihati','IN',22.69089,88.37404,378705,15,'Asia/Kolkata'),(1261481,'New Delhi','IN',28.63576,77.22445,317797,212,'Asia/Kolkata'),(1261669,'Navadwip','IN',23.4067,88.3686,111123,11,'Asia/Kolkata'),(1262180,'Nagpur','IN',21.15,79.1,2228018,310,'Asia/Kolkata'),(1262330,'Muzaffarpur','IN',26.12259,85.39055,333200,47,'Asia/Kolkata'),(1263311,'Mau','IN',25.94167,83.56111,246050,66,'Asia/Kolkata'),(1264728,'Ludhiana','IN',30.90015,75.85229,1545368,242,'Asia/Kolkata'),(1264733,'Lucknow','IN',26.83928,80.92313,2472011,131,'Asia/Kolkata'),(1266122,'Korba','IN',22.35,82.68333,419146,274,'Asia/Kolkata'),(1266285,'Kolhapur','IN',16.7,74.21667,516142,555,'Asia/Kolkata'),(1267696,'Karol Bagh','IN',28.65156,77.18858,505241,220,'Asia/Kolkata'),(1268257,'Kamarhati','IN',22.67111,88.37472,332965,8,'Asia/Kolkata'),(1269515,'Jaipur','IN',26.91962,75.78781,2711758,428,'Asia/Kolkata'),(1269633,'Jabalpur','IN',23.16697,79.95006,1030168,416,'Asia/Kolkata'),(1269743,'Indore','IN',22.71792,75.8333,1837041,550,'Asia/Kolkata'),(1269771,'Imphal','IN',24.80805,93.9442,223523,784,'Asia/Kolkata'),(1269843,'Hyderabad','IN',17.37528,78.47444,3597816,502,'Asia/Kolkata'),(1270393,'Hapur','IN',28.73041,77.78141,242920,207,'Asia/Kolkata'),(1270396,'Haora','IN',22.57688,88.31857,1027672,12,'Asia/Kolkata'),(1270407,'Hanumangarh','IN',29.58182,74.32938,155687,181,'Asia/Kolkata'),(1270752,'Gulbarga','IN',17.33333,76.83333,483615,458,'Asia/Kolkata'),(1271308,'Ghaziabad','IN',28.66249,77.43777,1199191,210,'Asia/Kolkata'),(1271685,'Ganganagar','IN',29.92008,73.87496,231838,166,'Asia/Kolkata'),(1271883,'Firozpur','IN',30.92574,74.61311,102130,185,'Asia/Kolkata'),(1271885,'Firozabad','IN',27.14941,78.4018,306409,166,'Asia/Kolkata'),(1271942,'Farrukhabad','IN',27.39048,79.58006,241152,155,'Asia/Kolkata'),(1271951,'Faridabad','IN',28.41252,77.31977,1220229,196,'Asia/Kolkata'),(1272543,'Dindigul','IN',10.36896,77.98036,200797,273,'Asia/Kolkata'),(1272552,'Dimapur','IN',25.91174,93.7217,135860,140,'Asia/Kolkata'),(1272805,'Dhaulpur','IN',26.69286,77.87968,102462,181,'Asia/Kolkata'),(1273294,'Delhi','IN',28.65381,77.22897,10927986,220,'Asia/Kolkata'),(1273309,'Dehri','IN',24.90504,84.18289,129938,106,'Asia/Kolkata'),(1273313,'Dehra Dun','IN',30.31667,78.03333,522081,655,'Asia/Kolkata'),(1273467,'Darjiling','IN',27.03333,88.26667,123797,2127,'Asia/Kolkata'),(1273800,'Cuddapah','IN',14.46667,78.81667,127010,135,'Asia/Kolkata'),(1273802,'Cuddalore','IN',11.75,79.75,158569,7,'Asia/Kolkata'),(1273865,'Coimbatore','IN',10.9925,76.96139,959823,384,'Asia/Kolkata'),(1273874,'Cochin','IN',9.93988,76.26022,604696,9,'Asia/Kolkata'),(1274220,'Chikmagalur','IN',13.31667,75.78333,121484,1021,'Asia/Kolkata'),(1274337,'Chhatarpur','IN',24.91422,79.5878,111594,305,'Asia/Kolkata'),(1274571,'Charkhi Dadri','IN',28.5963,76.27092,50558,224,'Asia/Kolkata'),(1274784,'Chandannagar','IN',22.86225,88.36796,180623,17,'Asia/Kolkata'),(1275004,'Kolkata','IN',22.56263,88.36304,4631392,14,'Asia/Kolkata'),(1275339,'Mumbai','IN',19.07283,72.88261,12691836,8,'Asia/Kolkata'),(1275346,'Bolpur','IN',23.66667,87.71667,70998,55,'Asia/Kolkata'),(1275817,'Bhubaneshwar','IN',20.23333,85.83333,762243,27,'Asia/Kolkata'),(1275841,'Bhopal','IN',23.25469,77.40289,1599914,499,'Asia/Kolkata'),(1276014,'Bhayandar','IN',19.3,72.85,520301,9,'Asia/Kolkata'),(1276100,'Bharuch','IN',21.7,72.96667,153528,19,'Asia/Kolkata'),(1276393,'Bettiah','IN',26.8024,84.49873,127008,66,'Asia/Kolkata'),(1276509,'Bellary','IN',15.15,76.93333,336681,452,'Asia/Kolkata'),(1276600,'Behat','IN',30.1705,77.61532,18223,278,'Asia/Kolkata'),(1276609,'Begusarai','IN',25.41853,86.1339,103060,41,'Asia/Kolkata'),(1276895,'Barnala','IN',30.37205,75.54537,105016,227,'Asia/Kolkata'),(1276901,'Barmer','IN',25.74572,71.39211,89487,206,'Asia/Kolkata'),(1277013,'Bareilly','IN',28.34702,79.42193,745435,166,'Asia/Kolkata'),(1277065,'Barasat','IN',22.72154,88.48198,298127,16,'Asia/Kolkata'),(1277066,'Barasat','IN',22.22516,88.45086,237783,4,'Asia/Kolkata'),(1277082,'Baranagar','IN',22.64132,88.37727,260072,11,'Asia/Kolkata'),(1277324,'Bangaon','IN',23.04552,88.83084,111693,11,'Asia/Kolkata'),(1277330,'Banganapalle','IN',15.31667,78.23333,25325,222,'Asia/Kolkata'),(1277333,'Bangalore','IN',12.97194,77.59369,5104047,913,'Asia/Kolkata'),(1277599,'Balasore','IN',21.49417,86.93167,114321,20,'Asia/Kolkata'),(1277808,'Bahjoi','IN',28.39361,78.62212,33752,192,'Asia/Kolkata'),(1277814,'Baheri','IN',28.77373,79.49553,63953,181,'Asia/Kolkata'),(1277820,'Baharampur','IN',24.10473,88.25155,180547,21,'Asia/Kolkata'),(1277835,'Bahadurgarh','IN',28.69108,76.9316,153613,211,'Asia/Kolkata'),(1277936,'Bagalkot','IN',16.18673,75.69614,97269,527,'Asia/Kolkata'),(1277939,'Bagaha','IN',27.09918,84.09003,103855,80,'Asia/Kolkata'),(1278148,'Aurangabad','IN',24.75389,84.37406,95929,108,'Asia/Kolkata'),(1278149,'Aurangabad','IN',19.88333,75.33333,1016441,573,'Asia/Kolkata'),(1278152,'Auraiya','IN',26.46313,79.51167,70508,137,'Asia/Kolkata'),(1278335,'Arvi','IN',20.98333,78.23333,41837,298,'Asia/Kolkata'),(1278340,'Aruppukkottai','IN',9.51667,78.1,85369,101,'Asia/Kolkata'),(1278466,'Arambagh','IN',22.88333,87.78333,60639,23,'Asia/Kolkata'),(1278471,'Arakkonam','IN',13.08449,79.67053,79080,84,'Asia/Kolkata'),(1278553,'Ankleshwar','IN',21.6,73,74742,20,'Asia/Kolkata'),(1278573,'Anjar','IN',23.13333,70.01667,66888,75,'Asia/Kolkata'),(1278580,'Anjangaon','IN',21.16306,77.30944,54999,345,'Asia/Kolkata'),(1278708,'Amroha','IN',28.90314,78.46984,176253,210,'Asia/Kolkata'),(1278710,'Amritsar','IN',31.63661,74.87476,1092450,218,'Asia/Kolkata'),(1278715,'Amreli','IN',21.61667,71.23333,99742,130,'Asia/Kolkata'),(1278718,'Amravati','IN',20.93333,77.75,603837,341,'Asia/Kolkata'),(1278815,'Ambur','IN',12.79163,78.71644,109873,309,'Asia/Kolkata'),(1278827,'Ambikapur','IN',23.11667,83.2,72821,593,'Asia/Kolkata'),(1278840,'Ambattur','IN',13.09833,80.16222,341049,17,'Asia/Kolkata'),(1278990,'Allahganj','IN',27.54559,79.6873,13824,145,'Asia/Kolkata'),(1278994,'Allahabad','IN',25.44894,81.83328,1073438,73,'Asia/Kolkata'),(1279228,'Ahmadnagar','IN',19.08333,74.73333,367140,647,'Asia/Kolkata'),(1279233,'Ahmadabad','IN',23.03333,72.61667,3719710,51,'Asia/Kolkata'),(1279259,'Agra','IN',27.18333,78.01667,1430055,166,'Asia/Kolkata'),(1279290,'Agartala','IN',23.83605,91.27939,203264,18,'Asia/Kolkata'),(1283240,'Kathmandu','NP',27.70169,85.3206,1442271,1296,'Asia/Kathmandu'),(1655559,'Louangphabang','LA',19.88556,102.13472,47378,300,'Asia/Vientiane'),(2294206,'Wa','GH',10.06069,-2.50192,78107,326,'Africa/Accra'),(2294665,'Teshi','GH',5.58365,-0.10722,144013,13,'Africa/Accra'),(2294700,'Tema','GH',5.6698,-0.01657,155782,82,'Africa/Accra'),(2294727,'Techiman','GH',7.58616,-1.94137,69720,398,'Africa/Accra'),(2294877,'Tamale','GH',9.40078,-0.8393,360579,196,'Africa/Accra'),(2294915,'Takoradi','GH',4.88447,-1.75536,232919,22,'Africa/Accra'),(2294938,'Tafo','GH',6.73453,-1.61275,50457,291,'Africa/Accra'),(2294962,'Swedru','GH',5.53711,-0.69984,50293,74,'Africa/Accra'),(2295021,'Sunyani','GH',7.33991,-2.32676,70299,298,'Africa/Accra'),(2295458,'Sekondi-Takoradi','GH',4.934,-1.7137,138872,10,'Africa/Accra'),(2296606,'Obuasi','GH',6.20602,-1.66191,137856,233,'Africa/Accra'),(2296969,'Nungua','GH',5.60106,-0.07713,70483,28,'Africa/Accra'),(2298330,'Madina','GH',5.68234,-0.16413,101207,69,'Africa/Accra'),(2298890,'Kumasi','GH',6.68848,-1.62443,1468609,270,'Africa/Accra'),(2299522,'Koforidua','GH',6.09408,-0.25913,96266,172,'Africa/Accra'),(2300379,'Ho','GH',6.60084,0.4713,69998,178,'Africa/Accra'),(2302357,'Cape Coast','GH',5.10535,-1.2466,143015,21,'Africa/Accra'),(2302821,'Bolgatanga','GH',10.78556,-0.85139,54430,191,'Africa/Accra'),(2303287,'Bawku','GH',11.0616,-0.24168,56830,252,'Africa/Accra'),(2306079,'Achiaman','GH',5.7,-0.33333,202932,39,'Africa/Accra'),(2306104,'Accra','GH',5.55602,-0.1969,1963264,91,'Africa/Accra'),(2509769,'Velez-Malaga','ES',36.77262,-4.10045,74190,39,'Europe/Madrid'),(2509954,'Valencia','ES',39.46975,-0.37739,814208,23,'Europe/Madrid'),(2510253,'Torrevieja','ES',37.97872,-0.68222,101792,14,'Europe/Madrid'),(2510279,'Torrent','ES',39.43705,-0.46546,78543,51,'Europe/Madrid'),(2510281,'Torremolinos','ES',36.62035,-4.49976,65448,47,'Europe/Madrid'),(2510409,'Toledo','ES',39.8581,-4.02263,82291,533,'Europe/Madrid'),(2510542,'Telde','ES',27.99242,-15.41915,100015,160,'Atlantic/Canary'),(2510693,'Talavera de la Reina','ES',39.96348,-4.83076,88856,380,'Europe/Madrid'),(2510911,'Sevilla','ES',37.38241,-5.97613,703206,14,'Europe/Madrid'),(2511150,'Santa Lucia','ES',27.91174,-15.54071,63637,699,'Atlantic/Canary'),(2511174,'Santa Cruz de Tenerife','ES',28.46824,-16.25462,222417,55,'Atlantic/Canary'),(2511306,'Sanlucar de Barrameda','ES',36.77808,-6.3515,65805,12,'Europe/Madrid'),(2511388,'San Fernando','ES',36.4759,-6.19817,96366,15,'Europe/Madrid'),(2511401,'La Laguna','ES',28.4853,-16.32014,150661,558,'Atlantic/Canary'),(2511619,'Sagunto','ES',39.68333,-0.26667,66070,43,'Europe/Madrid'),(2511716,'Roquetas de Mar','ES',36.76419,-2.61475,82665,12,'Europe/Madrid'),(2512862,'Paterna','ES',39.5,-0.43333,64023,61,'Europe/Madrid'),(2512989,'Palma','ES',39.56939,2.65024,401270,34,'Europe/Madrid'),(2513076,'Orihuela','ES',38.08483,-0.94401,86164,32,'Europe/Madrid'),(2513416,'Murcia','ES',37.98704,-1.13004,436870,53,'Europe/Madrid'),(2513477,'Motril','ES',36.75066,-3.5179,60279,65,'Europe/Madrid'),(2513759,'Molina de Segura','ES',38.05456,-1.20763,64065,108,'Europe/Madrid'),(2513882,'Mijas','ES',36.59575,-4.63728,73787,418,'Europe/Madrid'),(2513947,'Melilla','ES',35.29369,-2.93833,73460,14,'Africa/Ceuta'),(2514169,'Marbella','ES',36.51543,-4.88583,134623,57,'Europe/Madrid'),(2514256,'Malaga','ES',36.72016,-4.42034,568305,22,'Europe/Madrid'),(2514891,'Lorca','ES',37.67119,-1.7017,91906,339,'Europe/Madrid'),(2515045,'Linares','ES',38.09519,-3.63602,61338,413,'Europe/Madrid'),(2515270,'Las Palmas de Gran Canaria','ES',28.09973,-15.41343,381847,23,'Atlantic/Canary'),(2515812,'La Linea de la Concepcion','ES',36.16809,-5.34777,64595,4,'Europe/Madrid'),(2516326,'Jerez de la Frontera','ES',36.68645,-6.13606,207532,53,'Europe/Madrid'),(2516395,'Jaen','ES',37.76667,-3.78333,116557,541,'Europe/Madrid'),(2516548,'Huelva','ES',37.25833,-6.95083,148806,29,'Europe/Madrid'),(2517117,'Granada','ES',37.18817,-3.60667,234325,689,'Europe/Madrid'),(2517367,'Gandia','ES',38.96667,-0.18333,80020,34,'Europe/Madrid'),(2517595,'Fuengirola','ES',36.53998,-4.62473,71482,13,'Europe/Madrid'),(2517816,'Estepona','ES',36.42764,-5.14589,65592,13,'Europe/Madrid'),(2518207,'El Puerto de Santa Maria','ES',36.59389,-6.23298,87696,11,'Europe/Madrid'),(2518494,'El Ejido','ES',36.77629,-2.81456,84227,84,'Europe/Madrid'),(2518559,'Elche','ES',38.26218,-0.70107,230112,81,'Europe/Madrid'),(2518794,'Dos Hermanas','ES',37.28287,-5.92088,122943,45,'Europe/Madrid'),(2519240,'Cordoba','ES',37.88333,-4.76667,328428,106,'Europe/Madrid'),(2519402,'Ciudad Real','ES',38.98333,-3.93333,74014,633,'Europe/Madrid'),(2519513,'Chiclana de la Frontera','ES',36.41915,-6.14941,77293,14,'Europe/Madrid'),(2519752,'Castello de la Plana','ES',39.98333,-0.03333,180005,35,'Europe/Madrid'),(2520058,'Cartagena','ES',37.60512,-0.98623,211996,5,'Europe/Madrid'),(2520600,'Cadiz','ES',36.53361,-6.29944,126766,21,'Europe/Madrid'),(2520611,'Caceres','ES',39.47649,-6.37224,93131,441,'Europe/Madrid'),(2521088,'Benidorm','ES',38.53816,-0.13098,71034,30,'Europe/Madrid'),(2521420,'Badajoz','ES',38.87789,-6.97061,148334,192,'Europe/Madrid'),(2521582,'Arona','ES',28.09962,-16.68102,78614,632,'Atlantic/Canary'),(2521886,'Almeria','ES',36.83814,-2.45974,188810,21,'Europe/Madrid'),(2521978,'Alicante','ES',38.34517,-0.48149,334757,18,'Europe/Madrid'),(2522013,'Algeciras','ES',36.13326,-5.45051,116209,29,'Europe/Madrid'),(2522098,'Alcoy','ES',38.70545,-0.47432,61552,554,'Europe/Madrid'),(2522165,'Alcala de Guadaira','ES',37.33791,-5.83951,70155,71,'Europe/Madrid'),(2522258,'Albacete','ES',38.98333,-1.85,169716,691,'Europe/Madrid'),(2522713,'Vittoria','IT',36.95374,14.53318,55317,172,'Europe/Rome'),(2522876,'Trapani','IT',38.01584,12.51077,68346,21,'Europe/Rome'),(2523083,'Siracusa','IT',37.08515,15.273,123657,65,'Europe/Rome'),(2523630,'Reggio Calabria','IT',38.11047,15.66129,180353,110,'Europe/Rome'),(2523650,'Ragusa','IT',36.92824,14.71719,68956,591,'Europe/Rome'),(2523665,'Quartu Sant\'Elena','IT',39.24194,9.18389,68040,8,'Europe/Rome'),(2523920,'Palermo','IT',38.11582,13.35976,672175,30,'Europe/Rome'),(2524013,'Nicastro','IT',38.98333,16.31667,70288,438,'Europe/Rome'),(2524119,'Modica','IT',36.84594,14.77399,52639,436,'Europe/Rome'),(2524170,'Messina','IT',38.19327,15.54969,252026,66,'Europe/Rome'),(2524245,'Marsala','IT',37.79664,12.43518,77784,12,'Europe/Rome'),(2524653,'Gela','IT',37.08034,14.23068,72774,14,'Europe/Rome'),(2524881,'Crotone','IT',39.0851,17.11781,60010,6,'Europe/Rome'),(2524907,'Cosenza','IT',39.30999,16.25019,72998,235,'Europe/Rome'),(2525059,'Catanzaro','IT',38.89079,16.5987,95251,124,'Europe/Rome'),(2525068,'Catania','IT',37.50213,15.08719,313110,17,'Europe/Rome'),(2525448,'Caltanissetta','IT',37.48774,14.04497,61438,608,'Europe/Rome'),(2525473,'Cagliari','IT',39.20738,9.13462,164249,22,'Europe/Rome'),(2525764,'Agrigento','IT',37.32084,13.58876,54619,227,'Europe/Rome'),(2567529,'Groa de Murviedro','ES',39.64167,-0.23889,62368,3,'Europe/Madrid'),(2633352,'York','GB',53.95763,-1.08271,144202,17,'Europe/London'),(2633521,'Worthing','GB',50.81448,-0.37126,99110,12,'Europe/London'),(2633563,'Worcester','GB',52.18935,-2.22001,100023,29,'Europe/London'),(2633691,'Wolverhampton','GB',52.58547,-2.12296,252791,160,'Europe/London'),(2633709,'Woking','GB',51.31903,-0.55893,103932,39,'Europe/London'),(2633948,'Wigan','GB',53.53333,-2.61667,80788,41,'Europe/London'),(2634308,'Weston-super-Mare','GB',51.34603,-2.97665,82903,13,'Europe/London'),(2634491,'West Bromwich','GB',52.51868,-1.9945,135618,165,'Europe/London'),(2634677,'Watford','GB',51.65531,-0.39602,125707,77,'Europe/London'),(2634686,'Waterlooville','GB',50.88067,-1.0304,64350,54,'Europe/London'),(2634739,'Warrington','GB',53.39254,-2.58024,81238,15,'Europe/London'),(2634853,'Walsall','GB',52.58528,-1.98396,172141,129,'Europe/London'),(2634910,'Wakefield','GB',53.68331,-1.49768,78978,50,'Europe/London'),(2635650,'Torquay','GB',50.46384,-3.51434,65388,49,'Europe/London'),(2636177,'Taunton','GB',51.01494,-3.10293,60433,47,'Europe/London'),(2636276,'Tamworth','GB',52.63399,-1.69587,74129,73,'Europe/London'),(2636389,'Swindon','GB',51.55797,-1.78116,155432,113,'Europe/London'),(2636432,'Swansea','GB',51.62079,-3.94323,170883,18,'Europe/London'),(2636486,'Sutton Coldfield','GB',52.56667,-1.81667,107030,119,'Europe/London'),(2636503,'Sutton','GB',51.35,-0.2,187600,83,'Europe/London'),(2636531,'Sunderland','GB',54.90465,-1.38222,177965,36,'Europe/London'),(2636841,'Stoke-on-Trent','GB',53.00415,-2.18538,260419,114,'Europe/London'),(2636876,'Stockton-on-Tees','GB',54.56848,-1.3187,79957,15,'Europe/London'),(2636882,'Stockport','GB',53.40979,-2.15761,139052,59,'Europe/London'),(2636940,'Stevenage','GB',51.90224,-0.20256,84651,95,'Europe/London'),(2637142,'Stafford','GB',52.80521,-2.11636,65290,77,'Europe/London'),(2637329,'South Shields','GB',54.99859,-1.4323,83655,12,'Europe/London'),(2637343,'Southport','GB',53.64779,-3.00648,93044,12,'Europe/London'),(2637433,'Southend-on-Sea','GB',51.53782,0.71433,163377,31,'Europe/London'),(2637487,'Southampton','GB',50.90395,-1.40428,246201,19,'Europe/London'),(2637490,'Southall','GB',51.50896,-0.3713,70000,35,'Europe/London'),(2637546,'Solihull','GB',52.41426,-1.78094,96267,132,'Europe/London'),(2637627,'Slough','GB',51.50949,-0.59541,134072,33,'Europe/London'),(2637891,'Shrewsbury','GB',52.71009,-2.75208,69519,75,'Europe/London'),(2638077,'Sheffield','GB',53.38297,-1.4659,447047,75,'Europe/London'),(2638324,'Scunthorpe','GB',53.57905,-0.65437,72514,46,'Europe/London'),(2638671,'Salford','GB',53.48771,-2.29042,72750,44,'Europe/London'),(2638785,'Saint Helens','GB',53.45,-2.73333,102555,31,'Europe/London'),(2638867,'Saint Albans','GB',51.75,-0.33333,84561,98,'Europe/London'),(2638978,'Rugby','GB',52.37092,-1.26417,63323,120,'Europe/London'),(2639022,'Royal Tunbridge Wells','GB',51.13245,0.26333,61075,118,'Europe/London'),(2639093,'Rotherham','GB',53.43012,-1.35678,117618,41,'Europe/London'),(2639272,'Rochdale','GB',53.61766,-2.1552,97550,127,'Europe/London'),(2639557,'Redditch','GB',52.3065,-1.94569,77128,115,'Europe/London'),(2639577,'Reading','GB',51.45625,-0.97113,244070,51,'Europe/London'),(2639842,'Purley','GB',51.33678,-0.11201,72000,97,'Europe/London'),(2639912,'Preston','GB',53.76667,-2.71667,190687,22,'Europe/London'),(2639996,'Portsmouth','GB',50.79899,-1.09125,194150,6,'Europe/London'),(2640101,'Poole','GB',50.71667,-2,150092,1,'Europe/London'),(2640194,'Plymouth','GB',50.37153,-4.14305,247297,14,'Europe/London'),(2640354,'Peterborough','GB',52.57364,-0.24777,140141,12,'Europe/London'),(2640677,'Paisley','GB',55.83173,-4.43254,73074,50,'Europe/London'),(2640729,'Oxford','GB',51.75222,-1.25596,154566,72,'Europe/London'),(2641022,'Oldham','GB',53.54051,-2.1183,104782,204,'Europe/London'),(2641157,'Nuneaton','GB',52.52323,-1.46523,73555,85,'Europe/London'),(2641170,'Nottingham','GB',52.9536,-1.15047,246654,61,'Europe/London'),(2641181,'Norwich','GB',52.62783,1.29834,177636,19,'Europe/London'),(2641430,'Northampton','GB',52.25,-0.88333,197322,97,'Europe/London'),(2641520,'Newtownabbey','GB',54.65983,-5.90858,63860,15,'Europe/London'),(2641598,'Newport','GB',51.58774,-2.99835,117326,16,'Europe/London'),(2641673,'Newcastle upon Tyne','GB',54.97328,-1.61396,192382,54,'Europe/London'),(2641674,'Newcastle under Lyme','GB',53,-2.23333,75794,160,'Europe/London'),(2642465,'Milton Keynes','GB',52.04172,-0.75583,184506,114,'Europe/London'),(2642607,'Middlesbrough','GB',54.57623,-1.23483,142707,15,'Europe/London'),(2643044,'Margate','GB',51.38132,1.38617,60134,24,'Europe/London'),(2643097,'Mansfield','GB',53.13333,-1.2,70447,122,'Europe/London'),(2643123,'Manchester','GB',53.48095,-2.23743,395515,51,'Europe/London'),(2643179,'Maidstone','GB',51.26667,0.51667,90894,9,'Europe/London'),(2643339,'Luton','GB',51.87967,-0.41748,193669,117,'Europe/London'),(2643490,'Lowestoft','GB',52.4752,1.75159,71479,7,'Europe/London'),(2643734,'Londonderry County Borough','GB',54.99721,-7.30917,87153,24,'Europe/London'),(2643736,'Derry','GB',54.9981,-7.30934,83652,24,'Europe/London'),(2643741,'City of London','GB',51.51279,-0.09184,7556900,27,'Europe/London'),(2643743,'London','GB',51.50853,-0.12574,7556900,25,'Europe/London'),(2644210,'Liverpool','GB',53.41058,-2.97794,468945,30,'Europe/London'),(2644411,'Lisburn','GB',54.52337,-6.03527,77506,53,'Europe/London'),(2644487,'Lincoln','GB',53.22683,-0.53792,89228,9,'Europe/London'),(2644559,'Lewes','GB',50.87363,0.01133,16479,24,'Europe/London'),(2644668,'Leicester','GB',52.6386,-1.13169,339239,65,'Europe/London'),(2644688,'Leeds','GB',53.79648,-1.54785,455123,50,'Europe/London'),(2644737,'Royal Leamington Spa','GB',52.3,-1.53333,64640,69,'Europe/London'),(2645418,'Kingswood','GB',51.45278,-2.50833,64793,104,'Europe/London'),(2645425,'Hull','GB',53.7446,-0.33525,302296,8,'Europe/London'),(2646003,'Islington','GB',51.53622,-0.10304,319143,37,'Europe/London'),(2646057,'Ipswich','GB',52.05917,1.15545,143767,18,'Europe/London'),(2646458,'Huddersfield','GB',53.64904,-1.78416,149017,90,'Europe/London'),(2646504,'Hove','GB',50.83088,-0.1672,75174,24,'Europe/London'),(2646914,'High Wycombe','GB',51.62907,-0.74934,80357,76,'Europe/London'),(2647138,'Hemel Hempstead','GB',51.75369,-0.47517,85629,88,'Europe/London'),(2647356,'Hastings','GB',50.85519,0.57292,89100,29,'Europe/London'),(2647400,'Hartlepool','GB',54.68611,-1.2125,86713,14,'Europe/London'),(2647428,'Harrogate','GB',53.99078,-1.5373,87024,127,'Europe/London'),(2647461,'Harlow','GB',51.77655,0.11158,94365,68,'Europe/London'),(2647632,'Halifax','GB',53.71667,-1.85,82624,150,'Europe/London'),(2647793,'Guildford','GB',51.23536,-0.57427,71873,46,'Europe/London'),(2648182,'Grays','GB',51.47566,0.32521,70934,13,'Europe/London'),(2648272,'Gosport','GB',50.79509,-1.12902,70793,5,'Europe/London'),(2648404,'Gloucester','GB',51.86568,-2.2431,128721,24,'Europe/London'),(2648579,'Glasgow','GB',55.86515,-4.25763,610268,40,'Europe/London'),(2648657,'Gillingham','GB',51.38914,0.54863,101187,31,'Europe/London'),(2648773,'Gateshead','GB',54.96209,-1.60168,77649,53,'Europe/London'),(2648970,'Fylde','GB',53.83333,-2.91667,76500,22,'Europe/London'),(2649808,'Exeter','GB',50.7236,-3.52751,113118,46,'Europe/London'),(2650096,'Ellesmere Port','GB',53.27875,-2.90134,67768,26,'Europe/London'),(2650225,'Edinburgh','GB',55.95206,-3.19648,435791,66,'Europe/London'),(2650405,'East Kilbride','GB',55.76667,-4.16667,74231,172,'Europe/London'),(2650497,'Eastbourne','GB',50.76871,0.28453,112906,8,'Europe/London'),(2650752,'Dundee','GB',56.5,-2.96667,151592,122,'Europe/London'),(2650839,'Dudley','GB',52.5,-2.08333,199059,161,'Europe/London'),(2651123,'Doncaster','GB',53.52327,-1.13691,67670,23,'Europe/London'),(2651347,'Derby','GB',52.92277,-1.47663,235029,55,'Europe/London'),(2651513,'Darlington','GB',54.52429,-1.55039,87204,40,'Europe/London'),(2651621,'Dagenham','GB',51.55,0.16667,108368,13,'Europe/London'),(2652002,'Crewe','GB',53.09787,-2.44161,70455,60,'Europe/London'),(2652053,'Crawley','GB',51.11303,-0.18312,107061,84,'Europe/London'),(2652221,'Coventry','GB',52.40656,-1.51217,308313,89,'Europe/London'),(2652618,'Colchester','GB',51.88921,0.90421,109414,29,'Europe/London'),(2653225,'Chesterfield','GB',53.25,-1.41667,70679,89,'Europe/London'),(2653228,'Chester','GB',53.1905,-2.89189,77040,34,'Europe/London'),(2653261,'Cheltenham','GB',51.9,-2.08333,103249,62,'Europe/London'),(2653265,'Chelsea','GB',51.48755,-0.16936,60000,12,'Europe/London'),(2653266,'Chelmsford','GB',51.73575,0.46958,102671,33,'Europe/London'),(2653305,'Chatham','GB',51.37891,0.52786,75509,21,'Europe/London'),(2653775,'Carlisle','GB',54.8951,-2.9382,72633,29,'Europe/London'),(2653822,'Cardiff','GB',51.48,-3.18,302139,17,'Europe/London'),(2653883,'Cannock','GB',52.69045,-2.03085,68067,154,'Europe/London'),(2653941,'Cambridge','GB',52.2,0.11667,128488,12,'Europe/London'),(2654187,'Bury','GB',53.6,-2.3,61044,93,'Europe/London'),(2654264,'Burnley','GB',53.8,-2.23333,73480,140,'Europe/London'),(2654675,'Bristol','GB',51.45523,-2.59665,430713,21,'Europe/London'),(2654710,'Brighton','GB',50.82838,-0.13947,139001,29,'Europe/London'),(2654993,'Bradford','GB',53.79391,-1.75206,299310,110,'Europe/London'),(2655009,'Bracknell','GB',51.41363,-0.75054,76103,81,'Europe/London'),(2655095,'Bournemouth','GB',50.72048,-1.8795,163600,19,'Europe/London'),(2655237,'Bolton','GB',53.58333,-2.43333,141331,105,'Europe/London'),(2655262,'Bognor Regis','GB',50.78206,-0.67978,65391,5,'Europe/London'),(2655459,'Blackpool','GB',53.81667,-3.05,143101,21,'Europe/London'),(2655524,'Blackburn','GB',53.75,-2.48333,106154,121,'Europe/London'),(2655603,'Birmingham','GB',52.48142,-1.89983,984333,149,'Europe/London'),(2655613,'Birkenhead','GB',53.39337,-3.01479,81805,22,'Europe/London'),(2655775,'Bexley','GB',51.44162,0.14866,228000,16,'Europe/London'),(2655984,'Belfast','GB',54.58333,-5.93333,274770,17,'Europe/London'),(2656046,'Bedford','GB',52.13459,-0.46632,86658,30,'Europe/London'),(2656065,'Beckenham','GB',51.40878,-0.02526,82000,45,'Europe/London'),(2656161,'Battle','GB',50.91732,0.48417,6171,83,'Europe/London'),(2656173,'Bath','GB',51.37795,-2.35907,93238,24,'Europe/London'),(2656192,'Basingstoke','GB',51.26249,-1.08708,96348,96,'Europe/London'),(2656194,'Basildon','GB',51.56844,0.45782,101362,31,'Europe/London'),(2656284,'Barnsley','GB',53.55,-1.48333,71447,112,'Europe/London'),(2656333,'Barking','GB',51.53333,0.08333,61000,6,'Europe/London'),(2656396,'Bangor','GB',54.65338,-5.66895,60385,45,'Europe/London'),(2656719,'Aylesbury','GB',51.81665,-0.81458,74565,93,'Europe/London'),(2656955,'Ashford','GB',51.14586,0.87281,62787,45,'Europe/London'),(2657540,'Aldershot','GB',51.24827,-0.76389,61339,99,'Europe/London'),(2657832,'Aberdeen','GB',57.14369,-2.09814,183790,13,'Europe/London'),(2743477,'Zwolle','NL',52.5125,6.09444,111805,9,'Europe/Amsterdam'),(2743856,'Zoetermeer','NL',52.0575,4.49306,115845,0,'Europe/Amsterdam'),(2744114,'Zaanstad','NL',52.45313,4.81356,140085,2,'Europe/Amsterdam'),(2745641,'Venlo','NL',51.37,6.16806,92403,24,'Europe/Amsterdam'),(2745912,'Utrecht','NL',52.09083,5.12222,290529,13,'Europe/Amsterdam'),(2746301,'Tilburg','NL',51.55551,5.0913,199613,16,'Europe/Amsterdam'),(2747351,'\'s-Hertogenbosch','NL',51.69917,5.30417,134520,7,'Europe/Amsterdam'),(2747373,'Den Haag','NL',52.07667,4.29861,474292,4,'Europe/Amsterdam'),(2747891,'Rotterdam','NL',51.9225,4.47917,598199,9,'Europe/Amsterdam'),(2750053,'Nijmegen','NL',51.8425,5.85278,158732,25,'Europe/Amsterdam'),(2751283,'Maastricht','NL',50.84833,5.68889,122378,56,'Europe/Amsterdam'),(2751773,'Leiden','NL',52.15833,4.49306,119713,6,'Europe/Amsterdam'),(2751792,'Leeuwarden','NL',53.20139,5.80859,91424,0,'Europe/Amsterdam'),(2753801,'Hoofddorp','NL',52.3025,4.68889,132734,254,'Europe/Amsterdam'),(2754064,'Hilversum','NL',52.22333,5.17639,83640,7,'Europe/Amsterdam'),(2754394,'Hengelo','NL',52.26583,6.79306,80809,18,'Europe/Amsterdam'),(2754652,'Heerlen','NL',50.88365,5.98154,93084,114,'Europe/Amsterdam'),(2755003,'Haarlem','NL',52.38084,4.63683,147590,10,'Europe/Amsterdam'),(2755251,'Groningen','NL',53.21917,6.56667,181194,16,'Europe/Amsterdam'),(2756071,'Enschede','NL',52.21833,6.89583,153655,45,'Europe/Amsterdam'),(2756253,'Eindhoven','NL',51.44083,5.47778,209620,22,'Europe/Amsterdam'),(2756669,'Dordrecht','NL',51.81,4.67361,119260,3,'Europe/Amsterdam'),(2756987,'Deventer','NL',52.255,6.16389,97331,12,'Europe/Amsterdam'),(2757345,'Delft','NL',52.00667,4.35556,95060,1,'Europe/Amsterdam'),(2758401,'Breda','NL',51.58656,4.77596,167673,9,'Europe/Amsterdam'),(2758602,'Born','NL',51.03167,5.80972,97169,38,'Europe/Amsterdam'),(2759661,'Arnhem','NL',51.98,5.91111,141674,16,'Europe/Amsterdam'),(2759706,'Apeldoorn','NL',52.21,5.96944,136670,18,'Europe/Amsterdam'),(2759794,'Amsterdam','NL',52.37403,4.88969,741636,13,'Europe/Amsterdam'),(2759821,'Amersfoort','NL',52.155,5.3875,139914,8,'Europe/Amsterdam'),(2759879,'Almere Stad','NL',52.37025,5.21413,176432,253,'Europe/Amsterdam'),(2759899,'Alkmaar','NL',52.63167,4.74861,94853,5,'Europe/Amsterdam'),(2760415,'Zwettl Stift','AT',48.61667,15.2,11718,514,'Europe/Vienna'),(2760510,'Zistersdorf','AT',48.53333,16.75,5661,215,'Europe/Vienna'),(2760523,'Zirl','AT',47.28333,11.23333,6567,945,'Europe/Vienna'),(2760634,'Zell am See','AT',47.32556,12.79444,10046,784,'Europe/Vienna'),(2760854,'Worgl','AT',47.48333,12.06667,11265,518,'Europe/Vienna'),(2760855,'Wordern','AT',48.334,16.21016,6886,171,'Europe/Vienna'),(2760887,'Wolkersdorf','AT',48.38333,16.51667,6416,173,'Europe/Vienna'),(2760894,'Wolfurt','AT',47.46667,9.75,8110,413,'Europe/Vienna'),(2760910,'Wolfsberg','AT',46.84056,14.84417,25610,461,'Europe/Vienna'),(2761186,'Wilhelmsburg','AT',48.10571,15.60539,6718,320,'Europe/Vienna'),(2761353,'Wiener Neustadt','AT',47.8,16.25,38481,269,'Europe/Vienna'),(2761354,'Wiener Neudorf','AT',48.08278,16.31384,8530,202,'Europe/Vienna'),(2761369,'Vienna','AT',48.20849,16.37208,1691468,193,'Europe/Vienna'),(2761524,'Wels','AT',48.16667,14.03333,57946,317,'Europe/Vienna'),(2761531,'Weiz','AT',47.21667,15.61667,9128,506,'Europe/Vienna'),(2761669,'Weinzierl bei Krems','AT',48.4,15.6,24092,207,'Europe/Vienna'),(2761976,'Waldzell','AT',48.13562,13.42701,2095,511,'Europe/Vienna'),(2762077,'Waidhofen an der Ybbs','AT',47.96004,14.77361,11774,360,'Europe/Vienna'),(2762079,'Waidhofen an der Thaya','AT',48.81667,15.28333,5838,493,'Europe/Vienna'),(2762290,'Vorchdorf','AT',48.00388,13.92122,7455,410,'Europe/Vienna'),(2762303,'Vomp','AT',47.33333,11.68333,4628,542,'Europe/Vienna'),(2762315,'Voelkermarkt','AT',46.66222,14.63444,11373,463,'Europe/Vienna'),(2762327,'Voitsberg','AT',47.03333,15.15,9980,560,'Europe/Vienna'),(2762341,'Vocklamarkt','AT',48.0025,13.48383,4869,488,'Europe/Vienna'),(2762343,'Vocklabruck','AT',48.01667,13.65,11887,498,'Europe/Vienna'),(2762453,'Velden am Worthersee','AT',46.61301,14.0413,8817,448,'Europe/Vienna'),(2762908,'Gruenburg','AT',47.97234,14.26472,3824,359,'Europe/Vienna'),(2763423,'Traun','AT',48.22656,14.23459,23959,271,'Europe/Vienna'),(2763460,'Traiskirchen','AT',48.01485,16.29324,16212,204,'Europe/Vienna'),(2763595,'Timelkam','AT',48.00394,13.6076,5855,446,'Europe/Vienna'),(2763749,'Thalgau','AT',47.83333,13.25,5501,597,'Europe/Vienna'),(2763795,'Ternitz','AT',47.71565,16.03575,15153,395,'Europe/Vienna'),(2763810,'Telfs','AT',47.3,11.06667,14028,624,'Europe/Vienna'),(2763837,'Taxenbach','AT',47.28333,12.96667,2830,986,'Europe/Vienna'),(2763929,'Tamsweg','AT',47.12808,13.81102,6126,1026,'Europe/Vienna'),(2764172,'Strasswalchen','AT',47.98333,13.25,7145,523,'Europe/Vienna'),(2764175,'Strasshof an der Nordbahn','AT',48.31667,16.66667,7637,161,'Europe/Vienna'),(2764354,'Steyregg','AT',48.28513,14.36995,4856,252,'Europe/Vienna'),(2764359,'Steyr','AT',48.04274,14.42127,9566,285,'Europe/Vienna'),(2764786,'Spittal an der Drau','AT',46.8,13.5,16363,553,'Europe/Vienna'),(2764957,'Soelden','AT',46.96667,11,3449,1526,'Europe/Vienna'),(2764958,'Hall in Tirol','AT',47.28333,11.51667,12460,587,'Europe/Vienna'),(2765091,'Sieghartskirchen','AT',48.25531,16.01223,7062,198,'Europe/Vienna'),(2765231,'Seewalchen','AT',47.95246,13.58382,4959,493,'Europe/Vienna'),(2765257,'Seekirchen am Wallersee','AT',47.9,13.13333,9865,510,'Europe/Vienna'),(2765278,'Seefeld in Tirol','AT',47.33016,11.18786,3028,1178,'Europe/Vienna'),(2765286,'Seeboden','AT',46.82194,13.495,6221,592,'Europe/Vienna'),(2765388,'Schwechat','AT',48.13333,16.46667,15711,163,'Europe/Vienna'),(2765390,'Schwaz','AT',47.35169,11.71014,12507,537,'Europe/Vienna'),(2765581,'Schruns','AT',47.06667,9.91667,3506,689,'Europe/Vienna'),(2765602,'Schrems','AT',48.78333,15.06667,5811,526,'Europe/Vienna'),(2765961,'Schladming','AT',47.39289,13.68699,4659,738,'Europe/Vienna'),(2766080,'Scheibbs','AT',48.00474,15.16817,4600,344,'Europe/Vienna'),(2766340,'Sankt Wolfgang im Salzkammergut','AT',47.73932,13.44666,2794,556,'Europe/Vienna'),(2766359,'Sankt Veit an der Glan','AT',46.76806,14.36028,13116,485,'Europe/Vienna'),(2766365,'Sankt Valentin','AT',48.16667,14.51667,9063,269,'Europe/Vienna'),(2766675,'Sankt Jakob','AT',46.54778,14.05722,4481,490,'Europe/Vienna'),(2766683,'Sankt Gilgen','AT',47.76667,13.36667,3753,544,'Europe/Vienna'),(2766692,'Sankt Georgen im Attergau','AT',47.93595,13.48306,4180,537,'Europe/Vienna'),(2766727,'Sankt Florian am Inn','AT',48.44122,13.44263,3121,317,'Europe/Vienna'),(2766757,'Sankt Anton am Arlberg','AT',47.1275,10.26372,2848,1307,'Europe/Vienna'),(2766772,'Sankt Andrae','AT',46.76611,14.82361,10250,434,'Europe/Vienna'),(2766824,'Salzburg','AT',47.79941,13.04399,150269,435,'Europe/Vienna'),(2766922,'Saalfelden am Steinernen Meer','AT',47.42681,12.848,16119,742,'Europe/Vienna'),(2767471,'Ried im Innkreis','AT',48.21123,13.48855,11511,435,'Europe/Vienna'),(2767511,'Reutte','AT',47.48333,10.71667,5851,856,'Europe/Vienna'),(2768232,'Purkersdorf','AT',48.20769,16.17539,8327,250,'Europe/Vienna'),(2768236,'Purgstall','AT',48.05841,15.13478,5247,297,'Europe/Vienna'),(2770651,'Neustift im Stubaital','AT',47.11667,11.31667,4454,970,'Europe/Vienna'),(2771335,'Modling','AT',48.08605,16.28921,20710,222,'Europe/Vienna'),(2771385,'Mittersill','AT',47.26667,12.48333,5680,833,'Europe/Vienna'),(2771533,'Mittelberg','AT',47.3237,10.15463,4627,1207,'Europe/Vienna'),(2771557,'Mistelbach','AT',48.57,16.57667,10820,228,'Europe/Vienna'),(2771619,'Micheldorf in Oberoesterreich','AT',47.87764,14.13357,5902,459,'Europe/Vienna'),(2771725,'Mayrhofen','AT',47.16667,11.86667,3869,641,'Europe/Vienna'),(2771817,'Mattersburg','AT',47.73333,16.4,6448,267,'Europe/Vienna'),(2771828,'Matrei in Osttirol','AT',47,12.53333,5076,946,'Europe/Vienna'),(2771962,'Marchtrenk','AT',48.18333,14.11667,11666,296,'Europe/Vienna'),(2772400,'Linz','AT',48.30639,14.28611,181162,268,'Europe/Vienna'),(2772649,'Leoben','AT',47.3765,15.09144,24809,527,'Europe/Vienna'),(2772653,'Lenzing','AT',47.97326,13.60846,5044,485,'Europe/Vienna'),(2772753,'Leibnitz','AT',46.78161,15.53836,7029,273,'Europe/Vienna'),(2772827,'Lauterach','AT',47.48306,9.73306,9212,412,'Europe/Vienna'),(2772998,'Langenzersdorf','AT',48.3,16.35,7733,163,'Europe/Vienna'),(2773010,'Langenlois','AT',48.46667,15.66667,7081,277,'Europe/Vienna'),(2773070,'Landeck','AT',47.13988,10.56593,7351,789,'Europe/Vienna'),(2773215,'Laakirchen','AT',47.98188,13.82166,9569,439,'Europe/Vienna'),(2773229,'Laa an der Thaya','AT',48.71667,16.38333,6084,179,'Europe/Vienna'),(2773300,'Kufstein','AT',47.58333,12.16667,16115,483,'Europe/Vienna'),(2773304,'Kuchl','AT',47.62647,13.1448,6668,466,'Europe/Vienna'),(2773447,'Krieglach','AT',47.53333,15.55,5236,649,'Europe/Vienna'),(2773538,'Kremsmunster','AT',48.0529,14.12919,6626,344,'Europe/Vienna'),(2773549,'Krems an der Donau','AT',48.40921,15.61415,23932,195,'Europe/Vienna'),(2773653,'Kottingbrunn','AT',47.95096,16.22715,7184,252,'Europe/Vienna'),(2773698,'Korneuburg','AT',48.35,16.33333,11498,164,'Europe/Vienna'),(2773887,'Knittelfeld','AT',47.21667,14.81667,12704,654,'Europe/Vienna'),(2773913,'Klosterneuburg','AT',48.30521,16.32522,24843,192,'Europe/Vienna'),(2774326,'Klagenfurt am Woerthersee','AT',46.62472,14.30528,90610,450,'Europe/Vienna'),(2774347,'Kitzbuhel','AT',47.44637,12.39215,8818,751,'Europe/Vienna'),(2774773,'Kapfenberg','AT',47.44458,15.29331,21819,502,'Europe/Vienna'),(2775020,'Judenburg','AT',47.16667,14.66667,9992,754,'Europe/Vienna'),(2775307,'Imst','AT',47.24504,10.73974,9225,823,'Europe/Vienna'),(2775541,'Hopfgarten im Brixental','AT',47.45,12.16667,5314,726,'Europe/Vienna'),(2775636,'Hollabrunn','AT',48.55,16.08333,10966,257,'Europe/Vienna'),(2775742,'Hohenems','AT',47.36667,9.68306,14072,417,'Europe/Vienna'),(2776358,'Hinterbruehl','AT',48.08611,16.24809,4068,254,'Europe/Vienna'),(2776470,'Herzogenburg','AT',48.28137,15.69431,7866,229,'Europe/Vienna'),(2776497,'Hermagor','AT',46.62722,13.36722,7242,605,'Europe/Vienna'),(2776801,'Hartberg','AT',47.28333,15.96667,6634,396,'Europe/Vienna'),(2776874,'Hard','AT',47.48306,9.68306,11766,396,'Europe/Vienna'),(2776951,'Hallein','AT',47.68333,13.1,18980,447,'Europe/Vienna'),(2776988,'Hainburg an der Donau','AT',48.14627,16.94504,5622,170,'Europe/Vienna'),(2777701,'Gross-Gerungs','AT',48.57422,14.95789,4820,677,'Europe/Vienna'),(2777836,'Gross-Enzersdorf','AT',48.20278,16.55083,8791,157,'Europe/Vienna'),(2777921,'Grodig','AT',47.73333,13.03333,6918,564,'Europe/Vienna'),(2778067,'Graz','AT',47.06667,15.45,222326,363,'Europe/Vienna'),(2778455,'Gloggnitz','AT',47.67487,15.93893,6213,448,'Europe/Vienna'),(2778478,'Gleisdorf','AT',47.10559,15.71011,5245,362,'Europe/Vienna'),(2779380,'Frankenburg','AT',48.06844,13.49065,5162,515,'Europe/Vienna'),(2779450,'Fohnsdorf','AT',47.2,14.68333,8203,757,'Europe/Vienna'),(2779640,'Ferlach','AT',46.52694,14.30194,7661,464,'Europe/Vienna'),(2779669,'Feldkirchen in Karnten','AT',46.72368,14.0958,14440,543,'Europe/Vienna'),(2780048,'Enns','AT',48.21346,14.47612,10816,268,'Europe/Vienna'),(2780190,'Eisenstadt','AT',47.84565,16.52327,12190,182,'Europe/Vienna'),(2780207,'Eisenerz','AT',47.53333,14.88333,5987,854,'Europe/Vienna'),(2780531,'Eberndorf','AT',46.59139,14.64361,6088,486,'Europe/Vienna'),(2781017,'Deutsch-Wagram','AT',48.29972,16.56667,7153,163,'Europe/Vienna'),(2781023,'Deutschlandsberg','AT',46.81528,15.22222,8049,362,'Europe/Vienna'),(2781371,'Bruck an der Mur','AT',47.41667,15.28333,13254,572,'Europe/Vienna'),(2781373,'Bruck an der Leitha','AT',48.01667,16.76667,7339,154,'Europe/Vienna'),(2781503,'Bregenz','AT',47.50311,9.7471,27611,405,'Europe/Vienna'),(2781680,'Bludenz','AT',47.14972,9.81667,13904,562,'Europe/Vienna'),(2781735,'Bischofshofen','AT',47.41667,13.21667,10144,558,'Europe/Vienna'),(2782052,'Bad Ischl','AT',47.71109,13.61893,14267,470,'Europe/Vienna'),(2782053,'Bad Hofgastein','AT',47.17274,13.09871,7002,844,'Europe/Vienna'),(2782054,'Bad Hall','AT',48.03832,14.20773,4935,369,'Europe/Vienna'),(2782055,'Bad Goisern','AT',47.64252,13.61609,7869,498,'Europe/Vienna'),(2782058,'Bad Gastein','AT',47.11547,13.13467,5947,998,'Europe/Vienna'),(2782067,'Baden','AT',48.00543,16.23264,24893,230,'Europe/Vienna'),(2782555,'Amstetten','AT',48.1229,14.87206,22832,277,'Europe/Vienna'),(2782627,'Altmunster','AT',47.90219,13.76415,9651,448,'Europe/Vienna'),(2803560,'Zwickau','DE',50.72724,12.48839,98796,260,'Europe/Berlin'),(2805059,'Zehlendorf Bezirk','DE',52.43333,13.25,58469,46,'Europe/Berlin'),(2805615,'Wuerzburg','DE',49.78778,9.93611,133731,187,'Europe/Berlin'),(2805753,'Wuppertal','DE',51.27027,7.16755,360797,180,'Europe/Berlin'),(2806142,'Worms','DE',49.63278,8.35916,81099,91,'Europe/Berlin'),(2806654,'Wolfsburg','DE',52.42452,10.7815,123064,65,'Europe/Berlin'),(2806914,'Wolfenbuttel','DE',52.16442,10.54095,54740,78,'Europe/Berlin'),(2807363,'Witten','DE',51.44362,7.35258,101247,118,'Europe/Berlin'),(2808473,'Wilmersdorf Bezirk','DE',52.48333,13.31667,94113,39,'Europe/Berlin'),(2808559,'Willich','DE',51.26371,6.54734,51843,40,'Europe/Berlin'),(2808720,'Wilhelmshaven','DE',53.52998,8.11253,84393,2,'Europe/Berlin'),(2809346,'Wiesbaden','DE',50.08258,8.24932,272432,129,'Europe/Berlin'),(2809889,'Wetzlar','DE',50.56109,8.50495,52656,202,'Europe/Berlin'),(2810678,'Wesel','DE',51.6669,6.62037,61685,25,'Europe/Berlin'),(2812482,'Weimar','DE',50.9803,11.32903,64727,233,'Europe/Berlin'),(2813472,'Wedding Bezirk','DE',52.55,13.36667,78290,41,'Europe/Berlin'),(2815330,'Waiblingen','DE',48.83241,9.31641,52945,233,'Europe/Berlin'),(2817220,'Villingen-Schwenningen','DE',48.06226,8.49358,81770,751,'Europe/Berlin'),(2817311,'Viersen','DE',51.25435,6.39441,76153,37,'Europe/Berlin'),(2817724,'Velbert','DE',51.33536,7.04348,87669,238,'Europe/Berlin'),(2820087,'Unna','DE',51.53794,7.68969,66734,97,'Europe/Berlin'),(2820256,'Ulm','DE',48.39841,9.99155,120451,480,'Europe/Berlin'),(2820860,'Tuebingen','DE',48.52266,9.05222,83416,333,'Europe/Berlin'),(2821029,'Troisdorf','DE',50.80901,7.14968,74749,66,'Europe/Berlin'),(2821164,'Trier','DE',49.75565,6.63935,100129,141,'Europe/Berlin'),(2823538,'Tempelhof Bezirk','DE',52.46667,13.4,56669,47,'Europe/Berlin'),(2825297,'Stuttgart','DE',48.78232,9.17702,589793,252,'Europe/Berlin'),(2826287,'Stralsund','DE',54.30911,13.0818,58976,4,'Europe/Berlin'),(2826595,'Stolberg','DE',50.77368,6.22595,58874,234,'Europe/Berlin'),(2829109,'Steglitz Bezirk','DE',52.46667,13.33333,72464,53,'Europe/Berlin'),(2831580,'Solingen','DE',51.17343,7.0845,164359,199,'Europe/Berlin'),(2831948,'Sindelfingen','DE',48.7,9.01667,61311,468,'Europe/Berlin'),(2832495,'Siegen','DE',50.87482,8.02431,107242,250,'Europe/Berlin'),(2834282,'Schwerin','DE',53.62937,11.41316,96641,48,'Europe/Berlin'),(2834498,'Schweinfurt','DE',50.04937,10.22175,54012,220,'Europe/Berlin'),(2835482,'Schwabisch Gmund','DE',48.79947,9.79809,61338,325,'Europe/Berlin'),(2836788,'Schoneberg Bezirk','DE',52.46667,13.35,115976,47,'Europe/Berlin'),(2841648,'Sankt Augustin','DE',50.77538,7.197,56094,63,'Europe/Berlin'),(2842647,'Saarbrucken','DE',49.2354,6.98165,181227,211,'Europe/Berlin'),(2842884,'Russelsheim','DE',49.98955,8.42251,59730,88,'Europe/Berlin'),(2844588,'Rostock','DE',54.0887,12.14049,198293,18,'Europe/Berlin'),(2844988,'Rosenheim','DE',47.85637,12.12247,60167,448,'Europe/Berlin'),(2846032,'Koeln Rodenkirchen','DE',50.87748,6.96928,101421,50,'Europe/Berlin'),(2847645,'Rheine','DE',52.28509,7.44055,76491,40,'Europe/Berlin'),(2847736,'Reutlingen','DE',48.49144,9.20427,112627,374,'Europe/Berlin'),(2848273,'Remscheid','DE',51.17983,7.1925,117118,301,'Europe/Berlin'),(2848756,'Berlin Reinickendorf','DE',52.56667,13.33333,241756,42,'Europe/Berlin'),(2849483,'Regensburg','DE',49.015,12.09556,129151,348,'Europe/Berlin'),(2849647,'Recklinghausen','DE',51.61379,7.19738,122438,74,'Europe/Berlin'),(2850174,'Ratingen','DE',51.29724,6.84929,91606,64,'Europe/Berlin'),(2851746,'Pulheim','DE',50.99965,6.80632,53762,49,'Europe/Berlin'),(2852217,'Prenzlauer Berg Bezirk','DE',52.53333,13.4,148878,48,'Europe/Berlin'),(2852458,'Potsdam','DE',52.39886,13.06566,145292,34,'Europe/Berlin'),(2853292,'Plauen','DE',50.4973,12.13782,66412,350,'Europe/Berlin'),(2853969,'Pforzheim','DE',48.88436,8.69892,119313,266,'Europe/Berlin'),(2855598,'Berlin Pankow','DE',52.56926,13.40186,356019,47,'Europe/Berlin'),(2855745,'Paderborn','DE',51.71905,8.75439,142161,118,'Europe/Berlin'),(2856883,'Osnabruck','DE',52.27264,8.0498,166462,65,'Europe/Berlin'),(2857458,'Oldenburg','DE',53.14118,8.21467,159218,6,'Europe/Berlin'),(2857798,'Offenburg','DE',48.47377,7.94495,59238,165,'Europe/Berlin'),(2857807,'Offenbach','DE',50.1006,8.76647,119192,109,'Europe/Berlin'),(2860410,'Oberhausen','DE',51.47311,6.88074,219176,48,'Europe/Berlin'),(2861650,'Nuremberg','DE',49.44778,11.06833,499237,312,'Europe/Berlin'),(2861934,'Nordhorn','DE',52.43081,7.06833,52803,24,'Europe/Berlin'),(2862026,'Norderstedt','DE',53.6859,9.98041,71439,27,'Europe/Berlin'),(2863840,'Neuwied','DE',50.4336,7.47057,66805,66,'Europe/Berlin'),(2864054,'Neustadt an der Weinstrasse','DE',49.35009,8.13886,53984,135,'Europe/Berlin'),(2864072,'Neue Neustadt','DE',52.15,11.63333,226851,51,'Europe/Berlin'),(2864118,'Neuss','DE',51.19807,6.68504,152457,41,'Europe/Berlin'),(2864475,'Neumunster','DE',54.07477,9.98195,78383,23,'Europe/Berlin'),(2866135,'Neubrandenburg','DE',53.56414,13.27532,68082,15,'Europe/Berlin'),(2867543,'Muenster','DE',51.96236,7.62571,270184,64,'Europe/Berlin'),(2867714,'Muenchen','DE',48.13743,11.57549,1260391,524,'Europe/Berlin'),(2867838,'Muelheim (Ruhr)','DE',51.43333,6.88333,171000,43,'Europe/Berlin'),(2869894,'Monchengladbach','DE',51.18539,6.44172,261742,49,'Europe/Berlin'),(2870221,'Moers','DE',51.45342,6.6326,107816,26,'Europe/Berlin'),(2870310,'Moabit','DE',52.52635,13.33903,70911,40,'Europe/Berlin'),(2871039,'Minden','DE',52.28953,8.91455,82879,47,'Europe/Berlin'),(2871983,'Menden','DE',51.44337,7.77824,58451,144,'Europe/Berlin'),(2872504,'Meerbusch','DE',51.26118,6.6717,54826,35,'Europe/Berlin'),(2873263,'Marl','DE',51.65671,7.09038,91398,64,'Europe/Berlin'),(2873759,'Marburg an der Lahn','DE',50.80904,8.77069,78895,195,'Europe/Berlin'),(2873891,'Mannheim','DE',49.49671,8.47955,307960,93,'Europe/Berlin'),(2874225,'Mainz','DE',49.98419,8.2791,184997,112,'Europe/Berlin'),(2874545,'Magdeburg','DE',52.12773,11.62916,229826,47,'Europe/Berlin'),(2875107,'Lunen','DE',51.61634,7.52872,91009,57,'Europe/Berlin'),(2875115,'Luneburg','DE',53.2509,10.41409,71260,16,'Europe/Berlin'),(2875376,'Ludwigshafen am Rhein','DE',49.48121,8.44641,163196,95,'Europe/Berlin'),(2875392,'Ludwigsburg','DE',48.89731,9.19161,87603,298,'Europe/Berlin'),(2875457,'Ludenscheid','DE',51.21977,7.6273,79386,413,'Europe/Berlin'),(2875601,'Luebeck','DE',53.86893,10.68729,212207,16,'Europe/Berlin'),(2876865,'Lippstadt','DE',51.67369,8.34482,67219,79,'Europe/Berlin'),(2878018,'Lichterfelde','DE',52.4333,13.30762,80149,47,'Europe/Berlin'),(2878234,'Leverkusen','DE',51.0303,6.98432,162738,42,'Europe/Berlin'),(2879139,'Leipzig','DE',51.33962,12.37129,504971,116,'Europe/Berlin'),(2881085,'Langenfeld','DE',51.10821,6.94831,59378,50,'Europe/Berlin'),(2881485,'Landshut','DE',48.53333,12.15,60488,399,'Europe/Berlin'),(2884161,'Bezirk Kreuzberg','DE',52.49973,13.40338,147532,40,'Europe/Berlin'),(2884509,'Krefeld','DE',51.33921,6.58615,237984,33,'Europe/Berlin'),(2885656,'Kopenick Bezirk','DE',52.4455,13.57455,60128,35,'Europe/Berlin'),(2885657,'Berlin Koepenick','DE',52.44254,13.58228,59561,35,'Europe/Berlin'),(2885679,'Konstanz','DE',47.66033,9.17582,81275,402,'Europe/Berlin'),(2886242,'Koeln','DE',50.93333,6.95,963395,58,'Europe/Berlin'),(2886946,'Koblenz','DE',50.35357,7.57884,107319,74,'Europe/Berlin'),(2891122,'Kiel','DE',54.32133,10.13489,232758,7,'Europe/Berlin'),(2891524,'Kerpen','DE',50.86991,6.69691,64226,81,'Europe/Berlin'),(2891621,'Kempten (Allgaeu)','DE',47.72674,10.31389,61399,681,'Europe/Berlin'),(2892518,'Kassel','DE',51.31667,9.5,194501,164,'Europe/Berlin'),(2892794,'Karlsruhe','DE',49.00472,8.38583,283799,115,'Europe/Berlin'),(2894003,'Kaiserslautern','DE',49.443,7.77161,98732,245,'Europe/Berlin'),(2895044,'Jena','DE',50.92878,11.5899,104712,151,'Europe/Berlin'),(2895669,'Iserlohn','DE',51.37547,7.70281,97910,242,'Europe/Berlin'),(2895992,'Ingolstadt','DE',48.76508,11.42372,120658,367,'Europe/Berlin'),(2897216,'Hurth','DE',50.87079,6.86761,54678,91,'Europe/Berlin'),(2904789,'Hildesheim','DE',52.15077,9.95112,103052,92,'Europe/Berlin'),(2904795,'Hilden','DE',51.16818,6.93093,56565,51,'Europe/Berlin'),(2905560,'Herten','DE',51.59638,7.14387,65306,66,'Europe/Berlin'),(2905891,'Herne','DE',51.5388,7.22572,172108,69,'Europe/Berlin'),(2906121,'Herford','DE',52.11457,8.67343,64879,66,'Europe/Berlin'),(2907669,'Heilbronn','DE',49.13995,9.22054,120733,170,'Europe/Berlin'),(2907911,'Heidelberg','DE',49.40768,8.69079,143345,115,'Europe/Berlin'),(2909230,'Hattingen','DE',51.39894,7.18557,56866,94,'Europe/Berlin'),(2910685,'Harburg','DE',53.46057,9.98388,202571,16,'Europe/Berlin'),(2910831,'Hannover','DE',52.37052,9.73322,515140,57,'Europe/Berlin'),(2911007,'Hanau am Main','DE',50.13423,8.91418,88648,104,'Europe/Berlin'),(2911240,'Hamm','DE',51.68033,7.82089,185327,66,'Europe/Berlin'),(2911271,'Hameln','DE',52.10397,9.35623,58666,74,'Europe/Berlin'),(2911285,'Wandsbek','DE',53.56667,10.1,411422,18,'Europe/Berlin'),(2911287,'Marienthal','DE',53.56667,10.08333,287101,16,'Europe/Berlin'),(2911288,'Hamburg-Mitte','DE',53.55,10.01667,233144,8,'Europe/Berlin'),(2911293,'Eimsbuettel','DE',53.56667,9.98333,251907,15,'Europe/Berlin'),(2911296,'Altona','DE',53.55,9.93333,250192,34,'Europe/Berlin'),(2911298,'Hamburg','DE',53.57532,10.01534,1739117,2,'Europe/Berlin'),(2911522,'Halle (Saale)','DE',51.5,12,234107,109,'Europe/Berlin'),(2912621,'Hagen','DE',51.36081,7.47168,198972,137,'Europe/Berlin'),(2913366,'Gutersloh','DE',51.90693,8.37854,96180,75,'Europe/Berlin'),(2913761,'Gummersbach','DE',51.02608,7.56473,53131,252,'Europe/Berlin'),(2917540,'Grevenbroich','DE',51.09102,6.5827,64779,52,'Europe/Berlin'),(2917788,'Greifswald','DE',54.09311,13.38786,52731,1,'Europe/Berlin'),(2918632,'Gottingen','DE',51.53933,9.93406,122149,167,'Europe/Berlin'),(2918987,'Gorlitz','DE',51.15518,14.98853,57751,210,'Europe/Berlin'),(2919054,'Goppingen','DE',48.7028,9.65488,58040,323,'Europe/Berlin'),(2920236,'Gladbeck','DE',51.57626,6.99075,76940,70,'Europe/Berlin'),(2920512,'Giessen','DE',50.58333,8.65,74411,158,'Europe/Berlin'),(2920789,'Gesundbrunnen','DE',52.55035,13.39139,84789,53,'Europe/Berlin'),(2921232,'Gera','DE',50.88029,12.08187,104659,203,'Europe/Berlin'),(2921466,'Gelsenkirchen','DE',51.5075,7.12283,270028,60,'Europe/Berlin'),(2922586,'Garbsen','DE',52.41371,9.5899,63355,46,'Europe/Berlin'),(2923544,'Furth','DE',49.47593,10.98856,112025,302,'Europe/Berlin'),(2923822,'Fulda','DE',50.55162,9.67518,63760,265,'Europe/Berlin'),(2924573,'Friedrichshain Bezirk','DE',52.53333,13.43333,117829,49,'Europe/Berlin'),(2924585,'Friedrichshafen','DE',47.65689,9.47554,58403,394,'Europe/Berlin'),(2925177,'Freiburg','DE',47.9959,7.85222,215966,279,'Europe/Berlin'),(2925533,'Frankfurt am Main','DE',50.11552,8.68417,650000,113,'Europe/Berlin'),(2925535,'Frankfurt (Oder)','DE',52.34714,14.55062,51691,28,'Europe/Berlin'),(2926271,'Flensburg','DE',54.78431,9.43961,85838,33,'Europe/Berlin'),(2928396,'Euskirchen','DE',50.66057,6.78722,54889,159,'Europe/Berlin'),(2928751,'Esslingen','DE',48.73961,9.30473,92390,241,'Europe/Berlin'),(2928810,'Essen','DE',51.45657,7.01228,593085,86,'Europe/Berlin'),(2928963,'Eschweiler','DE',50.81854,6.27184,55778,138,'Europe/Berlin'),(2929567,'Erlangen','DE',49.59561,10.99497,102675,277,'Europe/Berlin'),(2929670,'Erfurt','DE',50.9787,11.03283,203254,194,'Europe/Berlin'),(2930596,'Emden','DE',53.36745,7.20778,51526,2,'Europe/Berlin'),(2934246,'Dusseldorf','DE',51.22172,6.77616,573057,45,'Europe/Berlin'),(2934486,'Duren','DE',50.80434,6.49299,93440,140,'Europe/Berlin'),(2934691,'Duisburg','DE',51.43247,6.76516,504358,35,'Europe/Berlin'),(2935022,'Dresden','DE',51.05089,13.73832,486854,116,'Europe/Berlin'),(2935517,'Dortmund','DE',51.51494,7.466,588462,100,'Europe/Berlin'),(2935530,'Dorsten','DE',51.66166,6.96514,79981,31,'Europe/Berlin'),(2935825,'Dormagen','DE',51.09683,6.83167,63582,43,'Europe/Berlin'),(2936871,'Dinslaken','DE',51.56227,6.7434,70573,30,'Europe/Berlin'),(2937936,'Detmold','DE',51.93855,8.87318,73680,135,'Europe/Berlin'),(2937959,'Dessau','DE',51.83864,12.24555,77315,63,'Europe/Berlin'),(2938323,'Delmenhorst','DE',53.0511,8.63091,75893,6,'Europe/Berlin'),(2938913,'Darmstadt','DE',49.87056,8.64944,140385,145,'Europe/Berlin'),(2939658,'Cuxhaven','DE',53.87176,8.69087,52677,5,'Europe/Berlin'),(2939811,'Cottbus','DE',51.75769,14.32888,84754,72,'Europe/Berlin'),(2940132,'Chemnitz','DE',50.83333,12.91667,247220,300,'Europe/Berlin'),(2940187,'Charlottenburg Bezirk','DE',52.51667,13.28333,119857,46,'Europe/Berlin'),(2940213,'Celle','DE',52.62264,10.08047,71010,45,'Europe/Berlin'),(2940231,'Castrop-Rauxel','DE',51.55657,7.31155,77924,102,'Europe/Berlin'),(2944368,'Bremerhaven','DE',53.55021,8.57674,117446,2,'Europe/Berlin'),(2944388,'Bremen','DE',53.07516,8.80777,546501,18,'Europe/Berlin'),(2945024,'Braunschweig','DE',52.26594,10.52673,244715,70,'Europe/Berlin'),(2945358,'Brandenburg an der Havel','DE',52.41667,12.55,59826,57,'Europe/Berlin'),(2945756,'Bottrop','DE',51.52392,6.9285,119909,50,'Europe/Berlin'),(2946447,'Bonn','DE',50.73438,7.09548,313125,57,'Europe/Berlin'),(2947022,'Bogenhausen','DE',48.15221,11.61585,77542,520,'Europe/Berlin'),(2947416,'Bochum','DE',51.48165,7.21648,385729,98,'Europe/Berlin'),(2947421,'Bocholt','DE',51.83879,6.61531,73943,25,'Europe/Berlin'),(2949186,'Bielefeld','DE',52.03333,8.53333,331906,111,'Europe/Berlin'),(2950159,'Berlin','DE',52.52437,13.41053,3426354,43,'Europe/Berlin'),(2950344,'Bergkamen','DE',51.61633,7.64451,52329,70,'Europe/Berlin'),(2950349,'Bergisch Gladbach','DE',50.9856,7.13298,106184,106,'Europe/Berlin'),(2950438,'Bergheim','DE',50.95572,6.63986,63558,67,'Europe/Berlin'),(2951825,'Bayreuth','DE',49.94806,11.57833,75061,341,'Europe/Berlin'),(2952984,'Bamberg','DE',49.89873,10.90067,70047,244,'Europe/Berlin'),(2953358,'Bad Salzuflen','DE',52.0862,8.74434,54899,82,'Europe/Berlin'),(2953436,'Bad Homburg vor der Hohe','DE',50.22667,8.61963,51859,182,'Europe/Berlin'),(2953504,'Baden-Baden','DE',48.7606,8.23975,54239,200,'Europe/Berlin'),(2954172,'Augsburg','DE',48.36667,10.88333,259196,485,'Europe/Berlin'),(2955272,'Aschaffenburg','DE',49.97704,9.15214,68551,139,'Europe/Berlin'),(2955471,'Arnsberg','DE',51.38333,8.08333,76612,295,'Europe/Berlin'),(2959223,'Ahlen','DE',51.76338,7.8887,55280,82,'Europe/Berlin'),(2959927,'Aalen','DE',48.83777,10.0933,67085,433,'Europe/Berlin'),(2967849,'Vitry-sur-Seine','FR',48.78716,2.40332,81001,32,'Europe/Paris'),(2968254,'Villeurbanne','FR',45.76667,4.88333,131445,173,'Europe/Paris'),(2969679,'Versailles','FR',48.8,2.13333,85416,141,'Europe/Paris'),(2971053,'Valence','FR',44.93333,4.9,63864,128,'Europe/Paris'),(2971549,'Troyes','FR',48.3,4.08333,60785,107,'Europe/Paris'),(2972191,'Tours','FR',47.38333,0.68333,141621,52,'Europe/Paris'),(2972284,'Tourcoing','FR',50.72391,3.16117,91574,49,'Europe/Paris'),(2972315,'Toulouse','FR',43.60426,1.44367,433055,150,'Europe/Paris'),(2972328,'Toulon','FR',43.11667,5.93333,168701,7,'Europe/Paris'),(2973783,'Strasbourg','FR',48.58342,7.74296,274845,151,'Europe/Paris'),(2977921,'Saint-Nazaire','FR',47.28333,-2.2,67054,3,'Europe/Paris'),(2978179,'Saint-Maur-des-Fosses','FR',48.79394,2.49323,75402,38,'Europe/Paris'),(2980291,'Saint-Etienne','FR',45.43333,4.4,176280,615,'Europe/Paris'),(2980916,'Saint-Denis','FR',48.93333,2.36667,96128,34,'Europe/Paris'),(2982235,'Rueil-Malmaison','FR',48.8765,2.18967,76616,64,'Europe/Paris'),(2982652,'Rouen','FR',49.44313,1.09932,112787,21,'Europe/Paris'),(2982681,'Roubaix','FR',50.69421,3.17456,95721,33,'Europe/Paris'),(2983990,'Rennes','FR',48.11198,-1.67429,209375,39,'Europe/Paris'),(2984114,'Reims','FR',49.25,4.03333,196565,84,'Europe/Paris'),(2984701,'Quimper','FR',48,-4.1,63849,36,'Europe/Paris'),(2986495,'Poitiers','FR',46.58333,0.33333,85960,76,'Europe/Paris'),(2987914,'Perpignan','FR',42.69764,2.89541,110706,43,'Europe/Paris'),(2988358,'Pau','FR',43.3,-0.36667,82697,216,'Europe/Paris'),(2988507,'Paris','FR',48.85341,2.3488,2138551,42,'Europe/Paris'),(2989317,'Orleans','FR',47.90289,1.90389,124149,115,'Europe/Paris'),(2990189,'Noisy-le-Grand','FR',48.84979,2.56266,62420,81,'Europe/Paris'),(2990363,'Nimes','FR',43.83333,4.35,148236,54,'Europe/Paris'),(2990440,'Nice','FR',43.70313,7.26608,338620,18,'Europe/Paris'),(2990611,'Neuilly-sur-Seine','FR',48.8846,2.26965,61300,32,'Europe/Paris'),(2990969,'Nantes','FR',47.21725,-1.55336,277269,19,'Europe/Paris'),(2990970,'Nanterre','FR',48.89198,2.20675,86719,50,'Europe/Paris'),(2990999,'Nancy','FR',48.68333,6.2,105334,195,'Europe/Paris'),(2991214,'Mulhouse','FR',47.75,7.33333,111430,240,'Europe/Paris'),(2992090,'Montreuil','FR',48.86415,2.44322,90652,79,'Europe/Paris'),(2992166,'Montpellier','FR',43.61092,3.87723,248252,56,'Europe/Paris'),(2994160,'Metz','FR',49.11911,6.17269,123914,182,'Europe/Paris'),(2994393,'Merignac','FR',44.83248,-0.63381,69791,33,'Europe/Paris'),(2995469,'Marseille','FR',43.29695,5.38107,794811,28,'Europe/Paris'),(2996944,'Lyon','FR',45.74846,4.84671,472317,173,'Europe/Paris'),(2998286,'Limoges','FR',45.83153,1.2578,141176,284,'Europe/Paris'),(2998324,'Lille','FR',50.63297,3.05858,228328,27,'Europe/Paris'),(2998975,'Levallois-Perret','FR',48.89389,2.28864,62178,38,'Europe/Paris'),(3003603,'Le Mans','FR',48,0.2,144515,61,'Europe/Paris'),(3003796,'Le Havre','FR',49.4938,0.10767,185972,12,'Europe/Paris'),(3006414,'La Seyne-sur-Mer','FR',43.09818,5.88472,62330,8,'Europe/Paris'),(3006787,'La Rochelle','FR',46.16667,-1.15,76810,12,'Europe/Paris'),(3012649,'Issy-les-Moulineaux','FR',48.82104,2.27718,61447,70,'Europe/Paris'),(3014728,'Grenoble','FR',45.16667,5.71667,158552,221,'Europe/Paris'),(3020686,'Dunkerque','FR',51.05,2.36667,71287,2,'Europe/Paris'),(3020839,'Drancy','FR',48.92578,2.44533,62488,47,'Europe/Paris'),(3021372,'Dijon','FR',47.31667,5.01667,149782,242,'Europe/Paris'),(3022530,'Creteil','FR',48.78333,2.46667,84833,51,'Europe/Paris'),(3023141,'Courbevoie','FR',48.89672,2.25666,85158,49,'Europe/Paris'),(3024266,'Colombes','FR',48.91882,2.25404,82300,40,'Europe/Paris'),(3024297,'Colmar','FR',48.08333,7.36667,65405,186,'Europe/Paris'),(3024635,'Clermont-Ferrand','FR',45.77966,3.08628,138681,406,'Europe/Paris'),(3027105,'Champigny-sur-Marne','FR',48.81642,2.49366,76726,42,'Europe/Paris'),(3027422,'Chambery','FR',45.56667,5.93333,61640,281,'Europe/Paris'),(3028808,'Cannes','FR',43.55135,7.01275,70011,11,'Europe/Paris'),(3029162,'Calais','FR',50.9581,1.85205,74433,5,'Europe/Paris'),(3029241,'Caen','FR',49.18585,-0.35912,110624,21,'Europe/Paris'),(3030300,'Brest','FR',48.4,-4.48333,144899,59,'Europe/Paris'),(3031005,'Bourges','FR',47.08333,2.4,67987,144,'Europe/Paris'),(3031137,'Boulogne-Billancourt','FR',48.83333,2.25,108782,38,'Europe/Paris'),(3031582,'Bordeaux','FR',44.84044,-0.5805,231844,20,'Europe/Paris'),(3032833,'Beziers','FR',43.34762,3.21899,74081,71,'Europe/Paris'),(3033123,'Besancon','FR',47.24878,6.01815,128426,300,'Europe/Paris'),(3035681,'Avignon','FR',43.94834,4.80892,89769,31,'Europe/Paris'),(3036145,'Aulnay-sous-Bois','FR',48.93814,2.49402,80615,45,'Europe/Paris'),(3036386,'Aubervilliers','FR',48.91667,2.38333,70914,38,'Europe/Paris'),(3036572,'Asnieres-sur-Seine','FR',48.91667,2.28333,86742,35,'Europe/Paris'),(3037044,'Argenteuil','FR',48.95,2.25,101475,36,'Europe/Paris'),(3037456,'Antibes','FR',43.56241,7.12777,76393,45,'Europe/Paris'),(3037656,'Angers','FR',47.46667,-0.55,168279,50,'Europe/Paris'),(3037854,'Amiens','FR',49.9,2.3,143086,28,'Europe/Paris'),(3038354,'Aix-en-Provence','FR',43.5283,5.44973,146821,205,'Europe/Paris'),(3044774,'Szekesfehervar','HU',47.18995,18.41034,101600,117,'Europe/Budapest'),(3046526,'Pecs','HU',46.08333,18.23333,156649,193,'Europe/Budapest'),(3050434,'Kecskemet','HU',46.90618,19.69128,109847,120,'Europe/Budapest'),(3052009,'Gyor','HU',47.68333,17.63512,128265,122,'Europe/Budapest'),(3054643,'Budapest','HU',47.49801,19.03991,1696128,111,'Europe/Budapest'),(3104324,'Zaragoza','ES',41.65606,-0.87734,674317,214,'Europe/Madrid'),(3104342,'Zamora','ES',41.5,-5.75,66293,633,'Europe/Madrid'),(3104499,'Vitoria-Gasteiz','ES',42.85,-2.66667,235661,522,'Europe/Madrid'),(3104748,'Villaverde','ES',40.35,-3.7,126802,597,'Europe/Madrid'),(3105184,'Vilanova i la Geltru','ES',41.22392,1.72511,65890,25,'Europe/Madrid'),(3105935,'Viladecans','ES',41.31405,2.01427,63489,20,'Europe/Madrid'),(3105976,'Vigo','ES',42.23282,-8.72264,297332,86,'Europe/Madrid'),(3106054,'Vicalvaro','ES',40.4,-3.6,66439,651,'Europe/Madrid'),(3106672,'Valladolid','ES',41.65518,-4.72372,317864,702,'Europe/Madrid'),(3106868,'Valdemoro','ES',40.19081,-3.67887,62750,607,'Europe/Madrid'),(3107112,'Vaciamadrid','ES',40.32605,-3.51088,68405,570,'Europe/Madrid'),(3107784,'Torrejon de Ardoz','ES',40.45535,-3.46973,118162,588,'Europe/Madrid'),(3108118,'Tetuan de las Victorias','ES',40.46667,-3.71667,155000,679,'Europe/Madrid'),(3108286,'Terrassa','ES',41.56667,2.01667,210941,302,'Europe/Madrid'),(3108288,'Tarragona','ES',41.11667,1.25,140323,43,'Europe/Madrid'),(3109453,'Barakaldo','ES',43.29564,-2.99729,98460,35,'Europe/Madrid'),(3109642,'Santiago de Compostela','ES',42.88052,-8.54569,95092,257,'Europe/Madrid'),(3109718,'Santander','ES',43.46472,-3.80444,182700,28,'Europe/Madrid'),(3109981,'Santa Coloma de Gramenet','ES',41.45152,2.2081,119717,39,'Europe/Madrid'),(3110040,'San Sebastian de los Reyes','ES',40.54433,-3.61588,75912,644,'Europe/Madrid'),(3110044,'San Sebastian','ES',43.31283,-1.97499,185357,17,'Europe/Madrid'),(3110718,'Sant Cugat del Valles','ES',41.46667,2.08333,79253,131,'Europe/Madrid'),(3110834,'Sant Boi de Llobregat','ES',41.34357,2.03659,82428,45,'Europe/Madrid'),(3110876,'Sant Andreu de Palomar','ES',41.43541,2.18982,142598,34,'Europe/Madrid'),(3111108,'Salamanca','ES',40.96667,-5.65,155619,816,'Europe/Madrid'),(3111199,'Sabadell','ES',41.54329,2.10942,206493,187,'Europe/Madrid'),(3111294,'Rubi','ES',41.49226,2.03305,72987,145,'Europe/Madrid'),(3111933,'Reus','ES',41.15612,1.10687,107118,133,'Europe/Madrid'),(3112737,'Puente de Vallecas','ES',40.39235,-3.6597,244151,636,'Europe/Madrid'),(3112989,'Pozuelo de Alarcon','ES',40.43293,-3.81338,82428,704,'Europe/Madrid'),(3113209,'Pontevedra','ES',42.431,-8.64435,81576,29,'Europe/Madrid'),(3113236,'Ponferrada','ES',42.54664,-6.59619,68736,519,'Europe/Madrid'),(3114256,'Parla','ES',40.23604,-3.76752,115611,648,'Europe/Madrid'),(3114472,'Pamplona','ES',42.81687,-1.64323,198491,455,'Europe/Madrid'),(3114531,'Palencia','ES',42.01667,-4.53333,82651,742,'Europe/Madrid'),(3114711,'Oviedo','ES',43.36029,-5.84476,224005,237,'Europe/Madrid'),(3114965,'Ourense','ES',42.33333,-7.85,107742,297,'Europe/Madrid'),(3116025,'Mostoles','ES',40.32234,-3.86496,206478,667,'Europe/Madrid'),(3116156,'Moratalaz','ES',40.41667,-3.65,104923,671,'Europe/Madrid'),(3117164,'Mataro','ES',41.54211,2.4445,121722,43,'Europe/Madrid'),(3117533,'Manresa','ES',41.72498,1.82656,76558,253,'Europe/Madrid'),(3117667,'Majadahonda','ES',40.47353,-3.87182,68110,743,'Europe/Madrid'),(3117735,'Madrid','ES',40.4165,-3.70256,3255944,665,'Europe/Madrid'),(3117814,'Lugo','ES',43,-7.56667,96678,402,'Europe/Madrid'),(3118150,'Logrono','ES',42.46667,-2.45,152107,389,'Europe/Madrid'),(3118514,'Lleida','ES',41.61667,0.61667,135919,183,'Europe/Madrid'),(3118532,'Leon','ES',42.6,-5.56667,134305,846,'Europe/Madrid'),(3118594,'Leganes','ES',40.32718,-3.7635,186066,672,'Europe/Madrid'),(3118848,'Las Rozas de Madrid','ES',40.49292,-3.87371,86340,718,'Europe/Madrid'),(3119841,'A Coruna','ES',43.37135,-8.396,246056,22,'Europe/Madrid'),(3120304,'Irun','ES',43.33904,-1.78938,60951,23,'Europe/Madrid'),(3120619,'L\'Hospitalet de Llobregat','ES',41.35967,2.10028,257038,18,'Europe/Madrid'),(3120635,'Hortaleza','ES',40.47444,-3.6411,161661,705,'Europe/Madrid'),(3121007,'Getxo','ES',43.35689,-3.01146,80770,43,'Europe/Madrid'),(3121070,'Guadalajara','ES',40.63333,-3.16667,83039,708,'Europe/Madrid'),(3121145,'Granollers','ES',41.60797,2.28773,60658,154,'Europe/Madrid'),(3121245,'Gracia','ES',41.40237,2.15641,120087,76,'Europe/Madrid'),(3121424,'Gijon','ES',43.53573,-5.66152,277554,22,'Europe/Madrid'),(3121437,'Getafe','ES',40.30571,-3.73295,167164,636,'Europe/Madrid'),(3121456,'Girona','ES',41.98311,2.82493,96188,81,'Europe/Madrid'),(3121960,'Fuenlabrada','ES',40.28419,-3.79415,197836,671,'Europe/Madrid'),(3123329,'El Prat de Llobregat','ES',41.32784,2.09472,63418,9,'Europe/Madrid'),(3123493,'Ferrol','ES',43.48321,-8.23689,74273,36,'Europe/Madrid'),(3124408,'Coslada','ES',40.42378,-3.56129,90280,619,'Europe/Madrid'),(3124569,'Cornella de Llobregat','ES',41.35,2.08333,86519,12,'Europe/Madrid'),(3124964,'Ciudad Lineal','ES',40.45349,-3.65434,228171,707,'Europe/Madrid'),(3125239,'Chamartin de la Rosa','ES',40.45,-3.7,140000,707,'Europe/Madrid'),(3125897,'Castelldefels','ES',41.27794,1.97033,62080,14,'Europe/Madrid'),(3127461,'Burgos','ES',42.35,-3.7,178966,900,'Europe/Madrid'),(3128026,'Bilbao','ES',43.26271,-2.92528,354860,20,'Europe/Madrid'),(3128760,'Barcelona','ES',41.38879,2.15899,1621537,47,'Europe/Madrid'),(3129028,'Badalona','ES',41.45004,2.24741,219547,16,'Europe/Madrid'),(3129135,'Aviles','ES',43.55473,-5.92483,84242,26,'Europe/Madrid'),(3130380,'Algorta','ES',43.34927,-3.0094,82624,51,'Europe/Madrid'),(3130564,'Alcorcon','ES',40.34582,-3.82487,167967,729,'Europe/Madrid'),(3130583,'Alcobendas','ES',40.54746,-3.64197,109104,696,'Europe/Madrid'),(3130616,'Alcala de Henares','ES',40.48205,-3.35996,204574,597,'Europe/Madrid'),(3164039,'Viterbo','IT',42.41783,12.10856,59308,349,'Europe/Rome'),(3164376,'Vigevano','IT',45.31166,8.86114,57450,103,'Europe/Rome'),(3164419,'Vicenza','IT',45.55729,11.5409,107223,37,'Europe/Rome'),(3164433,'Viareggio','IT',43.87354,10.2558,61103,2,'Europe/Rome'),(3164527,'Verona','IT',45.43419,10.99779,253208,57,'Europe/Rome'),(3164603,'Venezia','IT',45.43861,12.32667,270816,3,'Europe/Rome'),(3164699,'Varese','IT',45.82908,8.82193,80511,415,'Europe/Rome'),(3165072,'Udine','IT',46.06194,13.24222,95030,111,'Europe/Rome'),(3165185,'Trieste','IT',45.64861,13.78,211184,27,'Europe/Rome'),(3165201,'Treviso','IT',45.66667,12.245,80144,20,'Europe/Rome'),(3165243,'Trento','IT',46.06787,11.12108,104946,204,'Europe/Rome'),(3165322,'Trani','IT',41.27273,16.41537,53139,8,'Europe/Rome'),(3165456,'Torre del Greco','IT',40.78392,14.3708,90607,31,'Europe/Rome'),(3165524,'Turin','IT',45.07049,7.68682,865263,245,'Europe/Rome'),(3165771,'Terni','IT',42.56713,12.64987,105018,131,'Europe/Rome'),(3165926,'Taranto','IT',40.47611,17.22972,202033,17,'Europe/Rome'),(3166548,'Siena','IT',43.32004,11.33283,52625,341,'Europe/Rome'),(3166598,'Sesto San Giovanni','IT',45.53449,9.23401,78850,145,'Europe/Rome'),(3167022,'Savona','IT',44.30905,8.47715,62167,15,'Europe/Rome'),(3167096,'Sassari','IT',40.72722,8.56028,120729,211,'Europe/Rome'),(3167731,'San Severo','IT',41.68974,15.37604,55861,91,'Europe/Rome'),(3168673,'Salerno','IT',40.67797,14.76599,138188,25,'Europe/Rome'),(3169070,'Roma','IT',41.89474,12.4839,2563241,29,'Europe/Rome'),(3169361,'Rimini','IT',44.06333,12.58083,128656,2,'Europe/Rome'),(3169522,'Reggio nell\'Emilia','IT',44.69825,10.63125,141877,69,'Europe/Rome'),(3169561,'Ravenna','IT',44.4175,12.20111,134631,8,'Europe/Rome'),(3169921,'Prato','IT',43.88425,11.09092,172499,65,'Europe/Rome'),(3169984,'Pozzuoli','IT',40.83196,14.11001,78754,6,'Europe/Rome'),(3170027,'Potenza','IT',40.64432,15.80857,69060,726,'Europe/Rome'),(3170092,'Portofino','IT',44.30349,9.20942,529,11,'Europe/Rome'),(3170116,'Portici','IT',40.81563,14.33716,60218,37,'Europe/Rome'),(3170621,'Pistoia','IT',43.92125,10.92361,84274,56,'Europe/Rome'),(3170647,'Pisa','IT',43.71553,10.39659,89694,7,'Europe/Rome'),(3171058,'Piacenza','IT',45.04676,9.69937,95594,60,'Europe/Rome'),(3171168,'Pescara','IT',42.46024,14.21021,116286,4,'Europe/Rome'),(3171173,'Pesaro','IT',43.90357,12.89026,91086,7,'Europe/Rome'),(3171180,'Perugia','IT',43.1122,12.38878,149125,482,'Europe/Rome'),(3171366,'Pavia','IT',45.18446,9.16145,71214,75,'Europe/Rome'),(3171457,'Parma','IT',44.80266,10.32898,163457,67,'Europe/Rome'),(3171728,'Padova','IT',45.41519,11.88181,204870,16,'Europe/Rome'),(3172189,'Novara','IT',45.44056,8.61684,100910,161,'Europe/Rome'),(3172394,'Napoli','IT',40.83333,14.25,988972,28,'Europe/Rome'),(3172629,'Monza','IT',45.58248,9.27485,120204,169,'Europe/Rome'),(3172794,'Montepulciano','IT',43.10174,11.78684,13883,480,'Europe/Rome'),(3173180,'Moncalieri','IT',44.99625,7.69032,53350,221,'Europe/Rome'),(3173287,'Molfetta','IT',41.20023,16.59748,62546,33,'Europe/Rome'),(3173331,'Modena','IT',44.64783,10.92539,175502,46,'Europe/Rome'),(3173435,'Milano','IT',45.46427,9.18951,1306661,127,'Europe/Rome'),(3173529,'Mestre','IT',45.49028,12.2425,176000,5,'Europe/Rome'),(3173721,'Matera','IT',40.66852,16.60158,57785,411,'Europe/Rome'),(3173775,'Massa','IT',44.02204,10.11409,66769,17,'Europe/Rome'),(3174021,'Marano di Napoli','IT',40.89761,14.19053,57448,168,'Europe/Rome'),(3174092,'Manfredonia','IT',41.62594,15.90936,57704,16,'Europe/Rome'),(3174530,'Lucca','IT',43.84357,10.50585,81862,24,'Europe/Rome'),(3174659,'Livorno','IT',43.54264,10.316,156274,12,'Europe/Rome'),(3174741,'Lido di Ostia','IT',41.73212,12.27654,90000,12,'Europe/Rome'),(3174921,'Legnano','IT',45.59597,8.90784,53797,213,'Europe/Rome'),(3174953,'Lecce','IT',40.35703,18.17202,83303,53,'Europe/Rome'),(3175058,'Latina','IT',41.46614,12.9043,107898,27,'Europe/Rome'),(3175081,'La Spezia','IT',44.11054,9.84339,91391,3,'Europe/Rome'),(3175121,'L\'Aquila','IT',42.35055,13.39954,68503,728,'Europe/Rome'),(3175537,'Imola','IT',44.35227,11.71582,64348,51,'Europe/Rome'),(3175678,'Guidonia','IT',42.01667,12.75,75025,188,'Europe/Rome'),(3175786,'Grosseto','IT',42.77142,11.10794,71263,13,'Europe/Rome'),(3176059,'Giugliano in Campania','IT',40.92741,14.19103,97999,103,'Europe/Rome'),(3176219,'Genova','IT',44.40632,8.93386,601951,39,'Europe/Rome'),(3176746,'Forli','IT',44.22361,12.05278,108335,29,'Europe/Rome'),(3176885,'Foggia','IT',41.46093,15.54925,155203,74,'Europe/Rome'),(3176959,'Firenze','IT',43.76667,11.25,371517,62,'Europe/Rome'),(3177090,'Ferrara','IT',44.82678,11.62071,130992,8,'Europe/Rome'),(3177219,'Fano','IT',43.82036,13.01206,57529,18,'Europe/Rome'),(3177300,'Faenza','IT',44.2857,11.88334,53641,43,'Europe/Rome'),(3177363,'Ercolano','IT',40.80631,14.36093,56738,93,'Europe/Rome'),(3177838,'Cremona','IT',45.13617,10.02797,70887,54,'Europe/Rome'),(3178229,'Como','IT',45.80998,9.08744,78680,211,'Europe/Rome'),(3178671,'Cinisello Balsamo','IT',45.55707,9.22185,72050,154,'Europe/Rome'),(3178957,'Cesena','IT',44.1391,12.24315,90948,45,'Europe/Rome'),(3179075,'Cerignola','IT',41.26403,15.90046,57366,124,'Europe/Rome'),(3179661,'Castellammare di Stabia','IT',40.71551,14.48914,66929,5,'Europe/Rome'),(3179806,'Casoria','IT',40.90664,14.29587,81888,71,'Europe/Rome'),(3179866,'Caserta','IT',41.08322,14.33493,75208,81,'Europe/Rome'),(3180423,'Carrara','IT',44.06294,10.06069,65034,42,'Europe/Rome'),(3180445,'Carpi','IT',44.78237,10.8777,61476,28,'Europe/Rome'),(3181355,'Busto Arsizio','IT',45.61128,8.84914,75916,229,'Europe/Rome'),(3181402,'Burano','IT',45.48548,12.41696,4000,3,'Europe/Rome'),(3181528,'Brindisi','IT',40.62773,17.93682,89081,18,'Europe/Rome'),(3181554,'Brescia','IT',45.52478,10.22727,187567,132,'Europe/Rome'),(3181913,'Bolzano','IT',46.49272,11.33358,94989,255,'Europe/Rome'),(3181928,'Bologna','IT',44.49381,11.33875,371217,71,'Europe/Rome'),(3181995,'Bitonto','IT',41.11083,16.68938,56929,120,'Europe/Rome'),(3182164,'Bergamo','IT',45.69798,9.66895,113143,262,'Europe/Rome'),(3182179,'Benevento','IT',41.12952,14.78614,61791,164,'Europe/Rome'),(3182340,'Barletta','IT',41.31183,16.29077,92094,17,'Europe/Rome'),(3182351,'Bari','IT',41.11773,16.85118,316532,10,'Europe/Rome'),(3182640,'Aversa','IT',40.97321,14.20493,53369,48,'Europe/Rome'),(3182650,'Avellino','IT',40.91442,14.78874,52703,357,'Europe/Rome'),(3182714,'Asti','IT',44.89795,8.20684,71276,123,'Europe/Rome'),(3182884,'Arezzo','IT',43.46139,11.87691,91589,264,'Europe/Rome'),(3182957,'Aprilia','IT',41.58951,12.65009,56028,74,'Europe/Rome'),(3183072,'Andria','IT',41.23063,16.29087,95653,155,'Europe/Rome'),(3183089,'Ancona','IT',43.59816,13.51008,100507,29,'Europe/Rome'),(3183178,'Altamura','IT',40.82923,16.55368,64167,470,'Europe/Rome'),(3183299,'Alessandria','IT',44.91245,8.61894,85438,101,'Europe/Rome'),(3183455,'Afragola','IT',40.92601,14.31083,62319,41,'Europe/Rome'),(3196359,'Ljubljana','SI',46.05108,14.50513,255115,295,'Europe/Ljubljana'),(3197753,'Koper','SI',45.54694,13.72944,23273,15,'Europe/Ljubljana'),(3198365,'Kamnik','SI',46.22587,14.61207,12584,385,'Europe/Ljubljana'),(3198647,'Jesenice','SI',46.43056,14.06694,12511,560,'Europe/Ljubljana'),(3199171,'Idrija','SI',46.00278,14.03056,5784,341,'Europe/Ljubljana'),(3199523,'Grosuplje','SI',45.95556,14.65889,6256,344,'Europe/Ljubljana'),(3201730,'Domzale','SI',46.13774,14.59371,11647,301,'Europe/Ljubljana'),(3203925,'Bled','SI',46.36917,14.11361,5205,505,'Europe/Ljubljana'),(3232858,'Marzahn Bezirk','DE',52.55,13.55,103768,54,'Europe/Berlin'),(3232859,'Hellersdorf Bezirk','DE',52.51667,13.56667,74847,53,'Europe/Berlin'),(3247449,'Aachen','DE',50.77664,6.08342,265208,178,'Europe/Berlin'),(3345439,'Telford','GB',52.67659,-2.44926,138241,163,'Europe/London'),(3412888,'Stykkisholmur','IS',65.07573,-22.72967,1059,-9999,'Atlantic/Reykjavik'),(3571824,'Nassau','BS',25.05823,-77.34306,227940,5,'America/Nassau'),(3930946,'Querobamba','PE',-14.01333,-73.83972,0,3512,'America/Lima'),(3931276,'Puno','PE',-15.83333,-70.03333,116552,4017,'America/Lima'),(4049979,'Birmingham','US',33.52066,-86.80249,212237,187,'America/Chicago'),(4059102,'Dothan','US',31.22323,-85.39049,65496,102,'America/Chicago'),(4067994,'Hoover','US',33.40539,-86.81138,81619,185,'America/Chicago'),(4068590,'Huntsville','US',34.73037,-86.5861,180105,200,'America/Chicago'),(4076598,'Mobile','US',30.69436,-88.04305,195111,12,'America/Chicago'),(4076784,'Montgomery','US',32.36681,-86.29997,205764,76,'America/Chicago'),(4094455,'Tuscaloosa','US',33.20984,-87.56917,90468,69,'America/Chicago'),(4110486,'Fayetteville','US',36.06258,-94.15743,73580,436,'America/Chicago'),(4111410,'Fort Smith','US',35.38592,-94.39855,86209,135,'America/Chicago'),(4116834,'Jonesboro','US',35.8423,-90.70428,67263,96,'America/Chicago'),(4119403,'Little Rock','US',34.74648,-92.28959,193524,105,'America/Chicago'),(4124112,'North Little Rock','US',34.76954,-92.26709,62304,83,'America/Chicago'),(4132093,'Springdale','US',36.18674,-94.12881,69797,406,'America/Chicago'),(4140963,'Washington, D. C.','US',38.89511,-77.03637,601723,6,'America/New_York'),(4145381,'Wilmington','US',39.74595,-75.54659,70851,37,'America/New_York'),(4148411,'Boca Raton','US',26.35869,-80.0831,84392,11,'America/New_York'),(4148677,'Boynton Beach','US',26.52535,-80.06643,68217,11,'America/New_York'),(4148757,'Brandon','US',27.9378,-82.28592,103483,20,'America/New_York'),(4149962,'Cape Coral','US',26.56285,-81.94953,154305,6,'America/New_York'),(4150066,'Carol City','US',25.94065,-80.2456,63031,9,'America/New_York'),(4151316,'Clearwater','US',27.96585,-82.8001,107685,15,'America/New_York'),(4151909,'Coral Springs','US',26.27119,-80.2706,121096,4,'America/New_York'),(4152820,'Davie','US',26.06287,-80.2331,91992,11,'America/New_York'),(4152872,'Daytona Beach','US',29.21081,-81.02283,61005,6,'America/New_York'),(4153071,'Deerfield Beach','US',26.31841,-80.09977,75018,9,'America/New_York'),(4153132,'Delray Beach','US',26.46146,-80.07282,60522,11,'America/New_York'),(4153146,'Deltona','US',28.90054,-81.26367,85182,13,'America/New_York'),(4155966,'Fort Lauderdale','US',26.12231,-80.14338,165521,20,'America/New_York'),(4155995,'Fort Myers','US',26.62168,-81.84059,62298,9,'America/New_York'),(4156404,'Gainesville','US',29.65163,-82.32483,124354,37,'America/New_York'),(4158476,'Hialeah','US',25.8576,-80.27811,224669,8,'America/New_York'),(4158928,'Hollywood','US',26.0112,-80.14949,140768,10,'America/New_York'),(4159050,'Homestead','US',25.46872,-80.47756,60512,6,'America/New_York'),(4160021,'Jacksonville','US',30.33218,-81.65565,821784,12,'America/New_York'),(4160711,'Kendall','US',25.67927,-80.31727,75371,12,'America/New_York'),(4161438,'Lakeland','US',28.03947,-81.9498,97422,63,'America/New_York'),(4161580,'Largo','US',27.90947,-82.78732,77648,16,'America/New_York'),(4161625,'Lauderhill','US',26.14036,-80.21338,66887,7,'America/New_York'),(4161785,'Lehigh Acres','US',26.62535,-81.6248,86784,13,'America/New_York'),(4163971,'Melbourne','US',28.08363,-80.60811,76068,10,'America/New_York'),(4164138,'Miami','US',25.77427,-80.19366,399457,25,'America/New_York'),(4164143,'Miami Beach','US',25.79065,-80.13005,87779,10,'America/New_York'),(4164167,'Miami Gardens','US',25.94204,-80.2456,107167,9,'America/New_York'),(4164601,'Miramar','US',25.98731,-80.23227,122041,8,'America/New_York'),(4165565,'Naples','US',26.14204,-81.79481,19537,7,'America/New_York'),(4167147,'Orlando','US',28.53834,-81.37924,238300,54,'America/New_York'),(4167499,'Palm Bay','US',28.03446,-80.58866,103190,10,'America/New_York'),(4167538,'Palm Coast','US',29.58497,-81.20784,75180,7,'America/New_York'),(4168139,'Pembroke Pines','US',26.00315,-80.22394,154750,10,'America/New_York'),(4168459,'Pine Hills','US',28.55778,-81.4534,60076,41,'America/New_York'),(4168782,'Plantation','US',26.13421,-80.23184,84955,8,'America/New_York'),(4169014,'Pompano Beach','US',26.23786,-80.12477,99845,11,'America/New_York'),(4169171,'Port Saint Lucie','US',27.29393,-80.35033,164603,8,'America/New_York'),(4170156,'Riverview','US',27.86614,-82.32648,71050,9,'America/New_York'),(4171563,'Saint Petersburg','US',27.77086,-82.67927,244769,16,'America/New_York'),(4173838,'Spring Hill','US',28.47688,-82.52546,98621,20,'America/New_York'),(4174402,'Sunrise','US',26.15767,-80.28611,84439,5,'America/New_York'),(4174715,'Tallahassee','US',30.43826,-84.28073,181376,71,'America/New_York'),(4174738,'Tamarac','US',26.21286,-80.24977,60427,8,'America/New_York'),(4174757,'Tampa','US',27.94752,-82.45843,335709,41,'America/New_York'),(4175538,'Town \'n\' Country','US',28.01057,-82.57732,78442,5,'America/New_York'),(4177887,'West Palm Beach','US',26.71534,-80.05337,99919,21,'America/New_York'),(4178003,'Weston','US',26.10037,-80.39977,65333,7,'America/New_York'),(4179320,'Albany','US',31.57851,-84.15574,77434,66,'America/New_York'),(4180386,'Athens','US',33.96095,-83.37794,116714,232,'America/New_York'),(4180439,'Atlanta','US',33.749,-84.38798,420003,336,'America/New_York'),(4188985,'Columbus','US',32.46098,-84.98771,189885,75,'America/New_York'),(4207400,'Macon','US',32.84069,-83.6324,91351,118,'America/New_York'),(4219934,'Roswell','US',34.02316,-84.36159,88346,333,'America/New_York'),(4221333,'Sandy Springs','US',33.92427,-84.37854,93853,333,'America/New_York'),(4221552,'Savannah','US',32.08354,-81.09983,136286,9,'America/New_York'),(4229476,'Warner Robins','US',32.62098,-83.5999,66588,94,'America/New_York'),(4236895,'Decatur','US',39.84031,-88.9548,76122,206,'America/Chicago'),(4250542,'Springfield','US',39.80172,-89.64371,116250,184,'America/Chicago'),(4254679,'Bloomington','US',39.16532,-86.52639,80405,243,'America/Indiana/Indianapolis'),(4255466,'Carmel','US',39.97837,-86.11804,79191,262,'America/Indiana/Indianapolis'),(4257227,'Evansville','US',37.97476,-87.55585,117429,118,'America/Chicago'),(4257494,'Fishers','US',39.95559,-86.01387,76794,250,'America/Indiana/Indianapolis'),(4259418,'Indianapolis','US',39.76838,-86.15804,829718,248,'America/Indiana/Indianapolis'),(4265737,'Terre Haute','US',39.4667,-87.41391,60785,152,'America/Indiana/Indianapolis'),(4273837,'Kansas City','US',39.11417,-94.62746,145786,272,'America/Chicago'),(4274277,'Lawrence','US',38.97167,-95.23525,87643,267,'America/Chicago'),(4276614,'Olathe','US',38.8814,-94.81913,125872,324,'America/Chicago'),(4276873,'Overland Park','US',38.98223,-94.67079,173372,335,'America/Chicago'),(4279247,'Shawnee','US',39.04167,-94.72024,62209,328,'America/Chicago'),(4280539,'Topeka','US',39.04833,-95.67804,127473,306,'America/Chicago'),(4281730,'Wichita','US',37.69224,-97.33754,382368,402,'America/Chicago'),(4295940,'Ironville','US',38.45647,-82.69238,288649,221,'America/New_York'),(4297983,'Lexington','US',37.98869,-84.47772,225366,298,'America/New_York'),(4297999,'Lexington-Fayette','US',38.0498,-84.45855,295803,304,'America/New_York'),(4299276,'Louisville','US',38.25424,-85.75941,243639,143,'America/Kentucky/Louisville'),(4300488,'Meads','US',38.41258,-82.70905,288649,188,'America/New_York'),(4315588,'Baton Rouge','US',30.45075,-91.15455,229493,20,'America/Chicago'),(4317639,'Bossier City','US',32.51599,-93.73212,61315,53,'America/Chicago'),(4329753,'Kenner','US',29.99409,-90.24174,66702,5,'America/Chicago'),(4330145,'Lafayette','US',30.22409,-92.01984,120623,15,'America/Chicago'),(4330236,'Lake Charles','US',30.21309,-93.2044,71993,6,'America/Chicago'),(4333177,'Metairie','US',29.98409,-90.15285,138481,9,'America/Chicago'),(4333190,'Metairie Terrace','US',29.97854,-90.16396,142489,5,'America/Chicago'),(4335045,'New Orleans','US',29.95465,-90.07507,343829,18,'America/Chicago'),(4341513,'Shreveport','US',32.52515,-93.75018,199311,50,'America/Chicago'),(4347778,'Baltimore','US',39.29038,-76.61219,620961,35,'America/New_York'),(4348599,'Bethesda','US',38.98067,-77.10026,60858,97,'America/New_York'),(4352053,'Columbia','US',39.24038,-76.83942,99615,122,'America/New_York'),(4353765,'Dundalk','US',39.25066,-76.52052,63597,10,'America/New_York'),(4354265,'Ellicott City','US',39.26733,-76.79831,65834,55,'America/New_York'),(4355585,'Frederick','US',39.41427,-77.41054,65239,90,'America/New_York'),(4356050,'Germantown','US',39.17316,-77.27165,86395,137,'America/New_York'),(4356188,'Glen Burnie','US',39.16261,-76.62469,67639,19,'America/New_York'),(4367175,'Rockville','US',39.084,-77.15276,61209,140,'America/New_York'),(4369596,'Silver Spring','US',38.99067,-77.02609,71452,106,'America/New_York'),(4372599,'Waldorf','US',38.62456,-76.93914,67752,65,'America/New_York'),(4381982,'Columbia','US',38.95171,-92.33407,108500,219,'America/Chicago'),(4385018,'East Independence','US',39.09556,-94.35523,110675,262,'America/Chicago'),(4391812,'Independence','US',39.09112,-94.41551,116830,319,'America/Chicago'),(4393217,'Kansas City','US',39.09973,-94.57857,459787,290,'America/Chicago'),(4394870,'Lees Summit','US',38.91084,-94.38217,91364,323,'America/Chicago'),(4401242,'O\'Fallon','US',38.81061,-90.69985,79329,164,'America/Chicago'),(4406831,'Saint Charles','US',38.78394,-90.48123,65794,150,'America/Chicago'),(4407010,'Saint Joseph','US',39.76861,-94.84663,76780,279,'America/Chicago'),(4407066,'Saint Louis','US',38.62727,-90.19789,319294,149,'America/Chicago'),(4409896,'Springfield','US',37.21533,-93.29824,159498,399,'America/Chicago'),(4428667,'Gulfport','US',30.36742,-89.09282,67793,12,'America/Chicago'),(4431410,'Jackson','US',32.29876,-90.18481,173514,100,'America/Chicago'),(4450687,'West Gulfport','US',30.40409,-89.0942,71329,10,'America/Chicago'),(4453066,'Asheville','US',35.60095,-82.55402,83393,650,'America/New_York'),(4459467,'Cary','US',35.79154,-78.78112,135234,152,'America/New_York'),(4460243,'Charlotte','US',35.22709,-80.84313,731424,272,'America/New_York'),(4461574,'Concord','US',35.40875,-80.57951,79066,217,'America/New_York'),(4464368,'Durham','US',35.99403,-78.89862,228330,121,'America/New_York'),(4466033,'Fayetteville','US',35.05266,-78.87836,200564,33,'America/New_York'),(4467732,'Gastonia','US',35.26208,-81.1873,71741,249,'America/New_York'),(4469146,'Greensboro','US',36.07264,-79.79198,269666,260,'America/New_York'),(4469160,'Greenville','US',35.61266,-77.36635,84554,19,'America/New_York'),(4471025,'High Point','US',35.95569,-80.00532,104371,289,'America/New_York'),(4473083,'Jacksonville','US',34.75405,-77.43024,70145,7,'America/New_York'),(4487042,'Raleigh','US',35.7721,-78.63861,403892,99,'America/New_York'),(4498303,'West Raleigh','US',35.78682,-78.66389,338759,124,'America/New_York'),(4499379,'Wilmington','US',34.22573,-77.94471,106476,14,'America/New_York'),(4499612,'Winston-Salem','US',36.09986,-80.24422,229617,283,'America/New_York'),(4501018,'Camden','US',39.92595,-75.11962,77344,4,'America/New_York'),(4501198,'Cherry Hill','US',39.93484,-75.03073,70475,19,'America/New_York'),(4504476,'Toms River','US',39.95373,-74.19792,88791,8,'America/New_York'),(4504621,'Vineland','US',39.48623,-75.02573,60724,34,'America/New_York'),(4508722,'Cincinnati','US',39.162,-84.45689,296943,192,'America/New_York'),(4509177,'Columbus','US',39.96118,-82.99879,787033,242,'America/New_York'),(4509884,'Dayton','US',39.75895,-84.19161,141527,237,'America/New_York'),(4513575,'Hamilton','US',39.3995,-84.56134,62477,186,'America/New_York'),(4525353,'Springfield','US',39.92423,-83.80882,60608,305,'America/New_York'),(4531405,'Broken Arrow','US',36.0526,-95.79082,98850,234,'America/Chicago'),(4535740,'Edmond','US',35.65283,-97.4781,81405,372,'America/Chicago'),(4540737,'Lawton','US',34.60869,-98.39033,96867,342,'America/Chicago'),(4543762,'Norman','US',35.22257,-97.43948,110925,361,'America/Chicago'),(4544349,'Oklahoma City','US',35.46756,-97.51643,579999,395,'America/Chicago'),(4553433,'Tulsa','US',36.15398,-95.99278,391906,226,'America/Chicago'),(4560349,'Philadelphia','US',39.95234,-75.16379,1526006,40,'America/New_York'),(4574324,'Charleston','US',32.77657,-79.93092,120083,13,'America/New_York'),(4575352,'Columbia','US',34.00071,-81.03481,129272,97,'America/New_York'),(4588165,'Mount Pleasant','US',32.79407,-79.86259,67843,9,'America/New_York'),(4589387,'North Charleston','US',32.88856,-80.00751,97471,6,'America/New_York'),(4593142,'Rock Hill','US',34.92487,-81.02508,66154,209,'America/New_York'),(4612862,'Chattanooga','US',35.04563,-85.30968,167674,208,'America/New_York'),(4613868,'Clarksville','US',36.52977,-87.35945,132929,145,'America/Chicago'),(4619947,'East Chattanooga','US',35.06535,-85.24912,154024,208,'America/New_York'),(4623560,'Franklin','US',35.92506,-86.86889,62487,201,'America/Chicago'),(4632595,'Jackson','US',35.61452,-88.81395,65211,126,'America/Chicago'),(4633419,'Johnson City','US',36.31344,-82.35347,63152,500,'America/New_York'),(4634946,'Knoxville','US',35.96064,-83.92074,178874,277,'America/New_York'),(4641239,'Memphis','US',35.14953,-90.04898,646889,84,'America/Chicago'),(4644312,'Murfreesboro','US',35.84562,-86.39027,108755,191,'America/Chicago'),(4644585,'Nashville','US',36.16589,-86.78444,530852,171,'America/Chicago'),(4645421,'New South Memphis','US',35.08676,-90.05676,641608,79,'America/Chicago'),(4669635,'Abilene','US',32.44874,-99.73314,117063,525,'America/Chicago'),(4670300,'Allen','US',33.10317,-96.67055,84246,205,'America/Chicago'),(4671240,'Arlington','US',32.73569,-97.10807,365438,190,'America/Chicago'),(4671524,'Atascocita','US',29.99883,-95.1766,65844,25,'America/Chicago'),(4671654,'Austin','US',30.26715,-97.74306,790390,165,'America/Chicago'),(4672731,'Baytown','US',29.7355,-94.97743,71802,9,'America/Chicago'),(4672989,'Beaumont','US',30.08605,-94.10185,118296,12,'America/Chicago'),(4676740,'Brownsville','US',25.90175,-97.49748,175023,17,'America/Chicago'),(4677008,'Bryan','US',30.67436,-96.36996,76201,116,'America/Chicago'),(4679195,'Carrollton','US',32.95373,-96.89028,119097,163,'America/Chicago'),(4682464,'College Station','US',30.62798,-96.33441,93857,107,'America/Chicago'),(4683416,'Corpus Christi','US',27.80058,-97.39638,305215,8,'America/Chicago'),(4684888,'Dallas','US',32.78306,-96.80667,1197816,139,'America/Chicago'),(4685907,'Denton','US',33.21484,-97.13307,113383,206,'America/Chicago'),(4688275,'Edinburg','US',26.30174,-98.16334,77100,35,'America/Chicago'),(4691585,'Flower Mound','US',33.01457,-97.09696,64669,186,'America/Chicago'),(4691930,'Fort Worth','US',32.72541,-97.32085,741206,203,'America/Chicago'),(4692559,'Frisco','US',33.15067,-96.82361,116989,216,'America/Chicago'),(4693003,'Garland','US',32.91262,-96.63888,226876,174,'America/Chicago'),(4694482,'Grand Prairie','US',32.74596,-96.99778,175396,162,'America/Chicago'),(4696233,'Harlingen','US',26.19063,-97.6961,64849,17,'America/Chicago'),(4699066,'Houston','US',29.76328,-95.36327,2099451,30,'America/Chicago'),(4700168,'Irving','US',32.81402,-96.94889,216290,151,'America/Chicago'),(4703223,'Killeen','US',31.11712,-97.7278,127921,254,'America/Chicago'),(4705349,'Laredo','US',27.50641,-99.50754,236091,132,'America/Chicago'),(4705692,'League City','US',29.50745,-95.09493,83560,9,'America/Chicago'),(4706057,'Lewisville','US',33.04623,-96.99417,95290,161,'America/Chicago'),(4707814,'Longview','US',32.5007,-94.74049,80455,119,'America/Chicago'),(4709796,'McAllen','US',26.20341,-98.23001,129877,42,'America/Chicago'),(4710178,'McKinney','US',33.19762,-96.61527,131117,197,'America/Chicago'),(4710826,'Mesquite','US',32.7668,-96.59916,139824,155,'America/Chicago'),(4711725,'Mission','US',26.21591,-98.32529,77058,47,'America/Chicago'),(4711801,'Missouri City','US',29.61857,-95.53772,67358,26,'America/Chicago'),(4715292,'North Richland Hills','US',32.8343,-97.2289,63343,188,'America/Chicago'),(4717782,'Pasadena','US',29.69106,-95.2091,149043,12,'America/Chicago'),(4718097,'Pearland','US',29.56357,-95.28605,91252,17,'America/Chicago'),(4718721,'Pharr','US',26.1948,-98.18362,70400,38,'America/Chicago'),(4719457,'Plano','US',33.01984,-96.69889,259841,207,'America/Chicago'),(4722625,'Richardson','US',32.94818,-96.72972,99223,195,'America/Chicago'),(4724129,'Round Rock','US',30.50826,-97.6789,99887,226,'America/Chicago'),(4726206,'San Antonio','US',29.42412,-98.49363,1327407,202,'America/Chicago'),(4734825,'Sugar Land','US',29.61968,-95.63495,78817,32,'America/Chicago'),(4735966,'Temple','US',31.09823,-97.34278,66102,223,'America/Chicago'),(4736476,'The Woodlands','US',30.15799,-95.48938,93847,46,'America/Chicago'),(4738214,'Tyler','US',32.35126,-95.30106,96900,174,'America/Chicago'),(4739157,'Victoria','US',28.80527,-97.0036,62592,35,'America/Chicago'),(4739526,'Waco','US',31.54933,-97.14667,124805,147,'America/Chicago'),(4741752,'Wichita Falls','US',33.91371,-98.49339,104553,296,'America/Chicago'),(4744091,'Alexandria','US',38.80484,-77.04692,139966,15,'America/New_York'),(4744709,'Arlington','US',38.88101,-77.10428,207627,83,'America/New_York'),(4751839,'Centreville','US',38.84039,-77.42888,71135,110,'America/New_York'),(4752186,'Chesapeake','US',36.81904,-76.27494,222209,9,'America/New_York'),(4755158,'Dale City','US',38.63706,-77.31109,65969,71,'America/New_York'),(4756955,'East Hampton','US',37.03737,-76.33161,147993,7,'America/New_York'),(4762894,'Hampton','US',37.02987,-76.34522,137436,7,'America/New_York'),(4771075,'Lynchburg','US',37.41375,-79.14225,75568,199,'America/New_York'),(4776024,'Newport News','US',36.97876,-76.428,180719,7,'America/New_York'),(4776222,'Norfolk','US',36.84681,-76.28522,242803,15,'America/New_York'),(4779999,'Portsmouth','US',36.83543,-76.29827,95535,6,'America/New_York'),(4780011,'Portsmouth Heights','US',36.82098,-76.36883,99049,7,'America/New_York'),(4781708,'Richmond','US',37.55376,-77.46026,204214,68,'America/New_York'),(4782167,'Roanoke','US',37.27097,-79.94143,97032,296,'America/New_York'),(4786714,'South Suffolk','US',36.71709,-76.59023,80690,22,'America/New_York'),(4788158,'Suffolk','US',36.72821,-76.58356,84585,23,'America/New_York'),(4791259,'Virginia Beach','US',36.85293,-75.97798,437994,4,'America/New_York'),(4792867,'West Lynchburg','US',37.4032,-79.17808,65517,225,'America/New_York'),(4832353,'Danbury','US',41.39482,-73.45401,80893,126,'America/New_York'),(4833505,'East Norwalk','US',41.10565,-73.39845,84530,21,'America/New_York'),(4835797,'Hartford','US',41.76371,-72.68509,124775,27,'America/New_York'),(4838524,'Meriden','US',41.53815,-72.80704,60868,52,'America/New_York'),(4839292,'New Britain','US',41.66121,-72.77954,73206,55,'America/New_York'),(4839366,'New Haven','US',41.30815,-72.92816,129779,20,'America/New_York'),(4839745,'North Stamford','US',41.13815,-73.54346,121230,76,'America/New_York'),(4839822,'Norwalk','US',41.1176,-73.4079,85603,18,'America/New_York'),(4843564,'Stamford','US',41.05343,-73.53873,122643,16,'America/New_York'),(4845193,'Waterbury','US',41.55815,-73.0515,110366,84,'America/New_York'),(4845411,'West Hartford','US',41.76204,-72.74204,63268,41,'America/New_York'),(4850751,'Cedar Rapids','US',42.00833,-91.64407,126326,251,'America/Chicago'),(4852832,'Council Bluffs','US',41.26194,-95.86083,62230,299,'America/Chicago'),(4853423,'Davenport','US',41.52364,-90.57764,99685,182,'America/Chicago'),(4853828,'Des Moines','US',41.60054,-93.60911,203433,264,'America/Chicago'),(4862034,'Iowa City','US',41.66113,-91.53017,67862,204,'America/Chicago'),(4876523,'Sioux City','US',42.49999,-96.40031,82684,364,'America/Chicago'),(4880889,'Waterloo','US',42.49276,-92.34296,68406,263,'America/Chicago'),(4883555,'Arlington Heights','US',42.08836,-87.98063,75101,219,'America/Chicago'),(4883817,'Aurora','US',41.76058,-88.32007,197899,210,'America/Chicago'),(4885164,'Bloomington','US',40.4842,-88.99369,76610,246,'America/Chicago'),(4885265,'Bolingbrook','US',41.69864,-88.0684,73366,216,'America/Chicago'),(4887158,'Champaign','US',40.11642,-88.24338,81055,228,'America/Chicago'),(4887398,'Chicago','US',41.85003,-87.65005,2695598,180,'America/Chicago'),(4888015,'Cicero','US',41.84559,-87.75394,83891,186,'America/Chicago'),(4890864,'Elgin','US',42.03725,-88.28119,108188,229,'America/Chicago'),(4891382,'Evanston','US',42.04114,-87.69006,74486,189,'America/Chicago'),(4898015,'Joliet','US',41.52503,-88.08173,147433,168,'America/Chicago'),(4903279,'Naperville','US',41.78586,-88.14729,141853,217,'America/Chicago'),(4903976,'North Peoria','US',40.71754,-89.58426,113004,194,'America/Chicago'),(4905211,'Palatine','US',42.1103,-88.03424,68557,227,'America/Chicago'),(4905687,'Peoria','US',40.69365,-89.58899,115007,165,'America/Chicago'),(4907959,'Rockford','US',42.27113,-89.094,152871,224,'America/Chicago'),(4910713,'Schaumburg','US',42.03336,-88.08341,74227,246,'America/Chicago'),(4911600,'Skokie','US',42.03336,-87.73339,64784,187,'America/Chicago'),(4915734,'Waukegan','US',42.36363,-87.84479,89078,199,'America/Chicago'),(4920423,'Fort Wayne','US',41.1306,-85.12886,253691,250,'America/Indiana/Indianapolis'),(4920607,'Gary','US',41.59337,-87.34643,80294,185,'America/Chicago'),(4921100,'Hammond','US',41.58337,-87.50004,80830,188,'America/Chicago'),(4922462,'Lafayette','US',40.4167,-86.87529,67140,215,'America/Indiana/Indianapolis'),(4924006,'Muncie','US',40.19338,-85.38636,70085,292,'America/Indiana/Indianapolis'),(4926563,'South Bend','US',41.68338,-86.25001,101168,213,'America/Indiana/Indianapolis'),(4930956,'Boston','US',42.35843,-71.05977,617594,38,'America/New_York'),(4931429,'Brockton','US',42.08343,-71.01838,93810,37,'America/New_York'),(4931972,'Cambridge','US',42.3751,-71.10561,105162,13,'America/New_York'),(4936159,'Fall River','US',41.70149,-71.15505,88857,12,'America/New_York'),(4937230,'Framingham','US',42.27926,-71.41617,68318,54,'America/New_York'),(4937232,'Framingham Center','US',42.29732,-71.43701,65413,84,'America/New_York'),(4939085,'Haverhill','US',42.7762,-71.07728,60879,18,'America/New_York'),(4941720,'Lawrence','US',42.70704,-71.16311,76377,20,'America/New_York'),(4942618,'Lowell','US',42.63342,-71.31617,106519,39,'America/New_York'),(4942807,'Lynn','US',42.46676,-70.94949,90329,17,'America/New_York'),(4945121,'New Bedford','US',41.63622,-70.9342,95072,9,'America/New_York'),(4945283,'Newton','US',42.33704,-71.20922,85146,35,'America/New_York'),(4948247,'Quincy','US',42.25288,-71.00227,92271,17,'America/New_York'),(4951257,'Somerville','US',42.3876,-71.0995,75754,31,'America/New_York'),(4951305,'South Boston','US',42.33343,-71.04949,571281,20,'America/New_York'),(4951788,'Springfield','US',42.10148,-72.58981,153060,49,'America/New_York'),(4954380,'Waltham','US',42.37649,-71.23561,60632,22,'America/New_York'),(4956184,'Worcester','US',42.26259,-71.80229,181045,164,'America/New_York'),(4975802,'Portland','US',43.66147,-70.25533,66194,19,'America/New_York'),(4984247,'Ann Arbor','US',42.27756,-83.74088,113934,271,'America/Detroit'),(4987990,'Canton','US',42.30865,-83.48216,86825,209,'America/Detroit'),(4989133,'Clinton','US',42.58698,-82.91992,99753,186,'America/Detroit'),(4990510,'Dearborn','US',42.32226,-83.17631,98153,183,'America/Detroit'),(4990729,'Detroit','US',42.33143,-83.04575,713777,192,'America/Detroit'),(4992523,'Farmington Hills','US',42.48531,-83.37716,79740,260,'America/Detroit'),(4992982,'Flint','US',43.01253,-83.68746,102434,231,'America/Detroit'),(4994358,'Grand Rapids','US',42.96336,-85.66809,188040,205,'America/Detroit'),(4997787,'Kalamazoo','US',42.29171,-85.58723,74262,242,'America/Detroit'),(4998830,'Lansing','US',42.73254,-84.55553,114297,260,'America/Detroit'),(4999837,'Livonia','US',42.36837,-83.35271,96942,197,'America/Detroit'),(5007402,'Rochester Hills','US',42.65837,-83.14993,70995,250,'America/Detroit'),(5009586,'Shelby','US',42.67087,-83.03298,74099,210,'America/Detroit'),(5010636,'Southfield','US',42.47337,-83.22187,71739,212,'America/Detroit'),(5011148,'Sterling Heights','US',42.58031,-83.0302,129699,190,'America/Detroit'),(5011908,'Taylor','US',42.24087,-83.26965,63131,189,'America/Detroit'),(5012639,'Troy','US',42.60559,-83.14993,80980,231,'America/Detroit'),(5014051,'Warren','US',42.47754,-83.0277,134056,195,'America/Detroit'),(5014130,'Waterford','US',42.70225,-83.40272,75737,294,'America/Detroit'),(5014681,'Westland','US',42.3242,-83.40021,84094,202,'America/Detroit'),(5015618,'Wyoming','US',42.91336,-85.70531,72125,199,'America/Detroit'),(5018739,'Bloomington','US',44.8408,-93.29828,82893,251,'America/Chicago'),(5019335,'Brooklyn Park','US',45.09413,-93.35634,75781,263,'America/Chicago'),(5019767,'Burnsville','US',44.76774,-93.27772,60306,295,'America/Chicago'),(5022025,'Coon Rapids','US',45.11997,-93.28773,61476,263,'America/Chicago'),(5024719,'Duluth','US',46.78327,-92.10658,86265,216,'America/Chicago'),(5024825,'Eagan','US',44.80413,-93.16689,64206,289,'America/Chicago'),(5025219,'Eden Prairie','US',44.85469,-93.47079,60797,271,'America/Chicago'),(5036493,'Maple Grove','US',45.07246,-93.45579,61567,288,'America/Chicago'),(5037649,'Minneapolis','US',44.97997,-93.26384,382578,262,'America/Chicago'),(5041926,'Plymouth','US',45.01052,-93.45551,70576,292,'America/Chicago'),(5043473,'Rochester','US',44.02163,-92.4699,106769,314,'America/Chicago'),(5044407,'Saint Cloud','US',45.5608,-94.16249,65842,318,'America/Chicago'),(5045360,'Saint Paul','US',44.94441,-93.09327,285068,242,'America/Chicago'),(5052361,'West Coon Rapids','US',45.15969,-93.34967,62528,257,'America/Chicago'),(5053358,'Woodbury','US',44.92386,-92.95938,61961,323,'America/Chicago'),(5059163,'Fargo','US',46.87719,-96.7898,105549,279,'America/Chicago'),(5072006,'Lincoln','US',40.8,-96.66696,258379,366,'America/Chicago'),(5074472,'Omaha','US',41.25861,-95.93779,408958,343,'America/Chicago'),(5089178,'Manchester','US',42.99564,-71.45479,109565,81,'America/New_York'),(5090046,'Nashua','US',42.76537,-71.46757,86494,52,'America/New_York'),(5095445,'Bayonne','US',40.66871,-74.11431,63024,14,'America/New_York'),(5096699,'Clifton','US',40.85843,-74.16376,84136,56,'America/New_York'),(5097441,'East Orange','US',40.76732,-74.20487,64270,54,'America/New_York'),(5097529,'Edison','US',40.51872,-74.4121,102548,27,'America/New_York'),(5097598,'Elizabeth','US',40.66399,-74.2107,124969,7,'America/New_York'),(5099724,'Irvington','US',40.73232,-74.23487,61323,48,'America/New_York'),(5099836,'Jersey City','US',40.72816,-74.07764,247597,11,'America/New_York'),(5101798,'Newark','US',40.73566,-74.17237,277140,22,'America/New_York'),(5101879,'North Bergen','US',40.80427,-74.01208,63484,65,'America/New_York'),(5102443,'Passaic','US',40.85677,-74.12848,69781,38,'America/New_York'),(5102466,'Paterson','US',40.91677,-74.17181,146199,35,'America/New_York'),(5105496,'Trenton','US',40.21705,-74.74294,84913,23,'America/New_York'),(5105634,'Union City','US',40.77955,-74.02375,66455,56,'America/New_York'),(5106834,'Albany','US',42.65258,-73.75623,97856,50,'America/New_York'),(5107129,'Amherst','US',42.97839,-78.79976,122366,182,'America/New_York'),(5108815,'Bensonhurst','US',40.60177,-73.99403,60000,8,'America/New_York'),(5110077,'Brentwood','US',40.78121,-73.24623,60664,26,'America/New_York'),(5110266,'Borough of Bronx','US',40.84985,-73.86641,1385108,15,'America/New_York'),(5110302,'Brooklyn','US',40.6501,-73.94958,2300664,18,'America/New_York'),(5110629,'Buffalo','US',42.88645,-78.87837,261310,191,'America/New_York'),(5112375,'Cheektowaga','US',42.90339,-78.75475,75178,198,'America/New_York'),(5113481,'Coney Island','US',40.57788,-73.99403,60000,2,'America/New_York'),(5115985,'East New York','US',40.66677,-73.88236,173198,8,'America/New_York'),(5119347,'Greenburgh','US',41.03288,-73.84291,86764,63,'America/New_York'),(5122520,'Jamaica','US',40.69149,-73.80569,216866,12,'America/New_York'),(5125771,'Manhattan','US',40.78343,-73.96625,1487536,38,'America/New_York'),(5127835,'Mount Vernon','US',40.9126,-73.83708,67292,40,'America/New_York'),(5128549,'New Rochelle','US',40.91149,-73.78235,77062,37,'America/New_York'),(5128581,'New York City','US',40.71427,-74.00597,8175133,57,'America/New_York'),(5129603,'Oceanside','US',40.63871,-73.64013,32109,6,'America/New_York'),(5134086,'Rochester','US',43.15478,-77.61556,210565,156,'America/New_York'),(5136454,'Schenectady','US',42.81424,-73.93957,66135,78,'America/New_York'),(5139568,'Staten Island','US',40.56233,-74.13986,468730,23,'America/New_York'),(5140405,'Syracuse','US',43.04812,-76.14742,145170,129,'America/New_York'),(5142056,'Utica','US',43.1009,-75.23266,62235,143,'America/New_York'),(5143620,'West Albany','US',42.68313,-73.77845,93794,59,'America/New_York'),(5145215,'Yonkers','US',40.93121,-73.89875,195976,33,'America/New_York'),(5145476,'Akron','US',41.08144,-81.51901,199110,295,'America/New_York'),(5149222,'Canton','US',40.79895,-81.37845,73007,329,'America/New_York'),(5150529,'Cleveland','US',41.4995,-81.69541,396815,204,'America/New_York'),(5161262,'Lorain','US',41.45282,-82.18237,64097,187,'America/New_York'),(5166177,'Parma','US',41.40477,-81.72291,81601,264,'America/New_York'),(5174035,'Toledo','US',41.66394,-83.55521,287208,189,'America/New_York'),(5177568,'Youngstown','US',41.09978,-80.64952,66982,267,'America/New_York'),(5178127,'Allentown','US',40.60843,-75.49018,118032,107,'America/New_York'),(5180225,'Bethlehem','US',40.62593,-75.37046,74982,111,'America/New_York'),(5188843,'Erie','US',42.12922,-80.08506,101786,201,'America/New_York'),(5206379,'Pittsburgh','US',40.44062,-79.99589,305704,239,'America/New_York'),(5207728,'Reading','US',40.33565,-75.92687,88082,83,'America/New_York'),(5211303,'Scranton','US',41.40897,-75.66241,76089,234,'America/New_York'),(5221659,'Cranston','US',41.77982,-71.43728,80387,255,'America/New_York'),(5223869,'Pawtucket','US',41.87871,-71.38256,71148,245,'America/New_York'),(5224151,'Providence','US',41.82399,-71.41283,178042,239,'America/New_York'),(5225507,'Warwick','US',41.7001,-71.41617,82672,247,'America/New_York'),(5231851,'Sioux Falls','US',43.54997,-96.70033,153888,449,'America/Chicago'),(5244080,'Appleton','US',44.26193,-88.41538,72623,243,'America/Chicago'),(5251436,'Eau Claire','US',44.81135,-91.49849,65883,244,'America/Chicago'),(5254962,'Green Bay','US',44.51916,-88.01983,104057,182,'America/Chicago'),(5257754,'Janesville','US',42.68279,-89.01872,63575,257,'America/Chicago'),(5258393,'Kenosha','US',42.58474,-87.82119,99218,185,'America/Chicago'),(5261457,'Madison','US',43.07305,-89.40123,233209,272,'America/Chicago'),(5263045,'Milwaukee','US',43.0389,-87.90647,594833,203,'America/Chicago'),(5265838,'Oshkosh','US',44.02471,-88.54261,66083,237,'America/Chicago'),(5268249,'Racine','US',42.72613,-87.78285,78860,192,'America/Chicago'),(5278052,'Waukesha','US',43.01168,-88.23148,70718,252,'America/Chicago'),(5278420,'West Allis','US',43.01668,-88.00703,60411,224,'America/Chicago'),(5282804,'Bridgeport','US',41.16704,-73.20483,144229,5,'America/New_York'),(5282835,'Bristol','US',41.67176,-72.94927,60477,95,'America/New_York'),(5288661,'Casas Adobes','US',32.32341,-110.9951,66795,733,'America/Phoenix'),(5289282,'Chandler','US',33.30616,-111.84125,236123,368,'America/Phoenix'),(5294810,'Flagstaff','US',35.19807,-111.65127,65870,2108,'America/Phoenix'),(5295903,'Gilbert','US',33.35283,-111.78903,208453,377,'America/Phoenix'),(5295985,'Glendale','US',33.53865,-112.18599,226721,350,'America/Phoenix'),(5296266,'Goodyear','US',33.43532,-112.35821,65275,294,'America/Phoenix'),(5304391,'Mesa','US',33.42227,-111.82264,439041,380,'America/Phoenix'),(5308480,'Peoria','US',33.5806,-112.23738,154065,347,'America/Phoenix'),(5308655,'Phoenix','US',33.44838,-112.07404,1445632,366,'America/Phoenix'),(5313457,'Scottsdale','US',33.50921,-111.89903,217385,382,'America/Phoenix'),(5316428,'Surprise','US',33.63059,-112.33322,117517,357,'America/Phoenix'),(5317058,'Tempe','US',33.41477,-111.90931,161719,360,'America/Phoenix'),(5317071,'Tempe Junction','US',33.41421,-111.94348,158368,352,'America/Phoenix'),(5318313,'Tucson','US',32.22174,-110.92648,520116,757,'America/Phoenix'),(5322053,'Yuma','US',32.72532,-114.6244,93064,43,'America/Phoenix'),(5322737,'Alameda','US',37.76521,-122.24164,73812,12,'America/Los_Angeles'),(5323060,'Alhambra','US',34.09529,-118.12701,83089,153,'America/Los_Angeles'),(5323810,'Anaheim','US',33.83529,-117.9145,336265,55,'America/Los_Angeles'),(5324200,'Antioch','US',38.00492,-121.80579,102372,13,'America/Los_Angeles'),(5324363,'Apple Valley','US',34.50083,-117.18588,69135,902,'America/Los_Angeles'),(5325738,'Bakersfield','US',35.37329,-119.01871,347483,130,'America/Los_Angeles'),(5325866,'Baldwin Park','US',34.08529,-117.9609,75390,115,'America/Los_Angeles'),(5327422,'Bellflower','US',33.88168,-118.11701,76616,24,'America/Los_Angeles'),(5327684,'Berkeley','US',37.87159,-122.27275,112580,55,'America/Los_Angeles'),(5331575,'Buena Park','US',33.86751,-117.99812,80530,24,'America/Los_Angeles'),(5331835,'Burbank','US',34.18084,-118.30897,103340,192,'America/Los_Angeles'),(5333180,'Camarillo','US',34.21639,-119.0376,65201,55,'America/Los_Angeles'),(5334223,'Carlsbad','US',33.15809,-117.35059,105328,18,'America/Los_Angeles'),(5334336,'Carmichael','US',38.61713,-121.32828,61762,39,'America/Los_Angeles'),(5334519,'Carson','US',33.83141,-118.28202,91714,16,'America/Los_Angeles'),(5334928,'Castro Valley','US',37.6941,-122.08635,61388,49,'America/Los_Angeles'),(5336269,'Chico','US',39.72849,-121.83748,86187,64,'America/Los_Angeles'),(5336537,'Chino','US',34.01223,-117.68894,77983,222,'America/Los_Angeles'),(5336545,'Chino Hills','US',33.9938,-117.75888,74799,262,'America/Los_Angeles'),(5336899,'Chula Vista','US',32.64005,-117.0842,243916,21,'America/Los_Angeles'),(5337561,'Citrus Heights','US',38.70712,-121.28106,83301,52,'America/Los_Angeles'),(5338122,'Clovis','US',36.82523,-119.70292,95631,113,'America/Los_Angeles'),(5339066,'Compton','US',33.89585,-118.22007,96455,23,'America/Los_Angeles'),(5339111,'Concord','US',37.97798,-122.03107,122067,25,'America/Los_Angeles'),(5339631,'Corona','US',33.87529,-117.56644,152374,213,'America/Los_Angeles'),(5339840,'Costa Mesa','US',33.64113,-117.91867,109960,33,'America/Los_Angeles'),(5341430,'Daly City','US',37.70577,-122.46192,101123,123,'America/Los_Angeles'),(5341704,'Davis','US',38.54491,-121.74052,65622,17,'America/Los_Angeles'),(5343858,'Downey','US',33.94001,-118.13257,111772,41,'America/Los_Angeles'),(5344994,'East Los Angeles','US',34.0239,-118.17202,126496,63,'America/Los_Angeles'),(5345529,'El Cajon','US',32.79477,-116.96253,99478,133,'America/Los_Angeles'),(5345743,'El Monte','US',34.06862,-118.02757,113475,91,'America/Los_Angeles'),(5346111,'Elk Grove','US',38.4088,-121.37162,153015,17,'America/Los_Angeles'),(5346827,'Escondido','US',33.11921,-117.08642,143911,199,'America/Los_Angeles'),(5347335,'Fairfield','US',38.24936,-122.03997,105321,4,'America/Los_Angeles'),(5349705,'Folsom','US',38.67796,-121.17606,72203,66,'America/Los_Angeles'),(5349755,'Fontana','US',34.09223,-117.43505,196069,378,'America/Los_Angeles'),(5350734,'Fremont','US',37.54827,-121.98857,214089,18,'America/Los_Angeles'),(5350937,'Fresno','US',36.74773,-119.77237,494665,99,'America/Los_Angeles'),(5351247,'Fullerton','US',33.87029,-117.92534,135161,52,'America/Los_Angeles'),(5351515,'Garden Grove','US',33.77391,-117.94145,170883,26,'America/Los_Angeles'),(5352423,'Glendale','US',34.14251,-118.25508,191719,161,'America/Los_Angeles'),(5355828,'Hawthorne','US',33.9164,-118.35257,84293,24,'America/Los_Angeles'),(5355933,'Hayward','US',37.66882,-122.0808,144186,32,'America/Los_Angeles'),(5356277,'Hemet','US',33.74752,-116.97197,78657,487,'America/Los_Angeles'),(5356576,'Hesperia','US',34.42639,-117.30088,90173,967,'America/Los_Angeles'),(5357527,'Hollywood','US',34.09834,-118.32674,167664,113,'America/Los_Angeles'),(5358705,'Huntington Beach','US',33.6603,-117.99923,189992,16,'America/Los_Angeles'),(5359446,'Indio','US',33.72058,-116.21556,76036,251,'America/Los_Angeles'),(5359488,'Inglewood','US',33.96168,-118.35313,109673,44,'America/Los_Angeles'),(5359777,'Irvine','US',33.66946,-117.82311,212375,22,'America/Los_Angeles'),(5363922,'La Habra','US',33.93196,-117.94617,60239,92,'America/Los_Angeles'),(5364329,'Laguna Niguel','US',33.52253,-117.70755,62979,125,'America/Los_Angeles'),(5364514,'Lake Forest','US',33.64697,-117.68922,77264,150,'America/Los_Angeles'),(5364855,'Lakewood','US',33.85363,-118.13396,80048,20,'America/Los_Angeles'),(5364940,'Lancaster','US',34.69804,-118.13674,156633,718,'America/Los_Angeles'),(5367440,'Livermore','US',37.68187,-121.76801,80968,150,'America/Los_Angeles'),(5367565,'Lodi','US',38.1302,-121.27245,62134,15,'America/Los_Angeles'),(5367929,'Long Beach','US',33.76696,-118.18923,462257,24,'America/Los_Angeles'),(5368361,'Los Angeles','US',34.05223,-118.24368,3792621,96,'America/Los_Angeles'),(5369367,'Lynwood','US',33.93029,-118.21146,69772,31,'America/Los_Angeles'),(5369568,'Madera','US',36.96134,-120.06072,61416,87,'America/Los_Angeles'),(5370164,'Manteca','US',37.79743,-121.21605,67096,14,'America/Los_Angeles'),(5372205,'Menifee','US',33.72835,-117.14642,77519,452,'America/Los_Angeles'),(5372253,'Merced','US',37.30216,-120.48297,78958,56,'America/Los_Angeles'),(5373327,'Milpitas','US',37.42827,-121.90662,66790,5,'America/Los_Angeles'),(5373763,'Mission Viejo','US',33.60002,-117.672,93305,127,'America/Los_Angeles'),(5373900,'Modesto','US',37.6391,-120.99688,201165,29,'America/Los_Angeles'),(5374322,'Montebello','US',34.00946,-118.10535,62500,66,'America/Los_Angeles'),(5374406,'Monterey Park','US',34.06251,-118.12285,60269,118,'America/Los_Angeles'),(5374732,'Moreno Valley','US',33.93752,-117.23059,193365,499,'America/Los_Angeles'),(5375480,'Mountain View','US',37.38605,-122.08385,74066,34,'America/Los_Angeles'),(5375911,'Murrieta','US',33.55391,-117.21392,103466,336,'America/Los_Angeles'),(5376095,'Napa','US',38.29714,-122.28553,76915,9,'America/Los_Angeles'),(5376890,'Newport Beach','US',33.61891,-117.92895,85186,8,'America/Los_Angeles'),(5377613,'North Glendale','US',34.16056,-118.26452,203201,168,'America/Los_Angeles'),(5377654,'North Hollywood','US',34.17223,-118.37897,77848,199,'America/Los_Angeles'),(5377995,'Norwalk','US',33.90224,-118.08173,105549,29,'America/Los_Angeles'),(5378538,'Oakland','US',37.80437,-122.2708,390724,24,'America/Los_Angeles'),(5378771,'Oceanside','US',33.19587,-117.37948,167086,24,'America/Los_Angeles'),(5379439,'Ontario','US',34.06334,-117.65089,163924,307,'America/Los_Angeles'),(5379513,'Orange','US',33.78779,-117.85311,136416,61,'America/Los_Angeles'),(5380184,'Oxnard','US',34.1975,-119.17705,197899,19,'America/Los_Angeles'),(5380202,'Oxnard Shores','US',34.19084,-119.2415,187235,7,'America/Los_Angeles'),(5380698,'Palmdale','US',34.57943,-118.11646,152750,815,'America/Los_Angeles'),(5380748,'Palo Alto','US',37.44188,-122.14302,64403,10,'America/Los_Angeles'),(5381396,'Pasadena','US',34.14778,-118.14452,137122,272,'America/Los_Angeles'),(5382146,'Perris','US',33.78252,-117.22865,68386,445,'America/Los_Angeles'),(5382496,'Pico Rivera','US',33.98307,-118.09674,62942,53,'America/Los_Angeles'),(5383465,'Pittsburg','US',38.02798,-121.88468,63264,8,'America/Los_Angeles'),(5383777,'Pleasanton','US',37.66243,-121.87468,70285,107,'America/Los_Angeles'),(5384170,'Pomona','US',34.05529,-117.75228,149058,264,'America/Los_Angeles'),(5385941,'Rancho Cordova','US',38.58907,-121.30273,64776,28,'America/Los_Angeles'),(5385955,'Rancho Cucamonga','US',34.1064,-117.59311,165269,371,'America/Los_Angeles'),(5386754,'Redlands','US',34.05557,-117.18254,68747,417,'America/Los_Angeles'),(5386785,'Redondo Beach','US',33.84918,-118.38841,66748,22,'America/Los_Angeles'),(5386834,'Redwood City','US',37.48522,-122.23635,76815,8,'America/Los_Angeles'),(5387288,'Rialto','US',34.1064,-117.37032,99171,386,'America/Los_Angeles'),(5387428,'Richmond','US',37.93576,-122.34775,103701,12,'America/Los_Angeles'),(5387877,'Riverside','US',33.95335,-117.39616,303871,257,'America/Los_Angeles'),(5388881,'Roseville','US',38.75212,-121.28801,118788,51,'America/Los_Angeles'),(5389489,'Sacramento','US',38.58157,-121.4944,466488,14,'America/Los_Angeles'),(5391295,'Salinas','US',36.67774,-121.6555,150441,17,'America/Los_Angeles'),(5391710,'San Bernardino','US',34.10834,-117.28977,209924,324,'America/Los_Angeles'),(5391791,'San Clemente','US',33.42697,-117.61199,63522,71,'America/Los_Angeles'),(5391811,'San Diego','US',32.71533,-117.15726,1307402,31,'America/Los_Angeles'),(5391959,'San Francisco','US',37.77493,-122.41942,805235,28,'America/Los_Angeles'),(5392171,'San Jose','US',37.33939,-121.89496,945942,23,'America/Los_Angeles'),(5392263,'San Leandro','US',37.72493,-122.15608,84950,19,'America/Los_Angeles'),(5392368,'San Marcos','US',33.14337,-117.16614,83781,177,'America/Los_Angeles'),(5392423,'San Mateo','US',37.56299,-122.32553,97207,13,'America/Los_Angeles'),(5392528,'San Pedro','US',33.73585,-118.29229,78405,37,'America/Los_Angeles'),(5392593,'San Ramon','US',37.77993,-121.97802,72148,146,'America/Los_Angeles'),(5392900,'Santa Ana','US',33.74557,-117.86783,324528,39,'America/Los_Angeles'),(5392952,'Santa Barbara','US',34.42083,-119.69819,88410,16,'America/Los_Angeles'),(5393015,'Santa Clara','US',37.35411,-121.95524,116468,22,'America/Los_Angeles'),(5393049,'Santa Clarita','US',34.39166,-118.54259,176320,368,'America/Los_Angeles'),(5393180,'Santa Maria','US',34.95303,-120.43572,99553,68,'America/Los_Angeles'),(5393212,'Santa Monica','US',34.01945,-118.49119,89736,37,'America/Los_Angeles'),(5393287,'Santa Rosa','US',38.44047,-122.71443,167815,55,'America/Los_Angeles'),(5396003,'Simi Valley','US',34.26945,-118.78148,124237,236,'America/Los_Angeles'),(5397603,'South Gate','US',33.95474,-118.21202,94396,38,'America/Los_Angeles'),(5397765,'South San Francisco','US',37.65466,-122.40775,63632,5,'America/Los_Angeles'),(5399020,'Stockton','US',37.9577,-121.29078,291707,6,'America/Los_Angeles'),(5400075,'Sunnyvale','US',37.36883,-122.03635,140081,37,'America/Los_Angeles'),(5401395,'Temecula','US',33.49364,-117.14836,100097,308,'America/Los_Angeles'),(5402405,'Thousand Oaks','US',34.17056,-118.83759,126683,274,'America/Los_Angeles'),(5403022,'Torrance','US',33.83585,-118.34063,145438,33,'America/Los_Angeles'),(5403191,'Tracy','US',37.73965,-121.42522,82922,16,'America/Los_Angeles'),(5404024,'Turlock','US',37.49466,-120.84659,68549,32,'America/Los_Angeles'),(5404119,'Tustin','US',33.74585,-117.82617,75540,46,'America/Los_Angeles'),(5404554,'Union City','US',37.59583,-122.01917,69516,19,'America/Los_Angeles'),(5404555,'Union City','US',37.59577,-122.01913,69516,19,'America/Los_Angeles'),(5404794,'Universal City','US',34.1389,-118.35341,105000,234,'America/Los_Angeles'),(5404915,'Upland','US',34.09751,-117.64839,73732,380,'America/Los_Angeles'),(5405228,'Vacaville','US',38.35658,-121.98774,92428,55,'America/Los_Angeles'),(5405288,'Valencia','US',34.44361,-118.60953,148456,312,'America/Los_Angeles'),(5405380,'Vallejo','US',38.10409,-122.25664,115942,22,'America/Los_Angeles'),(5405693,'Van Nuys','US',34.18667,-118.44897,136443,220,'America/Los_Angeles'),(5405878,'Ventura','US',34.27834,-119.29317,96769,12,'America/Los_Angeles'),(5406222,'Victorville','US',34.53611,-117.29116,115903,834,'America/Los_Angeles'),(5406567,'Visalia','US',36.33023,-119.29206,124442,110,'America/Los_Angeles'),(5406602,'Vista','US',33.20004,-117.24254,93834,102,'America/Los_Angeles'),(5406990,'Walnut Creek','US',37.90631,-122.06496,64173,54,'America/Los_Angeles'),(5407933,'West Covina','US',34.06862,-117.93895,106098,120,'America/Los_Angeles'),(5408406,'Westminster','US',33.75918,-118.00673,89701,14,'America/Los_Angeles'),(5409059,'Whittier','US',33.97918,-118.03284,85331,117,'America/Los_Angeles'),(5410438,'Woodland Hills','US',34.16834,-118.60592,70000,277,'America/Los_Angeles'),(5410902,'Yorba Linda','US',33.88863,-117.81311,64234,116,'America/Los_Angeles'),(5411015,'Yuba City','US',39.14045,-121.61691,64925,18,'America/Los_Angeles'),(5412199,'Arvada','US',39.80276,-105.08748,106433,1637,'America/Denver'),(5412347,'Aurora','US',39.72943,-104.83192,325078,1651,'America/Denver'),(5416541,'Centennial','US',39.57916,-104.87692,100377,1781,'America/Denver'),(5417598,'Colorado Springs','US',38.83388,-104.82136,416427,1838,'America/Denver'),(5419384,'Denver','US',39.73915,-104.9847,600158,1636,'America/Denver'),(5425043,'Highlands Ranch','US',39.55388,-104.96943,96713,1741,'America/Denver'),(5427946,'Lakewood','US',39.70471,-105.08137,142980,1682,'America/Denver'),(5435464,'Pueblo','US',38.25445,-104.60914,106595,1430,'America/Denver'),(5441492,'Thornton','US',39.86804,-104.97192,118772,1635,'America/Denver'),(5443910,'Westminster','US',39.83665,-105.0372,106114,1644,'America/Denver'),(5454711,'Albuquerque','US',35.08449,-106.65114,545852,1513,'America/Denver'),(5475352,'Las Cruces','US',32.31232,-106.77834,97618,1189,'America/Denver'),(5487811,'Rio Rancho','US',35.23338,-106.66447,87521,1606,'America/Denver'),(5490263,'Santa Fe','US',35.68698,-105.9378,67947,2137,'America/Denver'),(5503766,'Enterprise','US',36.02525,-115.24194,108481,779,'America/Los_Angeles'),(5505411,'Henderson','US',36.0397,-114.98194,257729,572,'America/Los_Angeles'),(5506956,'Las Vegas','US',36.17497,-115.13722,583756,613,'America/Los_Angeles'),(5509403,'North Las Vegas','US',36.19886,-115.1175,216961,570,'America/Los_Angeles'),(5509952,'Paradise','US',36.09719,-115.14666,223167,629,'America/Los_Angeles'),(5511077,'Reno','US',39.52963,-119.8138,225221,1380,'America/Los_Angeles'),(5512862,'Sparks','US',39.53491,-119.75269,90264,1348,'America/Los_Angeles'),(5512909,'Spring Valley','US',36.10803,-115.245,178395,723,'America/Los_Angeles'),(5513343,'Sunrise Manor','US',36.21108,-115.07306,189372,561,'America/Los_Angeles'),(5516233,'Amarillo','US',35.222,-101.8313,190695,1124,'America/Chicago'),(5520993,'El Paso','US',31.75872,-106.48693,649121,1137,'America/Denver'),(5525577,'Lubbock','US',33.57786,-101.85517,229573,979,'America/Chicago'),(5526337,'Midland','US',31.99735,-102.07791,111147,862,'America/Chicago'),(5527554,'Odessa','US',31.84568,-102.36764,99940,885,'America/Chicago'),(5530022,'San Angelo','US',31.46377,-100.43704,93200,564,'America/Chicago'),(5546220,'Saint George','US',37.10415,-113.58412,72897,825,'America/Denver'),(5552301,'Avondale','US',33.4356,-112.3496,76238,295,'America/Phoenix'),(5570160,'Redding','US',40.58654,-122.39168,89861,172,'America/Los_Angeles'),(5574991,'Boulder','US',40.01499,-105.27055,97385,1630,'America/Denver'),(5577147,'Fort Collins','US',40.58526,-105.08442,143986,1531,'America/Denver'),(5577592,'Greeley','US',40.42331,-104.70913,92889,1428,'America/Denver'),(5579276,'Longmont','US',40.16721,-105.10193,86270,1520,'America/Denver'),(5579368,'Loveland','US',40.39776,-105.07498,66859,1522,'America/Denver'),(5586437,'Boise','US',43.6135,-116.20345,145987,834,'America/Boise'),(5600685,'Meridian','US',43.61211,-116.39151,75092,796,'America/Boise'),(5601933,'Nampa','US',43.54072,-116.56346,81557,767,'America/Boise'),(5640350,'Billings','US',45.78329,-108.50069,104170,954,'America/Denver'),(5666639,'Missoula','US',46.87215,-113.994,66788,978,'America/Denver'),(5688025,'Bismarck','US',46.80833,-100.78374,61272,520,'America/Chicago'),(5713376,'Beaverton','US',45.48706,-122.80371,89803,55,'America/Los_Angeles'),(5713587,'Bend','US',44.05817,-121.31531,76639,1106,'America/Los_Angeles'),(5725846,'Eugene','US',44.05207,-123.08675,156185,132,'America/Los_Angeles'),(5729485,'Gresham','US',45.49818,-122.43148,105594,96,'America/Los_Angeles'),(5731371,'Hillsboro','US',45.52289,-122.98983,91611,59,'America/Los_Angeles'),(5740099,'Medford','US',42.32652,-122.87559,74907,422,'America/Los_Angeles'),(5746545,'Portland','US',45.52345,-122.67621,583776,15,'America/Los_Angeles'),(5750162,'Salem','US',44.9429,-123.0351,154637,55,'America/Los_Angeles'),(5768233,'Rapid City','US',44.08054,-103.23101,67956,990,'America/Denver'),(5777107,'Layton','US',41.06022,-111.97105,67311,1327,'America/Denver'),(5778352,'Millcreek','US',40.68689,-111.87549,62139,1309,'America/Denver'),(5779206,'Ogden','US',41.223,-111.97383,82825,1315,'America/Denver'),(5779334,'Orem','US',40.2969,-111.69465,88328,1458,'America/Denver'),(5780026,'Provo','US',40.23384,-111.65853,112488,1394,'America/Denver'),(5780993,'Salt Lake City','US',40.76078,-111.89105,186440,1311,'America/Denver'),(5781061,'Sandy City','US',40.57204,-111.86056,87461,1398,'America/Denver'),(5781070,'Sandy Hills','US',40.58106,-111.85077,89575,1459,'America/Denver'),(5784549,'West Jordan','US',40.60967,-111.9391,103712,1338,'America/Denver'),(5784607,'West Valley City','US',40.69161,-112.00105,129480,1316,'America/Denver'),(5785965,'Auburn','US',47.30732,-122.22845,70180,25,'America/Los_Angeles'),(5786882,'Bellevue','US',47.61038,-122.20068,122363,28,'America/Los_Angeles'),(5786899,'Bellingham','US',48.75955,-122.48822,80885,21,'America/Los_Angeles'),(5793933,'Everett','US',47.97898,-122.20208,103019,22,'America/Los_Angeles'),(5794245,'Federal Way','US',47.32232,-122.31262,89306,142,'America/Los_Angeles'),(5799610,'Kennewick','US',46.21125,-119.13723,73917,126,'America/Los_Angeles'),(5799625,'Kent','US',47.38093,-122.23484,92411,14,'America/Los_Angeles'),(5802570,'Marysville','US',48.05176,-122.17708,60020,6,'America/Los_Angeles'),(5808189,'Renton','US',47.48288,-122.21707,90927,13,'America/Los_Angeles'),(5809844,'Seattle','US',47.60621,-122.33207,608660,56,'America/Los_Angeles'),(5811696,'Spokane','US',47.65966,-117.42908,208916,530,'America/Los_Angeles'),(5811729,'Spokane Valley','US',47.67323,-117.23937,89755,610,'America/Los_Angeles'),(5812944,'Tacoma','US',47.25288,-122.44429,198397,74,'America/Los_Angeles'),(5814616,'Vancouver','US',45.63873,-122.66149,161791,57,'America/Los_Angeles'),(5816605,'Yakima','US',46.60207,-120.5059,91067,325,'America/Los_Angeles'),(5856195,'Honolulu','US',21.30694,-157.85833,371657,18,'Pacific/Honolulu'),(5879400,'Anchorage','US',61.21806,-149.90028,291826,16,'America/Anchorage'),(5881791,'Abbotsford','CA',49.05798,-122.25257,151683,114,'America/Vancouver'),(5882873,'Ajax','CA',43.85012,-79.03288,90167,97,'America/Toronto'),(5892532,'Banff','CA',51.17622,-115.56982,7502,1388,'America/Edmonton'),(5894171,'Barrie','CA',44.40011,-79.66634,182041,269,'America/Toronto'),(5907364,'Brampton','CA',43.68341,-79.76633,433806,221,'America/Toronto'),(5907990,'Brantford','CA',43.1334,-80.26636,87759,200,'America/Toronto'),(5909629,'Brossard','CA',45.45008,-73.46583,69575,17,'America/Montreal'),(5911592,'Burlington','CA',43.38621,-79.83713,164415,165,'America/Toronto'),(5911606,'Burnaby','CA',49.26636,-122.95263,202799,87,'America/Vancouver'),(5913490,'Calgary','CA',51.05011,-114.08529,1019942,1042,'America/Edmonton'),(5913695,'Cambridge','CA',43.3601,-80.31269,120372,272,'America/Toronto'),(5920450,'Chatham-Kent','CA',42.40009,-82.1831,108589,184,'America/Toronto'),(5921357,'Chilliwack','CA',49.17468,-121.94427,69217,13,'America/Vancouver'),(5927689,'Coquitlam','CA',49.28297,-122.75262,114565,33,'America/Vancouver'),(5935277,'Dartmouth','CA',44.67134,-63.57719,101343,35,'America/Halifax'),(5937615,'Delta','CA',49.14399,-122.9068,101668,81,'America/Vancouver'),(5939236,'Digby','CA',44.61685,-65.76555,2052,44,'America/Halifax'),(5946768,'Edmonton','CA',53.55014,-113.46871,712391,610,'America/Edmonton'),(5950267,'Etobicoke','CA',43.65421,-79.56711,347948,148,'America/Toronto'),(5955895,'Fort McMurray','CA',56.72676,-111.38103,76000,258,'America/Edmonton'),(5959974,'Gatineau','CA',45.47723,-75.70164,242124,53,'America/Montreal'),(5964700,'Greater Sudbury','CA',46.49,-80.99001,157857,266,'America/Toronto'),(5967629,'Guelph','CA',43.5501,-80.24967,115760,325,'America/Toronto'),(5969785,'Hamilton','CA',43.23341,-79.94964,504559,215,'America/Toronto'),(5989045,'Kamloops','CA',50.66648,-120.3192,68714,414,'America/Vancouver'),(5989818,'Kawartha Lakes','CA',44.58342,-78.83288,74561,265,'America/Toronto'),(5990579,'Kelowna','CA',49.88307,-119.48568,125109,350,'America/Vancouver'),(5992500,'Kingston','CA',44.22976,-76.48098,114195,83,'America/Toronto'),(5992996,'Kitchener','CA',43.42537,-80.5112,409112,336,'America/Toronto'),(6049430,'Langley','CA',49.08297,-122.58589,93726,78,'America/Vancouver'),(6050610,'Laval','CA',45.56995,-73.692,376845,34,'America/Montreal'),(6053154,'Lethbridge','CA',49.69999,-112.81856,70617,907,'America/Edmonton'),(6058560,'London','CA',42.98339,-81.23304,346765,252,'America/Toronto'),(6059891,'Longueuil','CA',45.53121,-73.51806,229330,18,'America/Montreal'),(6062069,'Lunenburg','CA',44.38345,-64.31545,2473,3,'America/Halifax'),(6065686,'Maple Ridge','CA',49.21939,-122.60193,70000,42,'America/Vancouver'),(6066513,'Markham','CA',43.86682,-79.2663,261573,168,'America/Toronto'),(6071618,'Medicine Hat','CA',50.05006,-110.66834,63138,692,'America/Edmonton'),(6075357,'Mississauga','CA',43.5789,-79.6583,668549,159,'America/Toronto'),(6076211,'Moncton','CA',46.11594,-64.80186,87467,14,'America/Moncton'),(6077243,'Montreal','CA',45.50884,-73.58781,3268513,216,'America/Montreal'),(6085772,'Nanaimo','CA',49.16634,-123.93601,84905,17,'America/Vancouver'),(6087701,'Newmarket','CA',44.05011,-79.46631,74295,250,'America/Toronto'),(6087892,'Niagara Falls','CA',43.10012,-79.06627,82000,184,'America/Toronto'),(6089125,'Norfolk County','CA',42.8334,-80.38297,60847,235,'America/Toronto'),(6091104,'North York','CA',43.76681,-79.4163,636000,178,'America/Toronto'),(6092122,'Oakville','CA',43.45011,-79.68292,165697,99,'America/Toronto'),(6094578,'Oshawa','CA',43.90012,-78.84957,247989,105,'America/Toronto'),(6094817,'Ottawa','CA',45.41117,-75.69812,812129,71,'America/Toronto'),(6101645,'Peterborough','CA',44.30012,-78.31623,75877,188,'America/Toronto'),(6104111,'Pickering','CA',43.90012,-79.13289,87838,214,'America/Toronto'),(6113365,'Prince George','CA',53.9166,-122.75301,65558,578,'America/Vancouver'),(6118158,'Red Deer','CA',52.26682,-113.802,73593,856,'America/Edmonton'),(6119109,'Regina','CA',50.45008,-104.6178,176183,577,'America/Regina'),(6119518,'Repentigny','CA',45.74222,-73.45008,76237,10,'America/Montreal'),(6122085,'Richmond','CA',49.17003,-123.13683,182000,9,'America/Vancouver'),(6122091,'Richmond Hill','CA',43.87111,-79.43725,185541,232,'America/Toronto'),(6137270,'Saguenay','CA',48.41675,-71.06573,143692,84,'America/Montreal'),(6138495,'Saint-Jean-sur-Richelieu','CA',45.31678,-73.26586,71613,29,'America/Montreal'),(6138517,'Saint John','CA',45.27271,-66.06766,87857,5,'America/Moncton'),(6138610,'Saint-Laurent','CA',45.50008,-73.66585,77391,41,'America/Montreal'),(6141190,'Sarnia','CA',42.97866,-82.40407,82998,185,'America/Toronto'),(6141256,'Saskatoon','CA',52.11679,-106.63452,198958,501,'America/Regina'),(6141439,'Sault Ste. Marie','CA',46.51677,-84.33325,74948,186,'America/Toronto'),(6146143,'Sherbrooke','CA',45.40008,-71.89908,129447,175,'America/Montreal'),(6155721,'St. Catharines','CA',43.16681,-79.24958,131989,104,'America/Toronto'),(6159905,'Surrey','CA',49.10635,-122.82509,394976,82,'America/Vancouver'),(6163012,'Terrebonne','CA',45.70004,-73.64732,94703,18,'America/Montreal'),(6166142,'Thunder Bay','CA',48.4001,-89.31683,99334,199,'America/Thunder_Bay'),(6167865,'Toronto','CA',43.70011,-79.4163,4612191,175,'America/Toronto'),(6169141,'Trois-Rivieres','CA',46.35006,-72.54912,119693,20,'America/Montreal'),(6173331,'Vancouver','CA',49.24966,-123.11934,1837969,70,'America/Vancouver'),(6173577,'Vaughan','CA',43.8361,-79.49827,238866,218,'America/Toronto'),(6174041,'Victoria','CA',48.43294,-123.3693,289625,6,'America/Vancouver'),(6176823,'Waterloo','CA',43.4668,-80.51639,97475,325,'America/Toronto'),(6180961,'White Rock','CA',49.01636,-122.8026,66450,-9999,'America/Vancouver'),(6182962,'Windsor','CA',42.30008,-83.01654,278013,190,'America/Toronto'),(6183235,'Winnipeg','CA',49.8844,-97.14704,632063,245,'America/Winnipeg'),(6183858,'Wolfville','CA',45.08345,-64.36546,3523,53,'America/Halifax'),(6185217,'Yarmouth','CA',43.83345,-66.11557,7500,26,'America/Halifax'),(6252065,'Nou Barris','ES',41.44163,2.17727,164981,85,'Europe/Madrid'),(6324534,'Vrilissia','GR',38.03381,23.82962,74034,232,'Europe/Athens'),(6324729,'Halifax','CA',44.64533,-63.57239,359111,23,'America/Halifax'),(6324733,'St. John\'s','CA',47.56494,-52.70931,99182,35,'America/St_Johns'),(6325494,'Quebec','CA',46.81228,-71.21454,528595,54,'America/Montreal'),(6325521,'Levis','CA',46.80326,-71.17793,126396,87,'America/Montreal'),(6331909,'Johns Creek','US',34.02893,-84.19858,76728,293,'America/New_York'),(6332439,'Alafaya','US',28.5641,-81.2114,78113,31,'America/New_York'),(6354908,'Sydney','CA',46.1351,-60.1831,105968,6,'America/Glace_Bay'),(6362987,'Ceuta','ES',35.88933,-5.31979,78674,14,'Africa/Ceuta'),(6534228,'Guidonia Montecelio','IT',41.99362,12.72238,67516,92,'Europe/Rome'),(6534232,'Lamezia Terme','IT',38.96589,16.3092,70501,185,'Europe/Rome'),(6543862,'Villeneuve-d\'Ascq','FR',50.61669,3.16664,62400,32,'Europe/Paris'),(6544099,'Moncloa-Aravaca','ES',40.43547,-3.7317,116531,615,'Europe/Madrid'),(6544100,'Eixample','ES',41.38896,2.16179,262485,44,'Europe/Madrid'),(6544101,'les Corts','ES',41.38712,2.13007,82588,73,'Europe/Madrid'),(6544102,'Sarria-Sant Gervasi','ES',41.40104,2.1394,140000,124,'Europe/Madrid'),(6544103,'Horta-Guinardo','ES',41.41849,2.1677,169920,166,'Europe/Madrid'),(6544104,'Sants-Montjuic','ES',41.37263,2.1546,177636,44,'Europe/Madrid'),(6544105,'Sant Marti','ES',41.41814,2.19933,221029,21,'Europe/Madrid'),(6544106,'Ciutat Vella','ES',41.38022,2.17319,111290,28,'Europe/Madrid'),(6544487,'Arganzuela','ES',40.40021,-3.69618,148797,605,'Europe/Madrid'),(6544488,'San Blas','ES',40.43893,-3.61537,157367,663,'Europe/Madrid'),(6544489,'Latina','ES',40.38897,-3.74569,256644,652,'Europe/Madrid'),(6544490,'Usera','ES',40.38866,-3.70035,141189,586,'Europe/Madrid'),(6544491,'Salamanca','ES',40.42972,-3.67975,147707,698,'Europe/Madrid'),(6544492,'Chamberi','ES',40.43404,-3.70379,145934,693,'Europe/Madrid'),(6544493,'Carabanchel','ES',40.39094,-3.7242,253678,622,'Europe/Madrid'),(6544494,'City Center','ES',40.41831,-3.70275,149718,673,'Europe/Madrid'),(6544495,'Retiro','ES',40.41317,-3.68307,126058,665,'Europe/Madrid'),(6544881,'Amsterdam-Zuidoost','NL',52.3075,4.97222,84811,4,'Europe/Amsterdam'),(6545310,'Berlin Mitte','DE',52.52003,13.40489,329078,48,'Europe/Berlin'),(6615440,'Delicias','ES',41.64928,-0.90757,110520,228,'Europe/Madrid'),(6618856,'Santutxu','ES',43.25347,-2.9161,60000,78,'Europe/Madrid'),(6690602,'Battersea','GB',51.47475,-0.15547,75651,7,'Europe/London'),(6690870,'Becontree','GB',51.5529,0.129,100000,11,'Europe/London'),(6690877,'Brixton','GB',51.46593,-0.10652,66300,14,'Europe/London'),(6941055,'Bochum-Hordel','DE',51.50168,7.1756,380000,57,'Europe/Berlin'),(6944048,'Berlin-Neukoeln','DE',52.4808,13.425,158429,59,'Europe/Berlin'),(6947479,'Koeln-Ehrenfeld','DE',50.9456,6.92059,103621,54,'Europe/Berlin'),(6947482,'Koeln-Muelheim','DE',50.9631,7.00488,144625,51,'Europe/Berlin'),(6947483,'Koeln-Nippes','DE',50.963,6.9541,110140,52,'Europe/Berlin'),(6947513,'Koeln-Porz','DE',50.8888,7.05707,106520,60,'Europe/Berlin'),(6947544,'Koeln-Innenstadt','DE',50.9367,6.96028,127033,51,'Europe/Berlin'),(6947756,'Mendip','GB',51.2372,-2.6266,110000,293,'Europe/London'),(7259621,'West Bloomfield Township','US',42.56891,-83.38356,64690,303,'America/Detroit'),(7260806,'Arden-Arcade','US',38.6025,-121.37854,92186,23,'America/Los_Angeles'),(7261268,'Florence-Graham','US',33.96772,-118.24438,63387,46,'America/Los_Angeles'),(7281931,'Okanagan','CA',50.36386,-119.34997,297601,598,'America/Vancouver'),(7289614,'Halle Neustadt','DE',51.47924,11.91605,240000,85,'Europe/Berlin'),(7290243,'Bergedorf','DE',53.48462,10.22904,119665,17,'Europe/Berlin'),(7290245,'Berlin Steglitz Zehlendorf','DE',52.43485,13.24183,290506,45,'Europe/Berlin'),(7290251,'Berlin Wilmersdorf','DE',52.50097,13.29097,317190,42,'Europe/Berlin'),(7290252,'Berlin Spandau','DE',52.5511,13.19921,223862,35,'Europe/Berlin'),(7290253,'Berlin Tempelhof','DE',52.47693,13.41027,54629,50,'Europe/Berlin'),(7290254,'Berlin Schoeneberg','DE',52.48388,13.3477,116286,43,'Europe/Berlin'),(7310164,'San Tan Valley','US',33.1911,-111.528,81321,461,'America/Phoenix'),(7506758,'BloomingtonMn','US',44.84096,-93.29843,85172,251,'America/Chicago'),(7522530,'Marousi','GR',38.05404,23.806,69470,237,'Europe/Athens'),(7602078,'Ladner','CA',49.08938,-123.08241,200000,3,'America/Vancouver'),(7839240,'Enchanted Hills','US',35.33676,-106.59296,87521,1616,'America/Denver'),(8285534,'Fuencarral-El Pardo','ES',40.4984,-3.7314,220085,651,'Europe/Madrid'),(8285535,'Villa de Vallecas','ES',40.36695,-3.60146,65162,638,'Europe/Madrid'),(8299614,'Rossendale','GB',53.68456,-2.2769,67400,322,'Europe/London'),(8299617,'High Peak','GB',53.36797,-1.84536,92600,423,'Europe/London'),(8334616,'Mitte','DE',52.52131,13.39784,81205,34,'Europe/Berlin'),(8334617,'Pankow','DE',52.56715,13.41455,57113,45,'Europe/Berlin'),(8334618,'Reinickendorf','DE',52.57171,13.34525,75414,42,'Europe/Berlin'),(8334622,'Neu-Hohenschoenhausen','DE',52.56681,13.51255,53374,55,'Europe/Berlin'),(8354626,'Hamburg-Nord','DE',53.58935,9.984,280000,12,'Europe/Berlin');
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(49) CHARACTER SET utf8 DEFAULT NULL,
  `iso` char(2) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=136 DEFAULT CHARSET=latin1;

LOCK TABLES `languages` WRITE;
INSERT INTO `languages` VALUES (1,'English','en'),(2,'Afar','aa'),(3,'Abkhazian','ab'),(4,'Afrikaans','af'),(5,'Amharic','am'),(6,'Arabic','ar'),(7,'Assamese','as'),(8,'Aymara','ay'),(9,'Azerbaijani','az'),(10,'Bashkir','ba'),(11,'Belarusian','be'),(12,'Bulgarian','bg'),(13,'Bihari','bh'),(14,'Bislama','bi'),(15,'Bengali/Bangla','bn'),(16,'Tibetan','bo'),(17,'Breton','br'),(18,'Catalan','ca'),(19,'Corsican','co'),(20,'Czech','cs'),(21,'Welsh','cy'),(22,'Danish','da'),(23,'German','de'),(24,'Bhutani','dz'),(25,'Greek','el'),(26,'Esperanto','eo'),(27,'Spanish','es'),(28,'Estonian','et'),(29,'Basque','eu'),(30,'Persian','fa'),(31,'Finnish','fi'),(32,'Fiji','fj'),(33,'Faeroese','fo'),(34,'French','fr'),(35,'Frisian','fy'),(36,'Irish','ga'),(37,'Scots/Gaelic','gd'),(38,'Galician','gl'),(39,'Guarani','gn'),(40,'Gujarati','gu'),(41,'Hausa','ha'),(42,'Hindi','hi'),(43,'Croatian','hr'),(44,'Hungarian','hu'),(45,'Armenian','hy'),(46,'Interlingua','ia'),(47,'Interlingue','ie'),(48,'Inupiak','ik'),(49,'Indonesian','in'),(50,'Icelandic','is'),(51,'Italian','it'),(52,'Hebrew','iw'),(53,'Japanese','ja'),(54,'Yiddish','ji'),(55,'Javanese','jw'),(56,'Georgian','ka'),(57,'Kazakh','kk'),(58,'Greenlandic','kl'),(59,'Cambodian','km'),(60,'Kannada','kn'),(61,'Korean','ko'),(62,'Kashmiri','ks'),(63,'Kurdish','ku'),(64,'Kirghiz','ky'),(65,'Latin','la'),(66,'Lingala','ln'),(67,'Laothian','lo'),(68,'Lithuanian','lt'),(69,'Latvian/Lettish','lv'),(70,'Malagasy','mg'),(71,'Maori','mi'),(72,'Macedonian','mk'),(73,'Malayalam','ml'),(74,'Mongolian','mn'),(75,'Moldavian','mo'),(76,'Marathi','mr'),(77,'Malay','ms'),(78,'Maltese','mt'),(79,'Burmese','my'),(80,'Nauru','na'),(81,'Nepali','ne'),(82,'Dutch','nl'),(83,'Norwegian','no'),(84,'Occitan','oc'),(85,'(Afan)/Oromoor/Oriya','om'),(86,'Punjabi','pa'),(87,'Polish','pl'),(88,'Pashto/Pushto','ps'),(89,'Portuguese','pt'),(90,'Quechua','qu'),(91,'Rhaeto-Romance','rm'),(92,'Kirundi','rn'),(93,'Romanian','ro'),(94,'Russian','ru'),(95,'Kinyarwanda','rw'),(96,'Sanskrit','sa'),(97,'Sindhi','sd'),(98,'Sangro','sg'),(99,'Serbo-Croatian','sh'),(100,'Singhalese','si'),(101,'Slovak','sk'),(102,'Slovenian','sl'),(103,'Samoan','sm'),(104,'Shona','sn'),(105,'Somali','so'),(106,'Albanian','sq'),(107,'Serbian','sr'),(108,'Siswati','ss'),(109,'Sesotho','st'),(110,'Sundanese','su'),(111,'Swedish','sv'),(112,'Swahili','sw'),(113,'Tamil','ta'),(114,'Telugu','te'),(115,'Tajik','tg'),(116,'Thai','th'),(117,'Tigrinya','ti'),(118,'Turkmen','tk'),(119,'Tagalog','tl'),(120,'Setswana','tn'),(121,'Tonga','to'),(122,'Turkish','tr'),(123,'Tsonga','ts'),(124,'Tatar','tt'),(125,'Twi','tw'),(126,'Ukrainian','uk'),(127,'Urdu','ur'),(128,'Uzbek','uz'),(129,'Vietnamese','vi'),(130,'Volapuk','vo'),(131,'Wolof','wo'),(132,'Xhosa','xh'),(133,'Yoruba','yo'),(134,'Chinese','zh'),(135,'Zulu','zu');
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `UserID` int(11) NOT NULL,
  `FirstName` varchar(255) DEFAULT NULL,
  `LastName` varchar(255) DEFAULT NULL,
  `Address` varchar(255) DEFAULT NULL,
  `City` varchar(255) DEFAULT NULL,
  `Region` varchar(255) DEFAULT NULL,
  `Country` varchar(255) DEFAULT NULL,
  `Postal` varchar(255) DEFAULT NULL,
  `Phone` varchar(255) DEFAULT NULL,
  `Email` varchar(255) DEFAULT NULL,
  `Privacy` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`UserID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

LOCK TABLES `users` WRITE;
INSERT INTO `users` VALUES (1,'Luis','Goncalves','Av. Brigadeiro Faria Lima, 2170','Sao Jose dos Campos','SP','Brazil','12227-000','+55 (12) 3923-5555','luisg@embraer.com.br','1'),(2,'Leonie','Kohler','Theodor-Heuss-Strasse 34','Stuttgart',NULL,'Germany','70174','+49 0711 2842222','leonekohler@surfeu.de','1'),(3,'Bjorn','Hansen','Ullevalsveien 14','Oslo',NULL,'Norway','0171','+47 22 44 22 22','bjorn.hansen@yahoo.no','1'),(4,'Francois','Tremblay','1498 rue Belanger','Montreal','QC','Canada','H2G 1A7','+1 (514) 721-4711','ftremblay@gmail.com','1'),(5,'Frantisek','Wichterlova','Klanova 9/506','Prague',NULL,'Czech Republic','14700','+420 2 4172 5555','frantisekw@jetbrains.com','2'),(6,'Astrid','Gruber','Rotenturmstrasse 4, 1010 Innere Stadt','Vienna',NULL,'Austria','1010','+43 01 5134505','astrid.gruber@apple.at','1'),(7,'Helena','Holy','Rilska 3174/6','Prague',NULL,'Czech Republic','14300','+420 2 4177 0449','hholy@gmail.com','2'),(8,'Frank','Harris','1600 Amphitheatre Parkway','Mountain View','CA','USA','94043-1351','+1 (425) 882-8080','fharris@google.com','1'),(9,'Jack','Smith','1 Microsoft Way','Redmond','WA','USA','98052-8300','+1 (425) 882-8080','jacksmith@microsoft.com','2'),(10,'Michelle','Brooks','627 Broadway','New York','NY','USA','10012-2612','+1 (212) 221-3546','michelleb@aol.com','1'),(11,'Tim','Goyer','1 Infinite Loop','Cupertino','CA','USA','95014','+1 (408) 996-1010','tgoyer@apple.com','1'),(12,'Robert','Brown','796 Dundas Street West','Toronto','ON','Canada','M6J 1V1','+1 (416) 363-8888','robbrown@shaw.ca','2'),(13,'Edward','Francis','230 Elgin Street','Ottawa','ON','Canada','K2P 1L7','+1 (613) 234-3322','edfrancis@yachoo.ca','2'),(14,'Mark','Philips','8210 111 ST NW','Edmonto','AB','Canada','T6G 2C7','+1 (780) 434-4554','mphilips12@shaw.ca','1'),(15,'Martha','Silk','194A Chain Lake Drive','Halifax','NS','Canada','B3S 1C5','+1 (902) 450-0450','marthasilk@gmail.com','1'),(16,'Aaron','Mitchell','696 Osborne Street','Winnipeg','MB','Canada','R3L 2B9','+1 (204) 452-6452','aaronmitchell@yahoo.ca','2'),(17,'Ellie','Sullivan','5112 48 Street','Yellowknife','NT','Canada','X1A 1N6','+1 (867) 920-2233','ellie.sullivan@shaw.ca','2'),(18,'Joao','Fernandes','Rua da Assuncao 53','Lisbon',NULL,'Portugal',NULL,'+351 (213) 466-111','jfernandes@yahoo.pt','2'),(19,'Madalena','Sampaio','Rua dos Campeoes Europeus de Viena, 4350','Porto',NULL,'Portugal',NULL,'+351 (225) 022-448','masampaio@sapo.pt','2'),(20,'Hannah','Schneider','Tauentzienstrasse 8','Berlin',NULL,'Germany','10789','+49 030 26550280','hannah.schneider@yahoo.de','1'),(21,'Camille','Bernard','4, Rue Milton','Paris',NULL,'France','75009','+33 01 49 70 65 65','camille.bernard@yahoo.fr','1'),(22,'Isabelle','Mercier','68, Rue Jouvence','Dijon',NULL,'France','21000','+33 03 80 73 66 99','isabelle_mercier@apple.fr','1'),(23,'Emma','Jones','202 Hoxton Street','London',NULL,'United Kingdom','N1 5LH','+44 020 7707 0707','emma_jones@hotmail.com','1'),(24,'Phil','Hughes','113 Lupus St','London',NULL,'United Kingdom','SW1V 3EN','+44 020 7976 5722','phil.hughes@gmail.com','1'),(25,'Manoj','Pareek','12,Community Centre','Delhi',NULL,'India','110017','+91 0124 39883988','manoj.pareek@rediff.com','1'),(26,'Puja','Srivastava','3, Raj Bhavan Road','Bangalore',NULL,'India','560001','+91 080 22289999','puja_srivastava@yahoo.in','2'),(27,'Mark','Taylor','421 Bourke Street','Sidney','NSW','Australia','2010','+61 (02) 9332 3633','mark.taylor@yahoo.au','1'),(28,'Richard','Cunningham','2211 W Berry Street','Fort Worth','TX','USA','76110','+1 (817) 924-7272','ricunningham@hotmail.com','1'),(29,'Patrick','Gray','1033 N Park Ave','Tucson','AZ','USA','85719','+1 (520) 622-4200','patrick.gray@aol.com','2'),(30,'Terhi','Hamalainen','Porthaninkatu 9','Helsinki',NULL,'Finland','00530','+358 09 870 2000','terhi.hamalainen@apple.fi','2'),(31,'Stan','Wojcik','Ordynacka 10','Warsaw',NULL,'Poland','00-358','+48 22 828 37 39','stanisław.wojcik@wp.pl','1');
UNLOCK TABLES;

--
-- Table structure for table `userslogin`
--

DROP TABLE IF EXISTS `userslogin`;

CREATE TABLE `userslogin` (
  `UserID` int(11) NOT NULL AUTO_INCREMENT,
  `UserName` varchar(255) DEFAULT NULL,
  `Password` varchar(255) DEFAULT NULL,
  `Salt` varchar(100) DEFAULT NULL,
  `Password_sha256` varchar(100) DEFAULT NULL,
  `State` int(11) DEFAULT NULL,
  `DateJoined` datetime DEFAULT NULL,
  `DateLastModified` datetime DEFAULT NULL,
  PRIMARY KEY (`UserID`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;

LOCK TABLES `userslogin` WRITE;
INSERT INTO `userslogin` VALUES (1,'luisg@embraer.com.br','$2a$12$F.jpatdVlOnrYWLi/lxPNO90T0auUpFnDP5JTb3aTx7z1QSu5nX42','048d741e931f907110adf460816ff958','b7f054c4c6a92aeb1813ccf0b162cab31cdb9cad0a6cd3820a724f0819af20c',1,'2012-10-08 00:00:00','2018-11-15 00:00:00'),(2,'leonekohler@surfeu.de','$2a$12$o9lzPmLOFgpODyhYHUOXO.wojqkQph.fBZKO8k83hromrC0bC4TFi','9bce2f838034b8c8d2ba1220daef2e7e','b3efa8c9c09f76778fdd7f70b340c69a03d48861d2424bb5f4f4cd0d7ce11c06',1,'2012-08-22 00:00:00','2018-10-15 00:00:00'),(3,'ftremblay@gmail.com','$2a$12$QYTq9bIvZ/asycZCoh.GAOhsycshCzvEahXvXRrCczdqnGFdZ0XVS','c3a10800118c3bc6c50b1ac82d31e4a6','b8e62ee19ebbc23976b21e0820723405e27de1d4f2fd24e4e1f456c129cee82c',1,'2012-10-28 00:00:00','2018-11-16 00:00:00'),(4,'bjorn.hansen@yahoo.no','$2a$12$43FcE3LDDWlev12JkV4qae45LouL6pbXz/GeE4vSNT56OU1tAzdW2','d24e7731e8051cf253ca8e89e0dd0be9','e7a6803fc7d3db79780e300167aa8d05efebcffe5dba3a760f4f8eafe84a1af6',1,'2012-07-31 00:00:00','2018-08-14 00:00:00'),(5,'frantisekw@jetbrains.com','$2a$12$FbS.fUfQT9Aq9D8REtRx5udl4wKwxKwSuhgEe1Ef0EPcGDZoB8GCS','b3f2be95228f481bc544154fa77b56c6','c7c097bac3f74fb336965b98de2aa84afa6bae00651761be7277bc464869efce',1,'2012-08-06 00:00:00','2018-09-25 00:00:00'),(6,'hholy@gmail.com','$2a$12$TnZVOMj5H27JLk/IHtEsD.1cVrSuvToa9dAyM8QbENRXP74MVT5cm','231e1ed0db2b5dc8193ac7c78071aea4','62f5f09daf08a97ef8471d76ebf625bdaab121451bfd062d5a138bf04e30f8a1',1,'2012-11-01 00:00:00','2018-12-14 00:00:00'),(7,'astrid.gruber@apple.at','$2a$12$VWASiGnTzmFyqnv1j/WkaO5ihBDsQ/swN9ZkrooGkzxweGV/uft8K','7f9301cbee13b0afb7e7c79aa65c9483','ee3f23dcb0a13743fc84384ab46244b03ede2ee1bc56f6c77af906140fc78f94',1,'2012-06-05 00:00:00','2019-01-10 00:00:00'),(8,'fharris@google.com','$2a$12$R1vJzRYOg/SIW1yNyWEjCugGbBIC58fmxjjd.0ck1W6iWvrSBKGh6','1fc0e8b9a5704994608c34a189228f51','fb78347933ba30fd2ac53bd1d98581bbd612721f2ca177e87913c5a7773e6e40',1,'2012-09-25 00:00:00','2018-11-18 00:00:00'),(9,'jacksmith@microsoft.com','$2a$12$mWaauD2uy2oWG/9TO7nGvOSMZf44334WBjXJjOIzR9s66ziS3KuSq','1fc0e8b9a5704994608c34a189228f51','fb78347933ba30fd2ac53bd1d98581bbd612721f2ca177e87913c5a7773e6e40',1,'2012-11-16 00:00:00','2019-01-18 00:00:00'),(10,'michelleb@aol.com','$2a$12$Wb8L5KpmiYMDkh5dbPFM1OsyJMRhvZ0ZuidyOiudB9OX7qy6T/.I6','23a56dcf9c599bf803f2b7abf1db4b79','c46a4d121688f1fe18d23d35af64a74325255a4dbea07f6b18640ca055c54b68',1,'2012-12-07 00:00:00','2019-03-07 00:00:00'),(11,'tgoyer@apple.com','$2y$12$mgw9OzdYyB2zIXYGptdiHef7022jL.VLk.37oAodHyYA2Qd1nll4G','ea9f13c97a277bb3917b63a2a1234b39','746848aba0c93093bbba9dd75f41e687f1651b5888d06c10a21b65d80005e1ee',1,'2013-01-14 00:00:00','2019-04-19 00:00:00'),(12,'robbrown@shaw.ca','$2y$12$gdd2LeAoUr0hzE43MhCeJuOSOLoEB/o0G.tUYjr65cNUUCTbnM2Xe','23a56dcf9c599bf803f2b7abf1db4b79','c46a4d121688f1fe18d23d35af64a74325255a4dbea07f6b18640ca055c54b68',1,'2013-02-07 00:00:00','2019-06-11 00:00:00'),(13,'edfrancis@yachoo.ca','$2y$12$ZrtstCZGgKBbbC7kSFrQHOacz3blMEXQgTfpwv4GQyKG5pOSOsN/i','1fc0e8b9a5704994608c34a189228f51','fb78347933ba30fd2ac53bd1d98581bbd612721f2ca177e87913c5a7773e6e40',1,'2012-12-20 00:00:00','2019-01-11 00:00:00'),(14,'mphilips12@shaw.ca','$2a$12$F.jpatdVlOnrYWLi/lxPNO90T0auUpFnDP5JTb3aTx7z1QSu5nX42','7f9301cbee13b0afb7e7c79aa65c9483','ee3f23dcb0a13743fc84384ab46244b03ede2ee1bc56f6c77af906140fc78f94',1,'2012-05-21 00:00:00','2018-10-28 00:00:00'),(15,'marthasilk@gmail.com','$2y$12$uOsOiU5EUrsHxDlQuGSh9em/Dd8Sub9FDCPcshfdYdlGthwZUi9FW','231e1ed0db2b5dc8193ac7c78071aea4','62f5f09daf08a97ef8471d76ebf625bdaab121451bfd062d5a138bf04e30f8a1',1,'2012-11-17 00:00:00','2018-12-01 00:00:00'),(16,'aaronmitchell@yahoo.ca','$2y$12$xpmpbRqGQx4Oc0DWl6i27egN/hBRkIEA6sYQo4zbKLXyGJRNY6voO','b3f2be95228f481bc544154fa77b56c6','c7c097bac3f74fb336965b98de2aa84afa6bae00651761be7277bc464869efce',1,'2013-02-12 00:00:00','2019-03-21 00:00:00'),(17,'ellie.sullivan@shaw.ca','$2a$12$o9lzPmLOFgpODyhYHUOXO.wojqkQph.fBZKO8k83hromrC0bC4TFi','d24e7731e8051cf253ca8e89e0dd0be9','e7a6803fc7d3db79780e300167aa8d05efebcffe5dba3a760f4f8eafe84a1af6',1,'2012-09-10 00:00:00','2018-11-05 00:00:00'),(18,'jfernandes@yahoo.pt','$2a$12$FbS.fUfQT9Aq9D8REtRx5udl4wKwxKwSuhgEe1Ef0EPcGDZoB8GCS','9bce2f838034b8c8d2ba1220daef2e7e','b3efa8c9c09f76778fdd7f70b340c69a03d48861d2424bb5f4f4cd0d7ce11c06',1,'2012-08-27 00:00:00','2018-09-03 00:00:00'),(19,'masampaio@sapo.pt','$2a$12$Wb8L5KpmiYMDkh5dbPFM1OsyJMRhvZ0ZuidyOiudB9OX7qy6T/.I6','048d741e931f907110adf460816ff958','1b7f054c4c6a92aeb1813ccf0b162cab31cdb9cad0a6cd3820a724f0819af20c',1,'2012-07-29 00:00:00','2018-12-10 00:00:00'),(20,'hannah.schneider@yahoo.de','$2y$12$qzh6jvFIvGSKtSpr4SOBcuPgZ0N/zRfwTq594pV2oz59JQwGBEakW','c3a10800118c3bc6c50b1ac82d31e4a6','b8e62ee19ebbc23976b21e0820723405e27de1d4f2fd24e4e1f456c129cee82c',1,'2012-08-01 00:00:00','2018-11-02 00:00:00'),(21,'camille.bernard@yahoo.fr','$2a$12$o9lzPmLOFgpODyhYHUOXO.wojqkQph.fBZKO8k83hromrC0bC4TFi','ea9f13c97a277bb3917b63a2a1234b39','746848aba0c93093bbba9dd75f41e687f1651b5888d06c10a21b65d80005e1ee',1,'2012-10-29 00:00:00','2018-12-07 00:00:00'),(22,'isabelle_mercier@apple.fr','$2a$12$F.jpatdVlOnrYWLi/lxPNO90T0auUpFnDP5JTb3aTx7z1QSu5nX42','ea9f13c97a277bb3917b63a2a1234b39','746848aba0c93093bbba9dd75f41e687f1651b5888d06c10a21b65d80005e1ee',1,'2012-11-12 00:00:00','2019-01-21 00:00:00'),(23,'emma_jones@hotmail.com','$2y$12$uOsOiU5EUrsHxDlQuGSh9em/Dd8Sub9FDCPcshfdYdlGthwZUi9FW','23a56dcf9c599bf803f2b7abf1db4b79','c46a4d121688f1fe18d23d35af64a74325255a4dbea07f6b18640ca055c54b68',1,'2012-08-27 00:00:00','2018-10-29 00:00:00'),(24,'phil.hughes@gmail.com','$2y$12$ZhfTqJ3svu5zPT3/rxJko.fsw1Pt1mLyrMlQh5Wv.6AqE9bvWDxbm','1fc0e8b9a5704994608c34a189228f51','fb78347933ba30fd2ac53bd1d98581bbd612721f2ca177e87913c5a7773e6e40',1,'2012-07-24 00:00:00','2018-08-28 00:00:00'),(25,'manoj.pareek@rediff.com','$2a$12$TnZVOMj5H27JLk/IHtEsD.1cVrSuvToa9dAyM8QbENRXP74MVT5cm','231e1ed0db2b5dc8193ac7c78071aea4','62f5f09daf08a97ef8471d76ebf625bdaab121451bfd062d5a138bf04e30f8a1',1,'2012-09-07 00:00:00','2019-01-11 00:00:00'),(26,'puja_srivastava@yahoo.in','$2y$12$DnFhcTPWRs7maY.hr4ATVuJJ5fqbJL18JE7CceHQizLAchXEXcAPu','b3f2be95228f481bc544154fa77b56c6','c7c097bac3f74fb336965b98de2aa84afa6bae00651761be7277bc464869efce',1,'2013-02-01 00:00:00','2019-05-07 00:00:00'),(27,'mark.taylor@yahoo.au','$2y$12$l8QIBkyp/7mEYl.983P5l..H9DNsCY.LES4aBAYptS.UTJ5IqbHSK','d24e7731e8051cf253ca8e89e0dd0be9','e7a6803fc7d3db79780e300167aa8d05efebcffe5dba3a760f4f8eafe84a1af6',1,'2012-09-17 00:00:00','2018-11-06 00:00:00'),(28,'ricunningham@hotmail.com','$2y$12$lYIaYSjt3KqiZNSrTENGOushxHk9B1yMLkzK.N25bfF3C3h2lS7He','9bce2f838034b8c8d2ba1220daef2e7e','b3efa8c9c09f76778fdd7f70b340c69a03d48861d2424bb5f4f4cd0d7ce11c06',1,'2012-08-21 00:00:00','2018-11-10 00:00:00'),(29,'patrick.gray@aol.com','$2a$12$mWaauD2uy2oWG/9TO7nGvOSMZf44334WBjXJjOIzR9s66ziS3KuSq','048d741e931f907110adf460816ff958','1b7f054c4c6a92aeb1813ccf0b162cab31cdb9cad0a6cd3820a724f0819af20c',1,'2012-08-27 00:00:00','2018-08-30 00:00:00'),(30,'terhi.hamalainen@apple.fi','$2a$12$F.jpatdVlOnrYWLi/lxPNO90T0auUpFnDP5JTb3aTx7z1QSu5nX42','c3a10800118c3bc6c50b1ac82d31e4a6','b8e62ee19ebbc23976b21e0820723405e27de1d4f2fd24e4e1f456c129cee82c',1,'2013-01-24 00:00:00','2019-01-28 00:00:00'),(31,'stanisław.wójcik@wp.pl','$2y$12$uOsOiU5EUrsHxDlQuGSh9em/Dd8Sub9FDCPcshfdYdlGthwZUi9FW','7f9301cbee13b0afb7e7c79aa65c9483','ee3f23dcb0a13743fc84384ab46244b03ede2ee1bc56f6c77af906140fc78f94',1,'2012-11-25 00:00:00','2018-12-13 00:00:00');
UNLOCK TABLES;

--
-- Table structure for table `imagedetails`
--

DROP TABLE IF EXISTS `imagedetails`;

CREATE TABLE `imagedetails` (
  `ImageID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `UserID` int(11) DEFAULT '0',
  `Title` varchar(255) DEFAULT NULL,
  `Description` longtext,
  `Latitude` double DEFAULT NULL,
  `Longitude` double DEFAULT NULL,
  `CityCode` int(11) DEFAULT NULL,
  `CountryCodeISO` varchar(2) DEFAULT NULL,
  `ContinentCode` varchar(2) DEFAULT NULL,
  `Path` varchar(255) DEFAULT NULL,
  `Exif` longtext,
  `ActualCreator` varchar(256) DEFAULT NULL,
  `CreatorURL` varchar(256) DEFAULT NULL,
  `SourceURL` varchar(256) DEFAULT NULL,
  `Colors` longtext,
  PRIMARY KEY (`ImageID`),
  UNIQUE KEY `ImageID_UNIQUE` (`ImageID`),
  KEY `CityCode` (`CityCode`),
  KEY `ContinentCode` (`ContinentCode`),
  KEY `CountryCodeISO` (`CountryCodeISO`),
  KEY `UserID` (`UserID`)
) ENGINE=InnoDB AUTO_INCREMENT=149 DEFAULT CHARSET=utf8;

LOCK TABLES `imagedetails` WRITE;
INSERT INTO `imagedetails` VALUES (1,1,'Calgary Central Library','The Calgary Central Library, also known as the Calgary New Central Library (NCL), is a public library in Calgary, Alberta, Canada, and the flagship branch of the Calgary Public Library. It is located in the Downtown East Village neighborhood and opened on November 1, 2018, replacing the existing central branch in Downtown Calgary. The four-storey building cost $245 million to construct and was designed by American-Norwegian architecture firm Snøhetta and Canadian firm DIALOG after the two firms\' joint bid won a design competition in 2013. Their design features an oval-like form and an interior with a large central atrium with a skylight. The building is elevated one floor above street level to accommodate a light rail trackway below as well as a public plaza.',51.045325,-114.055394,5913490,'CA','NA','48844390243.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D810\", \"exposure_time\":\"1/40\", \"aperture\":\"1.8\", \"focal_length\":\"35.0\", \"iso\": 450 }','Robert Boschman','https://www.robertboschman.com/','','[ \"#332D26\", \"#615C5E\", \"#66502D\", \"#B09E86\", \"#D2CFD3\" ] '),(2,1,'Peace Bridge','Peace Bridge is a bridge that accommodates people walking and cycling across the Bow River in Calgary, Alberta, Canada. The bridge, designed by Spanish architect Santiago Calatrava, opened for use on March 24, 2012. The bridge was built by The City of Calgary to connect the southern Bow River pathway and Downtown Calgary with the northern Bow River pathway and the community of Sunnyside. This connection was designed to accommodate the increasing number of people commuting to and from work and those utilizing Calgary\'s pathways. The bridge is reportedly used by 6000 people a day and has ranked among the top 10 architectural projects in 2012 and among the top 10 public spaces of 2012',51.0486151,-114.0708459,5913490,'CA','NA','48844900556.jpg','','Denisse Leon','https://unsplash.com/@denisseleon','https://unsplash.com/photos/4ZPrc2__Kr0','[ \"#8E3533\", \"#FCFCF8\", \"#837E79\", \"#B1665F\", \"#5C1211\" ] '),(3,2,'The Bow','The Bow is a 158,000-square-metre (1,700,000 sq ft) office building for the headquarters of Encana Corporation and Cenovus Energy, in downtown Calgary, Alberta. The 236 metre (774 ft) building is currently the second tallest office tower in Calgary, since construction of Brookfield Place; and the third tallest in Canada outside Toronto. The Bow is also considered the start of redevelopment in Calgary\'s Downtown East Village. It was completed in 2012 and was ranked among the top 10 architectural projects in the world of that year according to Azure magazine.',51.04757167,-114.06207167,5913490,'CA','NA','48844533598.jpg','{ \"make\": \"Apple\", \"model\": \"iPhone X\", \"exposure_time\": \"1/2700\", \"aperture\": \"1.8\", \"focal_length\": \"4.0\", \"iso\": 25 }','Steph Smith','https://unsplash.com/@stephsmith','https://unsplash.com/photos/UACBRD8MUic','[ \"#82BCCF\", \"#A0D5E4\", \"#0C424A\", \"#353D3E\", \"#DCECF1\" ] '),(4,2,'National Music Centre','The National Music Centre is a non-profit museum and performance venue located in Calgary, Alberta, Canada. The centre\'s permanent building, branded Studio Bell, is located at 850 4th Street S.E. in Downtown East Village.',51.044408,-114.05301,5913490,'CA','NA','48844940962.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D810\", \"exposure_time\":\"1/40\", \"aperture\":\"1.8\", \"focal_length\":\"35.0\", \"iso\": 800 }','Robert Boschman','https://www.robertboschman.com/','','[ \"#2F2A28\", \"#060504\", \"#3F3734\", \"#A29899\", \"#C2BCCA\" ] '),(5,5,'Ascending Sulpher Mountain','First time using HDR with 2 stop bracketing composed in PhotoMatix Pro 4.1',51.149579,-115.559993,5892532,'CA','NA','6114904363.jpg','{ \"make\":\"Canon\", \"model\":\"Canon EOS 30D\", \"exposure_time\":\"1/1600\", \"aperture\":\"5.6\", \"focal_length\":\"64.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/6114904363','[ \"#3C422F\", \"#707370\", \"#0E140D\", \"#2F68A2\", \"#4A7FB2\" ] '),(6,5,'At top of Sulpher Mountain','Sulphur Mountain is a mountain in Banff National Park in the Canadian Rocky Mountains overlooking the town of Banff, Alberta, Canada. The mountain was named in 1916 for the hot springs on its lower slopes. George Dawson had referred to this landform as Terrace Mountain on his 1886 map of the area.',51.144571,-115.57467,5892532,'CA','NA','6115455110.JPG','{ \"make\":\"Canon\", \"model\":\"Canon EOS 30D\", \"exposure_time\":\"1/1250\", \"aperture\":\"5.6\", \"focal_length\":\"17.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/6115455110','[ \"#4F6A8B\", \"#7E93A7\", \"#68713A\", \"#36421E\", \"#BFC9D2\" ] '),(7,25,'Lunenburg Port','On board a small sailing ship leaving Lunenburg',44.373257,-64.307249,6062069,'CA','NA','5856697109.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/1000\", \"aperture\":\"4.0\", \"focal_length\":\"11.6\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/5856697109','[ \"#472B21\", \"#6A4E3E\", \"#D36D43\", \"#2D4772\", \"#CCCDBC\" ] '),(8,13,'Central United Church','Central United Church is a large, late nineteenth-century building on Cumberland Street, across from the Town Square, that has become a landmark in the Old Town Heritage Conservation District of Lunenburg, N.S. ',44.377596,-64.309123,6062069,'CA','NA','5856658791.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/640\", \"aperture\":\"4.0\", \"focal_length\":\"6.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/5856658791','[ \"#01798A\", \"#432E27\", \"#0FA5A9\", \"#5F4B3A\", \"#6DBAAC\" ] '),(9,11,'Peggy\'s Cove','Peggy\'s Cove is a small rural community located on the eastern shore of St. Margarets Bay in Nova Scotia\'s Halifax Regional Municipality, which is the site of Peggys Point Lighthouse (established 1868).',44.491558,-63.91379,5935277,'CA','NA','5856616479.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/250\", \"aperture\":\"4.0\", \"focal_length\":\"9.1\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/5856616479','[ \"#D1D7D9\", \"#0C0C04\", \"#ABABA2\", \"#3B420F\", \"#6E7D17\" ] '),(10,13,'Near Peggy\'s Cove','An interesting pile of junk',44.492859,-63.916676,5935277,'CA','NA','5856654945.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/250\", \"aperture\":\"4.0\", \"focal_length\":\"9.1\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/5856654945','[ \"#633E12\", \"#E5E8DD\", \"#AB8439\", \"#9BB7B0\", \"#2B7393\" ] '),(11,11,'Annapolis Royal','Outside the Fort Anne National Historic Site and Museum',44.741658,-65.519307,5939236,'CA','NA','5857298322.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/200\", \"aperture\":\"4.0\", \"focal_length\":\"24.5\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/5857295224','[ \"#4E4A0C\", \"#C7CED0\", \"#FAE7C2\", \"#BACBD8\", \"#655616\" ] '),(12,25,'Peace Bridge at Night','Peace Bridge is a bridge that accommodates people walking and cycling across the Bow River in Calgary, Alberta, Canada. The bridge, designed by Spanish architect Santiago Calatrava, opened for use on March 24, 2012. The bridge was built by The City of Calgary to connect the southern Bow River pathway and Downtown Calgary with the northern Bow River pathway and the community of Sunnyside. This connection was designed to accommodate the increasing number of people commuting to and from work and those utilizing Calgary\'s pathways. The bridge is reportedly used by 6000 people a day and has ranked among the top 10 architectural projects in 2012 and among the top 10 public spaces of 2012',51.054197,-114.079321,5913490,'CA','NA','48848276841.jpg','{ \"make\": \"NIKON CORPORATION\", \"model\": \"NIKON D5500\", \"exposure_time\": \"1/125\", \"aperture\": \"7.1\", \"focal_length\": \"13.0\", \"iso\": 2500}','Riley Sharp','https://unsplash.com/@rileysharp_','https://unsplash.com/photos/do7TsnMD3Kw','[ \"#26303C\", \"#08080A\", \"#1F0809\", \"#7B8176\", \"#E7F3F2\" ] '),(13,5,'Central Park','Conservatory Pond in Central Park New York',40.773684,-73.96701,5128581,'US','NA','48847989166.jpg','{ \"make\": \"Canon\", \"model\": \"Canon EOS 5D Mark II\", \"exposure_time\": \"1/800\", \"aperture\": \"4.0\", \"focal_length\": \"35.0\", \"iso\": 100 }','Josh Couch','https://unsplash.com/@joshcouchdesign','https://unsplash.com/photos/qjN-uw6YibY','[ \"#7A99AD\", \"#4E331C\", \"#C0C6C2\", \"#8D501C\", \"#A77A4B\" ] '),(14,5,'Rockefeller Center','Rockefeller Center is a large complex consisting of 19 commercial buildings covering 22 acres (89,000 m2) between 48th and 51st Streets, facing Fifth Avenue in Midtown Manhattan, New York City. The 14 original Art Deco buildings, commissioned by the Rockefeller family, span the area between Fifth and Sixth Avenues, split by a large sunken square and a private street called Rockefeller Plaza. Five International Style buildings, built later, are located on the west side of Sixth Avenue and at the north end of Rockefeller Plaza.',40.758713,-73.978731,5128581,'US','NA','48848180977.jpg','','ben o\'bro','https://unsplash.com/@benobro','https://unsplash.com/photos/wpU4veNGnHg','[ \"#6D5142\", \"#66B5C2\", \"#96BBC3\", \"#C1A186\", \"#0AB4C9\" ] '),(15,9,'Albert Hall','Him rendered may attended concerns jennings reserved now. Sympathize did now preference unpleasing mrs few. Mrs for hour game room want are fond dare. For detract charmed add talking age. Shy resolution instrument unreserved man few. She did open find pain some out. If we landlord stanhill mr whatever pleasure supplied concerns so. Exquisite by it admitting cordially september newspaper an. Acceptance middletons am it favourable. It it oh happen lovers afraid. \r\nSociety excited by cottage private an it esteems. Fully begin on by wound an. Girl rich in do up or both. At declared in as rejoiced of together. He impression collecting delightful unpleasant by prosperous as on. End too talent she object mrs wanted remove giving.',51.500241,-0.177273,2643743,'GB','EU','5855174537.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/1600\", \"aperture\":\"2.7\", \"focal_length\":\"7.2\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/5855174537','[ \"#BE9C73\", \"#DFC292\", \"#81B9DB\", \"#6C4437\", \"#F3EBCF\" ] '),(16,9,'Emirates Stadium','Home to Arsenal FC',51.556309,-0.107846,2643743,'GB','EU','5855735700.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/640\", \"aperture\":\"4.0\", \"focal_length\":\"6.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/5855735700','[ \"#E5AA98\", \"#0F8084\", \"#060E13\", \"#60C4D7\", \"#0E414F\" ] '),(17,27,'Westminister Abbey','Westminster Abbey, formally titled the Collegiate Church of Saint Peter at Westminster, is a large, mainly Gothic abbey church in the City of Westminster, London, England, just to the west of the Palace of Westminster. It is one of the United Kingdom\'s most notable religious buildings and the traditional place of coronation and burial site for English and, later, British monarchs. The building itself was a Benedictine monastic church until the monastery was dissolved in 1539. Between 1540 and 1556, the abbey had the status of a cathedral. Since 1560, the building is no longer an abbey or a cathedral, having instead the status of a Church of England \"Royal Peculiar\"—a church responsible directly to the sovereign.',51.49963,-0.128708,2643743,'GB','EU','5855191275.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/1000\", \"aperture\":\"4.0\", \"focal_length\":\"35.4\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/5855191275','[ \"#59532E\", \"#F4F4E6\", \"#BAD9F3\", \"#C6BF9C\", \"#0B7CCE\" ] '),(18,27,'Wellington\'s Arch','The top of Wellington\'s Arch has this sculptural grouping',51.502572,-0.150869,2643743,'GB','EU','5855752464.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/1000\", \"aperture\":\"4.0\", \"focal_length\":\"35.4\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/5855752464','[ \"#F1F5F7\", \"#080705\", \"#D2E0E9\", \"#98825D\", \"#AFC7D9\" ] '),(19,27,'British Museum','The library in the British Museum in London',51.519148,-0.126826,2643743,'GB','EU','5855729828.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/400\", \"aperture\":\"4.0\", \"focal_length\":\"6.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/5855729828','[ \"#BBC798\", \"#D3DAA6\", \"#342A24\", \"#504839\", \"#716D50\" ] '),(20,28,'Lewes Castle','Lewes Castle is a medieval castle in the town of Lewes in East Sussex, England. Originally called Bray Castle, it occupies a commanding position guarding the gap in the South Downs cut by the River Ouse and occupied by the towns of Lewes and Cliffe.',50.915115,0.485893,2656161,'GB','EU','5855774224.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/1000\", \"aperture\":\"4.0\", \"focal_length\":\"11.6\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/5855221959','[ \"#011C85\", \"#D5C4A4\", \"#8F7656\", \"#F0E8D7\", \"#0260F1\" ] '),(21,28,'Lewes Castle','Built in 1069, the castle has a tremendous view of the town of Lewes and the surrounding countryside.',50.872726,0.008259,2644559,'GB','EU','5855221959.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/640\", \"aperture\":\"4.0\", \"focal_length\":\"6.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/5855221959','[ \"#3C3829\", \"#D2EBF8\", \"#F9FDFD\", \"#12110A\", \"#7F745C\" ]'),(22,18,'View of Cologne','View of Cologne from atop the Cologne Cathedral',50.941149,6.957358,2886242,'DE','EU','6114850721.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/1000\", \"aperture\":\"4.0\", \"focal_length\":\"8.3\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/6114850721','[ \"#2C130D\", \"#F1EFE5\", \"#4B3227\", \"#635445\", \"#837D67\" ] '),(23,18,'Prinz-Georg Garten','The palace is in the Rococo style, made for Prince Georg William. Friedrich Ludwig von Sckell was involved with the design of the informal garden.',49.87872,8.654719,2938913,'DE','EU','6114859969.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/1600\", \"aperture\":\"2.7\", \"focal_length\":\"6.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/6114859969','[ \"#381C12\", \"#5E4225\", \"#016182\", \"#084157\", \"#B5C5B6\" ] '),(24,20,'Downtown Frankfurt','Downtown Frankfurt from the Frankfurt Cathedral',50.110647,8.684955,2925533,'DE','EU','6114960821.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/60\", \"aperture\":\"3.5\", \"focal_length\":\"20.7\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/6114960821','[ \"#E5D6E3\", \"#FAF8FA\", \"#6A6164\", \"#DDA96A\", \"#C0B0B0\" ] '),(25,10,'Brandenburg Gate, Berlin','The Brandenburg Gate is an 18th-century neoclassical monument in Berlin, built on the orders of Prussian king Frederick William II after the (temporarily) successful restoration of order during the early Batavian Revolution. One of the best-known landmarks of Germany, it was built on the site of a former city gate that marked the start of the road from Berlin to the town of Brandenburg an der Havel, which used to be capital of the Margraviate of Brandenburg. It is located in the western part of the city centre of Berlin within Mitte, at the junction of Unter den Linden and Ebertstraße, immediately west of the Pariser Platz. One block to the north stands the Reichstag building, which houses the German parliament (Bundestag). The gate is the monumental entry to Unter den Linden, the renowned boulevard of linden trees, which led directly to the royal City Palace of the Prussian monarchs.',52.516239,13.377214,2950159,'DE','EU','6114881215.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/1600\", \"aperture\":\"2.7\", \"focal_length\":\"6.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/6114881215','[ \"#080101\", \"#2D0904\", \"#4B200E\", \"#E9E4D2\", \"#D5CEB5\" ] '),(26,10,'Outside the Berliner Dom','Sense child do state to defer mr of forty. Become latter but nor abroad wisdom waited. Was delivered gentleman acuteness but daughters. In as of whole as match asked. Pleasure exertion put add entrance distance drawings. In equally matters showing greatly it as. Want name any wise are able park when. Saw vicinity judgment remember finished men throwing.',52.519255,13.399552,2950159,'DE','EU','6115603234.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/800\", \"aperture\":\"3.2\", \"focal_length\":\"9.5\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/6115603234','[ \"#4C2610\", \"#2B0F05\", \"#654326\", \"#DCD9D3\", \"#B6A076\" ] '),(27,10,'New National Gallery, Berlin','Exterior of the Mies van der Rohe designed New National Gallery',52.506482,13.367899,2950159,'DE','EU','6114867983.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/80\", \"aperture\":\"4.0\", \"focal_length\":\"6.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/6114867983','[ \"#060201\", \"#502B14\", \"#F8F8F7\", \"#64462A\", \"#E2E2D3\" ] '),(28,10,'Checkpoint Charlie','Checkpoint Charlie (or \"Checkpoint C\") was the name given by the Western Allies to the best-known Berlin Wall crossing point between East Berlin and West Berlin during the Cold War (1947–1991). East German leader Walter Ulbricht agitated and maneuvered to get the Soviet Union\'s permission to construct the Berlin Wall in 1961 to stop Eastern Bloc emigration and defection westward through the Soviet border system, preventing escape across the city sector border from communist East Berlin into West Berlin. Checkpoint Charlie became a symbol of the Cold War, representing the separation of East and West. Soviet and American tanks briefly faced each other at the location during the Berlin Crisis of 1961. After the dissolution of the Eastern Bloc and the reunification of Germany, the building at Checkpoint Charlie became a tourist attraction. ',52.507324,13.390419,2950159,'DE','EU','6115548152.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/800\", \"aperture\":\"3.2\", \"focal_length\":\"9.5\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly',NULL,'[ \"#0E130F\", \"#AFB4B2\", \"#535B57\", \"#32352D\", \"#999A93\" ] '),(29,29,'Plaza de Cibeles, Madrid','The Plaza de Cibeles is a square with a neo-classical complex of marble sculptures with fountains that has become an iconic symbol for the city of Madrid. It sits at the intersection of Calle de Alcala (running from east to west), Paseo de Recoletos (to the North) and Paseo del Prado (to the south). Plaza de Cibeles was originally named Plaza de Madrid, but in 1900, the City Council named it Plaza de Castelar, which was eventually replaced by its current name.',40.419098,-3.692452,3117735,'ES','EU','5855209453.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/60\", \"aperture\":\"3.5\", \"focal_length\":\"6.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/5855209453','[ \"#F5F8F6\", \"#030302\", \"#CCC7BB\", \"#62584B\", \"#332C23\" ] '),(30,29,'Santiago Bernabeu, Madrid','Home stadium for Real Madrid',40.452891,-3.689813,3117735,'ES','EU','5855213165.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/320\", \"aperture\":\"4.0\", \"focal_length\":\"25.2\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/5855213165','[ \"#CBE5ED\", \"#AA9B7D\", \"#6F5955\", \"#C6BEA1\", \"#21131A\" ] '),(31,30,'Paradise Island in Nassau','Photographed from Atlantis Bridge; Paradise Island in Nassau, Bahamas',25.077709,-77.324127,3571824,'BS','NA','6119127716.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/200\", \"aperture\":\"4.0\", \"focal_length\":\"6.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly',NULL,'[ \"#C8D1BD\", \"#9BC9C8\", \"#6DB5C0\", \"#6C5B53\", \"#0F4661\" ] '),(32,30,'Castaway Cay, South Abaco','Castaway Cay is a private island in the Bahamas which serves as an exclusive port for the Disney Cruise Line ships. It is located near Great Abaco Island and was formerly known as Gorda Cay.',26.082139,-77.536223,3571824,'BS','NA','6119130918.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/200\", \"aperture\":\"4.0\", \"focal_length\":\"6.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly',NULL,'[ \"#4CC8DB\", \"#07B5D4\", \"#757146\", \"#424829\", \"#A29A72\" ] '),(33,6,'Disney Coronado Resort','Set beside man-made Lago Dorado, this Spanish colonial-themed resort is 3 miles from Disney\'s Animal Kingdom and 22 miles from Orlando International Airport. ',28.365272,-81.572183,4167147,'US','NA','6119143988.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S3 IS\", \"exposure_time\":\"1/200\", \"aperture\":\"4.0\", \"focal_length\":\"6.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/6119143988','[ \"#BCCEE2\", \"#221F15\", \"#E7EEF0\", \"#9E5716\", \"#EE9947\" ] '),(34,3,'Beach in Ghana','Passage its ten led hearted removal cordial. Preference any astonished unreserved mrs. Prosperous understood middletons in conviction an uncommonly do. Supposing so be resolving breakfast am or perfectly. Is drew am hill from mr. Valley by oh twenty direct me so. Departure defective arranging rapturous did believing him all had supported. Family months lasted simple set nature vulgar him. Picture for attempt joy excited ten carried manners talking how. Suspicion neglected he resolving agreement perceived at an.',5.101961,-1.253407,2302357,'GH','AF','8152043422.jpg',NULL,'Alex Connolly',NULL,NULL,'[ \"#7CAFDD\", \"#9AB0C3\", \"#5B8CAA\", \"#3A5258\", \"#8BB4D7\" ] '),(35,3,'Beach in Ghana','Breakfast procuring nay end happiness allowance assurance frankness. Met simplicity nor difficulty unreserved who. Entreaties mr conviction dissimilar me astonished estimating cultivated. On no applauded exquisite my additions. Pronounce add boy estimable nay suspected. You sudden nay elinor thirty esteem temper. Quiet leave shy you gay off asked large style.',5.101961,-1.253407,2302357,'GH','AF','8152016381.jpg',NULL,'Alex Connolly',NULL,NULL,'[ \"#8E8974\", \"#A6BDCD\", \"#BDF9FB\", \"#7C7725\", \"#3B3B1A\" ] '),(36,3,'Cape Coast','Silent sir say desire fat him letter. Whatever settling goodness too and honoured she building answered her. Strongly thoughts remember mr to do consider debating. Spirits musical behaved on we he farther letters. Repulsive he he as deficient newspaper dashwoods we. Discovered her his pianoforte insipidity entreaties. Began he at terms meant as fancy. Breakfast arranging he if furniture we described on. Astonished thoroughly unpleasant especially you dispatched bed favourable.',5.104149,-1.240446,2302357,'GH','AF','8152045688.jpg',NULL,'Alex Connolly',NULL,NULL,'[ \"#D8E1E6\", \"#646252\", \"#7E7B6A\", \"#EBF0F3\", \"#28271C\" ] '),(37,16,'Pyramid','On the Giza Plateau.',29.977717,31.13287,360630,'EG','AF','48860768611.jpg','{ \"make\": \"NIKON CORPORATION\",\"model\": \"NIKON D3200\",\"exposure_time\": \"1/640\",\"aperture\": \"5.6\",\"focal_length\": \"17.0\",\"iso\": 100 }','Adrian Dascal','ttps://unsplash.com/@dascal','https://unsplash.com/photos/27a_s3DdbVc','[ \"#7E5E4C\", \"#967560\", \"#90B7BD\", \"#83ADB5\", \"#A2B8B9\" ] '),(38,3,'Cape Coast','Full he none no side. Uncommonly surrounded considered for him are its. It we is read good soon. My to considered delightful invitation announcing of no decisively boisterous. Did add dashwoods deficient man concluded additions resources. Or landlord packages overcame distance smallest in recurred. Wrong maids or be asked no on enjoy. Household few sometimes out attending described. Lain just fact four of am meet high.',5.103367,-1.241535,2302357,'GH','AF','8152020963.jpg',NULL,'Alex Connolly',NULL,NULL,'[ \"#9DAAAF\", \"#F2FDFD\", \"#DFF1F7\", \"#413D2B\", \"#AEBABE\" ] '),(39,3,'Accra','Are sentiments apartments decisively the especially alteration. Thrown shy denote ten ladies though ask saw. Or by to he going think order event music. Incommode so intention defective at convinced. Led income months itself and houses you. After nor you leave might share court balls.',5.603717,-0.186964,2306104,'GH','AF','8152048712.jpg',NULL,'Alex Connolly',NULL,NULL,'[ \"#A8B4BA\", \"#9B9989\", \"#7E7E71\", \"#423E34\", \"#946034\" ] '),(40,27,'Mausoleo di Galla Placidia','The Mausoleum of Galla Placidia is a Roman building in Ravenna, Italy. It was listed with seven other structures in Ravenna in the World Heritage List in 1996. The UNESCO experts describe it as \"the earliest and best preserved of all mosaic monuments, and at the same time one of the most artistically perfect\". The interior of the mausoleum is covered with rich Byzantine mosaics, and light enters through alabaster window panels. The inside contains two famous mosaic lunettes, and the rest of the interior is filled with mosaics of Christian and Apocalyptic symbols.',44.420788,12.196555,3169561,'IT','EU','48833316971.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D7200\", \"exposure_time\":\"1/400\", \"aperture\":\"16.0\", \"focal_length\":\"13.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/48833316971','[ \"#6A6860\", \"#0271B2\", \"#827F76\", \"#3B3833\", \"#5989A7\" ] '),(41,27,'Bologna Tracks','Bologna looking towards the central train station from the Strada Statale Porrettana',44.504041,11.353663,3181928,'IT','EU','48833317116.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D7200\", \"exposure_time\":\"1/400\", \"aperture\":\"6.3\", \"focal_length\":\"35.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/48833317116','[ \"#2C2B22\", \"#F7F5EC\", \"#EEEADB\", \"#7A7568\", \"#AEA694\" ] '),(42,17,'Verona Building Art','Verona Building Art',45.442871,10.997508,3164527,'IT','EU','9493997865.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/160\", \"aperture\":\"5.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9493997865','[ \"#987C63\", \"#E3DDD7\", \"#493624\", \"#84B5DA\", \"#B59C86\" ] '),(43,17,'Verona Ponte Scaligero','The Castel Vecchio Bridge or Scaliger Bridge is a fortified bridge in Verona, northern Italy, over the Adige River. The segmental arch bridge featured the world\'s largest span at the time of its construction.',45.441069,10.987755,3164527,'IT','EU','9496787858.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/320\", \"aperture\":\"7.1\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9496787858','[ \"#6F6C6B\", \"#40342D\", \"#A5A6AA\", \"#5F7D9F\", \"#CFC8C4\" ] '),(44,17,'Verona Piazza Bra at Night','Piazza Bra, often shortened to Bra, is the largest piazza in Verona, Italy, with some claims that it is the largest in the country. The piazza is lined with numerous cafés and restaurants, along with several notable buildings.',45.438794,10.993353,3164527,'IT','EU','9496792166.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/20\", \"aperture\":\"3.5\", \"focal_length\":\"14.0\", \"iso\": 3200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9496792166','[ \"#030303\", \"#36250E\", \"#965C0C\", \"#B78E4B\", \"#6E4B1C\" ] '),(45,17,'Verona','Near Ponte Nuovo',45.443997,11.000893,3164527,'IT','EU','9496799098.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/320\", \"aperture\":\"10.0\", \"focal_length\":\"31.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9496799098','[ \"#979688\", \"#494D31\", \"#356399\", \"#846C4F\", \"#E1B086\" ] '),(46,17,'Prato della Valle','Prato della Valle is a 90,000 square meter elliptical square in Padova, Italy. It is the largest square in Italy, and one of the largest in Europe. Today, the square is a large space with a green island at the center, l\'Isola Memmia, surrounded by a small canal bordered by two rings of statues.',45.398611,11.875797,3171728,'IT','EU','9494282329.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/4000\", \"aperture\":\"18.0\", \"focal_length\":\"14.0\", \"iso\": 6400 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9494282329','[ \"#40668E\", \"#869CAE\", \"#676B54\", \"#BFB7AE\", \"#424634\" ] '),(47,8,'St Marks Square in Venice','Piazza San Marco, often known in English as St Mark\'s Square, is the principal public square of Venice, Italy, where it is generally known just as la Piazza. All other urban spaces in the city are called campi. The Piazzetta is an extension of the Piazza towards San Marco basin in its south east corner',45.434233,12.338693,3164603,'IT','EU','9494475161.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/400\", \"aperture\":\"9.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9494475161','[ \"#A27B6B\", \"#EAE4E1\", \"#7D5751\", \"#553333\", \"#9C868C\" ] '),(48,8,'Santa Maria della Salute, Venice','Santa Maria della Salute, commonly known simply as the Salute, is a Roman Catholic church and minor basilica located at Punta della Dogana in the Dorsoduro sestiere of the city of Venice, Italy. It stands on the narrow finger of Punta della Dogana, between the Grand Canal and the Giudecca Canal, at the Bacino di San Marco, making the church visible when entering the Piazza San Marco from the water. The Salute is part of the parish of the Gesuati and is the most recent of the so-called plague churches. The dome of the Salute was an important addition to the Venice skyline and soon became emblematic of the city, inspiring artists like Canaletto, J. M. W. Turner, John Singer Sargent, and the Venetian artist Francesco Guardi.',45.431003,12.334766,3164603,'IT','EU','9494472443.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/400\", \"aperture\":\"8.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9494472443','[ \"#73614C\", \"#867767\", \"#BAA591\", \"#161109\", \"#F1DCC6\" ] '),(49,8,'Venice View From Ponte di Rialto','The Rialto Bridge (Italian: Ponte di Rialto; Venetian: Ponte de Rialto) is the oldest of the four bridges spanning the Grand Canal in Venice, Italy. Connecting the sestieri (districts) of San Marco and San Polo, it has been rebuilt several times since its first construction as a pontoon bridge in the 12th century, and is now a significant tourist attraction in the city. The Grand Canal forms one of the major water-traffic corridors in the city. One end of the canal leads into the lagoon near the Santa Lucia railway station and the other end leads into the basin at San Marco; in between, it makes a large reverse-S shape through the central districts (sestieri) of Venice. It is 3.8 km (2.4 mi) long, and 30 to 90 m (98 to 295 ft) wide, with an average depth of 5 metres (16 feet).',45.437975,12.335871,3164603,'IT','EU','9494464567.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/400\", \"aperture\":\"9.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9494464567','[ \"#CFC4BC\", \"#918884\", \"#E6E0D8\", \"#4E6079\", \"#39322C\" ] '),(50,8,'Palazzo Tiepolo Passi','The Palazzo Tiepolo Passi is a Venetian Gothic-style palace located between the Palazzo Giustinian Persico and the Palazzo Soranzo Pisani on the Grand Canal, in the Sestieri of San Polo, Venice, Italy. The neighboring building is Palazzo Soranzo Pisani. The narrow asymmetric palace was commissioned in the 14th century. It has undergone modern refurbishment.',45.435124,12.328055,3164603,'IT','EU','9494470337.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/500\", \"aperture\":\"9.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9494470337','[ \"#747160\", \"#36476E\", \"#654930\", \"#C3683C\", \"#838BAA\" ] '),(51,8,'Montepulciano','Montepulciano is a medieval hilltop town in Tuscany, Italy. Surrounded by vineyards, it’s known for its vino nobile red wine. The Torre di Pulcinella is a clock tower topped by a figure of the Pulcinella, a commedia dell’arte character. On the Piazza Grande is the 14th-century Palazzo Comunale, with a tower offering views of the surrounding countryside. Also here is the Duomo, with a huge triptych above its altar.',43.092535,11.782022,3172794,'IT','EU','9496560520.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/160\", \"aperture\":\"6.3\", \"focal_length\":\"23.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9496560520','[ \"#CBCAC9\", \"#59453A\", \"#3C3029\", \"#E7A98E\", \"#476581\" ] '),(52,17,'Arch of Constantine','The Arch of Constantine is a triumphal arch in Rome, situated between the Colosseum and the Palatine Hill. It was erected by the Roman Senate to commemorate Constantine I\'s victory over Maxentius at the Battle of Milvian Bridge in 312. Dedicated in 315, it is the largest Roman triumphal arch.',41.88983,12.490873,3169070,'IT','EU','9498368556.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/400\", \"aperture\":\"8.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9498368556','[ \"#AA9E97\", \"#B6C6D7\", \"#749CCC\", \"#AE9963\", \"#524F44\" ] '),(53,17,'Inside the Colosseum','View from within the The Colosseum or Coliseum, an oval amphitheatre in the centre of the city of Rome, Italy. Built of travertine limestone, tuff (volcanic rock), and brick-faced concrete, it was the largest amphitheatre ever built at the time and held 50,000 spectators. The Colosseum is situated just east of the Roman Forum. Construction began under the emperor Vespasian in AD 72 and was completed in AD 80 under his successor and heir, Titus. Further modifications were made during the reign of Domitian (81–96). These three emperors are known as the Flavian dynasty, and the amphitheatre was named in Latin for its association with their family name ',41.890332,12.49181,3169070,'IT','EU','9495571869.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/400\", \"aperture\":\"8.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9495571869','[ \"#916244\", \"#6C4833\", \"#452F22\", \"#8E99B6\", \"#EABE9B\" ] '),(54,17,'Arch of Septimus Severus','The Arch of Septimius Severus at the northwest end of the Roman Forum is a white marble triumphal arch dedicated in 203 to commemorate the Parthian victories of Emperor Septimius Severus and his two sons, Caracalla and Geta, in the two campaigns against the Parthians of 194/195 and 197–199.',41.892949,12.484972,3169070,'IT','EU','9495574327.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/400\", \"aperture\":\"8.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9495574327','[ \"#4D3C2F\", \"#B29479\", \"#E4C9AF\", \"#02488D\", \"#0A72C3\" ] '),(55,17,'Palatine Hill','Walking up the via di San Gregorio side of the Hill',41.887437,12.48866,3169070,'IT','EU','9498381010.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/400\", \"aperture\":\"8.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9498381010','[ \"#4D4F29\", \"#787342\", \"#9E8F63\", \"#6C94CA\", \"#4C7EBA\" ] '),(56,17,'From St. Peters','Out believe has request not how comfort evident. Up delight cousins we feeling minutes. Genius has looked end piqued spring. Down has rose feel find man. Learning day desirous informed expenses material returned six the. She enabled invited exposed him another. Reasonably conviction solicitude me mr at discretion reasonable. Age out full gate bed day lose.',41.902172,12.456098,3169070,'IT','EU','9498386718.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/200\", \"aperture\":\"6.3\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9498386718','[ \"#6B5C4F\", \"#948476\", \"#B2987F\", \"#3D3329\", \"#D8B797\" ] '),(57,4,'Temple of Asclepius','In the Villa Borghese Park',41.914541,12.483443,3169070,'IT','EU','9498388516.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/200\", \"aperture\":\"6.3\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9498388516','[ \"#021432\", \"#022555\", \"#3E3E13\", \"#6A611E\", \"#265A91\" ] '),(58,22,'Florence Duomo','Photo taken from the Campanile. The Florence Cathedral, formally the Cattedrale di Santa Maria del Fiore, is the cathedral of Florence, Italy. It was begun in 1296 in the Gothic style to a design of Arnolfo di Cambio and was structurally completed by 1436, with the dome designed by Filippo Brunelleschi.',43.772801,11.255673,3176959,'IT','EU','9498358806.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/400\", \"aperture\":\"10.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9498358806','[ \"#5F3E26\", \"#926543\", \"#6371AE\", \"#DCCDC9\", \"#3B4F85\" ] '),(59,22,'Orpheus Fountain, Florence','In the garden of Palazzo Vivarelli Colonna',43.76964,11.266535,3176959,'IT','EU','9504606628.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/250\", \"aperture\":\"6.3\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9504606628','[ \"#CEBC9E\", \"#54502D\", \"#837550\", \"#6994CF\", \"#477FC2\" ] '),(60,22,'Pazzi Chapel at Santa Croce','By Filippo Brunelleschi, the chapel is considered to be one of the masterpieces of Renaissance architecture. It is located in the first cloister of the Basilica di Santa Croce.',43.768234,11.262212,3176959,'IT','EU','9504609042.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/2000\", \"aperture\":\"11.0\", \"focal_length\":\"14.0\", \"iso\": 3200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9504609042','[ \"#575235\", \"#8E7D58\", \"#C6AB80\", \"#EADCC6\", \"#6B88AD\" ] '),(61,12,'Palazzo Strozzi, Florence','The construction of the palace was begun in 1489 by Benedetto da Maiano, for Filippo Strozzi the Elder, a rival of the Medici who had returned to the city in November 1466 and desired the most magnificent palace to assert his family\'s continued prominence and, perhaps more important, a political statement of his own status. A great number of other buildings were acquired during the 1470s and demolished to provide enough space for the new construction. Giuliano da Sangallo provided a wood model of the design. Filippo Strozzi died in 1491, long before the construction\'s completion in 1538. Duke Cosimo I de\' Medici confiscated it in the same year, not returning it to the Strozzi family until thirty years later.',43.771339,11.251678,3176959,'IT','EU','9504613978.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/160\", \"aperture\":\"5.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9504613978','[ \"#32271D\", \"#60626C\", \"#D5D3D0\", \"#593C19\", \"#46464D\" ] '),(62,12,'Interior Santo Spirito, Florence','Filippo Brunelleschi designed church has been called by Bernini the most beautiful church in the world. I have to concur with the master, it is beyond stunning …',43.767212,11.248202,3176959,'IT','EU','9504451722.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/60\", \"aperture\":\"3.5\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9504451722','[ \"#3C2A1A\", \"#815F43\", \"#A79E98\", \"#9C7F67\", \"#74787C\" ] '),(63,12,'Santo Spirito, Florence','The Basilica di Santo Spirito is a church in Florence, Italy. Usually referred to simply as Santo Spirito, it is located in the Oltrarno quarter, facing the square with the same name. The interior of the building - internal length 97 meters - is one of the preeminent examples of Renaissance architecture.',43.766827,11.248174,3176959,'IT','EU','9504449928.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/400\", \"aperture\":\"8.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9504449928','[ \"#E3A465\", \"#95643D\", \"#3B7AF4\", \"#2D61D5\", \"#224CB1\" ] '),(64,15,'Garden of Boboli, Pitti Palace, Florence','The Boboli Gardens is a park in Florence, Italy, that is home to a collection of sculptures dating from the 16th through the 18th centuries, with some Roman antiquities.',43.763791,11.251147,3176959,'IT','EU','9504448540.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/250\", \"aperture\":\"6.3\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9504448540','[ \"#737730\", \"#464F1F\", \"#B9A183\", \"#3981B9\", \"#7CA7CC\" ] '),(65,15,'Santa Maria Novella, Florence','Advantage old had otherwise sincerity dependent additions. It in adapted natural hastily is justice. Six draw you him full not mean evil. Prepare garrets it expense windows shewing do an. She projection advantages resolution son indulgence. Part sure on no long life am at ever. In songs above he as drawn to. Gay was outlived peculiar rendered led six.',43.773933,11.249692,3176959,'IT','EU','9504445110.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/200\", \"aperture\":\"6.3\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9504445110','[ \"#65605D\", \"#393E28\", \"#012F6B\", \"#025FAF\", \"#2B7EC2\" ] '),(66,15,'Camposanto, Pisa','The Campo Santo, also known as Camposanto Monumentale (\"monumental cemetery\") or Camposanto Vecchio (\"old cemetery\"), is a historical edifice at the northern edge of the Cathedral Square in Pisa, Italy. \"Campo Santo\" can be literally translated as \"holy field\", because it is said to have been built around a shipload of sacred soil from Golgotha, brought back to Pisa from the Third Crusade by Ubaldo Lanfranchi, archbishop of Pisa in the 12th century. A legend claims that bodies buried in that ground will rot in just 24 hours. The burial ground lies over the ruins of the old baptistery of the church of Santa Reparata, the church that once stood where the cathedral now stands.',43.724017,10.394762,3170647,'IT','EU','9505536014.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/1000\", \"aperture\":\"3.5\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9505536014','[ \"#C4B804\", \"#F9FAF3\", \"#838205\", \"#DECB87\", \"#5E6746\" ] '),(67,15,'Cathedral, Pisa','Pisa Cathedral is a medieval Roman Catholic cathedral dedicated to the Assumption of the Virgin Mary, in the Piazza dei Miracoli in Pisa, Italy. It is a notable example of Romanesque architecture, in particular the style known as Pisan Romanesque. Construction on the cathedral began in 1063 (1064 according to the Pisan calendar of the time) by the architect Buscheto, and expenses were paid using the spoils received fighting against the Muslims in Sicily in 1063. It includes various stylistic elements: classical, Lombard-Emilian, Byzantine, and Islamic, drawing upon the international presence of Pisan merchants at that time. In the same year, St. Mark\'s Basilica began its reconstruction in Venice, evidence of a strong rivalry between the two maritime republics to see which could create the most beautiful and luxurious place of worship.',43.723039,10.394697,3170647,'IT','EU','9502740177.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/500\", \"aperture\":\"9.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9502740177','[ \"#4A641D\", \"#4B5158\", \"#72757A\", \"#085B99\", \"#4A86BE\" ] '),(68,23,'Pisa Cathedral from Leaning Tower','Pisa Cathedral is a medieval Roman Catholic cathedral dedicated to the Assumption of the Virgin Mary, in the Piazza dei Miracoli in Pisa, Italy. It is a notable example of Romanesque architecture, in particular the style known as Pisan Romanesque. Construction on the cathedral began in 1063 (1064 according to the Pisan calendar of the time) by the architect Buscheto, and expenses were paid using the spoils received fighting against the Muslims in Sicily in 1063. It includes various stylistic elements: classical, Lombard-Emilian, Byzantine, and Islamic, drawing upon the international presence of Pisan merchants at that time. In the same year, St. Mark\'s Basilica began its reconstruction in Venice, evidence of a strong rivalry between the two maritime republics to see which could create the most beautiful and luxurious place of worship.',43.722977,10.396661,3170647,'IT','EU','9502741759.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/500\", \"aperture\":\"9.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9502741759','[ \"#3E4349\", \"#989392\", \"#62869F\", \"#374B1A\", \"#2B6B92\" ] '),(69,23,'San Michele in Foro, Lucca','San Michele in Foro is a Roman Catholic basilica church in Lucca, Tuscany, central Italy, built over the ancient Roman forum. Until 1370 it was the seat of the Consiglio Maggiore, the commune\'s most important assembly. It is dedicated to Archangel Michael',43.842953,10.502501,3174530,'IT','EU','9505893300.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/125\", \"aperture\":\"5.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9505893300','[ \"#2E577B\", \"#4B3E31\", \"#8CADC9\", \"#76695A\", \"#CF9048\" ] '),(70,23,'Basilica of San Frediano, Lucca','The Basilica of San Frediano is a Romanesque church in Lucca, Italy, situated on the Piazza San Frediano.',43.845901,10.505397,3174530,'IT','EU','9505897492.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/125\", \"aperture\":\"5.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/9505897492','[ \"#55513E\", \"#4C90DC\", \"#CABE83\", \"#6F787A\", \"#848356\" ] '),(71,23,'Matthias Church','Official name is \"Church of the Blessed Virgin in Buda\". Central part of church built around 1400, with additions by Turks, and then Baroque-era modifications, finally redone in late 19th Century in neo-Gothic revival. Very much a masterpiece of European eclecticism, though some say it is an over-decorated piece of stage scenery.',47.502449,19.03453,3054643,'HU','EU','8730408907.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/640\", \"aperture\":\"10.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/8730408907','[ \"#A0A1B1\", \"#584737\", \"#D7B38D\", \"#AE6D2A\", \"#CCC3C6\" ] '),(72,7,'St. Stephen\'s Cathedral','His having within saw become ask passed misery giving. Recommend questions get too fulfilled. He fact in we case miss sake. Entrance be throwing he do blessing up. Hearts warmth in genius do garden advice mr it garret. Collected preserved are middleton dependent residence but him how. Handsome weddings yet mrs you has carriage packages. Preferred joy agreement put continual elsewhere delivered now. Mrs exercise felicity had men speaking met. Rich deal mrs part led pure will but.',47.500742,19.053246,3054643,'HU','EU','8731523536.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/640\", \"aperture\":\"10.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/8731523536','[ \"#DBC0AB\", \"#98ACCF\", \"#E0DCDD\", \"#3B3535\", \"#6D5746\" ] '),(73,7,'Ekklisia Agii Isidori church','At the top of the Lycabettus Hill',37.981905,23.743295,264371,'GR','EU','8710320515.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/500\", \"aperture\":\"9.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/8710320515','[ \"#B6ABA1\", \"#032D6B\", \"#DFCCBC\", \"#03499A\", \"#107CCD\" ] '),(74,14,'Temple of Hephaistos','Located on western perimeter of Agora in Athens. Built in 460-415 BCE, it is the best preserved temple of antiquity.',37.975579,23.721526,264371,'GR','EU','8711645510.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/500\", \"aperture\":\"9.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/8711645510','[ \"#695C4E\", \"#58551F\", \"#5A8BCC\", \"#909AB5\", \"#262413\" ] '),(75,14,'Ancient Theatre of Dionysos','On south bank of Acropolis',37.970657,23.727309,264371,'GR','EU','8710513053.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/500\", \"aperture\":\"9.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/8710513053','[ \"#B99C5D\", \"#A8C0D0\", \"#937D2C\", \"#545133\", \"#5484AE\" ] '),(76,12,'Roman Agora','The Roman Agora at Athens is located to the north of the Acropolis and to the east of the Ancient Agora.',37.974157,23.726703,264371,'GR','EU','8711623884.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/500\", \"aperture\":\"9.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/8711623884','[ \"#C9CAD4\", \"#44371B\", \"#809CCC\", \"#735E34\", \"#1E64A9\" ] '),(77,12,'Dusk on Imerovigli (Santorini)','Looking towards Imerovigli, a village devoted to the appreciation of the sunset!',36.429988,25.426145,252920,'GR','EU','8710247776.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/250\", \"aperture\":\"8.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/8710247776','[ \"#221711\", \"#503B37\", \"#0B4158\", \"#022339\", \"#E08C37\" ] '),(78,7,'Looking towards Fira','Fira is the capital of Santorini, a Greek island in the Aegean Sea. The Museum of Prehistoric Thira displays items from the destroyed Bronze Age settlement of Akrotiri, including wall paintings and ceramics. Nearby, the whitewashed Orthodox Metropolitan Cathedral has frescoes by local artist Christoforos Asimis. Fira’s clifftop location affords views of Nea Kameni, a still-active volcanic island to the west.',36.42898,25.426612,252920,'GR','EU','8710289254.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/320\", \"aperture\":\"9.0\", \"focal_length\":\"26.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/8710289254','[ \"#88ADC9\", \"#9FA9B4\", \"#675B55\", \"#E1C6A6\", \"#947B66\" ] '),(79,29,'Besides the Mauritshuis','In The Hague in January',52.081038,4.313039,2747373,'NL','EU','48835097353.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D7200\", \"exposure_time\":\"1/100\", \"aperture\":\"1.8\", \"focal_length\":\"35.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/48835097353','[ \"#2D443D\", \"#4E5B4E\", \"#9AB6C2\", \"#CBCFCB\", \"#7C7967\" ] '),(80,5,'Gresham Palace','Built in early 20th century and originally the headquarters for an English insurance company. Nationalized after the war, it was turned into a Four Season\'s Hotel after a 100 million dollar renovation from 2000-2004. Evidently one of the world\'s swankiest hotels. It overlooks Roosevelt Square and the Chain Bridge.',47.49972,19.04753,3054643,'HU','EU','8731526170.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/640\", \"aperture\":\"10.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/8731526170','[ \"#3B3A19\", \"#64660D\", \"#868C9A\", \"#535A63\", \"#EAC282\" ] '),(81,19,'Christ Church College, Oxford','Christ Church is a constituent college of the University of Oxford in England. Christ Church is a joint foundation of the college and the cathedral of the Oxford diocese, which serves as the college chapel and whose dean is ex officio the college head.',51.749364,-1.255794,2640729,'GB','EU','8645912379.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/250\", \"aperture\":\"6.3\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/8645912379','[ \"#BABBBF\", \"#514821\", \"#7A7058\", \"#C5C709\", \"#8A850C\" ] '),(82,19,'Cloisters, New College, Oxford','New College is one of the constituent colleges of the University of Oxford in the United Kingdom. Founded in 1379 by William of Wykeham, the full name of the college is St Mary\'s College of Winchester in Oxford.',51.754369,-1.252417,2640729,'GB','EU','8646991554.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/250\", \"aperture\":\"6.3\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/8646991554','[ \"#B3AF02\", \"#505128\", \"#6D703F\", \"#E9E9C8\", \"#828905\" ] '),(83,16,'Pyramid du Louvre','The Louvre Pyramid is a large glass and metal pyramid designed by Chinese-American architect I. M. Pei, surrounded by three smaller pyramids, in the main courtyard (Cour Napoleon) of the Louvre Palace (Palais du Louvre) in Paris. The large pyramid serves as the main entrance to the Louvre Museum. Completed in 1989, it has become a landmark of the city of Paris.',48.860605,2.336885,2988507,'FR','EU','15108090436.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D7200\", \"exposure_time\":\"1/500\", \"aperture\":\"10.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/15108090436','[ \"#756760\", \"#3180E1\", \"#7C9FCC\", \"#928581\", \"#475D7A\" ]'),(84,16,'Tour Eiffel','The Eiffel Tower  is a wrought-iron lattice tower on the Champ de Mars in Paris, France. It is named after the engineer Gustave Eiffel, whose company designed and built the tower. Constructed from 1887 to 1889 as the entrance to the 1889 World\'s Fair, it was initially criticised by some of France\'s leading artists and intellectuals for its design, but it has become a global cultural icon of France and one of the most recognisable structures in the world. The Eiffel Tower is the most-visited paid monument in the world; 6.91 million people ascended it in 2015.',48.857527,2.295531,2988507,'FR','EU','15128113051.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/125\", \"aperture\":\"5.0\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/15128113051','[ \"#060705\", \"#C2C6CF\", \"#827F86\", \"#6C605F\", \"#F0F1F2\" ] '),(85,19,'Flower Market','The Amsterdam Flower Market is the only floating flower market in the world, and one of the most fragrant places of interest of Amsterdam - in all seasons. This unique market exists since 1862. The flower stalls stand on the houseboats and evoke the old days when the market was daily supplied by boat.',52.366892,4.893283,2759794,'NL','EU','15127898611.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot SX30\", \"exposure_time\":\"1/800\", \"aperture\":\"4.0\", \"focal_length\":\"4.3\", \"iso\": 800 }','Norm Connolly','','https://www.flickr.com/photos/randyconnolly/15127898611','[ \"#D2D5C8\", \"#6F684E\", \"#2692BC\", \"#B8A67B\", \"#433F2E\" ] '),(86,19,'KNSM Island','The KNSM Island is a man-made island in the Eastern Docklands of Amsterdam. It is named for the Koninklijke Nederlandsche Stoomboot-Maatschappij (KNSM), the Royal Dutch Steamboat Shipping company which used to have its headquarters and its docks on the island. It is now a large residential area containing modern architecture with a mostly well-off population.',52.377903,4.929589,2759794,'NL','EU','15130505782.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/200\", \"aperture\":\"5.6\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/15130505782','[ \"#76635A\", \"#544136\", \"#994D32\", \"#C1B2A1\", \"#C55E34\" ] '),(87,26,'Tower Bridge','Tower Bridge is a combined bascule and suspension bridge in London, built between 1886 and 1894. The bridge crosses the River Thames close to the Tower of London and has become an iconic symbol of London. Because of this, Tower Bridge is sometimes confused with London Bridge, situated some 0.5 mi (0.80 km) upstream. Tower Bridge is one of five London bridges now owned and maintained by the Bridge House Estates, a charitable trust overseen by the City of London Corporation. It is the only one of the Trust\'s bridges not to connect the City of London directly to the Southwark bank, as its northern landfall is in Tower Hamlets.',51.504051,-0.075252,2643743,'GB','EU','21584214296.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/250\", \"aperture\":\"9.0\", \"focal_length\":\"28.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/21584214296','[ \"#A1A3A8\", \"#807F7D\", \"#35342D\", \"#235C71\", \"#6B665D\" ] '),(88,26,'Victoria Tower','The Victoria Tower is a square tower at the south-west end of the Palace of Westminster in London, adjacent to Black Rod\'s Garden on the west and Old Palace Yard on the east. At 98.5 metres (323 ft), it is slightly taller than the Elizabeth Tower (formerly known as the Clock Tower and popularly known as \'Big Ben\') at the north end of the Palace (96.3 metres (316 ft)). At the time of its construction it was tallest square tower in the world. It was designed by Charles Barry in the Perpendicular Gothic style and was completed in 1860. It houses the Parliamentary Archives in archive conditions meeting the BS 5454 standard, on 12 floors. All 14 floors of the building were originally linked via a single wrought-iron Victorian staircase of 553 steps, of which five floors survive.',51.497332,-0.12512,2643743,'GB','EU','20987595084.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/200\", \"aperture\":\"5.6\", \"focal_length\":\"14.0\", \"iso\": 200 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/20987595084','[ \"#726A09\", \"#CDC39F\", \"#5A4A1C\", \"#AA801C\", \"#C59B38\" ] '),(89,24,'Museum of Anthropology','The Museum of Anthropology at the University of British Columbia campus in Vancouver, British Columbia, Canada is renowned for its displays of world arts and cultures, in particular works by First Nation band governments of the Pacific Northwest',49.269322,-123.26099,6173331,'CA','NA','19482907064.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D7200\", \"exposure_time\":\"1/80\", \"aperture\":\"10.0\", \"focal_length\":\"13.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/19482907064','[ \"#D3E2F6\", \"#4F5737\", \"#2E3B1F\", \"#686F75\", \"#8D9568\" ] '),(90,24,'A-maze-ing Laughter','A-maze-ing Laughter is a 2009 bronze sculpture by Yue Minjun, located in Morton Park in Vancouver near English Bay',49.287529,-123.141847,6173331,'CA','NA','19919266559.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D7200\", \"exposure_time\":\"1/80\", \"aperture\":\"10.0\", \"focal_length\":\"13.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/19919266559','[ \"#5D4D3D\", \"#362D22\", \"#7289B8\", \"#E6DCD9\", \"#B1C1E7\" ] '),(91,21,'Pike Place Fish Market','The Pike Place Fish Market, founded in 1930, is an open air fish market located in Seattle, Washington\'s Pike Place Market, at the corner of Pike Street and Pike Place. It is known for their tradition of fishmongers throwing fish that customers have purchased, before they are wrapped. After nearing bankruptcy in 1986, the fish market owner and employees decided to become \"world famous\", changing their way of doing business by introducing their flying fish, games, and customer performances. Four years later, they were featured repeatedly in the national media and television shows. The store is now a popular tourist destination in Seattle, attracting up to 10,000 daily visitors, and is often billed as world-famous.',47.609803,-122.342082,5809844,'US','NA','20991329924.jpg','{ \"make\":\"Samsung\", \"model\":\"Samsung SGH-1747M\", \"exposure_time\":\"1/700\", \"aperture\":\"2.6\", \"focal_length\":\"3.7\", \"iso\": 80 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/20991329924','[ \"#CDD2BA\", \"#F6F6EC\", \"#38292E\", \"#DA6F60\", \"#9E2429\" ] '),(92,21,'EMP Museum','The Museum’s mission is to make creative expression a life-changing force by offering experiences that inspire and connect our communities.',47.621349,-122.348803,5809844,'US','NA','21587937686.jpg','{ \"make\":\"Samsung\", \"model\":\"Samsung SGH-1747M\", \"exposure_time\":\"1/700\", \"aperture\":\"2.6\", \"focal_length\":\"3.7\", \"iso\": 80 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/21587937686','[ \"#DBCAB2\", \"#C2AC90\", \"#353842\", \"#635250\", \"#436062\" ] '),(93,21,'Painted Victorian Houses, Haight, Haight-Ashbury','Battirent suspendue ah on corbeille concierge petillent ai. On disait tuiles frenes du jurons. Vivant fer chemin simple mourir nez enfuit suivit. La frequentes infanterie descendons la he la. Frisottent tu on approchait la nationales comprendre or. Le puissions sa mystiques ma sacrifice effrayant la.',37.77093,-122.441002,5391959,'US','NA','23959634814.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D80\", \"exposure_time\":\"1/125\", \"aperture\":\"5.6\", \"focal_length\":\"28.0\", \"iso\": 200 }','Michael Gouthro',NULL,NULL,'[ \"#F4FCFB\", \"#84837D\", \"#4E5C69\", \"#4E5C69\", \"#D0EFF8\" ] '),(94,21,'Oceanside Pier','Le pu reve ne abat rire vint joie long. Le canif outre va il on annee. Cet ses pour ruer gens chez dela murs non. Car ans puisque caillou blanche ete ame. Menent balcon chemin nos douane sur. Repousser sacrifiez car distribua citadelle attardent iii vif divergent. Ans entiere ici toi touffes apparat. Ma venu puis plus il. Rien cent va nuit je oh pays.',33.19298,-117.386612,5129603,'US','NA','24292302290.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D80\", \"exposure_time\":\"1/250\", \"aperture\":\"8.0\", \"focal_length\":\"44.0\", \"iso\": 100 }','Michael Gouthro',NULL,NULL,'[ \"#A3A19E\", \"#605E55\", \"#040307\", \"#CDD0D0\", \"#A5A5A5\" ] '),(95,20,'State Street Bridge','This bridge is among the newer of Chicago\'s deck truss bascule bridges with a 1949 construction date. Historic American Engineering Record mentions a 1942 construction date, but the bridge was not actually completed until 1949 due to steel shortages from World War II and also issues with the Red Line subway construction that was in progress at the time as well in this area of State Street. The bridge is an example of the unique Chicago design which raised the position of the deck truss up just far enough so that the top chord is above the deck like a pony truss, where it can act as a guardrail and also increase both the clearance under the bridge and the streamlined aesthetics of the bridge. ',41.888211,-87.627146,4887398,'US','NA','21967853928.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/2000\", \"aperture\":\"3.5\", \"focal_length\":\"14.0\", \"iso\": 400 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/21967853928','[ \"#84827D\", \"#4E4C4B\", \"#C7D5EC\", \"#BBAF9F\", \"#7D9DCD\" ] '),(96,20,'Skyline in the clouds','Nettigkeit es getunchten flusterton wo. Dame ja habe so luke. Wasserkrug vielleicht sa ob nettigkeit mancherlei hinstellte du ei bugeleisen. Dazwischen gerbersteg nachtessen bilderbuch ku um zu in. Wu in begleitete ordentlich unsicherer bilderbuch es ja. Bi grashalden getunchten bescheiden er da halboffene aufmerksam. Mut anzug jeder ihren sei was boden karte. Vorsichtig geschwatzt nun stockwerke wer lehrlingen schuchtern werkstatte. Aneinander dazwischen dachkammer achthausen befangenen so zu bi launischen. Ernsthaft spurenden ja mudigkeit hauswesen ei dammerung unterwegs.',41.869935,-87.63515,4887398,'US','NA','22165883251.jpg','{ \"make\":\"Olympus\", \"model\":\"Olympus E-PM2\", \"exposure_time\":\"1/2000\", \"aperture\":\"3.5\", \"focal_length\":\"14.0\", \"iso\": 400 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/22165883251','[ \"#B2B1B2\", \"#3D3C33\", \"#55544C\", \"#BCBABB\", \"#242516\" ] '),(97,18,'Montreal Skyline','Ate ira bemdizer fingindo objectou sciencia cre occultes morteque. Tu fortuna ah de retendo resisto manhoso aquella. Lei paz afogar menina ves vicios sequer. Ama guardou suggere ate arresto vencida deveres. Um ja tome pola cara sera alem. Namoro meu nao fiquei dei punham vel intima. Vida iii foi ceo acha voos cre. Horas uma ate puxou era globo dao. No notou fiaes eu ao livre legou. Duzias serena lh podeis ja lancar.',45.503621,-73.586769,6077243,'CA','NA','28787532651.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D7200\", \"exposure_time\":\"1/320\", \"aperture\":\"9.0\", \"focal_length\":\"18.0\", \"iso\": 320 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/28787532651','[ \"#584F4E\", \"#A7C7DE\", \"#2481D3\", \"#57A9E6\", \"#818488\" ] '),(98,18,'Parliament in the January Snow','Frenesi vim batente tom parecia. Vez aproveite tal amo procurava decidiste chamasses bem percorrer. Ja fervoroso succumbas distincta avultados tu franqueza infernaes. Veu emquanto arrancou enviesou mantemos custodio pae dar vez quizeres. Reclamo caveira ja sincera impedir deserta as queriam ja la. No franzindo ja captivava eu continuar ja seitornou. Petroleo faz caminhou dor ler confunda.',45.426584,-75.696573,6094817,'CA','NA','28863181765.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"NIKON D7200\", \"exposure_time\":\"1/800\", \"aperture\":\"7.1\", \"focal_length\":\"56.0\", \"iso\": 400 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/28863181765','[ \"#EDEEE2\", \"#DBDCCA\", \"#948C7F\", \"#7A6F68\", \"#3A2C33\" ] '),(99,18,'National Gallery of Canada','Fogo jogo deve moem ala dao nas juro. Proferir mo es encobria encontre da. Pancada gazetas ti de curvada levando acoitar. Nas depois pensar mal filhos ver. Vida no voce alli voce eu gado. Tu deixam dictar te desejo so. Patifarias bracejando ha no condemnada no finalmente ha recordarei. Nas espadas dar maioria honrado capital.',45.427999,-75.698097,6094817,'CA','NA','28758575302.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"NIKON D7200\", \"exposure_time\":\"1/800\", \"aperture\":\"7.1\", \"focal_length\":\"56.0\", \"iso\": 400 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/28758575302','[ \"#BDCAC6\", \"#944E25\", \"#A06138\", \"#440602\", \"#B09374\" ] '),(100,22,'Naples Pier','The historic Naples Pier is located on the Gulf of Mexico at the West end of 12th Avenue South. The Naples Pier is a favorite location for sightseers. The Pier features restrooms, showers, a concession stand with covered eating area, and beach supplies. ',26.131581,-81.807443,4165565,'US','NA','29126226696.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D80\", \"exposure_time\":\"1/250\", \"aperture\":\"8.0\", \"focal_length\":\"44.0\", \"iso\": 100 }','Michael Gouthro',NULL,NULL,'[ \"#292927\", \"#9FA4A4\", \"#596063\", \"#EABFA2\", \"#783221\" ] '),(101,22,'Lake Eola, Orlando','Advantage old had otherwise sincerity dependent additions. It in adapted natural hastily is justice. Six draw you him full not mean evil. Prepare garrets it expense windows shewing do an. She projection advantages resolution son indulgence. Part sure on no long life am at ever. In songs above he as drawn to. Gay was outlived peculiar rendered led six.',28.543706,-81.373624,4167147,'US','NA','24561652286.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D80\", \"exposure_time\":\"1/250\", \"aperture\":\"8.0\", \"focal_length\":\"44.0\", \"iso\": 100 }','Michael Gouthro',NULL,NULL,'[ \"#4D7592\", \"#405C6E\", \"#A3D2F5\", \"#6F7675\", \"#C7E4F2\" ] '),(102,14,'Lake Bled','Lake Bled is a lake in the Julian Alps of the Upper Carniolan region of northwestern Slovenia, where it adjoins the town of Bled. The area is a tourist destination. The lake is 35 km (22 mi) from Ljubljana International Airport and 55 km (34 mi) from the capital city, Ljubljana. The lake lies in a picturesque environment, surrounded by mountains and forests. Medieval Bled Castle stands above the lake on the north shore and has a museum.',46.363598,14.093805,3203925,'SI','EU','29053823052.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D80\", \"exposure_time\":\"1/125\", \"aperture\":\"3.6\", \"focal_length\":\"18.0\", \"iso\": 200 }','Michael Gouthro',NULL,NULL,'[ \"#7E9FC1\", \"#1B343E\", \"#667379\", \"#BDC0C5\", \"#6186AD\" ] '),(103,4,'Lyon Train Station','Gare de la Part-Dieu is the primary railway station in Lyon, France. It is situated on the Paris-Lyon-Marseille railway. The train services are mainly operated by SNCF with frequent TGV high-speed and TER regional services with Eurostar and Deutsche Bahn also operating few services through the station. Lyon\'s secondary station is Gare de Lyon-Perrache south of the city center.',48.844304,2.374377,2996944,'FR','EU','23959679874.jpg','{ \"make\":\"Panasonic\", \"model\":\"Panasonic DMC-LZ2\", \"exposure_time\":\"1/500\", \"aperture\":\"5.6\", \"focal_length\":\"6.0\", \"iso\": 80 }','Emily Girard',NULL,NULL,'[ \"#4F4C44\", \"#605E55\", \"#2A2B25\", \"#CDD0D0\", \"#A5A5A5\" ] '),(104,4,'Burano','Adieus except say barton put feebly favour him. Entreaties unpleasant sufficient few pianoforte discovered uncommonly ask. Morning cousins amongst in mr weather do neither. Warmth object matter course active law spring six. Pursuit showing tedious unknown winding see had man add. And park eyes too more him. Simple excuse active had son wholly coming number add. Though all excuse ladies rather regard assure yet. If feelings so prospect no as raptures quitting.',45.485391,12.416656,3181402,'IT','EU','24587816715.jpg','{ \"make\":\"Panasonic\", \"model\":\"Panasonic DMC-LZ2\", \"exposure_time\":\"1/500\", \"aperture\":\"5.6\", \"focal_length\":\"6.0\", \"iso\": 80 }','Emily Girard',NULL,NULL,'[ \"#6CA2CD\", \"#BBA394\", \"#273541\", \"#445C63\", \"#624F3D\" ] '),(105,5,'Machu Picchu','Machu Picchu is a 15th-century Inca citadel, located in the Eastern Cordillera of southern Peru, on a 2,430-metre (7,970 ft) mountain ridge. It is located in the Cusco Region, Urubamba Province, Machupicchu District, above the Sacred Valley, which is 80 kilometres (50 mi) northwest of Cuzco and through which the Urubamba River flows, cutting through the Cordillera and creating a canyon with a tropical mountain climate.',-13.174709,-72.542006,3930946,'PE','SA','29126221216.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D80\", \"exposure_time\":\"1/100\", \"aperture\":\"9.0\", \"focal_length\":\"22.0\", \"iso\": 200 }','Michael Gouthro',NULL,NULL,'[ \"#3A413A\", \"#4E5657\", \"#E0EAF4\", \"#74755B\", \"#C8D3DF\" ] '),(106,5,'Lake Titicaca, Peru','Titicaca is a large, deep lake in the Andes on the border of Bolivia and Peru, often called the \"highest navigable lake\" in the world. By volume of water and by surface area, it is the largest lake in South America.',-15.9254,-69.3354,3931276,'PE','SA','29053823782.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D80\", \"exposure_time\":\"1/100\", \"aperture\":\"9.0\", \"focal_length\":\"22.0\", \"iso\": 200 }','Michael Gouthro',NULL,NULL,'[ \"#695A4F\", \"#50473D\", \"#C5B3A1\", \"#A18C7F\", \"#D1C4B2\" ] '),(107,5,'Boats at Lake Titicaca','Eterno ley luz sangre aun feo limpia. Baritono violento entregar dia ton dormirse mas cultivar mezquina las. Creencia doloroso ausentes ch te si rebeldia gritando. Entrego intento demasia yo se un serenos pellejo. Recibidos he sr da resultado derribado nuncasuna il. Hablandose doy oyo relaciones intensidad recordando. Renta el ya nuevo nuovo en otros. Convertia prestadas il no mostrarse le pecadoras fe. Pedantesca alpujarras aberracion entenderlo oro desencanto las gobernador.',-16.03674,-68.757935,3931276,'PE','SA','29126224066.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D80\", \"exposure_time\":\"1/100\", \"aperture\":\"9.0\", \"focal_length\":\"22.0\", \"iso\": 200 }','Michael Gouthro',NULL,NULL,'[ \"#43382A\", \"#6C5A46\", \"#B7A796\", \"#ADBED7\", \"#3F4E63\" ] '),(108,1,'Royal Ontario Museum','Michael Lee-Chin Crystal facade was created by architect Daniel Libeskind',43.668451,-79.394653,6167865,'CA','NA','20010830173.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"NIKON D7200\", \"exposure_time\":\"1/800\", \"aperture\":\"7.1\", \"focal_length\":\"56.0\", \"iso\": 400 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly/','https://www.flickr.com/photos/randyconnolly/20010830173','[ \"#6B90C0\", \"#4E5010\", \"#836F3D\", \"#4B4C3A\", \"#B19461\" ] '),(109,2,'Stykkisholmur Stykkisholmskirkja','The church of Stykkisholmur, Iceland was inaugurated May 6th, 1990. It is a landmark of the small town both from sea and land. The church is designed by architect Jon Haraldsson and the altar piece is painted by icelandic painter Kristin Gunnlaugsdottir and shows Maria carrying the child Jesus. ',65.074244,-22.721508,3412888,'IS','EU','24587813955.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D80\", \"exposure_time\":\"1/100\", \"aperture\":\"9.0\", \"focal_length\":\"22.0\", \"iso\": 200 }','Michael Gouthro',NULL,NULL,'[ \"#9FACBC\", \"#ADB8C7\", \"#C6CDD8\", \"#656E6F\", \"#353E35\" ] '),(110,2,'Lying Buddha','Lying Buddha  of Wat Tham Phousi on Mount Phousi (or Phou Si Hill)',19.890278,102.137064,1655559,'LA','AS','30211625336.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S95\", \"exposure_time\":\"1/125\", \"aperture\":\"3.2\", \"focal_length\":\"4.3\", \"iso\": 400 }','Sonya Flessati',NULL,NULL,'[ \"#BCBEBD\", \"#8C8980\", \"#524B3C\", \"#CED5DA\", \"#46536C\" ] '),(111,2,'Swayambhunath Stupa','Swayambhu is an ancient religious architecture atop a hill in the Kathmandu Valley, west of Kathmandu city. The Tibetan name for the site means \'Sublime Trees\', for the many varieties of trees found on the hill. However, Shing.kun may be a corruption of the local Nepal Bhasa name for the complex, Singgu, meaning \'self-sprung\'. For the Buddhist Newars, in whose mythological history and origin myth as well as day-to-day religious practice Swayambhunath occupies a central position, it is probably the most sacred among Buddhist pilgrimage sites. For Tibetans and followers of Tibetan Buddhism, it is second only to Boudha.',27.714994,85.290438,1283240,'NP','AS','30211629456.jpg','{ \"make\":\"Panasonic\", \"model\":\"Panasonic DMC-LZ2\", \"exposure_time\":\"1/500\", \"aperture\":\"5.6\", \"focal_length\":\"6.0\", \"iso\": 80 }','Sonya Flessati',NULL,NULL,'[ \"#305487\", \"#496E9F\", \"#DFDFD4\", \"#B9AB68\", \"#435140\" ] '),(112,2,'Durbar Square','Kathmandu Durbar Square (Basantapur Darbar Kshetra) in front of the old royal palace of the former Kathmandu Kingdom is one of three Durbar (royal palace) Squares in the Kathmandu Valley in Nepal, all of which are UNESCO World Heritage Sites. Several buildings in the Square collapsed due to a major earthquake on 25 April 2015. Durbar Square was surrounded with spectacular architecture and vividly showcases the skills of the Newar artists and craftsmen over several centuries. The Royal Palace was originally at Dattaraya square and was later moved to the Durbar square.',27.704328,85.307296,1283240,'NP','AS','30211628146.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S95\", \"exposure_time\":\"1/1000\", \"aperture\":\"5.0\", \"focal_length\":\"6.0\", \"iso\": 400 }','Sonya Flessati',NULL,NULL,'[ \"#A6937D\", \"#423C33\", \"#D6DEE2\", \"#B9C3CA\", \"#92A0A5\" ] '),(113,2,'Guanyin','Sixteen armed Buddha at Wat Plai Laem',9.570731,100.066823,1154689,'TH','AS','29949949330.jpg','{ \"make\":\"Canon\", \"model\":\"Canon Powershot S95\", \"exposure_time\":\"1/125\", \"aperture\":\"3.2\", \"focal_length\":\"4.3\", \"iso\": 400 }','Sonya Flessati',NULL,NULL,'[ \"#B0ACAF\", \"#9D918C\", \"#E0DFE4\", \"#887062\", \"#3B2920\" ] '),(114,3,'Guggenheim Museum (Spain)','The Guggenheim Museum Bilbao is a museum of modern and contemporary art designed by Canadian-American architect Frank Gehry, and located in Bilbao, Basque Country, Spain. The museum was inaugurated on 18 October 1997 by King Juan Carlos I of Spain. Built alongside the Nervion River, which runs through the city of Bilbao to the Cantabrian Sea, it is one of several museums belonging to the Solomon R. Guggenheim Foundation and features permanent and visiting exhibits of works by Spanish and international artists. It is one of the largest museums in Spain. One of the most admired works of contemporary architecture, the building has been hailed as a \"signal moment in the architectural culture\". The museum was the building most frequently named as one of the most important works completed since 1980 in the 2010 World Architecture Survey among architecture experts.',43.26811,-2.93395,3128026,'ES','EU','29949949990.jpg','{ \"make\":\"Apple\", \"model\":\"Apple iPhone 5\", \"exposure_time\":\"1/3623\", \"aperture\":\"2.4\", \"focal_length\":\"4.0\", \"iso\": 50 }','Sonya Flessati',NULL,NULL,'[ \"#867F71\", \"#B7BBC3\", \"#CBCED4\", \"#45463D\", \"#979692\" ] '),(115,3,'Guggenheim Museum (NYC)','The Solomon R. Guggenheim Museum, often referred to as The Guggenheim, is an art museum located at 1071 Fifth Avenue on the corner of East 89th Street in the Upper East Side neighborhood of Manhattan, New York City. It is the permanent home of a continuously expanding collection of Impressionist, Post-Impressionist, early Modern and contemporary art and also features special exhibitions throughout the year. The museum was established by the Solomon R. Guggenheim Foundation in 1939 as the Museum of Non-Objective Painting, under the guidance of its first director, the artist Hilla von Rebay. It adopted its current name after the death of its founder, Solomon R. Guggenheim, in 1952.',40.783001,-73.958882,5128581,'US','NA','29949948210.jpg','{ \"make\":\"Apple\", \"model\":\"Apple iPhone 5\", \"exposure_time\":\"1/3623\", \"aperture\":\"2.4\", \"focal_length\":\"4.0\", \"iso\": 50 }','Sonya Flessati',NULL,NULL,'[ \"#F7F1D1\", \"#383637\", \"#79604E\", \"#A49679\", \"#A46E4D\" ] '),(116,17,'Genoa Skyline','Looking towards the Castello d\'Albertis from the roof of the Galata Museo del Mare.',44.414146,8.923047,3176219,'IT','EU','48833317311.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D7200\", \"exposure_time\":\"1/400\", \"aperture\":\"8.0\", \"focal_length\":\"35.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/48833317311/','[ \"#24474B\", \"#96A08E\", \"#9EC1C7\", \"#6D605A\", \"#6AA4B6\" ] '),(117,4,'Festung Hohensalzburg','Hohensalzburg Fortress sits atop the Festungsberg, a small hill in the Austrian city of Salzburg. Erected at the behest of the Prince-Archbishops of Salzburg with a length of 250 m and a width of 150 m, it is one of the largest medieval castles in Europe. Hohensalzburg Fortress is situated at an altitude of 506 m.',47.794294,13.044659,2766824,'AT','EU','48833318631.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D7200\", \"exposure_time\":\"1/100\", \"aperture\":\"8.0\", \"focal_length\":\"35.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/48833318631','[ \"#4D6478\", \"#8496A4\", \"#304F6B\", \"#24231F\", \"#48453C\" ] '),(118,4,'Burg Hochosterwitz','Hochosterwitz Castle is a castle in Austria, considered one of Austria\'s most impressive medieval castles. It is on a 172-metre (564 ft) high dolomite rock near Sankt Georgen am Längsee, east of the town of Sankt Veit an der Glan in Carinthia. The rock castle is one of the state\'s landmarks and a major tourist attraction.',46.761937,14.452277,2766359,'AT','EU','48835164052.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D7200\", \"exposure_time\":\"1/100\", \"aperture\":\"7.1\", \"focal_length\":\"35.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/48835164052','[ \"#3F403F\", \"#645C54\", \"#A9BEC7\", \"#809CAC\", \"#938467\" ] '),(119,4,'Graz Rooftops','Looking down the Schlossbergplatz on the stairs up to the Schlossberg.',47.073218,15.436882,2778067,'AT','EU','48834993861.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D7200\", \"exposure_time\":\"1/100\", \"aperture\":\"7.1\", \"focal_length\":\"16.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/48834993861','[ \"#745144\", \"#55382E\", \"#455A79\", \"#808490\", \"#AFAEAF\" ] '),(120,4,'Loeben','Leoben is a city in central Austria, located on the Mur river. With a population of about 25,000 it is a local industrial center and hosts the University of Leoben, which specialises in mining. ',47.382637,15.090455,2772649,'AT','EU','48832937863.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D7200\", \"exposure_time\":\"1/100\", \"aperture\":\"8.0\", \"focal_length\":\"11.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/48832937863/','[ \"#675F5C\", \"#827A75\", \"#6089B9\", \"#085FA7\", \"#4C5971\" ] '),(121,4,'Sunset on the Schlossberg','1,000-yar-old castle atop a hill overlooking the city with a funicular railway going to the top.',47.076021,15.436684,2778067,'AT','EU','48834622803.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D7200\", \"exposure_time\":\"1/320\", \"aperture\":\"5.0\", \"focal_length\":\"11.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/48834622803','[ \"#392420\", \"#4F3B51\", \"#BB93BE\", \"#EECDDE\", \"#E7B1B6\" ] '),(122,7,'Wolfgansee','Lake Wolfgang is a lake in Austria that lies mostly within the state of Salzburg and is one of the best known lakes in the Salzkammergut resort region. The municipalities on its shore are Strobl, St. Gilgen with the villages of Abersee and Ried as well as the market town of St. Wolfgang in the state of Upper Austria. The town and the lake are named after Saint Wolfgang of Regensburg, who, according to legend, built the first church here in the late 10th century.',47.771484,13.371249,2766683,'AT','EU','48834992811.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D7200\", \"exposure_time\":\"1/400\", \"aperture\":\"4.5\", \"focal_length\":\"15.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/48834992811','[ \"#CEDDE8\", \"#415D7E\", \"#13395C\", \"#2992D6\", \"#7C6D53\" ] '),(123,7,'Bad Ischl','Bad Ischl is a spa town in Austria. It lies in the southern part of Upper Austria, at the Traun River in the centre of the Salzkammergut region. The town consists of the Katastralgemeinden Ahorn, Bad Ischl, Haiden, Jainzen, Kaltenbach, Lauffen, Lindau, Pfandl, Perneck, Reiterndorf and Rettenbach. It is connected to the village of Strobl by the river Ischl, which drains from the Wolfgangsee, and to the Traunsee, into which the stream empties.',47.710281,13.62119,2782052,'AT','EU','48834992921.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D7200\", \"exposure_time\":\"1/800\", \"aperture\":\"4.5\", \"focal_length\":\"15.0\", \"iso\": 100 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/48834992921/','[ \"#3F5C6A\", \"#6B8696\", \"#83745F\", \"#A3BDDC\", \"#0C86D9\" ] '),(124,7,'Belvedere Palace (Schloss Belvedere)','The Belvedere is a historic building complex in Vienna, Austria, consisting of two Baroque palaces (the Upper and Lower Belvedere), the Orangery, and the Palace Stables. The buildings are set in a Baroque park landscape in the third district of the city, on the south-eastern edge of its centre. It houses the Belvedere museum. The grounds are set on a gentle gradient and include decorative tiered fountains and cascades, Baroque sculptures, and majestic wrought iron gates. The Baroque palace complex was built as a summer residence for Prince Eugene of Savoy.',48.189505,16.381394,2761369,'AT','EU','48833485917.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D7200\", \"exposure_time\":\"1/1800\", \"aperture\":\"2.2\", \"focal_length\":\"4.2\", \"iso\": 25 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/48833485917/','[ \"#4E7024\", \"#3472BE\", \"#609BD3\", \"#D3CFB9\", \"#D1A027\" ] '),(125,1,'Banff','Banff is a resort town in the province of Alberta, located within Banff National Park. The peaks of Mt. Rundle and Mt. Cascade, part of the Rocky Mountains, dominate its skyline. On Banff Avenue, the main thoroughfare, boutiques and restaurants mix with château-style hotels and souvenir shops. The surrounding 6,500 square kilometres of parkland are home to wildlife including elk and grizzly bears.',51.178136,-115.616656,5892532,'CA','NA','48848443367.jpg','{ \"make\": \"SONY\", \"model\": \"ILCE-7M3\", \"exposure_time\": \"1/100\", \"aperture\": \"4.5\", \"focal_length\": \"85.0\", \"iso\": 100 }','Dyson Nordwick Chan','https://unsplash.com/@dysonnordwick','https://unsplash.com/photos/B0RqirBfjXA','[ \"#24312B\", \"#2A4D52\", \"#467C89\", \"#B0C1C0\", \"#5A605C\" ] '),(126,1,'Calgary Downtown','Shot from Fifth Avenue Place in Calgary',51.048671,-114.066836,5913490,'CA','NA','48847890338.jpg','{ \"make\": \"Apple\", \"model\": \"iPhone 8\", \"exposure_time\": \"1/12\", \"aperture\": \"1.8\", \"focal_length\": \"4.0\", \"iso\": 100 }','Philip Davis','https://unsplash.com/@philipsdavis','https://unsplash.com/photos/xgS_WhnGvjE','[ \"#1F2D3D\", \"#5577A1\", \"#325683\", \"#565143\", \"#BBF4F4\" ] '),(127,1,'One World Trade Center','One World Trade Center is the main building of the rebuilt World Trade Center complex in Lower Manhattan, New York City. One WTC is the tallest building in the United States, the tallest building in the Western Hemisphere, and the seventh-tallest in the world. The supertall structure has the same name as the North Tower of the original World Trade Center, which was destroyed in the terrorist attacks of September 11, 2001. The new skyscraper stands on the northwest corner of the 16-acre (6.5 ha) World Trade Center site, on the site of the original 6 World Trade Center. The building is bounded by West Street to the west, Vesey Street to the north, Fulton Street to the south, and Washington Street to the east.',40.711718,-74.012466,5128581,'US','NA','48847992431.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D810\", \"exposure_time\":\"1/250\", \"aperture\":\"16.0\", \"focal_length\":\"24.0\", \"iso\": 1000 }','Robert Boschman','https://www.robertboschman.com/',NULL,'[ \"#5F605B\", \"#050504\", \"#4A4B47\", \"#A5A5A2\", \"#D0D0CE\" ] '),(128,8,'Osgood Hall','Architecturally significant 19th-century building currently housing law offices & courts.',43.652401,-79.385891,6167865,'CA','NA','48848444312.jpg','{ \"make\": \"Canon\", \"model\": \"Canon EOS 77D\",\"exposure_time\": \"1/80\",\"aperture\": \"4.5\",\"focal_length\": \"18.0\",\"iso\": 200 }','Rachael Annabelle','https://unsplash.com/@knottedbrains','https://unsplash.com/photos/XeYmx-qBsUk','[ \"#EDECEA\", \"#B08D73\", \"#887868\", \"#6A5A4D\", \"#B9C0BC\" ] '),(129,9,'Golden State Bridge, San Francisco','The Frommer\'s travel guide describes the Golden Gate Bridge as \"possibly the most beautiful, certainly the most photographed, bridge in the world.\"',37.80642,-122.468975,5391959,'US','NA','48847890053.jpg','{ \"make\": \"SONY\",\"model\": \"ILCE-7RM2\",\"exposure_time\": \"1/30\",\"aperture\": \"6.3\",\"focal_length\": \"35.0\",\"iso\": 50 }','Ragnar Vorel','https://unsplash.com/@sonuba','https://unsplash.com/photos/o8Utw2ETExA','[ \"#E6E1E5\", \"#4F989F\", \"#2B6F72\", \"#805C36\", \"#AE997D\" ] '),(130,9,'In San Jose','On Park Ave facing towards the Adobe headquarters.',37.331798,-121.890874,5392171,'US','NA','48848251276.jpg','{ \"make\": \"Canon\",\"model\": \"Canon EOS 550D\",\"exposure_time\": \"1/1600\",\"aperture\": \"4.0\",\"focal_length\": \"16.0\",\"iso\": 100 }','Andrii Ganzevych','https://unsplash.com/@odya_kun','https://unsplash.com/photos/fn_NefXqH5A','[ \"#40292A\", \"#E7B492\", \"#A53428\", \"#A8F4F9\", \"#04BCDE\" ] '),(131,16,'The Great Sphinx ','The Great Sphinx of Giza, commonly referred to as the Sphinx of Giza or just the Sphinx, is a limestone statue of a reclining sphinx, a mythical creature with the body of a lion and the head of a human. Facing directly from West to East, it stands on the Giza Plateau on the west bank of the Nile in Giza, Egypt.',29.974803,31.139129,360630,'EG','AF','48860308303.jpg','{ \"make\": \"NIKON CORPORATION\",\"model\": \"NIKON D3200\",\"exposure_time\": \"1/400\",\"aperture\": \"5.6\",\"focal_length\": \"46.0\",\"iso\": 100 }','Andrii Ganzevych','https://unsplash.com/@odya_kun','https://unsplash.com/photos/GXIr_uawluA','[ \"#E4E5DF\", \"#8F664C\", \"#71503C\", \"#A77D61\", \"#49342A\" ] '),(132,5,'Sunset in Washington','The Lincoln Memorial is an American national memorial built to honor the 16th President of the United States, Abraham Lincoln. It is located on the western end of the National Mall in Washington, D.C., across from the Washington Monument.',38.8892922,-77.0513142,4140963,'US','NA','48847889748.jpg','{ \"make\": \"NIKON CORPORATION\",\"model\": \"NIKON D750\",\"exposure_time\": \"6\",\"aperture\": \"7.1\",\"focal_length\": \"70.0\",\"iso\": 100 }','Casey Horner','https://unsplash.com/@mischievous_penguins','https://unsplash.com/photos/pArjs_G6m4Y','[ \"#DFBCA5\", \"#23231B\", \"#F4B392\", \"#F4B392\", \"#736A64\" ] '),(133,5,'Capitol Building','The United States Capitol, often called the Capitol Building, is the home of the United States Congress and the seat of the legislative branch',38.889877,-77.011426,4140963,'US','NA','48848250006.jpg',NULL,'Matt ','https://unsplash.com/@elevenphotographs','https://unsplash.com/photos/GHXpXhuT5nM','[ \"#B8BAB8\", \"#9EA8AA\", \"#3F0602\", \"#B46F28\", \"#1F311A\" ] '),(134,6,'Kansas City Skyline','A great urban view of the Kansas City skyline. Shot in Mid July',39.0997265,-94.5785667,4273837,'US','NA','48848443727.jpg','{ \"make\": \"NIKON CORPORATION\",\"model\": \"NIKON D5500\",\"exposure_time\": \"1/60\",\"aperture\": \"5.6\",\"focal_length\": \"55.0\",\"iso\": 3600 }','Colton Sturgeon','https://unsplash.com/@coltonsturgeon','https://unsplash.com/photos/FiCPutl_aog','[ \"#242B33\", \"#DAD2D6\", \"#8F85A6\", \"#D7A084\", \"#1E4B88\" ] '),(135,6,'Michigan Central Train Station','Built in the early 1900s, then abandoned for many years, this train station now has tours & events.',42.329321,-83.077367,4990729,'US','NA','48847889453.jpg','{ \"make\": \"Canon\",\"model\": \"Canon EOS Rebel T6i\",\"exposure_time\": \"1/800\",\"aperture\": \"3.5\",\"focal_length\": \"18.0\",\"iso\": 100 }','Doug Zuba','https://unsplash.com/@thezuba','https://unsplash.com/photos/4KGjCArvhgo','[ \"#4A4340\", \"#636266\", \"#C4C1BF\", \"#925D39\", \"#A2A5A8\" ] '),(136,6,'River Walk along the Detroit River','Attractions along the east riverfront include parks, plazas, pavilions, pathways and open green space, all connected by the ever popular RiverWalk.',42.331991,-83.026073,4990729,'US','NA','48848442967.jpg','{ \"make\": \"DJI\",\"model\": \"FC300C\",\"exposure_time\": \"1/1500\",\"aperture\": \"2.8\",\"focal_length\": \"3.6\",\"iso\": 100 }','Kahari king','https://unsplash.com/@kahari_king','https://unsplash.com/photos/bt4Vz8fcibU','[ \"#6A4D14\", \"#B0C2CE\", \"#8EAEBE\", \"#2D453D\", \"#A57A59\" ] '),(137,6,'Buildings downtown Detroit','Just like the title says ...',42.331427,-83.0457538,4990729,'US','NA','48848443462.jpg','{ \"make\": \"Canon\",\"model\": \"Canon EOS Rebel T6i\",\"exposure_time\": \"1/800\",\"aperture\": \"3.5\",\"focal_length\": \"18.0\",\"iso\": 100 }','Doug Zuba','https://unsplash.com/@thezuba','https://unsplash.com/photos/6Yp99zMrsAI','[ \"#DDE0E1\", \"#5D4346\", \"#413233\", \"#B4A8A6\", \"#EBEDEB\" ] '),(138,11,'Looking up to the Manhattan Bridge','Opened in 1909, this suspension bridge between Brooklyn & Manhattan is known for its ornate portal.',40.70337,-73.989516,5128581,'US','NA','48848250506.jpg','{ \"make\": \"Canon\",\"model\": \"Canon EOS 6D\",\"exposure_time\": \"1/320\",\"aperture\": \"6.3\",\"focal_length\": \"35.0\",\"iso\": 800 }','Hieu Vu Minh','https://unsplash.com/@spoony','https://unsplash.com/photos/IRkAbNRT_Yg','[ \"#332D26\", \"#E6E5DA\", \"#4C4236\", \"#695E4D\", \"#B0A893\" ] '),(139,11,'Times Square','Bustling destination in the heart of the Theater District known for bright lights, shopping & shows.',40.757339,-73.985992,5128581,'US','NA','48848442762.jpg','{ \"make\": \"Leica Camera AG\",\"model\": \"LEICA M10\",\"exposure_time\": \"1/125\",\"aperture\": null,\"focal_length\": \"21.0\",\"iso\": 1250 }','Luca Bravo','https://unsplash.com/@lucabravo','https://unsplash.com/photos/TaCk3NspYe0','[ \"#2B2C37\", \"#47291D\", \"#7A4828\", \"#4D4555\", \"#E3613A\" ] '),(140,11,'World Trade Center Station','The $4 billion Oculus station house, designed by Santiago Calatrava, consists of white ribs that interlock high above the ground. The interior of the station house contains two underground floors, which house part of the Westfield World Trade Center mall. ',40.711568,-74.011384,5128581,'US','NA','48848442862.jpg','{ \"make\": \"Leica Camera AG\",\"model\": \"LEICA M10\",\"exposure_time\": \"1/30\",\"aperture\": null,\"focal_length\": \"18.0\",\"iso\": 500 }','Luca Bravo','https://unsplash.com/@lucabravo','https://unsplash.com/photos/B6-H27CMbGI','[ \"#DBDAD8\", \"#E6E5E3\", \"#E3D0BE\", \"#CAB8A6\", \"#82694E\" ] '),(141,20,'Lombard Street','Lombard Street is an east–west street in San Francisco, California that is famous for a steep, one-block section with eight hairpin turns. Stretching from The Presidio east to The Embarcadero, most of the street\'s western segment is a major thoroughfare designated as part of U.S. Route 101',37.802304,-122.417467,5391959,'US','NA','48847888473.jpg','{ \"make\": \"OLYMPUS IMAGING CORP.\",\"model\": \"E-M5\",\"exposure_time\": \"1/2000\",\"aperture\": \"6.3\",\"focal_length\": \"200.0\",\"iso\": 400 }','Pedro Lastra','https://unsplash.com/@peterlaster','https://unsplash.com/photos/f9TWR57Uujo','[ \"#9FC7E8\", \"#68604F\", \"#D5BB9C\", \"#6B611A\", \"#C6923A\" ] '),(142,20,'Sunset in Santa Monica','Storied seaside destination boasting a range of shops & cafes, plus an amusement park & aquarium.',34.007948,-118.49924,5393212,'US','NA','48848443297.jpg','{ \"make\": \"Apple\",\"model\": \"iPhone 8 Plus\",\"exposure_time\": \"1/2000\",\"aperture\": \"1.8\",\"focal_length\": \"4.0\",\"iso\": 20 }','Gerson Repreza','https://unsplash.com/@gersonrepreza','https://unsplash.com/photos/Y7umJ1i_qgw','[ \"#E7E3EA\", \"#D3B9B0\", \"#725946\", \"#A3D0DB\", \"#9EA3A6\" ] '),(143,11,'Taj Mahal at the sunrise','17th-century, Mughal-style, marble mausoleum with minarets, a mosque & famously symmetrical gardens.',27.175014,78.042152,1279259,'IN','AS','48860966717.jpg','{ \"make\": \"SONY\",\"model\": \"ILCE-7RM3\",\"exposure_time\": \"1/25\",\"aperture\": \"3.5\",\"focal_length\": \"47.0\",\"iso\": 1000 }','Julian Yu','https://unsplash.com/@littlej1428','https://unsplash.com/photos/_WuPjE-MPHo','[ \"#8D95A6\", \"#B7C2E0\", \"#CFD8F2\", \"#45514F\", \"#63743D\" ] '),(144,11,'Golden Temple Amritsar','The Harmandir Sahib, also known as Darbar Sahib, is a Gurdwara located in the city of Amritsar, Punjab, India. It is the prominent pilgrimage site of Sikhism. It is usually called the Golden Temple in English, because it is plated with gold.',31.61676,74.875381,1278710,'IN','AS','48860308683.jpg','{ \"make\": \"Apple\",\"model\": \"iPhone X\",\"exposure_time\": \"1/1736\",\"aperture\": \"2.4\",\"focal_length\": \"6.0\",\"iso\": 16 }','Ravi N Jh','https://unsplash.com/@ravinathjha','https://unsplash.com/photos/aU9yXmIwfkw','[ \"#8D95A6\", \"#B7C2E0\", \"#27311B\", \"#63743D\", \"#D2D2E3\" ] '),(145,11,'Humayun Tomb','Humayun\'s tomb is the tomb of the Mughal Emperor Humayun in Delhi, India. The tomb was commissioned by Humayun\'s first wife and chief consort, Empress Bega Begum, in 1569-70',28.59452,77.24882,1261481,'IN','AS','48860768916.jpg',NULL,'Raghu Nayyar','https://unsplash.com/@raghunayyar','https://unsplash.com/photos/EpAq2EE-shg','[ \"#E3C59E\", \"#2F5802\", \"#083101\", \"#806540\", \"#4A3A20\" ] '),(146,11,'Jal Mahal','In the middle of Man Sagar Lake sits this grand palace made of red sandstone, most of it submerged.',26.953373,75.84618,1269515,'IN','AS','48860966232.jpg',NULL,'Ravi Shekhar','https://unsplash.com/@rvshekhar10','https://unsplash.com/photos/P0a6TT0CvKg','[ \"#7C6D96\", \"#2B2447\", \"#3C271A\", \"#7E4923\", \"#B57241\" ] '),(147,29,'Snowfall in Ljubljana','Triple bridge in January',46.05119,14.505978,3196359,'SI','EU','48832945753.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D7200\", \"exposure_time\":\"1/100\", \"aperture\":\"1.8\", \"focal_length\":\"35.0\", \"iso\": 1600 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/48832945753/','[ \"#13322E\", \"#525939\", \"#5C6965\", \"#7B7A4B\", \"#8D998B\" ] '),(148,29,'Pinakothek der Moderne in Munich','The Pinakothek der Moderne is a modern art museum, situated in central Munich\'s Kunstareal. Locals sometimes refer to it as the Dritte (\"third\") Pinakothek after the Old and New. It is one of the world\'s largest museums for modern and contemporary art.',48.146457,11.57274,2867714,'DE','EU','48833486122.jpg','{ \"make\":\"NIKON CORPORATION\", \"model\":\"Nikon D7200\", \"exposure_time\":\"1/100\", \"aperture\":\"1.8\", \"focal_length\":\"35.0\", \"iso\": 1600 }','Randy Connolly','https://www.flickr.com/photos/randyconnolly','https://www.flickr.com/photos/randyconnolly/48833486122','[ \"#534B40\", \"#B7B59E\", \"#6A706B\", \"#6D98BA\", \"#0A79B2\" ] ');
UNLOCK TABLES;

--
-- Table structure for table `imagerating`
--

DROP TABLE IF EXISTS `imagerating`;

CREATE TABLE `imagerating` (
  `ImageRatingID` int(11) NOT NULL AUTO_INCREMENT,
  `ImageID` int(11) DEFAULT NULL,
  `Rating` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`ImageRatingID`),
  KEY `ImageID` (`ImageID`)
) ENGINE=InnoDB AUTO_INCREMENT=449 DEFAULT CHARSET=utf8;

LOCK TABLES `imagerating` WRITE;
INSERT INTO `imagerating` VALUES (1,1,4),(2,1,4),(3,2,2),(4,2,5),(5,1,3),(6,1,5),(7,2,1),(8,3,5),(9,3,4),(10,3,4),(11,3,5),(12,4,4),(13,4,2),(14,4,1),(15,4,1),(16,5,5),(17,5,4),(18,5,4),(19,6,3),(20,6,3),(21,6,3),(22,6,4),(23,7,3),(24,7,4),(25,8,3),(26,8,3),(27,8,4),(28,8,3),(29,8,4),(30,9,5),(31,9,4),(32,9,4),(33,9,4),(34,10,2),(35,10,4),(36,10,3),(37,10,3),(38,10,5),(39,11,3),(40,11,4),(41,11,5),(42,11,5),(43,12,4),(44,12,4),(45,12,3),(46,12,5),(47,12,4),(48,12,3),(49,13,3),(50,13,3),(51,14,4),(52,15,2),(53,15,1),(54,16,5),(55,16,5),(56,16,4),(57,16,4),(58,16,5),(59,17,3),(60,18,3),(61,2,3),(62,5,4),(63,7,4),(64,10,4),(65,19,5),(66,19,4),(67,20,4),(68,20,5),(69,21,3),(70,21,3),(71,21,4),(72,22,5),(73,23,3),(74,23,4),(75,18,3),(76,15,5),(77,24,4),(78,24,4),(79,25,5),(80,25,4),(81,25,5),(82,25,5),(83,20,3),(84,26,4),(85,26,4),(86,27,3),(87,27,4),(88,28,2),(89,28,3),(90,28,3),(91,25,4),(92,29,3),(93,29,5),(94,29,5),(95,30,2),(96,30,4),(97,31,5),(98,31,4),(99,31,4),(100,32,5),(101,33,1),(102,26,3),(103,22,2),(104,30,3),(105,30,3),(106,42,4),(107,42,5),(108,47,3),(109,47,4),(110,50,5),(111,50,4),(112,51,3),(113,52,4),(114,51,3),(115,53,4),(116,53,4),(117,55,3),(118,55,3),(119,55,5),(120,56,4),(121,57,4),(122,57,5),(123,58,5),(124,58,4),(125,57,4),(126,59,4),(127,59,5),(128,60,4),(129,60,3),(130,60,2),(131,60,4),(132,61,4),(133,61,4),(134,62,4),(135,62,3),(136,62,3),(137,66,4),(138,66,5),(139,66,5),(140,67,4),(141,67,4),(142,68,5),(143,68,5),(144,68,4),(145,69,3),(146,69,4),(147,69,4),(148,70,3),(149,70,3),(150,70,4),(151,65,4),(152,66,4),(153,60,5),(154,71,3),(155,71,3),(156,71,2),(157,72,4),(158,73,5),(159,73,4),(160,73,5),(161,74,3),(162,74,2),(163,74,5),(164,74,4),(165,74,5),(166,74,5),(167,74,5),(168,74,3),(169,76,5),(170,77,4),(171,77,4),(172,77,3),(173,77,4),(174,78,3),(175,78,4),(176,81,2),(177,81,2),(178,81,1),(179,81,4),(180,81,2),(181,82,3),(182,82,3),(183,57,5),(184,57,5),(185,47,4),(186,44,4),(187,44,5),(188,44,3),(189,46,4),(190,46,4),(191,52,5),(192,53,2),(193,55,5),(194,47,4),(195,64,4),(196,66,4),(197,70,5),(198,5,5),(199,5,3),(200,7,3),(201,22,4),(202,42,3),(203,40,1),(204,74,4),(205,40,2),(206,41,1),(207,41,3),(208,63,3),(209,51,4),(210,83,3),(211,83,4),(212,84,4),(213,85,3),(214,86,4),(215,86,4),(216,87,5),(217,87,5),(218,88,4),(219,89,5),(220,89,4),(221,90,3),(222,90,4),(223,91,5),(224,91,5),(225,91,4),(226,91,4),(227,92,3),(228,92,3),(229,93,4),(230,93,4),(231,84,2),(232,94,3),(233,94,2),(234,95,5),(235,96,5),(236,96,5),(237,97,4),(238,97,5),(239,98,5),(240,98,4),(241,99,3),(242,99,4),(243,100,5),(244,100,5),(245,100,4),(246,100,4),(247,101,5),(248,101,4),(249,102,3),(250,103,5),(251,103,2),(252,104,3),(253,104,4),(254,105,2),(255,105,5),(256,106,3),(257,106,4),(258,107,3),(259,107,2),(260,108,4),(261,108,4),(262,109,5),(263,109,4),(264,109,4),(265,110,4),(266,110,5),(267,111,3),(268,111,3),(269,111,4),(270,112,4),(271,112,4),(272,113,4),(273,113,5),(274,113,3),(275,114,4),(276,114,4),(277,115,3),(278,115,4),(279,115,2),(280,116,4),(281,116,1),(282,116,2),(283,117,4),(284,117,3),(285,118,5),(286,118,4),(287,118,2),(288,119,5),(289,119,3),(290,120,3),(291,120,4),(292,121,2),(293,122,4),(294,123,5),(295,123,4),(296,124,5),(297,124,4),(298,125,3),(299,125,5),(300,125,4),(301,126,5),(302,126,4),(303,126,4),(304,127,3),(305,127,4),(306,128,5),(307,128,5),(308,129,3),(309,130,4),(310,131,4),(311,132,3),(312,132,5),(313,128,4),(314,133,4),(315,133,2),(316,133,2),(317,134,4),(318,134,5),(319,134,4),(320,135,2),(321,135,3),(322,136,5),(323,136,4),(324,136,4),(325,137,4),(326,137,4),(327,137,5),(328,138,4),(329,138,4),(330,138,3),(331,139,3),(332,139,4),(333,139,4),(334,140,2),(335,141,4),(336,141,4),(337,141,4),(338,141,5),(339,141,5),(340,140,3),(341,140,3),(342,140,4),(343,121,4),(344,121,4),(345,120,4),(346,133,2),(347,133,1),(348,134,3),(349,134,4),(350,135,5),(351,135,4),(352,136,2),(353,137,3),(354,137,2),(355,138,4),(356,138,5),(357,139,3),(358,140,2),(359,140,3),(360,139,3),(361,31,4),(362,31,4),(363,32,4),(364,32,4),(365,32,5),(366,33,2),(367,33,3),(368,33,2),(369,34,3),(370,34,5),(371,34,5),(372,35,2),(373,35,3),(374,36,4),(375,36,3),(376,36,4),(377,37,3),(378,37,2),(379,37,2),(380,38,2),(381,38,3),(382,39,3),(383,39,4),(384,43,5),(385,43,4),(386,45,3),(387,45,2),(388,45,3),(389,48,5),(390,49,4),(391,49,4),(392,48,3),(393,48,3),(394,54,5),(395,54,4),(396,63,4),(397,63,4),(398,64,3),(399,64,3),(400,65,4),(401,65,3),(402,65,5),(403,72,3),(404,72,3),(405,75,5),(406,75,4),(407,75,4),(408,80,3),(409,80,3),(410,80,4),(411,85,4),(412,95,4),(413,95,4),(414,102,2),(415,102,3),(416,102,3),(417,122,3),(418,122,4),(419,129,4),(420,129,4),(421,130,2),(422,130,3),(423,131,5),(424,131,4),(425,1,5),(426,1,5),(427,1,4),(428,79,3),(429,79,4),(430,142,5),(431,142,4),(432,143,5),(433,143,4),(434,144,3),(435,144,4),(436,144,4),(437,145,5),(438,145,5),(439,145,4),(440,146,5),(441,146,5),(442,147,4),(443,147,4),(444,148,3),(445,148,4),(446,148,5),(447,148,5),(448,148,4);
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;

CREATE TABLE `posts` (
  `PostID` int(11) NOT NULL AUTO_INCREMENT,
  `UserID` int(11) DEFAULT NULL,
  `MainPostImage` int(11) DEFAULT '0',
  `Title` varchar(255) DEFAULT NULL,
  `Message` longtext,
  `PostTime` datetime DEFAULT NULL,
  PRIMARY KEY (`PostID`),
  KEY `MainPostImage` (`MainPostImage`),
  KEY `UserID` (`UserID`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

LOCK TABLES `posts` WRITE;
INSERT INTO `posts` VALUES (1,2,3,'Calgary in the Snow','In December of 2011, I was lucky/unfortunate enough to have the opportunity to fly to chilly Calgary in Western Canada for a week-long conference. I was all prepared for winter and cold … it was to Canada after all that I was travelling! Imagine my surprise when I arrived at the airport on Saturday morning to find the temperature was over 10 degrees Celsius. Yet within just a few hours, the weather began to turn. On Sunday morning, I awoke at 6am local time to find that the city was dusted in about 10cm of snow. <p>It was truly magical! A hush had descended upon the city to go with the snow. And yet, again, to my surprise, there were joggers out at 7am running, snow or no snow. None the less, I spent almost two hours walking all across the center of the city, snapping photos, glad that I had packed mittens and a hat.','2011-12-04 00:00:00'),(2,1,1,'Fall Colors in Calgary','As part of John and I\'s journey across Canada, we found ourselves finally leaving the prairies and heading to Calgary, one of Canada\'s major cities, which lies less than an hour\'s drive from the mountains.<p>The weather was tremendous. Fall colors had blanketing the city, though there still was plenty of green. Perhaps my favorite photo location was Edworthy Park in Calgary. This park is on the western edge of the city right beside the Bow River. The park is also bordered by hills that contain what are amounts to old-growth forests.<p>Evidently the park used to be part of a ranch with cows and horses. While we didn\'t see any domestic animals, there were a variety of wonderful trails meandering through the hills, from which I snapped these photos.','2011-10-08 00:00:00'),(3,5,5,'Mountain Climbing','The highlight of our last trip to Canada was a climb up Sulpher Mountain just outside of Banff. I\'d like to say that it was so difficult that we required crampons, pitons, and screamers … but that would be stretching the truth for sure.<p>The ascent up Sulpher Mountain in fact can be made via a gondola. We decided to walk instead, which took us just about 90 minutes, if I remember correctly. There were lots of other people making the same ascent. Most of the climb is a series of eventually tedious switchbacks. Yet the view eventually becomes quite stunning, allowing one to view up and down the Bow River valley.','2011-09-03 00:00:00'),(4,5,13,'One Day in New York','After my last conference, I had time for a quick one day tour of New York. There is so much to see! Because of the time constraints, I decided to focus on a pretty small area, in my case, midtown New York around Central Park and the Rockefeller Center.<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Phasellus hendrerit. Pellentesque aliquet nibh nec urna. In nisi neque, aliquet vel, dapibus id, mattis vel, nisi. Sed pretium, ligula sollicitudin laoreet viverra, tortor libero sodales leo, eget blandit nunc tortor eu nibh. Nullam mollis. Ut justo. Suspendisse potenti.\r\n<p>\r\nSed egestas, ante et vulputate volutpat, eros pede semper est, vitae luctus metus libero eu augue. Morbi purus libero, faucibus adipiscing, commodo quis, gravida id, est. Sed lectus. Praesent elementum hendrerit tortor. Sed semper lorem at felis. Vestibulum volutpat, lacus a ultrices sagittis, mi neque euismod dui, eu pulvinar nunc sapien ornare nisl. Phasellus pede arcu, dapibus eu, fermentum et, dapibus sed, urna.','2012-10-22 00:00:00'),(5,6,33,'Visiting Orlando','Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Donec odio. Quisque volutpat mattis eros. Nullam malesuada erat ut turpis. Suspendisse urna nibh, viverra non, semper suscipit, posuere a, pede.\r\n<p>\r\nDonec nec justo eget felis facilisis fermentum. Aliquam porttitor mauris sit amet orci. Aenean dignissim pellentesque felis.\r\n<p>\r\nMorbi in sem quis dui placerat ornare. Pellentesque odio nisi, euismod in, pharetra a, ultricies in, diam. Sed arcu. Cras consequat.\r\n<p>\r\nPraesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus.','2012-07-18 00:00:00'),(6,9,15,'Favorite Places','But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally encounter consequences that are extremely painful.\r\n<p>\r\nNor again is there anyone who loves or pursues or desires to obtain pain of itself, because it is pain, but because occasionally circumstances occur in which toil and pain can procure him some great pleasure. To take a trivial example, which of us ever undertakes laborious physical exercise, except to obtain some advantage from it? But who has any right to find fault with a man who chooses to enjoy a pleasure that has no annoying consequences, or one who avoids a pain that produces no resultant pleasure?\r\n<p>\r\nOn the other hand, we denounce with righteous indignation and dislike men who are so beguiled and demoralized by the charms of pleasure of the moment, so blinded by desire, that they cannot foresee the pain and trouble that are bound to ensue; and equal blame belongs to those who fail in their duty through weakness of will, which is the same as saying through shrinking from toil and pain. These cases are perfectly simple and easy to distinguish. In a free hour, when our power of choice is untrammelled and when nothing prevents our being able to do what we like best, every pleasure is to be welcomed and every pain avoided. But in certain circumstances and owing to the claims of duty or the obligations of business it will frequently occur that','2012-06-08 00:00:00'),(7,10,25,'Berlin Tour','A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now.\r\n<p>\r\nWhen, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage of my trees, and but a few stray gleams steal into the inner sanctuary, I throw myself down among the tall grass by the trickling stream; and, as I lie close to the earth, a thousand unknown plants are noticed by me: when I hear the buzz of the little world among the stalks, and grow familiar with the countless indescribable forms of the insects and flies, then I feel the presence of the Almighty, who formed us in his own image, and the breath of that universal love which bears and sustains us, as it floats around us in an eternity of bliss; and then, my friend, when darkness overspreads my eyes, and heaven and earth seem to dwell in my soul and absorb its power, like the form of a beloved mistress, then I often think with longing, Oh, would I could describe these conceptions, could impress upon paper all that is living so full and warm within me, that it might be the mirror of my soul, as my soul is the mirror of the infinite God!\r\n<p>\r\nO my friend -- but it is too much for my strength -- I sink under the weight of the splendour of these visions! A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.\r\n<p>\r\nI am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage of my trees, and but a few stray gleams steal into the inner sanctuary, I throw myself down among the tall grass by the trickling stream; and, as I lie close to the earth, a thousand unknown plants are noticed by me: when I hear the buzz of the little world among the stalks, and grow familiar with the','2012-11-11 00:00:00'),(8,11,9,'Old World Charm in the New World','<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents.</p>\n\n<p>I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now.</p>\n\n<p>When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage of my trees, and but a few stray gleams steal into the inner sanctuary, I throw myself down among the tall grass by the trickling stream; and, as I lie close to the earth, a thousand unknown plants are noticed by me: when I hear the buzz of the little world among the stalks, and grow familiar with the countless indescribable forms of the insects and flies, then I feel the presence of the Almighty, who formed us in his own image, and the breath of that universal love which bears and sustains us, as it floats around us in an eternity of bliss; and then, my friend, when darkness overspreads my eyes, and heaven and earth seem to dwell in my soul and absorb its power, like the form of a beloved mistress, then I often think with longing, Oh, would I could describe these conceptions, could impress upon paper all that is living so full and warm within me, that it might be the mirror of my soul, as my soul is the mirror of the infinite God!</p>\n\n<p>O my friend -- but it is too much for my strength -- I sink under the weight of the splendour of these visions! A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>\n\n<p>I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single</p>','2013-01-17 00:00:00'),(9,13,8,'Nova Scotia','<p>The steamer Mongolia, belonging to the Peninsular and Oriental Company, built of iron, of two thousand eight hundred tons burden, and five hundred horse-power, was due at eleven o\'clock a.m. on Wednesday, the 9th of October, at Suez.  The Mongolia plied regularly between Brindisi and Bombay via the Suez Canal, and was one of the fastest steamers belonging to the company, always making more than ten knots an hour between Brindisi and Suez, and nine and a half between Suez and Bombay.</p>\n\n<p>Two men were promenading up and down the wharves, among the crowd of natives and strangers who were sojourning at this once straggling village&mdash;now, thanks to the enterprise of M. Lesseps, a fast-growing town.  One was the British consul at Suez, who, despite the prophecies of the English Government, and the unfavourable predictions of Stephenson, was in the habit of seeing, from his office window, English ships daily passing to and fro on the great canal, by which the old roundabout route from England to India by the Cape of Good Hope was abridged by at least a half.  The other was a small, slight-built personage, with a nervous, intelligent face, and bright eyes peering out from under eyebrows which he was incessantly twitching.  He was just now manifesting unmistakable signs of impatience, nervously pacing up and down, and unable to stand still for a moment.  This was Fix, one of the detectives who had been dispatched from England in search of the bank robber; it was his task to narrowly watch every passenger who arrived at Suez, and to follow up all who seemed to be suspicious characters, or bore a resemblance to the description of the criminal, which he had received two days before from the police headquarters at London.  The detective was evidently inspired by the hope of obtaining the splendid reward which would be the prize of success, and awaited with a feverish impatience, easy to understand, the arrival of the steamer Mongolia.</p>\n\n<p>\"So you say, consul,\" asked he for the twentieth time, \"that this steamer is never behind time?\"</p>\n\n<p>\"No, Mr. Fix,\" replied the consul.  \"She was bespoken yesterday at Port Said, and the rest of the way is of no account to such a craft.  I repeat that the Mongolia has been in advance of the time required by the company\'s regulations, and gained the prize awarded for excess of speed.\"</p>\n\n<p>\"Does she come directly from Brindisi?\"</p>','2012-03-19 00:00:00'),(10,18,22,'Rio Reno Voyage','<p>Li Europan lingues es membres del sam familie. Lor separat existentie es un myth. Por scientie, musica, sport etc, litot Europa usa li sam vocabular. Li lingues differe solmen in li grammatica, li pronunciation e li plu commun vocabules.</p>\n\n<p>Omnicos directe al desirabilite de un nov lingua franca: On refusa continuar payar custosi traductores. At solmen va esser necessi far uniform grammatica, pronunciation e plu sommun paroles.</p>\n\n<p>Ma quande lingues coalesce, li grammatica del resultant lingue es plu simplic e regulari quam ti del coalescent lingues. Li nov lingua franca va esser plu simplic e regulari quam li existent Europan lingues. It va esser tam simplic quam Occidental in fact, it va esser Occidental.</p>\n\n<p>A un Angleso it va semblar un simplificat Angles, quam un skeptic Cambridge amico dit me que Occidental es. Li Europan lingues es membres del sam familie. Lor separat existentie es un myth. Por scientie, musica, sport etc, litot Europa usa li sam vocabular. Li lingues differe solmen in li grammatica, li pronunciation e li plu commun vocabules. Omnicos directe al desirabilite de un nov lingua franca: On refusa continuar payar custosi traductores. At solmen va esser necessi far uniform grammatica, pronunciation e plu sommun paroles.</p>','2012-11-23 00:00:00'),(11,20,24,'European Business','<p>At last we gained such an offing, that the two pilots were needed no longer. The stout sail-boat that had accompanied us began ranging alongside.</p>\n\n<p>It was curious and not unpleasing, how Peleg and Bildad were affected at this juncture, especially Captain Bildad. For loath to depart, yet; very loath to leave, for good, a ship bound on so long and perilous a voyage&mdash;beyond both stormy Capes; a ship in which some thousands of his hard earned dollars were invested; a ship, in which an old shipmate sailed as captain; a man almost as old as he, once more starting to encounter all the terrors of the pitiless jaw; loath to say good-bye to a thing so every way brimful of every interest to him,&mdash;poor old Bildad lingered long; paced the deck with anxious strides; ran down into the cabin to speak another farewell word there; again came on deck, and looked to windward; looked towards the wide and endless waters, only bounded by the far-off unseen Eastern Continents; looked towards the land; looked aloft; looked right and left; looked everywhere and nowhere; and at last, mechanically coiling a rope upon its pin, convulsively grasped stout Peleg by the hand, and holding up a lantern, for a moment stood gazing heroically in his face, as much as to say, \"Nevertheless, friend Peleg, I can stand it; yes, I can.\"</p>\n\n<p>As for Peleg himself, he took it more like a philosopher; but for all his philosophy, there was a tear twinkling in his eye, when the lantern came too near. And he, too, did not a little run from cabin to deck&mdash;now a word below, and now a word with Starbuck, the chief mate.</p>\n\n<p>But, at last, he turned to his comrade, with a final sort of look about him,&mdash;\"Captain Bildad&mdash;come, old shipmate, we must go. Back the main-yard there! Boat ahoy! Stand by to come close alongside, now! Careful, careful!&mdash;come, Bildad, boy&mdash;say your last. Luck to ye, Starbuck&mdash;luck to ye, Mr. Stubb&mdash;luck to ye, Mr. Flask&mdash;good-bye and good luck to ye all&mdash;and this day three years I\'ll have a hot supper smoking for ye in old Nantucket. Hurrah and away!\"</p>','2012-08-20 00:00:00'),(12,27,7,'Honeymoon Journey','<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>\n\n<p>A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p>\n\n<p>Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.</p>\n\n<p>The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then</p>','2011-08-22 00:00:00'),(13,27,17,'British Adventure','<p>But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness.</p>\n\n<p>No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally encounter consequences that are extremely painful. Nor again is there anyone who loves or pursues or desires to obtain pain of itself, because it is pain, but because occasionally circumstances occur in which toil and pain can procure him some great pleasure.</p>\n\n<p>To take a trivial example, which of us ever undertakes laborious physical exercise, except to obtain some advantage from it? But who has any right to find fault with a man who chooses to enjoy a pleasure that has no annoying consequences, or one who avoids a pain that produces no resultant pleasure? On the other hand, we denounce with righteous indignation and dislike men who are so beguiled and demoralized by the charms of pleasure of the moment, so blinded by desire, that they cannot foresee</p>','2013-02-03 00:00:00'),(14,28,20,'Sussex Zombie Castles','Zombie ipsum reversus ab viral inferno, nam rick grimes malum cerebro. De carne lumbering animata corpora quaeritis. Summus brains sit??, morbo vel maleficia? De apocalypsi gorger omero undead survivor dictum mauris. Hi mindless mortuis soulless creaturas, imo evil stalking monstra adventus resi dentevil vultus comedat cerebella viventium. Qui animated corpse, cricket bat max brucks terribilem incessu zomby. The voodoo sacerdos flesh eater, suscitat mortuos comedere carnem virus. Zonbi tattered for solum oculi eorum defunctis go lum cerebro. Nescio brains an Undead zombies. Sicut malus putrid voodoo horror. Nigh tofth eliv ingdead.\r\n<p>\r\nCim horribilem walking dead resurgere de crazed sepulcris creaturis, zombie sicut de grave feeding iride et serpens. Pestilentia, shaun ofthe dead scythe animated corpses ipsa screams. Pestilentia est plague haec decaying ambulabat mortuos. Sicut zeder apathetic malus voodoo. Aenean a dolor plan et terror soulless vulnerum contagium accedunt, mortui iam vivam unlife. Qui tardius moveri, brid eof reanimator sed in magna copia sint terribiles undeath legionis. Alii missing oculis aliorum sicut serpere crabs nostram. Putridi braindead odores kill and infect, aere implent left four dead.\r\n<p>\r\nLucio fulci tremor est dark vivos magna. Expansis creepy arm yof darkness ulnis witchcraft missing carnem armis Kirkman Moore and Adlard caeruleum in locis. Romero morbo Congress amarus in auras. Nihil horum sagittis tincidunt, zombie slack-jawed gelida survival portenta. The unleashed virus est, et iam zombie mortui ambulabunt super terram. Souless mortuum glassy-eyed oculos attonitos indifferent back zom bieapoc alypse. An hoc dead snow braaaiiiins sociopathic incipere Clairvius Narcisse, an ante? Is bello mundi z?','2011-05-16 00:00:00'),(15,29,29,'Beautiful Madrid','Direct trade readymade vice, PBR stumptown blog gentrify fixie pickled gluten-free forage cardigan. Single-origin coffee raw denim readymade brooklyn 8-bit polaroid. Pour-over squid godard, semiotics vinyl american apparel mixtape polaroid scenester wolf four loko thundercats. Viral american apparel scenester, master cleanse swag typewriter kogi wes anderson forage gastropub 3 wolf moon pitchfork bicycle rights. Lo-fi fanny pack bushwick fingerstache art party, cray before they sold out seitan. Freegan food truck hella, chillwave lo-fi lomo small batch pour-over photo booth yr banh mi. Yr butcher keytar, retro williamsburg helvetica blog stumptown narwhal gluten-free american apparel fap.\r\n<p>\r\nWilliamsburg you probably haven\'t heard of them organic, banksy echo park post-ironic fingerstache craft beer cred ennui godard VHS squid. Beard jean shorts DIY, craft beer street art kale chips dreamcatcher forage scenester. Photo booth cliche bushwick, pinterest ethnic pop-up ennui leggings bicycle rights. Banh mi keytar four loko, ethical beard etsy food truck mixtape. Mustache squid narwhal trust fund. Umami authentic vinyl whatever food truck. 3 wolf moon mustache thundercats whatever, vinyl kogi cliche.\r\n<p>\r\nScenester cliche readymade, mlkshk squid vice Austin locavore quinoa selvage master cleanse lo-fi seitan. Wayfarers ethical squid forage, cliche gastropub mixtape marfa. Next level leggings pop-up cardigan kogi, shoreditch synth portland chambray mixtape. Vegan pork belly hella typewriter, ethnic swag before they sold out brunch sartorial synth bicycle rights stumptown seitan echo park. Sustainable pinterest stumptown iphone hella. Small batch viral cred, freegan banh mi banksy biodiesel letterpress post-ironic vice four loko mustache. Street art irony high life semiotics mustache odd future, wes anderson terry richardson stumptown forage put a bird on it pour-over readymade.\r\n<p>\r\nChambray PBR cliche, single-origin coffee vinyl wes anderson truffaut Austin DIY. Salvia whatever wes anderson street art pinterest high life. Master cleanse pour-over jean shorts four loko. Street art artisan biodiesel chillwave, next level synth lomo art party four loko put a bird on it umami pitchfork portland salvia. Art party butcher farm-to-table gastropub aesthetic. Terry richardson swag food truck chambray cardigan art party. Four loko irony polaroid, seitan keffiyeh typewriter +1 fanny pack DIY pour-over aesthetic.','2012-09-02 00:00:00'),(16,30,31,'Our Bahamas Getaway','Bacon ipsum dolor sit amet kielbasa officia ribeye tri-tip sausage, swine salami occaecat biltong. Strip steak shoulder rump swine sunt commodo turducken sint eu ut kielbasa meatball duis. Do chicken laboris officia ut. Hamburger aute labore jerky, laborum cillum ullamco ham cupidatat est esse voluptate non. Pig kielbasa chuck occaecat dolore tempor sint laborum beef ribs anim nisi cupidatat. Shank tail sint, excepteur short ribs bacon beef. Chicken frankfurter nostrud, pork dolore in meatloaf.\r\n<p>\r\nT-bone rump ham velit salami, ullamco laborum consectetur tenderloin jowl turducken. Meatball ham hock filet mignon, ad nisi esse commodo sint culpa labore magna. Nostrud aute officia shank non duis jerky venison t-bone spare ribs ut ribeye. T-bone est rump dolore ribeye kielbasa fugiat pancetta velit. Salami in proident adipisicing. Ball tip fugiat ex in jowl.','2012-02-07 00:00:00'),(17,3,34,'Summer in Ghana','A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now.\r\n<p>\r\nWhen, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage of my trees, and but a few stray gleams steal into the inner sanctuary, I throw myself down among the tall grass by the trickling stream; and, as I lie close to the earth, a thousand unknown plants are noticed by me: when I hear the buzz of the little world among the stalks, and grow familiar with the countless indescribable forms of the insects and flies, then I feel the presence of the Almighty, who formed us in his own image, and the breath of that universal love which bears and sustains us, as it floats around us in an eternity of bliss; and then, my friend, when darkness overspreads my eyes, and heaven and earth seem to dwell in my soul and absorb its power, like the form of a beloved mistress, then I often think with longing, Oh, would I could describe these conceptions, could impress upon paper all that is living so full and warm within me, that it might be the mirror of my soul, as my soul is the mirror of the infinite God!\r\n<p>\r\nO my friend -- but it is too much for my strength -- I sink under the weight of the splendour of these visions! A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.\r\n<p>\r\nI am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage of my trees, and but a few stray gleams steal into the inner sanctuary, I throw myself down among the tall grass by the trickling stream; and, as I lie close to the earth, a thousand unknown plants are noticed by me: when I hear the buzz of the little world among the stalks, and grow familiar with the','2012-11-03 00:00:00'),(18,27,40,'Northern Italy','<p>But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness.</p>\n\n<p>No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally encounter consequences that are extremely painful. Nor again is there anyone who loves or pursues or desires to obtain pain of itself, because it is pain, but because occasionally circumstances occur in which toil and pain can procure him some great pleasure.</p>\n\n<p>To take a trivial example, which of us ever undertakes laborious physical exercise, except to obtain some advantage from it? But who has any right to find fault with a man who chooses to enjoy a pleasure that has no annoying consequences, or one who avoids a pain that produces no resultant pleasure? On the other hand, we denounce with righteous indignation and dislike men who are so beguiled and demoralized by the charms of pleasure of the moment, so blinded by desire, that they cannot foresee</p>','2012-11-12 00:00:00'),(19,17,42,'Love in Venezia','<p>The Lakeman now patrolled the barricade, all the while keeping his eye on the Captain, and jerking out such sentences as these:&mdash;\'It\'s not our fault; we didn\'t want it; I told him to take his hammer away; it was boy\'s business; he might have known me before this; I told him not to prick the buffalo; I believe I have broken a finger here against his cursed jaw; ain\'t those mincing knives down in the forecastle there, men? Look to those handspikes, my hearties. Captain, by God, look to yourself; say the word; don\'t be a fool; forget it all; we are ready to turn to; treat us decently, and we\'re your men; but we won\'t be flogged.</p>','2013-06-12 00:00:00'),(20,8,47,'Best Sabbatical Ever','<p>Of the grand order of folio leviathans, the Sperm Whale and the Right Whale are by far the most noteworthy. They are the only whales regularly hunted by man. To the Nantucketer, they present the two extremes of all the known varieties of the whale. As the external difference between them is mainly observable in their heads; and as a head of each is this moment hanging from the Pequod\'s side; and as we may freely go from one to the other, by merely stepping across the deck:&mdash;where, I should like to know, will you obtain a better chance to study practical cetology than here?</p>\r\n\r\n<p>In the first place, you are struck by the general contrast between these heads. Both are massive enough in all conscience; but there is a certain mathematical symmetry in the Sperm Whale\'s which the Right Whale\'s sadly lacks. There is more character in the Sperm Whale\'s head. As you behold it, you involuntarily yield the immense superiority to him, in point of pervading dignity. In the present instance, too, this dignity is heightened by the pepper and salt colour of his head at the summit, giving token of advanced age and large experience. In short, he is what the fishermen technically call a \"grey-headed whale.\"</p>\r\n\r\n<p>Let us now note what is least dissimilar in these heads&mdash;namely, the two most important organs, the eye and the ear. Far back on the side of the head, and low down, near the angle of either whale\'s jaw, if you narrowly search, you will at last see a lashless eye, which you would fancy to be a young colt\'s eye; so out of all proportion is it to the magnitude of the head.</p>','2013-07-09 00:00:00'),(21,17,52,'When in Rome','<p>The Narwhale has a very picturesque, leopard-like look, being of a milk-white ground colour, dotted with round and oblong spots of black. His oil is very superior, clear and fine; but there is little of it, and he is seldom hunted. He is mostly found in the circumpolar seas.</p>\r\n\r\n<p>Of this whale little is precisely known to the Nantucketer, and nothing at all to the professed naturalist. From what I have seen of him at a distance, I should say that he was about the bigness of a grampus. He is very savage&mdash;a sort of Feegee fish. He sometimes takes the great Folio whales by the lip, and hangs there like a leech, till the mighty brute is worried to death. The Killer is never hunted. I never heard what sort of oil he has. Exception might be taken to the name bestowed upon this whale, on the ground of its indistinctness. For we are all killers, on land and on sea; Bonapartes and Sharks included.</p>','2013-08-06 00:00:00'),(22,4,57,'The Park','<p>A word or two more concerning this matter of the skin or blubber of the whale. It has already been said, that it is stript from him in long pieces, called blanket-pieces. Like most sea-terms, this one is very happy and significant. For the whale is indeed wrapt up in his blubber as in a real blanket or counterpane; or, still better, an Indian poncho slipt over his head, and skirting his extremity. It is by reason of this cosy blanketing of his body, that the whale is enabled to keep himself comfortable in all weathers, in all seas, times, and tides. What would become of a Greenland whale, say, in those shuddering, icy seas of the North, if unsupplied with his cosy surtout? True, other fish are found exceedingly brisk in those Hyperborean waters; but these, be it observed, are your cold-blooded, lungless fish, whose very bellies are refrigerators; creatures, that warm themselves under the lee of an iceberg, as a traveller in winter would bask before an inn fire; whereas, like man, the whale has lungs and warm blood. Freeze his blood, and he dies. How wonderful is it then&mdash;except after explanation&mdash;that this great monster, to whom corporeal warmth is as indispensable as it is to man; how wonderful that he should be found at home, immersed to his lips for life in those Arctic waters! where, when seamen fall overboard, they are sometimes found, months afterwards, perpendicularly frozen into the hearts of fields of ice, as a fly is found glued in amber. But more surprising is it to know, as has been proved by experiment, that the blood of a Polar whale is warmer than that of a Borneo negro in summer.</p>','2013-03-10 00:00:00'),(23,22,58,'Florence Tour','<p>I know it, old man; these stubbs will weld together like glue from the melted bones of murderers. Quick! forge me the harpoon. And forge me first, twelve rods for its shank; then wind, and twist, and hammer these twelve together like the yarns and strands of a tow-line. Quick! I\'ll blow the fire.</p>\r\n\r\n<p>When at last the twelve rods were made, Ahab tried them, one by one, by spiralling them, with his own hand, round a long, heavy iron bolt. \"A flaw!\" rejecting the last one. \"Work that over again, Perth.\"</p>\r\n\r\n<p>This done, Perth was about to begin welding the twelve into one, when Ahab stayed his hand, and said he would weld his own iron. As, then, with regular, gasping hems, he hammered on the anvil, Perth passing to him the glowing rods, one after the other, and the hard pressed forge shooting up its intense straight flame, the Parsee passed silently, and bowing over his head towards the fire, seemed invoking some curse or some blessing on the toil. But, as Ahab looked up, he slid aside.</p>','2013-04-18 00:00:00'),(24,12,61,'Architecture of Florence','<p>Champollion deciphered the wrinkled granite hieroglyphics. But there is no Champollion to decipher the Egypt of every man\'s and every being\'s face. Physiognomy, like every other human science, is but a passing fable. If then, Sir William Jones, who read in thirty languages, could not read the simplest peasant\'s face in its profounder and more subtle meanings, how may unlettered Ishmael hope to read the awful Chaldee of the Sperm Whale\'s brow? I but put that brow before you. Read it if you can.</p>\n\n<p>If the Sperm Whale be physiognomically a Sphinx, to the phrenologist his brain seems that geometrical circle which it is impossible to square.</p>','2013-02-12 00:00:00'),(25,15,64,'Tilting in Pisa','<p>But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness.</p>\n\n<p>No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally encounter consequences that are extremely painful. Nor again is there anyone who loves or pursues or desires to obtain pain of itself, because it is pain, but because occasionally circumstances occur in which toil and pain can procure him some great pleasure.</p>\n\n<p>To take a trivial example, which of us ever undertakes laborious physical exercise, except to obtain some advantage from it? But who has any right to find fault with a man who chooses to enjoy a pleasure that has no annoying consequences, or one who avoids a pain that produces no resultant pleasure? On the other hand, we denounce with righteous indignation and dislike men who are so beguiled and demoralized by the charms of pleasure of the moment, so blinded by desire, that they cannot foresee</p>','2013-09-19 00:00:00'),(26,23,67,'Lovin\' Tuscany','<p>At last we gained such an offing, that the two pilots were needed no longer. The stout sail-boat that had accompanied us began ranging alongside.</p>\n\n<p>It was curious and not unpleasing, how Peleg and Bildad were affected at this juncture, especially Captain Bildad. For loath to depart, yet; very loath to leave, for good, a ship bound on so long and perilous a voyage&mdash;beyond both stormy Capes; a ship in which some thousands of his hard earned dollars were invested; a ship, in which an old shipmate sailed as captain; a man almost as old as he, once more starting to encounter all the terrors of the pitiless jaw; loath to say good-bye to a thing so every way brimful of every interest to him,&mdash;poor old Bildad lingered long; paced the deck with anxious strides; ran down into the cabin to speak another farewell word there; again came on deck, and looked to windward; looked towards the wide and endless waters, only bounded by the far-off unseen Eastern Continents; looked towards the land; looked aloft; looked right and left; looked everywhere and nowhere; and at last, mechanically coiling a rope upon its pin, convulsively grasped stout Peleg by the hand, and holding up a lantern, for a moment stood gazing heroically in his face, as much as to say, \"Nevertheless, friend Peleg, I can stand it; yes, I can.\"</p>\n\n<p>As for Peleg himself, he took it more like a philosopher; but for all his philosophy, there was a tear twinkling in his eye, when the lantern came too near. And he, too, did not a little run from cabin to deck&mdash;now a word below, and now a word with Starbuck, the chief mate.</p>\n\n<p>But, at last, he turned to his comrade, with a final sort of look about him,&mdash;\"Captain Bildad&mdash;come, old shipmate, we must go. Back the main-yard there! Boat ahoy! Stand by to come close alongside, now! Careful, careful!&mdash;come, Bildad, boy&mdash;say your last. Luck to ye, Starbuck&mdash;luck to ye, Mr. Stubb&mdash;luck to ye, Mr. Flask&mdash;good-bye and good luck to ye all&mdash;and this day three years I\'ll have a hot supper smoking for ye in old Nantucket. Hurrah and away!\"</p>','2013-09-13 00:00:00'),(27,7,71,'Spicy Budapest','Bacon ipsum dolor sit amet kielbasa officia ribeye tri-tip sausage, swine salami occaecat biltong. Strip steak shoulder rump swine sunt commodo turducken sint eu ut kielbasa meatball duis. Do chicken laboris officia ut. Hamburger aute labore jerky, laborum cillum ullamco ham cupidatat est esse voluptate non. Pig kielbasa chuck occaecat dolore tempor sint laborum beef ribs anim nisi cupidatat. Shank tail sint, excepteur short ribs bacon beef. Chicken frankfurter nostrud, pork dolore in meatloaf.\r\n<p>\r\nT-bone rump ham velit salami, ullamco laborum consectetur tenderloin jowl turducken. Meatball ham hock filet mignon, ad nisi esse commodo sint culpa labore magna. Nostrud aute officia shank non duis jerky venison t-bone spare ribs ut ribeye. T-bone est rump dolore ribeye kielbasa fugiat pancetta velit. Salami in proident adipisicing. Ball tip fugiat ex in jowl.','2013-03-20 00:00:00'),(28,14,73,'Athen in the Sunshine','<p>The Lakeman now patrolled the barricade, all the while keeping his eye on the Captain, and jerking out such sentences as these:&mdash;\'It\'s not our fault; we didn\'t want it; I told him to take his hammer away; it was boy\'s business; he might have known me before this; I told him not to prick the buffalo; I believe I have broken a finger here against his cursed jaw; ain\'t those mincing knives down in the forecastle there, men? Look to those handspikes, my hearties. Captain, by God, look to yourself; say the word; don\'t be a fool; forget it all; we are ready to turn to; treat us decently, and we\'re your men; but we won\'t be flogged.</p>','2013-06-10 00:00:00'),(29,12,76,'Greek Dreaming','<p>Soon we were running through a suffusing wide veil of mist; neither ship nor boat to be seen.</p>\n\n<p>\"Give way, men,\" whispered Starbuck, drawing still further aft the sheet of his sail; \"there is time to kill a fish yet before the squall comes. There\'s white water again!&mdash;close to! Spring!\"</p>\n\n<p>Soon after, two cries in quick succession on each side of us denoted that the other boats had got fast; but hardly were they overheard, when with a lightning-like hurtling whisper Starbuck said: \"Stand up!\" and Queequeg, harpoon in hand, sprang to his feet.</p>','2013-04-30 00:00:00'),(30,21,81,'Oxford Day Trip','<p>Li Europan lingues es membres del sam familie. Lor separat existentie es un myth. Por scientie, musica, sport etc, litot Europa usa li sam vocabular. Li lingues differe solmen in li grammatica, li pronunciation e li plu commun vocabules.</p>\n\n<p>Omnicos directe al desirabilite de un nov lingua franca: On refusa continuar payar custosi traductores. At solmen va esser necessi far uniform grammatica, pronunciation e plu sommun paroles.</p>\n\n<p>Ma quande lingues coalesce, li grammatica del resultant lingue es plu simplic e regulari quam ti del coalescent lingues. Li nov lingua franca va esser plu simplic e regulari quam li existent Europan lingues. It va esser tam simplic quam Occidental in fact, it va esser Occidental.</p>\n\n<p>A un Angleso it va semblar un simplificat Angles, quam un skeptic Cambridge amico dit me que Occidental es. Li Europan lingues es membres del sam familie. Lor separat existentie es un myth. Por scientie, musica, sport etc, litot Europa usa li sam vocabular. Li lingues differe solmen in li grammatica, li pronunciation e li plu commun vocabules. Omnicos directe al desirabilite de un nov lingua franca: On refusa continuar payar custosi traductores. At solmen va esser necessi far uniform grammatica, pronunciation e plu sommun paroles.</p>','2013-03-22 00:00:00');
UNLOCK TABLES;

--
-- Table structure for table `postimages`
--

DROP TABLE IF EXISTS `postimages`;

CREATE TABLE `postimages` (
  `ImageID` int(11) NOT NULL,
  `PostID` int(11) NOT NULL,
  PRIMARY KEY (`ImageID`,`PostID`),
  KEY `ImageID` (`ImageID`),
  KEY `PostID` (`PostID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

LOCK TABLES `postimages` WRITE;
INSERT INTO `postimages` VALUES (1,2),(2,2),(3,1),(4,1),(5,3),(6,3),(7,12),(8,9),(9,8),(10,9),(11,8),(12,12),(13,4),(14,4),(15,6),(16,6),(17,13),(18,13),(19,13),(20,14),(21,14),(22,10),(23,10),(24,11),(25,7),(26,7),(27,7),(28,7),(29,15),(30,15),(31,16),(32,16),(33,5),(34,17),(35,17),(36,17),(37,17),(38,17),(39,17),(40,18),(41,18),(42,19),(43,19),(44,19),(45,19),(46,19),(47,20),(48,20),(49,20),(50,20),(51,20),(52,21),(53,21),(54,21),(55,21),(56,21),(57,22),(58,23),(59,23),(60,23),(61,24),(62,24),(63,24),(64,25),(65,25),(66,25),(67,26),(68,26),(69,26),(70,26),(71,27),(72,27),(73,28),(74,28),(75,28),(76,29),(77,29),(78,29),(80,27),(81,30),(82,30);
UNLOCK TABLES;